<!DOCTYPE html>
<html lang="pt">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Ficha de Inscrição do Aluno - <?php echo e(\App\Models\Configuracao::get('escola', 'Colégio Premium')); ?></title>

<style>
body {
    font-family: Arial, Helvetica, sans-serif;
    background: #eee;
    margin: 0;
    padding: 20px;
}

.actions {
    position: fixed;
    top: 20px;
    right: 20px;
    z-index: 1000;
    display: flex;
    gap: 10px;
}

.actions button {
    padding: 10px 20px;
    font-size: 16px;
    border: none;
    border-radius: 5px;
    cursor: pointer;
    background-color: #007bff;
    color: white;
    font-weight: bold;
    box-shadow: 0 2px 5px rgba(0,0,0,0.2);
    transition: background-color 0.3s;
}

.actions button:hover {
    background-color: #0056b3;
}

.actions button.download {
    background-color: #28a745;
}

.actions button.download:hover {
    background-color: #218838;
}

.actions button.print {
    background-color: #17a2b8;
}

.actions button.print:hover {
    background-color: #138496;
}

.page {
    width: 210mm;
    min-height: 297mm;
    margin: 10mm auto;
    background: #fff;
    padding: 12mm;
    box-sizing: border-box;
    border: 1px solid #999;
    font-size: 12px;
}

.header {
    display: flex;
    border: 1px solid #000;
    padding: 8px;
    margin-bottom: 8px;
}

.logo {
    width: 150px;
    border-right: 1px solid #000;
    text-align: center;
    font-size: 10px;
    padding: 5px;
}

.logo img {
    width: 100%;
    height: auto;
    max-height: 140px;
    object-fit: contain;
}

.header-text {
    flex: 1;
    text-align: center;
}

.header-text h1 {
    margin: 0;
    font-size: 18px;
}

.header-text p {
    margin: 2px 0;
}

.title {
    text-align: center;
    font-weight: bold;
    border: 1px solid #000;
    padding: 5px;
    margin-bottom: 6px;
}

.gray-box {
    background: #eaeaea;
    border: 1px solid #000;
    padding: 5px;
    margin-bottom: 6px;
}

.section {
    border: 1px solid #000;
    padding: 5px;
    margin-bottom: 6px;
}

.section-title {
    font-weight: bold;
    margin-bottom: 4px;
}

.line {
    display: inline-block;
    border-bottom: 1px dotted #000;
    min-width: 200px;
    height: 14px;
    margin-left: 5px;
}

.row {
    display: flex;
    gap: 6px;
}

.col {
    flex: 1;
}

.photo {
    width: 40mm;
    height: 55mm;
    border: 1px dashed #000;
    text-align: center;
    font-weight: bold;
    color: #666;
    display: flex;
    align-items: center;
    justify-content: center;
}

.photo img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}

.small {
    font-size: 11px;
}

.signature {
    margin-top: 15px;
    text-align: center;
}

.signature-line {
    border-bottom: 1px solid #000;
    width: 70%;
    margin: 10px auto;
}

.footer {
    font-size: 10px;
    margin-top: 6px;
}

@media print {
    body {
        background: #fff;
        padding: 0;
        margin: 0;
    }
    .page {
        margin: 0;
        border: none;
        box-shadow: none;
        padding: 12mm;
        width: 210mm;
        min-height: 297mm;
        max-height: 297mm;
        overflow: hidden;
    }
    .actions {
        display: none;
    }
    .header {
        padding: 6px;
        margin-bottom: 6px;
    }
    .header-text h1 {
        font-size: 16px;
    }
    .header-text p {
        font-size: 10px;
        margin: 1px 0;
    }
    .title {
        padding: 4px;
        margin-bottom: 5px;
        font-size: 13px;
    }
    .gray-box {
        padding: 4px;
        margin-bottom: 5px;
        font-size: 10px;
    }
    .section {
        padding: 4px;
        margin-bottom: 4px;
    }
    .section-title {
        font-size: 11px;
        margin-bottom: 3px;
    }
    .line {
        min-width: 150px;
        height: 12px;
    }
    .photo {
        width: 35mm;
        height: 48mm;
    }
    .small {
        font-size: 10px;
    }
    .signature {
        margin-top: 10px;
    }
    .signature-line {
        margin: 8px auto;
    }
    .footer {
        font-size: 9px;
        margin-top: 4px;
    }
}

@page {
    size: A4;
    margin: 0;
}
</style>
</head>

<body>

<div class="actions">
    <button class="download" onclick="window.location.href='<?php echo e(route('admin.alunos.ficha-inscricao.download', $aluno)); ?>'">
        📥 Download PDF
    </button>
    <button class="print" onclick="window.print()">
        🖨️ Imprimir
    </button>
</div>

<div class="page">

    <div class="header">
        <div class="logo">
            <?php if(isset($logotipoBase64) && $logotipoBase64): ?>
                <img src="<?php echo e($logotipoBase64); ?>" alt="Logotipo">
            <?php else: ?>
                LOGOTIPO<br><br>
                <?php echo e(strtoupper(\App\Models\Configuracao::get('escola', 'COLÉGIO PREMIUM'))); ?>

            <?php endif; ?>
        </div>
        <div class="header-text">
            <h1><?php echo e(strtoupper(\App\Models\Configuracao::get('escola', 'COLÉGIO PREMIUM'))); ?></h1>
            <p><?php echo e(\App\Models\Configuracao::get('endereco_escola', 'Rua do Intaka, Bairro Boquisso, quarteirão nº 5, talhão nº 30, R/C')); ?></p>
            <p>TEL: <?php echo e(\App\Models\Configuracao::get('telefone_escola', '00258 844870068 / 0025887488877')); ?></p>
            <p>Email: <?php echo e(\App\Models\Configuracao::get('email_escola', 'colegiopremium2025@gmail.com')); ?></p>
        </div>
    </div>

    <div class="title">FICHA DE INSCRIÇÃO DO ALUNO</div>

    <div class="gray-box small">
        (a preencher pelos serviços)<br>
        Data da Inscrição: <?php echo e(now()->format('d/m/Y')); ?> &nbsp;&nbsp;
        Ano Lectivo: <?php echo e($anoLetivo->ano ?? date('Y')); ?> &nbsp;&nbsp;
        Classe: <?php if($turma && $turma->codigo): ?>
            <?php
                preg_match('/^(\d+)/', $turma->codigo, $matches);
                $classeNumero = $matches[1] ?? '';
            ?>
            <?php echo e($classeNumero); ?>

        <?php else: ?>
            ____________
        <?php endif; ?><br>
        Turma: <?php echo e($turma->codigo ?? '____________'); ?> &nbsp;&nbsp;
        Número do Aluno: <?php echo e($aluno->codigo_estudante ?? '____________'); ?> &nbsp;&nbsp;
        Novo Ingresso ( ) &nbsp;&nbsp; Transferido ( )
    </div>

    <div class="row">
        <div class="col section">
            <div class="section-title">IDENTIFICAÇÃO DO ALUNO</div>
            Nome do Aluno: <span class="line"><?php echo e($aluno->user->name ?? ''); ?></span><br>
            Data de Nascimento: <?php echo e($aluno->data_nascimento ? $aluno->data_nascimento->format('d') : '____'); ?> / <?php echo e($aluno->data_nascimento ? $aluno->data_nascimento->format('m') : '____'); ?> / <?php echo e($aluno->data_nascimento ? $aluno->data_nascimento->format('Y') : '______'); ?> &nbsp;&nbsp;
            Nº de BI ou Certidão: <?php echo e($aluno->num_documento ?? '____________________'); ?><br>
            Sexo: F (<?php echo e(($aluno->genero ?? '') == 'F' ? 'X' : ' '); ?>) &nbsp;&nbsp; M (<?php echo e(($aluno->genero ?? '') == 'M' ? 'X' : ' '); ?>)<br><br>
            Residência: <span class="line"><?php echo e($enderecoParts['bairro'] ?? ''); ?></span><br>
            Bairro: <?php echo e($enderecoParts['bairro'] ?? '____________________'); ?> &nbsp;&nbsp;
            Avenida/Rua: <?php echo e($enderecoParts['rua'] ?? '____________________'); ?><br>
            Nº: <?php echo e($enderecoParts['numero'] ?? '______'); ?> &nbsp;&nbsp; Quarteirão/andar: <?php echo e($enderecoParts['quarteirao'] ?? '______'); ?> &nbsp;&nbsp; Flat: <?php echo e($enderecoParts['flat'] ?? '______'); ?>

        </div>

        <div class="photo">
            <?php if(isset($fotoBase64) && $fotoBase64): ?>
                <img src="<?php echo e($fotoBase64); ?>" alt="Foto do Aluno">
            <?php else: ?>
                FOTOGRAFIA
            <?php endif; ?>
        </div>
    </div>

    <div class="section">
        <div class="section-title">INFORMAÇÃO COMPLEMENTAR (a)</div>
        Nº de Irmãos: ______ &nbsp;&nbsp;
        Mais velhos: <?php echo e($aluno->num_irmaos_mais_velhos ?? '______'); ?> &nbsp;&nbsp;
        Mais novos: <?php echo e($aluno->num_irmaos_mais_novos ?? '______'); ?> &nbsp;&nbsp;
        Com a mesma idade: <?php echo e($aluno->num_irmaos_mesma_idade ?? '______'); ?>

    </div>

    <div class="section">
        <div class="section-title">IDENTIFICAÇÃO DOS PAIS</div>
        Nome do Pai: <span class="line"><?php echo e($aluno->nome_pai ?? ''); ?></span><br>
        Local de trabalho: <?php echo e($aluno->local_trabalho_pai ?? '____________________'); ?> &nbsp;&nbsp;
        Endereço: <?php echo e($aluno->endereco_pai_bairro ?? '____________________'); ?><br>
        Avenida/Rua: <?php echo e($aluno->endereco_pai_rua ?? '____________________'); ?> Nº <?php echo e($aluno->endereco_pai_numero ?? '______'); ?> Quarteirão/andar <?php echo e($aluno->endereco_pai_quarteirao ?? '______'); ?> Flat <?php echo e($aluno->endereco_pai_flat ?? '______'); ?> Tel: <?php echo e($aluno->telefone_pai ?? '______'); ?><br>
        Nº do BI: <?php echo e($aluno->bi_pai ?? '____________________'); ?><br><br>

        Nome da Mãe: <span class="line"><?php echo e($aluno->nome_mae ?? ''); ?></span><br>
        Local de trabalho: <?php echo e($aluno->local_trabalho_mae ?? '____________________'); ?> &nbsp;&nbsp;
        Endereço: <?php echo e($aluno->endereco_mae_bairro ?? '____________________'); ?><br>
        Avenida/Rua: <?php echo e($aluno->endereco_mae_rua ?? '____________________'); ?> Nº <?php echo e($aluno->endereco_mae_numero ?? '______'); ?> Quarteirão/andar <?php echo e($aluno->endereco_mae_quarteirao ?? '______'); ?> Flat <?php echo e($aluno->endereco_mae_flat ?? '______'); ?> Tel: <?php echo e($aluno->telefone_mae ?? '______'); ?><br>
        Nº do BI: <?php echo e($aluno->bi_mae ?? '____________________'); ?>

    </div>

    <div class="section">
        <div class="section-title">ENCARREGADO DE EDUCAÇÃO</div>
        Nome: <span class="line"><?php echo e($aluno->nome_encarregado ?? ''); ?></span><br>
        BI Nº: <?php echo e($aluno->bi_encarregado ?? '____________________'); ?><br>
        Residência: <?php echo e($enderecoEncarregadoParts['bairro'] ?? '____________________'); ?> Bairro: <?php echo e($enderecoEncarregadoParts['bairro'] ?? '____________________'); ?><br>
        Avenida/Rua: <?php echo e($enderecoEncarregadoParts['rua'] ?? '____________________'); ?> Nº <?php echo e($enderecoEncarregadoParts['numero'] ?? '______'); ?> Quarteirão/andar <?php echo e($enderecoEncarregadoParts['quarteirao'] ?? '______'); ?> Flat <?php echo e($enderecoEncarregadoParts['flat'] ?? '______'); ?><br>
        Tel: <?php echo e($aluno->telefone_encarregado ?? '____________________'); ?> ou <?php echo e($aluno->telefone_encarregado_alternativo ?? '____________________'); ?> &nbsp;&nbsp;
        Grau de parentesco: <?php echo e($aluno->parentesco_encarregado ?? '____________________'); ?>

    </div>

    <!-- DADOS DE SAÚDE DO ALUNO -->
    <div class="section">
        <div class="section-title">DADOS DE SAÚDE DO ALUNO</div>

        É dependente de algum plano de Saúde? Se sim, qual?
        <span class="line"><?php echo e($aluno->plano_saude ?? ''); ?></span><br>

        Tem algum problema de saúde crónico? Se sim, qual?
        <span class="line"><?php echo e($aluno->problema_saude_cronico ?? ''); ?></span><br>

        Tem alergias? Se sim, qual?
        <span class="line"><?php echo e($aluno->alergias ?? ''); ?></span><br>

        Já recebeu algum diagnóstico médico de deficiência? Se sim, qual?
        <span class="line"><?php echo e($aluno->deficiencia ?? ''); ?></span><br>

        Apresenta alguma dificuldade motora, auditiva, visual, na fala ou emocional?
        <span class="line"><?php echo e($aluno->dificuldades ?? ''); ?></span><br>

        Está em tratamento médico? Se sim, para que doença?
        <span class="line"><?php echo e($aluno->tratamento_medico ?? ''); ?></span><br>

        Está em uso de alguma medicação? Qual? Quando encerrar o uso?
        <span class="line"><?php echo e($aluno->medicacao ?? ''); ?></span><br>

        As vacinas do calendário de vacinação do Ministério da Saúde estão em dia?
        <span class="line"><?php echo e($aluno->vacinas_em_dia ? 'Sim' : ($aluno->vacinas_em_dia === false ? 'Não' : '')); ?></span><br>

        Em caso de emergência para quem ligar e em qual número?
        <span class="line"><?php echo e($aluno->contato_emergencia ?? ''); ?></span><br>

        Existe alguma outra informação a respeito da saúde do aluno (a)
        que o Encarregado queira fazer constar da ficha?
        <span class="line"><?php echo e($aluno->outras_informacoes_saude ?? ''); ?></span>
        <span class="line"></span>
    </div>

    <div class="section">
        <div class="section-title">INDIVÍDUOS AUTORIZADOS A ACOMPANHAR O ALUNO (a) (b)</div>
        Nome: <?php echo e($aluno->individuo_autorizado_1_nome ?? '____________________'); ?> Tel: <?php echo e($aluno->individuo_autorizado_1_telefone ?? '____________________'); ?> ou <?php echo e($aluno->individuo_autorizado_2_telefone ?? '____________________'); ?><br>
        Nome: <?php echo e($aluno->individuo_autorizado_2_nome ?? '____________________'); ?> Tel: <?php echo e($aluno->individuo_autorizado_2_telefone ?? '____________________'); ?> ou <?php echo e($aluno->individuo_autorizado_3_telefone ?? '____________________'); ?><br>
        Nome: <?php echo e($aluno->individuo_autorizado_3_nome ?? '____________________'); ?> Tel: <?php echo e($aluno->individuo_autorizado_3_telefone ?? '____________________'); ?>

    </div>

    <div class="section">
        <div class="section-title">TERMO DE COMPROMISSO</div>
        <p class="small">
            Através da entrega desta ficha, abaixo assinada, solicito a matrícula do aluno(a)
            <strong><?php echo e($aluno->user->name ?? ''); ?></strong> para frequentar a 
            <?php if($turma && $turma->codigo): ?>
                <?php
                    preg_match('/^(\d+)/', $turma->codigo, $matches);
                    $classeNumero = $matches[1] ?? '';
                ?>
                <strong><?php echo e($classeNumero); ?></strong>
            <?php else: ?>
                _____
            <?php endif; ?>
            ª Classe do ensino Nacional
            para o ano lectivo <strong><?php echo e($anoLetivo->ano ?? date('Y')); ?></strong>, ciente de que para a efectivação da matrícula são
            indispensáveis o pagamento da taxa de inscrição e a assinatura desta ficha.
        </p>

        <div class="signature">
            Matola, aos ____ de __________________ de 20____<br><br>
            <div class="signature-line"></div>
            Assinatura do Encarregado de Educação
        </div>
    </div>

    <div class="footer">
    a) Para efeitos de benefícios diversos (redução de propinas e Uso das instalações para eventos, mediante Termos e Condições Aplicáveis)
    <br>
    b) Adulto, idôneo ou maior de 16 anos emancipado.   
    </div>

</div>

</body>
</html>
<?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/admin/alunos/ficha-inscricao-view.blade.php ENDPATH**/ ?>