

<?php $__env->startSection('title', 'Criar Professor - SGE'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-md-10">
        <div class="card">
            <div class="card-header bg-primary-custom text-white">
                <h4 class="mb-0">Criar Novo Professor</h4>
            </div>
            <div class="card-body">
                <form method="POST" action="<?php echo e(route('admin.professores.store')); ?>" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>

                    <div class="row g-2">
                        <div class="col-md-6">
                            <label for="name" class="form-label">Nome *</label>
                            <input type="text" class="form-control form-control-sm <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   id="name" name="name" value="<?php echo e(old('name')); ?>" required>
                            <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="col-md-6">
                            <label for="genero" class="form-label">Género</label>
                            <select class="form-select form-select-sm <?php $__errorArgs = ['genero'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                    id="genero" name="genero">
                                <option value="">Selecione</option>
                                <option value="M" <?php echo e(old('genero') == 'M' ? 'selected' : ''); ?>>Masculino</option>
                                <option value="F" <?php echo e(old('genero') == 'F' ? 'selected' : ''); ?>>Feminino</option>
                                <option value="Outro" <?php echo e(old('genero') == 'Outro' ? 'selected' : ''); ?>>Outro</option>
                            </select>
                            <?php $__errorArgs = ['genero'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="col-md-6">
                            <label for="telefone" class="form-label">Contacto</label>
                            <input type="text" class="form-control form-control-sm <?php $__errorArgs = ['telefone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   id="telefone" name="telefone" value="<?php echo e(old('telefone')); ?>" 
                                   placeholder="Ex: 842528792">
                            <?php $__errorArgs = ['telefone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="col-md-6">
                            <label for="nivel_ensino" class="form-label">Nível de Ensino *</label>
                            <select class="form-select form-select-sm <?php $__errorArgs = ['nivel_ensino'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    id="nivel_ensino" name="nivel_ensino" required>
                                <option value="">Selecione</option>
                                <option value="PRIMARIO" <?php echo e(old('nivel_ensino') == 'PRIMARIO' ? 'selected' : ''); ?>>Primário</option>
                                <option value="SECUNDARIO" <?php echo e(old('nivel_ensino') == 'SECUNDARIO' ? 'selected' : ''); ?>>Secundário</option>
                                <option value="AMBOS" <?php echo e(old('nivel_ensino', 'AMBOS') == 'AMBOS' ? 'selected' : ''); ?>>Ambos</option>
                            </select>
                            <?php $__errorArgs = ['nivel_ensino'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <!-- Campos de Salário -->
                        <div class="col-md-6" id="salario_fixo_field" style="display: none;">
                            <label for="salario_fixo" class="form-label">Salário Fixo (MT) *</label>
                            <input type="number" step="0.01" min="0" 
                                   class="form-control form-control-sm <?php $__errorArgs = ['salario_fixo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   id="salario_fixo" name="salario_fixo" 
                                   value="<?php echo e(old('salario_fixo')); ?>" 
                                   placeholder="Ex: 15000.00">
                            <small class="form-text text-muted">Salário fixo para professores da primária</small>
                            <?php $__errorArgs = ['salario_fixo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="col-md-6" id="valor_hora_field" style="display: none;">
                            <label for="valor_hora" class="form-label">Valor por Hora (MT) *</label>
                            <input type="number" step="0.01" min="0" 
                                   class="form-control form-control-sm <?php $__errorArgs = ['valor_hora'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   id="valor_hora" name="valor_hora" 
                                   value="<?php echo e(old('valor_hora')); ?>" 
                                   placeholder="Ex: 500.00">
                            <small class="form-text text-muted">Valor por hora para professores do secundário</small>
                            <?php $__errorArgs = ['valor_hora'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="col-md-6">
                            <label for="documento_identificacao" class="form-label">Documento (Opcional)</label>
                            <input type="file" class="form-control form-control-sm <?php $__errorArgs = ['documento_identificacao'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   id="documento_identificacao" name="documento_identificacao" 
                                   accept=".pdf,.jpg,.jpeg,.png">
                            <?php $__errorArgs = ['documento_identificacao'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="col-md-6">
                            <label for="turma_id" class="form-label">Turma (Opcional)</label>
                            <select class="form-select form-select-sm <?php $__errorArgs = ['turma_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                    id="turma_id" name="turma_id">
                                <option value="">Selecione uma turma</option>
                                <?php $__currentLoopData = $turmas ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $turma): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($turma->id); ?>"
                                            data-nivel="<?php echo e($turma->nivel_ensino ?? 'PRIMARIO'); ?>"
                                            <?php echo e(old('turma_id') == $turma->id ? 'selected' : ''); ?>>
                                        <?php echo e($turma->codigo); ?> - Turma <?php echo e($turma->nome); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php $__errorArgs = ['turma_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="col-md-6">
                            <label for="disciplinas" class="form-label">Disciplinas (Opcional)</label>
                            <select class="form-select form-select-sm <?php $__errorArgs = ['disciplinas'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                    id="disciplinas" name="disciplinas[]" multiple size="4">
                                <?php $__currentLoopData = $disciplinas ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $disciplina): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($disciplina->id); ?>"
                                            data-nivel="<?php echo e($disciplina->nivel_ensino ?? 'PRIMARIO'); ?>"
                                            <?php echo e(in_array($disciplina->id, old('disciplinas', [])) ? 'selected' : ''); ?>>
                                        <?php echo e($disciplina->nome); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <small class="form-text text-muted">Mantenha Ctrl pressionado para selecionar múltiplas</small>
                            <?php $__errorArgs = ['disciplinas'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>

                    <div class="mt-3">
                        <button type="submit" class="btn btn-primary-custom btn-sm">Criar Professor</button>
                        <a href="<?php echo e(route('admin.professores.index')); ?>" class="btn btn-secondary btn-sm">Cancelar</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<script>
function initProfessorCreateForm() {
    const nivelSelect = document.getElementById('nivel_ensino');
    const disciplinasSelect = document.getElementById('disciplinas');
    const turmasSelect = document.getElementById('turma_id');

    function filtrarDisciplinas() {
        if (!nivelSelect || !disciplinasSelect) return;
        const nivel = nivelSelect.value || 'AMBOS';
        const options = Array.from(disciplinasSelect.options);
        options.forEach(option => {
            const nivelDisciplina = option.getAttribute('data-nivel') || 'PRIMARIO';
            const visivel = (nivel === 'AMBOS') || (nivelDisciplina === nivel);
            option.hidden = !visivel;
            if (!visivel) {
                option.selected = false;
            }
        });
    }

    function filtrarTurmas() {
        if (!nivelSelect || !turmasSelect) return;
        const nivel = nivelSelect.value || 'AMBOS';
        const options = Array.from(turmasSelect.options);
        options.forEach(option => {
            if (!option.value) return;
            const nivelTurma = option.getAttribute('data-nivel') || 'PRIMARIO';
            const visivel = (nivel === 'AMBOS') || (nivelTurma === nivel);
            option.hidden = !visivel;
            if (!visivel && option.selected) {
                option.selected = false;
            }
        });
    }

    // Função para mostrar/ocultar campos de salário baseado no nível
    function atualizarCamposSalario() {
        const nivel = nivelSelect.value;
        const salarioFixoField = document.getElementById('salario_fixo_field');
        const valorHoraField = document.getElementById('valor_hora_field');
        const salarioFixoInput = document.getElementById('salario_fixo');
        const valorHoraInput = document.getElementById('valor_hora');

        if (nivel === 'PRIMARIO' || nivel === 'AMBOS') {
            if (salarioFixoField) salarioFixoField.style.display = 'block';
            if (salarioFixoInput) salarioFixoInput.required = true;
        } else {
            if (salarioFixoField) salarioFixoField.style.display = 'none';
            if (salarioFixoInput) {
                salarioFixoInput.required = false;
                salarioFixoInput.value = '';
            }
        }

        if (nivel === 'SECUNDARIO' || nivel === 'AMBOS') {
            if (valorHoraField) valorHoraField.style.display = 'block';
            if (valorHoraInput) valorHoraInput.required = true;
        } else {
            if (valorHoraField) valorHoraField.style.display = 'none';
            if (valorHoraInput) {
                valorHoraInput.required = false;
                valorHoraInput.value = '';
            }
        }
    }

    if (nivelSelect) {
        nivelSelect.addEventListener('change', function() {
            filtrarDisciplinas();
            filtrarTurmas();
            atualizarCamposSalario();
        });
        filtrarDisciplinas();
        filtrarTurmas();
        atualizarCamposSalario(); // Executar ao carregar a página
    }
}

window.initProfessorCreateForm = initProfessorCreateForm;

document.addEventListener('DOMContentLoaded', function() {
    initProfessorCreateForm();
});
</script>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/admin/professores/create.blade.php ENDPATH**/ ?>