

<?php $__env->startSection('title', 'Minhas Turmas - Professor'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h4 class="mb-0">
                <i class="bi bi-building text-success me-2"></i>
                Minhas Turmas e Disciplinas
            </h4>
            <div>
                <span class="badge bg-primary"><?php echo e($anoLetivoAtivo->ano ?? 'N/A'); ?></span>
                <a href="<?php echo e(route('professor.dashboard')); ?>" class="btn btn-sm btn-secondary">
                    <i class="bi bi-arrow-left me-1"></i> Voltar
                </a>
            </div>
        </div>
    </div>

    <div class="col-12">
        <div class="card border-0 shadow-sm">
            <div class="card-body p-2">
                <?php if(count($alocacoes) > 0): ?>
                    <?php
                        $totalTurmas = $alocacoes->pluck('turma_codigo')->unique()->count();
                        $totalDisciplinas = $alocacoes->pluck('disciplina_nome')->unique()->count();
                        $totalAlunos = $alocacoes->sum('total_alunos');
                    ?>
                    
                    <div class="mb-2 p-2" style="background-color: #f8f9fa; border-radius: 4px; font-size: 0.75rem;">
                        <div class="d-flex flex-wrap gap-3">
                            <span><strong>Total de Turmas:</strong> <?php echo e($totalTurmas); ?></span>
                            <span><strong>Total de Disciplinas:</strong> <?php echo e($totalDisciplinas); ?></span>
                            <span><strong>Total de Alocações:</strong> <?php echo e(count($alocacoes)); ?></span>
                            <span><strong>Total de Alunos:</strong> <?php echo e($totalAlunos); ?></span>
                        </div>
                    </div>
                    
                    <div class="table-responsive">
                        <table class="table table-bordered table-sm" style="font-size: 0.75rem;">
                            <style>
                                .table-bordered th, .table-bordered td {
                                    padding: 0.3rem 0.5rem !important;
                                }
                                .grupo-classe {
                                    background-color: #e9ecef !important;
                                    font-weight: 600;
                                }
                            </style>
                            <thead>
                                <tr>
                                    <th style="width: 25%;">Classe</th>
                                    <th style="width: 20%;">Turma</th>
                                    <th style="width: 25%;">Disciplina</th>
                                    <th style="width: 10%; text-align: center;">Alunos</th>
                                    <th style="width: 20%; text-align: center;">Acções</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                    $classeAnterior = null;
                                ?>
                                <?php $__currentLoopData = $alocacoes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $alocacao): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $classeAtual = $alocacao->turma_codigo;
                                        $novaClasse = $classeAnterior !== $classeAtual;
                                        $classeAnterior = $classeAtual;
                                    ?>
                                    <?php if($novaClasse && count($alocacoes) > 1): ?>
                                        <tr class="grupo-classe">
                                            <td colspan="5" style="padding: 0.4rem 0.5rem;">
                                                <strong><?php echo e($alocacao->turma_codigo); ?></strong>
                                                <?php
                                                    $disciplinasClasse = $alocacoes->where('turma_codigo', $alocacao->turma_codigo)->pluck('disciplina_nome')->unique()->count();
                                                ?>
                                                <span class="text-muted" style="font-size: 0.7rem; margin-left: 10px;">
                                                    (<?php echo e($alocacoes->where('turma_codigo', $alocacao->turma_codigo)->count()); ?> alocação(ões), 
                                                    <?php echo e($disciplinasClasse); ?> disciplina(s))
                                                </span>
                                            </td>
                                        </tr>
                                    <?php endif; ?>
                                    <tr>
                                        <td><?php echo e($alocacao->turma_codigo); ?></td>
                                        <td><?php echo e($alocacao->turma_nome); ?></td>
                                        <td>
                                            <span class="badge bg-info" style="font-size: 0.7rem;"><?php echo e($alocacao->disciplina_nome); ?></span>
                                        </td>
                                        <td class="text-center"><?php echo e($alocacao->total_alunos ?? 0); ?></td>
                                        <td style="text-align: center;">
                                            <?php if(isset($alocacao->turma_id) && isset($alocacao->disciplina_id)): ?>
                                                <a href="<?php echo e(route('avaliacoes.create')); ?>?turma_id=<?php echo e($alocacao->turma_id); ?>&disciplina_id=<?php echo e($alocacao->disciplina_id); ?>" 
                                                   class="btn btn-sm btn-primary" style="font-size: 0.7rem; padding: 0.2rem 0.4rem;" title="Lançar avaliações">
                                                    <i class="bi bi-clipboard-plus"></i> Lançar
                                                </a>
                                                <a href="<?php echo e(route('avaliacoes.index')); ?>?turma_id=<?php echo e($alocacao->turma_id); ?>&disciplina_id=<?php echo e($alocacao->disciplina_id); ?>" 
                                                   class="btn btn-sm btn-outline-info" style="font-size: 0.7rem; padding: 0.2rem 0.4rem;" title="Ver avaliações">
                                                    <i class="bi bi-eye"></i> Ver
                                                </a>
                                            <?php else: ?>
                                                <span class="text-muted" style="font-size: 0.7rem;">Dados incompletos</span>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                <?php else: ?>
                    <div class="text-center py-5">
                        <i class="bi bi-inbox display-4 text-muted"></i>
                        <p class="text-muted mt-3">Nenhuma turma atribuída</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/professor/turmas.blade.php ENDPATH**/ ?>