

<?php $__env->startSection('title', 'Criar TPC - Professor'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-2" style="font-size: 0.85rem;">
            <h5 class="mb-0" style="font-weight: 600;">Criar Novo TPC</h5>
            <a href="<?php echo e(route('professor.tpcs.index')); ?>" class="btn btn-sm btn-secondary" style="font-size: 0.85rem; padding: 0.25rem 0.5rem;">
                <i class="bi bi-arrow-left"></i> Voltar
            </a>
        </div>

        <div class="card border-0 shadow-sm">
            <div class="card-body p-2">
                <form method="POST" action="<?php echo e(route('professor.tpcs.store')); ?>" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    
                <div class="mb-2">
                    <label for="titulo" class="form-label small mb-0">Título <span class="text-danger">*</span></label>
                    <input type="text" class="form-control form-control-sm <?php $__errorArgs = ['titulo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                           id="titulo" name="titulo" value="<?php echo e(old('titulo')); ?>" required>
                    <?php $__errorArgs = ['titulo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback small"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div class="row g-2">
                    <div class="col-md-6 mb-2">
                        <label for="turma_id" class="form-label small mb-0">Turma <span class="text-danger">*</span></label>
                        <select class="form-select form-select-sm <?php $__errorArgs = ['turma_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                id="turma_id" name="turma_id" required>
                            <option value="">Selecione a turma</option>
                            <?php $__currentLoopData = $alocacoes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $alocacao): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($alocacao->turma_id); ?>" 
                                        data-disciplina="<?php echo e($alocacao->disciplina_id); ?>"
                                        <?php echo e(old('turma_id') == $alocacao->turma_id ? 'selected' : ''); ?>>
                                    <?php echo e($alocacao->turma_codigo); ?> - <?php echo e($alocacao->turma_nome); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php $__errorArgs = ['turma_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback small"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="col-md-6 mb-2">
                        <label for="disciplina_id" class="form-label small mb-0">Disciplina <span class="text-danger">*</span></label>
                        <select class="form-select form-select-sm <?php $__errorArgs = ['disciplina_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                id="disciplina_id" name="disciplina_id" required>
                            <option value="">Selecione a disciplina</option>
                            <?php $__currentLoopData = $alocacoes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $alocacao): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($alocacao->disciplina_id); ?>" 
                                        data-turma="<?php echo e($alocacao->turma_id); ?>"
                                        <?php echo e(old('disciplina_id') == $alocacao->disciplina_id ? 'selected' : ''); ?>>
                                    <?php echo e($alocacao->disciplina_nome); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php $__errorArgs = ['disciplina_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback small"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>

                <div class="row g-2">
                    <div class="col-md-6 mb-2">
                        <label for="data_entrega" class="form-label small mb-0">Data de Entrega <span class="text-danger">*</span></label>
                        <input type="date" class="form-control form-control-sm <?php $__errorArgs = ['data_entrega'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                               id="data_entrega" name="data_entrega" value="<?php echo e(old('data_entrega')); ?>" required>
                        <?php $__errorArgs = ['data_entrega'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback small"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="col-md-6 mb-2">
                        <label for="valor" class="form-label small mb-0">Valor</label>
                        <input type="number" step="0.1" min="0" max="20" class="form-control form-control-sm <?php $__errorArgs = ['valor'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                               id="valor" name="valor" value="<?php echo e(old('valor')); ?>">
                        <?php $__errorArgs = ['valor'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback small"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>

                <div class="mb-2">
                    <label for="descricao" class="form-label small mb-0">Descrição</label>
                    <textarea class="form-control form-control-sm <?php $__errorArgs = ['descricao'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                              id="descricao" name="descricao" rows="2"><?php echo e(old('descricao')); ?></textarea>
                    <?php $__errorArgs = ['descricao'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback small"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div class="mb-2">
                    <label for="arquivo" class="form-label small mb-0">Arquivo</label>
                    <input type="file" class="form-control form-control-sm <?php $__errorArgs = ['arquivo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                           id="arquivo" name="arquivo" accept=".pdf,.doc,.docx">
                    <?php $__errorArgs = ['arquivo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback small"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div class="d-flex justify-content-between mt-2">
                    <a href="<?php echo e(route('professor.tpcs.index')); ?>" class="btn btn-sm btn-secondary" style="font-size: 0.75rem; padding: 0.25rem 0.5rem;">
                        <i class="bi bi-x-circle"></i> Cancelar
                    </a>
                    <button type="submit" class="btn btn-sm btn-primary" style="font-size: 0.75rem; padding: 0.25rem 0.5rem;">
                        <i class="bi bi-check-circle"></i> Criar
                    </button>
                </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const turmaSelect = document.getElementById('turma_id');
    const disciplinaSelect = document.getElementById('disciplina_id');
    
    // Filtrar disciplinas quando turma é selecionada
    turmaSelect.addEventListener('change', function() {
        const turmaId = this.value;
        const options = disciplinaSelect.querySelectorAll('option[data-turma]');
        
        options.forEach(option => {
            if (turmaId && option.getAttribute('data-turma') !== turmaId) {
                option.style.display = 'none';
            } else {
                option.style.display = '';
            }
        });
        
        if (!turmaId) {
            disciplinaSelect.value = '';
        }
    });
    
    // Filtrar turmas quando disciplina é selecionada
    disciplinaSelect.addEventListener('change', function() {
        const disciplinaId = this.value;
        const options = turmaSelect.querySelectorAll('option[data-disciplina]');
        
        options.forEach(option => {
            if (disciplinaId && option.getAttribute('data-disciplina') !== disciplinaId) {
                option.style.display = 'none';
            } else {
                option.style.display = '';
            }
        });
        
        if (!disciplinaId) {
            turmaSelect.value = '';
        }
    });
});
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/professor/tpcs/create.blade.php ENDPATH**/ ?>