<?php $__env->startSection('title', 'Turmas - SGE'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-2" style="border-bottom: 1px solid #dee2e6; padding-bottom: 8px;">
            <h5 class="mb-0" style="font-weight: 600;">Turmas</h5>
            <a href="<?php echo e(route('admin.turmas.create')); ?>" class="btn btn-sm btn-primary">Nova Turma</a>
        </div>

        <form method="GET" action="<?php echo e(route('admin.turmas.index')); ?>" class="mb-2" style="display: flex; gap: 8px; align-items: end;">
            <input type="text" class="form-control form-control-sm" name="search" id="search"
                   placeholder="Pesquisar..." value="<?php echo e(request('search')); ?>" style="flex: 1;">
            <select class="form-select form-select-sm" name="ano_letivo_id" id="ano_letivo_id" style="width: 150px;">
                <option value="">2026 (Padrão)</option>
                <?php $__currentLoopData = $anoLetivos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ano): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($ano->id); ?>" <?php echo e(request('ano_letivo_id') == $ano->id ? 'selected' : ''); ?>><?php echo e($ano->ano_inicial); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
            <select class="form-select form-select-sm" name="nivel_ensino" id="nivel_ensino" style="width: 150px;">
                <option value="">Todos os Níveis</option>
                <option value="PRIMARIO" <?php echo e(request('nivel_ensino') == 'PRIMARIO' ? 'selected' : ''); ?>>Primário</option>
                <option value="SECUNDARIO" <?php echo e(request('nivel_ensino') == 'SECUNDARIO' ? 'selected' : ''); ?>>Secundário</option>
            </select>
            <button type="submit" class="btn btn-sm btn-primary">Filtrar</button>
            <?php if(request('search') || request('ano_letivo_id') || request('nivel_ensino')): ?>
                <a href="<?php echo e(route('admin.turmas.index')); ?>" class="btn btn-sm btn-secondary">Limpar</a>
            <?php endif; ?>
        </form>

        <div class="js-ajax-pagination">
            <div class="table-responsive">
                <table class="table table-sm table-bordered" style="font-size: 0.85rem; margin-bottom: 0;">
                <thead style="background-color: #f8f9fa;">
                    <tr>
                        <th style="padding: 6px;">Classe</th>
                        <th style="padding: 6px;">Turma</th>
                        <th style="padding: 6px;">Nível</th>
                        <th style="padding: 6px;">Ano Letivo</th>
                        <th style="padding: 6px;">Capacidade</th>
                        <th style="padding: 6px;">Status</th>
                        <th style="padding: 6px;">Acções</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $turmas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $turma): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <?php
                            try {
                                $anoLetivoAtivo = \App\Models\AnoLetivo::getAnoLetivoAtual();
                                $totalAlunos = $turma->alunos()->wherePivot('ano_letivo_id', $anoLetivoAtivo?->id)->count();
                            } catch (\Exception $e) {
                                $totalAlunos = 0;
                            }
                        ?>
                        <tr>
                            <td style="padding: 5px;"><?php echo e($turma->codigo); ?></td>
                            <td style="padding: 5px;">
                                <a href="<?php echo e(route('admin.turmas.show', $turma)); ?>" style="text-decoration: none; color: inherit;">Turma <?php echo e($turma->nome); ?></a>
                            </td>
                            <td style="padding: 5px;">
                                <?php echo e(($turma->nivel_ensino ?? 'PRIMARIO') === 'SECUNDARIO' ? 'Secundário' : 'Primário'); ?>

                            </td>
                            <td style="padding: 5px;">
                                <?php
                                    try {
                                        $anoRaw = $turma->anoLetivo ? $turma->anoLetivo->getRawOriginal('ano') : null;
                                        $anoExibir = $anoRaw ? (strpos($anoRaw, '/') !== false ? explode('/', $anoRaw)[0] : $anoRaw) : '-';
                                    } catch (\Exception $e) {
                                        $anoExibir = '-';
                                    }
                                ?>
                                <?php echo e($anoExibir); ?>

                            </td>
                            <td style="padding: 5px;">
                                <span style="font-size: 0.75rem; padding: 2px 6px; background: #e7f3ff; color: #0066cc; border-radius: 3px;"><?php echo e($totalAlunos); ?>/<?php echo e($turma->capacidade_maxima ?: 35); ?></span>
                            </td>
                            <td style="padding: 5px;">
                                <?php if($turma->ativa): ?>
                                    <span style="font-size: 0.75rem; padding: 2px 6px; background: #d4edda; color: #155724; border-radius: 3px;">Activa</span>
                                <?php else: ?>
                                    <span style="font-size: 0.75rem; padding: 2px 6px; background: #e2e3e5; color: #383d41; border-radius: 3px;">Inactiva</span>
                                <?php endif; ?>
                            </td>
                            <td style="padding: 5px;">
                                <div style="display: flex; gap: 4px; flex-wrap: wrap;">
                                    <a href="<?php echo e(route('admin.turmas.show', $turma)); ?>" class="btn btn-sm" style="padding: 2px 6px; font-size: 0.75rem; background: #e7f3ff; color: #0066cc; border: none;" title="Ver detalhes">
                                        <i class="bi bi-eye"></i>
                                    </a>
                                    <a href="<?php echo e(route('admin.turmas.edit', $turma)); ?>" class="btn btn-sm" style="padding: 2px 6px; font-size: 0.75rem; background: #fff3cd; color: #856404; border: none;" title="Editar">
                                        <i class="bi bi-pencil"></i>
                                    </a>
                                    <a href="<?php echo e(route('admin.turmas.alocar-alunos', $turma)); ?>" class="btn btn-sm" style="padding: 2px 6px; font-size: 0.75rem; background: #d4edda; color: #155724; border: none;" title="Alocar Alunos">
                                        <i class="bi bi-people"></i>
                                    </a>
                                    <a href="<?php echo e(route('admin.turmas.atribuir-disciplinas', $turma)); ?>" class="btn btn-sm" style="padding: 2px 6px; font-size: 0.75rem; background: #d1ecf1; color: #0c5460; border: none;" title="Disciplinas e Professores">
                                        <i class="bi bi-book"></i>
                                    </a>
                                    <form action="<?php echo e(route('admin.turmas.destroy', $turma)); ?>" method="POST" class="d-inline delete-form"
                                          data-id="<?php echo e($turma->id); ?>"
                                          data-confirm="Tem certeza que deseja eliminar esta turma?">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn btn-sm" style="padding: 2px 6px; font-size: 0.75rem; background: #f8d7da; color: #721c24; border: none;" title="Eliminar">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="7" class="text-center text-muted">
                                <i class="bi bi-inbox"></i> Nenhuma turma encontrada
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
                </table>
            </div>
            
            <?php if(method_exists($turmas, 'links')): ?>
                <div class="mt-3">
                    <?php echo e($turmas->appends(request()->query())->links()); ?>

                </div>
            <?php endif; ?>
        </div>

    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Variável para controlar se já está processando uma requisição
    let processando = false;
    
    // Interceptar formulários de delete
    document.querySelectorAll('.delete-form').forEach(function(form) {
        form.addEventListener('submit', function(e) {
            e.preventDefault();
            
            // Evitar múltiplas requisições simultâneas
            if (processando) {
                return false;
            }
            
            const confirmMsg = this.getAttribute('data-confirm');
            if (!confirm(confirmMsg)) {
                return false;
            }
            
            processando = true;
            
            const formData = new FormData(this);
            const row = this.closest('tr');
            const url = this.action;
            
            // Mostrar loading
            const submitBtn = this.querySelector('button[type="submit"]');
            const originalHTML = submitBtn.innerHTML;
            submitBtn.disabled = true;
            submitBtn.innerHTML = '<i class="bi bi-hourglass-split"></i>';
            
            fetch(url, {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': formData.get('_token'),
                    'X-Requested-With': 'XMLHttpRequest',
                    'Accept': 'application/json'
                },
                body: formData
            })
            .then(response => {
                if (!response.ok) {
                    return response.json().then(data => {
                        throw new Error(data.message || 'Erro ao processar requisição');
                    }).catch(err => {
                        // Se não conseguir parsear JSON, usar mensagem padrão
                        if (err.message === 'Erro ao processar requisição' && response.status === 404) {
                            throw new Error('O registo solicitado não foi encontrado ou foi eliminado.');
                        }
                        throw err;
                    });
                }
                return response.json();
            })
            .then(data => {
                processando = false;
                
                if (data.success) {
                    // Remover linha da tabela com animação
                    row.style.transition = 'opacity 0.3s';
                    row.style.opacity = '0';
                    setTimeout(function() {
                        row.remove();
                        // Verificar se a tabela ficou vazia
                        const tbody = document.querySelector('tbody');
                        if (tbody && tbody.children.length === 0) {
                            tbody.innerHTML = '<tr><td colspan="7" class="text-center text-muted"><i class="bi bi-inbox"></i> Nenhuma turma encontrada</td></tr>';
                        }
                    }, 300);
                } else {
                    alert('Erro: ' + (data.message || 'Erro desconhecido'));
                    submitBtn.disabled = false;
                    submitBtn.innerHTML = originalHTML;
                }
            })
            .catch(error => {
                processando = false;
                console.error('Erro:', error);
                
                // Evitar múltiplos alerts
                if (!window.alertMostrado) {
                    window.alertMostrado = true;
                    alert('Erro: ' + (error.message || 'Erro ao eliminar turma. Por favor, tente novamente.'));
                    setTimeout(function() {
                        window.alertMostrado = false;
                    }, 1000);
                }
                
                submitBtn.disabled = false;
                submitBtn.innerHTML = originalHTML;
            });
        });
    });
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/admin/turmas/index.blade.php ENDPATH**/ ?>