<?php $__env->startSection('title', 'Lançar Avaliação - SGE'); ?>

<?php $__env->startSection('content'); ?>
<style>
    /* Estilos Mobile para Lançamento de Notas */
    @media (max-width: 768px) {
        .avaliacoes-mobile-header {
            background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
            color: white;
            padding: 1rem;
            margin: -1rem -1rem 1.5rem -1rem;
            position: relative;
        }
        
        .avaliacoes-mobile-header .back-btn {
            position: absolute;
            top: 1rem;
            left: 1rem;
            color: white;
            font-size: 1.5rem;
            text-decoration: none;
            z-index: 10;
        }
        
        .avaliacoes-mobile-header h1 {
            font-size: 1.1rem;
            font-weight: bold;
            margin: 0.5rem 0;
            text-align: center;
        }
        
        .avaliacoes-mobile-tabs {
            display: flex;
            gap: 0.5rem;
            margin: 0 -1rem 1rem -1rem;
            padding: 0 1rem;
            overflow-x: auto;
            -webkit-overflow-scrolling: touch;
        }
        
        .avaliacoes-mobile-tab {
            flex: 1;
            min-width: 100px;
            padding: 0.75rem 1rem;
            background: #f8f9fa;
            border: 1px solid #dee2e6;
            border-radius: 8px 8px 0 0;
            text-align: center;
            font-size: 0.85rem;
            font-weight: 500;
            color: #666;
            text-decoration: none;
            cursor: pointer;
            transition: all 0.2s;
        }
        
        .avaliacoes-mobile-tab.active {
            background: #4a90e2;
            color: white;
            border-color: #4a90e2;
            border-bottom: 3px solid #357abd;
        }
        
        .avaliacoes-mobile-disciplina {
            background: white;
            padding: 1rem;
            margin: 0 -1rem 1rem -1rem;
            border-bottom: 1px solid #e0e0e0;
            font-size: 0.95rem;
            font-weight: 600;
            color: #333;
        }
        
        .avaliacoes-mobile-aluno-card {
            background: white;
            border: 1px solid #e0e0e0;
            border-radius: 12px;
            margin-bottom: 1rem;
            padding: 1rem;
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        }
        
        .avaliacoes-mobile-aluno-nome {
            font-size: 1rem;
            font-weight: 600;
            color: #333;
            margin-bottom: 1rem;
            padding-bottom: 0.75rem;
            border-bottom: 1px solid #f0f0f0;
            display: flex;
            align-items: center;
            gap: 0.75rem;
        }
        
        .avaliacoes-mobile-aluno-numero {
            font-size: 0.85rem;
            color: #666;
            font-weight: 500;
        }
        
        .avaliacoes-mobile-aluno-genero {
            font-size: 0.85rem;
            color: #666;
            font-weight: 500;
        }
        
        .avaliacoes-mobile-notas-row {
            display: flex;
            gap: 0.5rem;
            margin-bottom: 0.5rem;
            align-items: center;
            flex-wrap: nowrap;
            overflow-x: auto;
            -webkit-overflow-scrolling: touch;
            padding: 0.5rem 0;
        }
        
        .avaliacoes-mobile-notas-label {
            font-size: 0.75rem;
            font-weight: 500;
            color: #666;
            white-space: nowrap;
        }
        
        .avaliacoes-mobile-notas-input {
            min-width: 60px;
            padding: 0.5rem 0.4rem;
            border: 1px solid #dee2e6;
            border-radius: 6px;
            font-size: 0.85rem;
            text-align: center;
            flex-shrink: 0;
        }
        
        .avaliacoes-mobile-notas-input:focus {
            border-color: #4a90e2;
            outline: none;
            box-shadow: 0 0 0 2px rgba(74, 144, 226, 0.1);
        }
        
        .avaliacoes-mobile-notas-input[readonly] {
            background-color: #f8f9fa;
            font-weight: 600;
        }
        
        .avaliacoes-mobile-actions {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            background: white;
            padding: 1rem;
            border-top: 1px solid #e0e0e0;
            display: flex;
            gap: 0.75rem;
            z-index: 100;
            box-shadow: 0 -2px 8px rgba(0,0,0,0.1);
        }
        
        .avaliacoes-mobile-actions .btn {
            flex: 1;
            padding: 0.75rem;
            font-size: 0.9rem;
            font-weight: 600;
            border-radius: 8px;
        }
        
        .avaliacoes-mobile-content {
            padding-bottom: 100px; /* Espaço para os botões fixos */
        }
    }
    
    /* Desktop - manter layout atual */
    @media (min-width: 769px) {
        .avaliacoes-mobile-header,
        .avaliacoes-mobile-tabs,
        .avaliacoes-mobile-disciplina,
        .avaliacoes-mobile-content,
        .avaliacoes-mobile-actions {
            display: none;
        }
    }
</style>

<!-- Layout Mobile -->
<div class="d-md-none avaliacoes-mobile-content">
    <div class="avaliacoes-mobile-header">
        <a href="<?php echo e(route('avaliacoes.index')); ?>" class="back-btn">
            <i class="bi bi-arrow-left"></i>
        </a>
        <h1>Lançar Avaliação</h1>
    </div>
    
    <div class="avaliacoes-mobile-tabs">
        <?php $__currentLoopData = $trimestres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <a href="<?php echo e(route('avaliacoes.create', ['turma_id' => $turma->id, 'disciplina_id' => $disciplina->id, 'trimestre_id' => $t->id])); ?>" 
               class="avaliacoes-mobile-tab <?php echo e($trimestre->id == $t->id ? 'active' : ''); ?>">
                <?php echo e($t->numero); ?>º <?php echo e(strpos($t->nome, 'Trimestre') !== false ? 'Trimestre' : 'Bimestre'); ?>

            </a>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
    
    <div class="avaliacoes-mobile-disciplina">
        <?php echo e($disciplina->nome); ?> - <?php echo e($turma->nome); ?>

    </div>
    
    <form method="POST" action="<?php echo e(route('avaliacoes.store')); ?>" id="form-avaliacoes-mobile">
        <?php echo csrf_field(); ?>
        <input type="hidden" name="turma_id" value="<?php echo e($turma->id); ?>">
        <input type="hidden" name="disciplina_id" value="<?php echo e($disciplina->id); ?>">
        <input type="hidden" name="trimestre_id" value="<?php echo e($trimestre->id); ?>">
        <input type="hidden" name="ano_letivo_id" value="<?php echo e($anoLetivo->id); ?>">
        <input type="hidden" name="modelo" value="NACIONAL">
        
        <?php
            $isSecundario = ($turma->nivel_ensino ?? 'PRIMARIO') === 'SECUNDARIO';
        ?>
        
        <?php $__currentLoopData = $alunos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $aluno): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
                $avaliacaoExistente = \App\Models\Avaliacao::where('aluno_id', $aluno->id)
                    ->where('disciplina_id', $disciplina->id)
                    ->where('turma_id', $turma->id)
                    ->where('trimestre_id', $trimestre->id)
                    ->where('ano_letivo_id', $anoLetivo->id)
                    ->first();
            ?>
            
            <div class="avaliacoes-mobile-aluno-card">
                <div class="avaliacoes-mobile-aluno-nome">
                    <span class="avaliacoes-mobile-aluno-numero"><?php echo e($index + 1); ?></span>
                    <span><?php echo e($aluno->user->name); ?></span>
                    <span class="avaliacoes-mobile-aluno-genero"><?php echo e($aluno->genero == 'M' ? 'H' : ($aluno->genero == 'F' ? 'M' : '')); ?></span>
                </div>
                
                <?php if($isSecundario): ?>
                    <div class="avaliacoes-mobile-notas-row">
                        <span class="avaliacoes-mobile-notas-label">Teste 1</span>
                        <input type="number" step="0.1" min="0" max="20" 
                               class="avaliacoes-mobile-notas-input teste-1" 
                               name="notas[<?php echo e($aluno->id); ?>][teste1]" 
                               value="<?php echo e($avaliacaoExistente->teste1 ?? ''); ?>"
                               data-aluno="<?php echo e($aluno->id); ?>"
                               <?php echo e(!$lancamentoNotasLiberado ? 'disabled readonly' : ''); ?>>
                    </div>
                    <div class="avaliacoes-mobile-notas-row">
                        <span class="avaliacoes-mobile-notas-label">Teste 2</span>
                        <input type="number" step="0.1" min="0" max="20" 
                               class="avaliacoes-mobile-notas-input teste-2" 
                               name="notas[<?php echo e($aluno->id); ?>][teste2]" 
                               value="<?php echo e($avaliacaoExistente->teste2 ?? ''); ?>"
                               data-aluno="<?php echo e($aluno->id); ?>"
                               <?php echo e(!$lancamentoNotasLiberado ? 'disabled readonly' : ''); ?>>
                    </div>
                    <div class="avaliacoes-mobile-notas-row">
                        <span class="avaliacoes-mobile-notas-label">Aval. Final</span>
                        <input type="number" step="0.1" min="0" max="20" 
                               class="avaliacoes-mobile-notas-input avaliacao-final" 
                               name="notas[<?php echo e($aluno->id); ?>][avaliacao_final]" 
                               value="<?php echo e($avaliacaoExistente->avaliacao_final ?? ''); ?>"
                               data-aluno="<?php echo e($aluno->id); ?>"
                               <?php echo e(!$lancamentoNotasLiberado ? 'disabled readonly' : ''); ?>>
                    </div>
                    <div class="avaliacoes-mobile-notas-row">
                        <span class="avaliacoes-mobile-notas-label">Média</span>
                        <input type="number" step="0.1" class="avaliacoes-mobile-notas-input media-nacional" 
                               name="notas[<?php echo e($aluno->id); ?>][media_nacional]" 
                               value="<?php echo e($avaliacaoExistente->media_nacional ?? ''); ?>"
                               data-aluno="<?php echo e($aluno->id); ?>" readonly>
                    </div>
                <?php else: ?>
                    <!-- A.Prática -->
                    <div style="margin-bottom: 1rem;">
                        <div style="font-size: 0.75rem; font-weight: 600; color: #666; margin-bottom: 0.5rem; padding-bottom: 0.25rem; border-bottom: 1px solid #e0e0e0;">A.Prática</div>
                        <div class="avaliacoes-mobile-notas-row">
                            <span class="avaliacoes-mobile-notas-label" style="min-width: 35px;">1ª</span>
                            <input type="number" step="0.1" min="0" max="20" 
                                   class="avaliacoes-mobile-notas-input a-pratica-1" 
                                   name="notas[<?php echo e($aluno->id); ?>][a_pratica_1]" 
                                   value="<?php echo e($avaliacaoExistente->a_pratica_1 ?? ''); ?>"
                                   data-aluno="<?php echo e($aluno->id); ?>"
                                   <?php echo e(!$lancamentoNotasLiberado ? 'disabled readonly' : ''); ?>

                                   style="max-width: 75px;">
                            <span class="avaliacoes-mobile-notas-label" style="min-width: 35px;">2ª</span>
                            <input type="number" step="0.1" min="0" max="20" 
                                   class="avaliacoes-mobile-notas-input a-pratica-2" 
                                   name="notas[<?php echo e($aluno->id); ?>][a_pratica_2]" 
                                   value="<?php echo e($avaliacaoExistente->a_pratica_2 ?? ''); ?>"
                                   data-aluno="<?php echo e($aluno->id); ?>"
                                   <?php echo e(!$lancamentoNotasLiberado ? 'disabled readonly' : ''); ?>

                                   style="max-width: 75px;">
                            <span class="avaliacoes-mobile-notas-label" style="min-width: 45px; font-weight: 600;">MAP</span>
                            <input type="number" step="0.1" class="avaliacoes-mobile-notas-input map" 
                                   name="notas[<?php echo e($aluno->id); ?>][map]" 
                                   value="<?php echo e($avaliacaoExistente->map ?? ''); ?>"
                                   data-aluno="<?php echo e($aluno->id); ?>" readonly style="max-width: 75px;">
                        </div>
                    </div>
                    
                    <!-- ACS -->
                    <div style="margin-bottom: 1rem;">
                        <div style="font-size: 0.75rem; font-weight: 600; color: #666; margin-bottom: 0.5rem; padding-bottom: 0.25rem; border-bottom: 1px solid #e0e0e0;">ACS</div>
                        <div class="avaliacoes-mobile-notas-row">
                            <span class="avaliacoes-mobile-notas-label" style="min-width: 35px;">1ª</span>
                            <input type="number" step="0.1" min="0" max="20" 
                                   class="avaliacoes-mobile-notas-input acs-1" 
                                   name="notas[<?php echo e($aluno->id); ?>][acs_1]" 
                                   value="<?php echo e($avaliacaoExistente->acs_1 ?? ''); ?>"
                                   data-aluno="<?php echo e($aluno->id); ?>"
                                   <?php echo e(!$lancamentoNotasLiberado ? 'disabled readonly' : ''); ?>

                                   style="max-width: 75px;">
                            <span class="avaliacoes-mobile-notas-label" style="min-width: 35px;">2ª</span>
                            <input type="number" step="0.1" min="0" max="20" 
                                   class="avaliacoes-mobile-notas-input acs-2" 
                                   name="notas[<?php echo e($aluno->id); ?>][acs_2]" 
                                   value="<?php echo e($avaliacaoExistente->acs_2 ?? ''); ?>"
                                   data-aluno="<?php echo e($aluno->id); ?>"
                                   <?php echo e(!$lancamentoNotasLiberado ? 'disabled readonly' : ''); ?>

                                   style="max-width: 75px;">
                            <span class="avaliacoes-mobile-notas-label" style="min-width: 50px; font-weight: 600;">MACS</span>
                            <input type="number" step="0.1" class="avaliacoes-mobile-notas-input macs" 
                                   name="notas[<?php echo e($aluno->id); ?>][macs]" 
                                   value="<?php echo e($avaliacaoExistente->macs ?? ''); ?>"
                                   data-aluno="<?php echo e($aluno->id); ?>" readonly style="max-width: 75px;">
                        </div>
                    </div>
                    
                    <!-- AT e MT -->
                    <div class="avaliacoes-mobile-notas-row">
                        <span class="avaliacoes-mobile-notas-label" style="min-width: 35px;">AT</span>
                        <input type="number" step="0.1" min="0" max="20" 
                               class="avaliacoes-mobile-notas-input at" 
                               name="notas[<?php echo e($aluno->id); ?>][at]" 
                               value="<?php echo e($avaliacaoExistente->at ?? ''); ?>"
                               data-aluno="<?php echo e($aluno->id); ?>"
                               <?php echo e(!$lancamentoNotasLiberado ? 'disabled readonly' : ''); ?>

                               style="max-width: 75px;">
                        <span class="avaliacoes-mobile-notas-label" style="min-width: 35px;">MT</span>
                        <input type="number" step="0.1" class="avaliacoes-mobile-notas-input mt" 
                               name="notas[<?php echo e($aluno->id); ?>][mt]" 
                               value="<?php echo e($avaliacaoExistente->mt ?? ''); ?>"
                               data-aluno="<?php echo e($aluno->id); ?>" readonly style="max-width: 75px;">
                    </div>
                <?php endif; ?>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </form>
    
    <?php if(!$lancamentoNotasLiberado): ?>
    <div class="alert alert-warning alert-dismissible fade show mb-2 mx-2" role="alert" style="font-size: 0.75rem; padding: 0.5rem 0.75rem;">
        <i class="bi bi-lock-fill"></i> <strong>Lançamento do <?php echo e($trimestre->numero); ?>º Trimestre trancado:</strong> Você pode apenas visualizar as notas.
    </div>
    <?php endif; ?>
    
    <div class="avaliacoes-mobile-actions">
        <?php if($lancamentoNotasLiberado): ?>
        <button type="submit" form="form-avaliacoes-mobile" class="btn btn-primary" id="btn-salvar-mobile">
            <span id="btn-salvar-text-mobile">Salvar</span>
            <span id="btn-salvar-loading-mobile" class="spinner-border spinner-border-sm d-none" role="status"></span>
        </button>
        <?php else: ?>
        <button type="button" class="btn btn-secondary" disabled>
            <i class="bi bi-lock-fill"></i> Lançamento Trancado
        </button>
        <?php endif; ?>
        <a href="<?php echo e(route('avaliacoes.index')); ?>" class="btn btn-secondary">Cancelar</a>
    </div>
</div>

<!-- Layout Desktop -->
<div class="d-none d-md-block">
<div class="row">
    <div class="col-md-12">
        <div class="card border-0 shadow-sm">
            <div class="card-body p-2">
                <!-- Informações e botões minimalistas -->
                <div class="mb-2 d-flex align-items-center justify-content-between flex-wrap gap-2" style="font-size: 0.85rem;">
                    <div class="d-flex align-items-center flex-wrap gap-2">
                        <span class="fw-bold"><?php echo e($turma->codigo); ?> - <?php echo e($turma->nome); ?></span>
                        <span>|</span>
                        <span class="fw-bold"><?php echo e($disciplina->nome); ?></span>
                        <form method="GET" action="<?php echo e(route('avaliacoes.create')); ?>" id="form-trimestre" class="d-inline-flex align-items-center gap-1">
                            <input type="hidden" name="turma_id" value="<?php echo e($turma->id); ?>">
                            <input type="hidden" name="disciplina_id" value="<?php echo e($disciplina->id); ?>">
                            <select class="form-select form-select-sm" id="trimestre_id" name="trimestre_id" style="width: auto; font-size: 0.85rem;">
                                <?php $__currentLoopData = $trimestres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($t->id); ?>" <?php echo e($trimestre->id == $t->id ? 'selected' : ''); ?>>
                                        <?php echo e($t->numero); ?>º Trimestre
                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </form>
                    </div>
                    <div class="text-muted" style="font-size: 0.7rem;">
                        <i class="bi bi-info-circle"></i> As notas devem estar entre 0 e 20
                    </div>
                    
                    <?php if(!$lancamentoNotasLiberado): ?>
                    <div class="alert alert-warning alert-dismissible fade show mb-2" role="alert" style="font-size: 0.75rem; padding: 0.5rem 0.75rem; margin-bottom: 0.5rem !important;">
                        <i class="bi bi-lock-fill"></i> <strong>Lançamento de notas do <?php echo e($trimestre->numero); ?>º Trimestre trancado:</strong> Você pode apenas visualizar as notas, mas não pode alterá-las.
                    </div>
                    <?php endif; ?>
                    
                    <div class="d-flex align-items-center gap-2">
                        <span id="status-auto-save" class="text-muted small d-none" style="font-size: 0.7rem;">
                            <i class="bi bi-arrow-repeat spinner-border spinner-border-sm" style="width: 0.7rem; height: 0.7rem;"></i>
                            <span id="status-auto-save-text">Salvando automaticamente...</span>
                        </span>
                        <?php if($lancamentoNotasLiberado): ?>
                        <button type="submit" form="form-avaliacoes" class="btn btn-primary btn-sm" id="btn-salvar" style="font-size: 0.85rem; padding: 0.25rem 0.5rem;">
                            <span id="btn-salvar-text">Salvar</span>
                            <span id="btn-salvar-loading" class="spinner-border spinner-border-sm d-none" role="status"></span>
                        </button>
                        <?php else: ?>
                        <button type="button" class="btn btn-secondary btn-sm" disabled style="font-size: 0.85rem; padding: 0.25rem 0.5rem;">
                            <i class="bi bi-lock-fill"></i> Lançamento Trancado
                        </button>
                        <?php endif; ?>
                        <a href="<?php echo e(route('avaliacoes.index')); ?>" class="btn btn-secondary btn-sm" style="font-size: 0.85rem; padding: 0.25rem 0.5rem;">Cancelar</a>
                    </div>
                </div>

                <!-- Formulário principal para a tabela -->
                <form method="POST" action="<?php echo e(route('avaliacoes.store')); ?>" id="form-avaliacoes">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="turma_id" value="<?php echo e($turma->id); ?>">
                    <input type="hidden" name="disciplina_id" value="<?php echo e($disciplina->id); ?>">
                    <input type="hidden" name="trimestre_id" value="<?php echo e($trimestre->id); ?>">
                    <input type="hidden" name="ano_letivo_id" value="<?php echo e($anoLetivo->id); ?>">
                    <input type="hidden" name="modelo" value="NACIONAL">
                    <?php
                        $isSecundario = ($turma->nivel_ensino ?? 'PRIMARIO') === 'SECUNDARIO';
                    ?>

                    <div class="table-responsive">
                        <table class="table table-bordered table-sm" style="font-size: 0.7rem;">
                            <style>
                                .table-bordered th, .table-bordered td {
                                    padding: 0.25rem 0.35rem !important;
                                }
                                .form-control-sm {
                                    font-size: 0.7rem !important;
                                    padding: 0.2rem 0.3rem !important;
                                }
                                input[disabled], input[readonly] {
                                    background-color: #f8f9fa !important;
                                    cursor: not-allowed !important;
                                }
                            </style>
                            <thead>
                                <?php if($isSecundario): ?>
                                    <tr>
                                        <th style="vertical-align: middle;">N°</th>
                                        <th style="vertical-align: middle;">Aluno</th>
                                        <th style="vertical-align: middle;">G</th>
                                        <th style="vertical-align: middle;">Teste 1</th>
                                        <th style="vertical-align: middle;">Teste 2</th>
                                        <th style="vertical-align: middle;">Avaliação Final</th>
                                        <th style="vertical-align: middle;">Média</th>
                                    </tr>
                                <?php else: ?>
                                    <tr>
                                        <th rowspan="2" style="vertical-align: middle;">N°</th>
                                        <th rowspan="2" style="vertical-align: middle;">Aluno</th>
                                        <th rowspan="2" style="vertical-align: middle;">G</th>
                                        <th colspan="3">A.Prática</th>
                                        <th colspan="3">ACS</th>
                                        <th rowspan="2" style="vertical-align: middle;">AT</th>
                                        <th rowspan="2" style="vertical-align: middle;">MT</th>
                                    </tr>
                                    <tr>
                                        <th>1ª</th>
                                        <th>2ª</th>
                                        <th>MAP</th>
                                        <th>1ª</th>
                                        <th>2ª</th>
                                        <th>MACS</th>
                                    </tr>
                                <?php endif; ?>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $alunos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $aluno): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $avaliacaoExistente = \App\Models\Avaliacao::where('aluno_id', $aluno->id)
                                            ->where('disciplina_id', $disciplina->id)
                                            ->where('turma_id', $turma->id)
                                            ->where('trimestre_id', $trimestre->id)
                                            ->where('ano_letivo_id', $anoLetivo->id)
                                            ->first();
                                    ?>
                                    <tr>
                                        <td><?php echo e($index + 1); ?></td>
                                        <td><?php echo e($aluno->user->name); ?></td>
                                        <td><?php echo e($aluno->genero == 'M' ? 'H' : ($aluno->genero == 'F' ? 'M' : '')); ?></td>
                                        <?php if($isSecundario): ?>
                                            <td>
                                                <input type="number" step="0.1" min="0" max="20" 
                                                       class="form-control form-control-sm teste-1" 
                                                       name="notas[<?php echo e($aluno->id); ?>][teste1]" 
                                                       value="<?php echo e($avaliacaoExistente->teste1 ?? ''); ?>"
                                                       data-aluno="<?php echo e($aluno->id); ?>"
                                                       <?php echo e(!$lancamentoNotasLiberado ? 'disabled readonly' : ''); ?>>
                                            </td>
                                            <td>
                                                <input type="number" step="0.1" min="0" max="20" 
                                                       class="form-control form-control-sm teste-2" 
                                                       name="notas[<?php echo e($aluno->id); ?>][teste2]" 
                                                       value="<?php echo e($avaliacaoExistente->teste2 ?? ''); ?>"
                                                       data-aluno="<?php echo e($aluno->id); ?>"
                                                       <?php echo e(!$lancamentoNotasLiberado ? 'disabled readonly' : ''); ?>>
                                            </td>
                                            <td>
                                                <input type="number" step="0.1" min="0" max="20" 
                                                       class="form-control form-control-sm avaliacao-final" 
                                                       name="notas[<?php echo e($aluno->id); ?>][avaliacao_final]" 
                                                       value="<?php echo e($avaliacaoExistente->avaliacao_final ?? ''); ?>"
                                                       data-aluno="<?php echo e($aluno->id); ?>">
                                            </td>
                                            <td>
                                                <input type="number" step="0.1" class="form-control form-control-sm media-nacional" 
                                                       name="notas[<?php echo e($aluno->id); ?>][media_nacional]" 
                                                       value="<?php echo e($avaliacaoExistente->media_nacional ?? ''); ?>"
                                                       data-aluno="<?php echo e($aluno->id); ?>" readonly>
                                            </td>
                                        <?php else: ?>
                                            <td>
                                                <input type="number" step="0.1" min="0" max="20" 
                                                       class="form-control form-control-sm a-pratica-1" 
                                                       name="notas[<?php echo e($aluno->id); ?>][a_pratica_1]" 
                                                       value="<?php echo e($avaliacaoExistente->a_pratica_1 ?? ''); ?>"
                                                       data-aluno="<?php echo e($aluno->id); ?>"
                                                       <?php echo e(!$lancamentoNotasLiberado ? 'disabled readonly' : ''); ?>>
                                            </td>
                                            <td>
                                                <input type="number" step="0.1" min="0" max="20" 
                                                       class="form-control form-control-sm a-pratica-2" 
                                                       name="notas[<?php echo e($aluno->id); ?>][a_pratica_2]" 
                                                       value="<?php echo e($avaliacaoExistente->a_pratica_2 ?? ''); ?>"
                                                       data-aluno="<?php echo e($aluno->id); ?>">
                                            </td>
                                            <td>
                                                <input type="number" step="0.1" class="form-control form-control-sm map" 
                                                       name="notas[<?php echo e($aluno->id); ?>][map]" 
                                                       value="<?php echo e($avaliacaoExistente->map ?? ''); ?>"
                                                       data-aluno="<?php echo e($aluno->id); ?>" readonly>
                                            </td>
                                            <td>
                                                <input type="number" step="0.1" min="0" max="20" 
                                                       class="form-control form-control-sm acs-1" 
                                                       name="notas[<?php echo e($aluno->id); ?>][acs_1]" 
                                                       value="<?php echo e($avaliacaoExistente->acs_1 ?? ''); ?>"
                                                       data-aluno="<?php echo e($aluno->id); ?>"
                                                       <?php echo e(!$lancamentoNotasLiberado ? 'disabled readonly' : ''); ?>>
                                            </td>
                                            <td>
                                                <input type="number" step="0.1" min="0" max="20" 
                                                       class="form-control form-control-sm acs-2" 
                                                       name="notas[<?php echo e($aluno->id); ?>][acs_2]" 
                                                       value="<?php echo e($avaliacaoExistente->acs_2 ?? ''); ?>"
                                                       data-aluno="<?php echo e($aluno->id); ?>">
                                            </td>
                                            <td>
                                                <input type="number" step="0.1" class="form-control form-control-sm macs" 
                                                       name="notas[<?php echo e($aluno->id); ?>][macs]" 
                                                       value="<?php echo e($avaliacaoExistente->macs ?? ''); ?>"
                                                       data-aluno="<?php echo e($aluno->id); ?>" 
                                                       readonly
                                                       style="background-color: #f8f9fa; font-weight: bold;">
                                            </td>
                                            <td>
                                                <input type="number" step="0.1" min="0" max="20" 
                                                       class="form-control form-control-sm at" 
                                                       name="notas[<?php echo e($aluno->id); ?>][at]" 
                                                       value="<?php echo e($avaliacaoExistente->at ?? ''); ?>"
                                                       data-aluno="<?php echo e($aluno->id); ?>"
                                                       <?php echo e(!$lancamentoNotasLiberado ? 'disabled readonly' : ''); ?>>
                                            </td>
                                            <td>
                                                <input type="number" step="0.1" class="form-control form-control-sm mt" 
                                                       name="notas[<?php echo e($aluno->id); ?>][mt]" 
                                                       value="<?php echo e($avaliacaoExistente->mt ?? ''); ?>"
                                                       data-aluno="<?php echo e($aluno->id); ?>" readonly>
                                            </td>
                                        <?php endif; ?>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
</div>


<script>
(function() {
    'use strict';
    
    let autoSaveTimer = null;
    let isSaving = false;
    let form, btnSalvar, btnSalvarText, btnSalvarLoading, statusSalvamento;
    
    // Função para atualizar status de salvamento
    function atualizarStatus(mensagem, tipo = 'info') {
        if (statusSalvamento) {
            statusSalvamento.textContent = mensagem;
            statusSalvamento.className = `text-${tipo} small`;
            if (mensagem) {
                setTimeout(function() {
                    if (statusSalvamento) statusSalvamento.textContent = '';
                }, 3000);
            }
        }
    }

    // Calcular valores dependentes IMEDIATAMENTE
    function calcularValoresDependentes(alunoId, formElement) {
        if (!alunoId) return;
        
        // Se não foi passado um formulário específico, usar o form global ou encontrar
        if (!formElement) {
            formElement = form || document.getElementById('form-avaliacoes-mobile') || document.getElementById('form-avaliacoes');
        }
        
        if (!formElement) {
            inicializarListeners();
            formElement = form || document.getElementById('form-avaliacoes-mobile') || document.getElementById('form-avaliacoes');
            if (!formElement) return;
        }
        
        // Buscar elementos - usar seletores mais específicos primeiro
        const pratica1 = formElement.querySelector('input.a-pratica-1[data-aluno="' + alunoId + '"]') || 
                        formElement.querySelector('input[name*="a_pratica_1"][data-aluno="' + alunoId + '"]');
        const pratica2 = formElement.querySelector('input.a-pratica-2[data-aluno="' + alunoId + '"]') || 
                        formElement.querySelector('input[name*="a_pratica_2"][data-aluno="' + alunoId + '"]');
        const acs1 = formElement.querySelector('input.acs-1[data-aluno="' + alunoId + '"]') || 
                    formElement.querySelector('input[name*="acs_1"][data-aluno="' + alunoId + '"]');
        const acs2 = formElement.querySelector('input.acs-2[data-aluno="' + alunoId + '"]') || 
                    formElement.querySelector('input[name*="acs_2"][data-aluno="' + alunoId + '"]');
        const at = formElement.querySelector('input.at[data-aluno="' + alunoId + '"]') || 
                  formElement.querySelector('input[name*="[at]"][data-aluno="' + alunoId + '"]');
        const map = formElement.querySelector('input.map[data-aluno="' + alunoId + '"]') || 
                   formElement.querySelector('input[name*="[map]"][data-aluno="' + alunoId + '"]');
        const macs = formElement.querySelector('input.macs[data-aluno="' + alunoId + '"]') || 
                    formElement.querySelector('input[name*="[macs]"][data-aluno="' + alunoId + '"]');
        const mt = formElement.querySelector('input.mt[data-aluno="' + alunoId + '"]') || 
                  formElement.querySelector('input[name*="[mt]"][data-aluno="' + alunoId + '"]');
        const teste1 = formElement.querySelector('input.teste-1[data-aluno="' + alunoId + '"]') || 
                      formElement.querySelector('input[name*="teste1"][data-aluno="' + alunoId + '"]');
        const teste2 = formElement.querySelector('input.teste-2[data-aluno="' + alunoId + '"]') || 
                      formElement.querySelector('input[name*="teste2"][data-aluno="' + alunoId + '"]');
        const avaliacaoFinal = formElement.querySelector('input.avaliacao-final[data-aluno="' + alunoId + '"]') || 
                              formElement.querySelector('input[name*="avaliacao_final"][data-aluno="' + alunoId + '"]');
        const mediaNacional = formElement.querySelector('input.media-nacional[data-aluno="' + alunoId + '"]') || 
                             formElement.querySelector('input[name*="media_nacional"][data-aluno="' + alunoId + '"]');
        
        // Detectar tipo de ensino - verificar se existem os campos necessários
        // Priorizar primário se tiver os campos de primário
        const temCamposPrimario = (pratica1 || pratica2) && (acs1 || acs2) && at && map && macs && mt;
        const temCamposSecundario = teste1 && teste2 && avaliacaoFinal && mediaNacional;
        
        // Calcular para primário
        if (temCamposPrimario && map && macs && mt) {
            // Calcular MAP - verificar se ambos os valores foram preenchidos
            if (pratica1 && pratica2) {
                const v1Str = pratica1.value.trim();
                const v2Str = pratica2.value.trim();
                
                if (v1Str !== '' && v2Str !== '') {
                    const v1Num = parseFloat(v1Str);
                    const v2Num = parseFloat(v2Str);
                    // Validar que estão entre 0 e 20
                    if (!isNaN(v1Num) && !isNaN(v2Num) && v1Num >= 0 && v1Num <= 20 && v2Num >= 0 && v2Num <= 20) {
                        const mapVal = (v1Num + v2Num) / 2;
                        map.value = mapVal.toFixed(2);
                        // Forçar atualização visual
                        map.dispatchEvent(new Event('input', { bubbles: true }));
                    } else {
                        map.value = '';
                    }
                } else {
                    map.value = '';
                }
            } else if (map) {
                map.value = '';
            }
            
            // Calcular MACS - verificar se ambos os valores foram preenchidos
            if (acs1 && acs2) {
                const a1Str = acs1.value.trim();
                const a2Str = acs2.value.trim();
                
                if (a1Str !== '' && a2Str !== '') {
                    const a1Num = parseFloat(a1Str);
                    const a2Num = parseFloat(a2Str);
                    // Validar que estão entre 0 e 20
                    if (!isNaN(a1Num) && !isNaN(a2Num) && a1Num >= 0 && a1Num <= 20 && a2Num >= 0 && a2Num <= 20) {
                        const macsVal = (a1Num + a2Num) / 2;
                        macs.value = macsVal.toFixed(2);
                        // Forçar atualização visual
                        macs.dispatchEvent(new Event('input', { bubbles: true }));
                    } else {
                        macs.value = '';
                    }
                } else {
                    macs.value = '';
                }
            } else if (macs) {
                macs.value = '';
            }
            
            // Recalcular para MT - usar valores já calculados
            const mapVal = map && map.value.trim() ? parseFloat(map.value) : null;
            const macsVal = macs && macs.value.trim() ? parseFloat(macs.value) : null;
            const atValStr = at && at.value ? at.value.trim() : '';
            const atValNum = atValStr !== '' ? parseFloat(atValStr) : null;
            
            // Calcular MT - precisa de MAP, MACS e AT preenchidos e válidos (0-20)
            if (mapVal !== null && macsVal !== null && atValNum !== null && 
                !isNaN(mapVal) && !isNaN(macsVal) && !isNaN(atValNum) &&
                mapVal >= 0 && mapVal <= 20 && macsVal >= 0 && macsVal <= 20 && atValNum >= 0 && atValNum <= 20) {
                const mtVal = (mapVal + macsVal + atValNum) / 3;
                if (mt) {
                    mt.value = mtVal.toFixed(2);
                    // Forçar atualização visual
                    mt.dispatchEvent(new Event('input', { bubbles: true }));
                }
            } else if (mt) {
                mt.value = '';
            }
        }

        // Calcular para secundário
        if (temCamposSecundario && !temCamposPrimario && mediaNacional && teste1 && teste2 && avaliacaoFinal) {
            const t1Str = teste1.value.trim();
            const t2Str = teste2.value.trim();
            const afStr = avaliacaoFinal.value.trim();
            
            const t1 = t1Str !== '' ? parseFloat(t1Str) : null;
            const t2 = t2Str !== '' ? parseFloat(t2Str) : null;
            const af = afStr !== '' ? parseFloat(afStr) : null;

            // Validar que todos os valores estão entre 0 e 20
            if (t1 !== null && t2 !== null && af !== null && 
                !isNaN(t1) && !isNaN(t2) && !isNaN(af) &&
                t1 >= 0 && t1 <= 20 && t2 >= 0 && t2 <= 20 && af >= 0 && af <= 20) {
                const media = ((t1 + t2) * 0.40) + (af * 0.60);
                mediaNacional.value = media.toFixed(2);
                // Forçar atualização visual
                mediaNacional.dispatchEvent(new Event('input', { bubbles: true }));
            } else {
                mediaNacional.value = '';
            }
        }
    }

    // Função para processar mudança em qualquer campo
    function processarMudancaCampo(input, formElement) {
        // Limpar timer anterior
        if (autoSaveTimer) {
            clearTimeout(autoSaveTimer);
        }
        
        // Se não foi passado um formulário específico, usar o form global ou encontrar
        if (!formElement) {
            formElement = form || input.closest('form') || document.getElementById('form-avaliacoes-mobile') || document.getElementById('form-avaliacoes');
        }
        
        // Mostrar indicador de auto-save no desktop
        const statusAutoSave = document.getElementById('status-auto-save');
        const statusAutoSaveText = document.getElementById('status-auto-save-text');
        
        // Auto-save após 2 segundos (apenas para salvar, não para calcular)
        // O cálculo já foi feito no evento input
        autoSaveTimer = setTimeout(function() {
            // Mostrar indicador de salvamento
            if (statusAutoSave && formElement && formElement.id === 'form-avaliacoes') {
                statusAutoSave.classList.remove('d-none');
                if (statusAutoSaveText) {
                    statusAutoSaveText.textContent = 'Salvando automaticamente...';
                }
            }
            
            if (formElement) {
                salvarAvaliacoes(false, formElement);
            }
        }, 2000);
    }

    // Função para verificar se pode lançar notas do trimestre atual
    function verificarOrdemTrimestres(formElement) {
        if (!formElement) return { podeLancar: true, mensagem: '' };
        
        const trimestreId = formElement.querySelector('input[name="trimestre_id"]')?.value;
        const turmaId = formElement.querySelector('input[name="turma_id"]')?.value;
        const disciplinaId = formElement.querySelector('input[name="disciplina_id"]')?.value;
        const anoLetivoId = formElement.querySelector('input[name="ano_letivo_id"]')?.value;
        
        if (!trimestreId || !turmaId || !disciplinaId || !anoLetivoId) {
            return { podeLancar: true, mensagem: '' };
        }
        
        // Buscar informações do trimestre atual via AJAX
        // Por enquanto, retornar true e deixar o backend validar
        // Mas podemos adicionar uma verificação básica aqui se necessário
        return { podeLancar: true, mensagem: '' };
    }

    // Função para salvar via AJAX
    function salvarAvaliacoes(mostrarMensagem = true, formElement) {
        // Se não foi passado um formulário específico, usar o form global ou encontrar
        if (!formElement) {
            formElement = form || document.getElementById('form-avaliacoes-mobile') || document.getElementById('form-avaliacoes');
        }
        
        // Se form não estiver definido, tentar encontrar novamente
        if (!formElement) {
            const btn = document.getElementById('btn-salvar-mobile') || document.getElementById('btn-salvar');
            if (btn) {
                formElement = btn.closest('form');
            }
            
            if (!formElement) {
                formElement = document.querySelector('form[action*="avaliacoes.store"]');
            }
            
            // Buscar por formulário que tem os campos corretos
            if (!formElement) {
                const allForms = document.querySelectorAll('form[method="POST"]');
                allForms.forEach(function(f) {
                    if (f.querySelector('input[name="turma_id"]') && 
                        f.querySelector('input[name="disciplina_id"]') &&
                        !f.action.includes('logout')) {
                        formElement = f;
                    }
                });
            }
        }
        
        if (isSaving) {
            console.log('Já está salvando, aguardando...');
            return;
        }
        
        if (!formElement) {
            console.error('Não é possível salvar: formulário não encontrado');
            if (!form) {
                console.log('Tentando encontrar formulário...');
                console.log('Formulários disponíveis:', document.querySelectorAll('form'));
            }
            alert('Erro: Formulário não encontrado. Por favor, recarregue a página.');
            return;
        }
        
        // Verificar se é o formulário correto (não o logout)
        if (formElement.action.includes('logout')) {
            console.error('Formulário errado encontrado (logout)!');
            formElement = null;
            return;
        }
        
        isSaving = true;
        if (btnSalvar) btnSalvar.disabled = true;
        if (btnSalvarText) btnSalvarText.textContent = 'Salvando...';
        if (btnSalvarLoading) btnSalvarLoading.classList.remove('d-none');
        
        if (mostrarMensagem) {
            atualizarStatus('Salvando...', 'info');
        }

        // Construir FormData manualmente para garantir que todos os campos sejam incluídos
        const formData = new FormData();
        
        // Adicionar campos hidden obrigatórios
        const turmaId = formElement.querySelector('input[name="turma_id"]')?.value;
        const disciplinaId = formElement.querySelector('input[name="disciplina_id"]')?.value;
        // IMPORTANTE: Sempre pegar o trimestre_id da URL primeiro (é a fonte mais confiável)
        const urlParams = new URLSearchParams(window.location.search);
        let trimestreId = urlParams.get('trimestre_id');
        
        // Se não encontrar na URL, tentar do formulário
        if (!trimestreId) {
            trimestreId = formElement.querySelector('input[name="trimestre_id"]')?.value;
        }
        
        // Se encontrou na URL, atualizar o campo hidden para manter sincronizado
        if (trimestreId) {
            const hiddenTrimestre = formElement.querySelector('input[name="trimestre_id"]');
            if (hiddenTrimestre) {
                hiddenTrimestre.value = trimestreId;
            }
        }
        const anoLetivoId = formElement.querySelector('input[name="ano_letivo_id"]')?.value;
        const modelo = formElement.querySelector('input[name="modelo"]')?.value;
        const csrfToken = formElement.querySelector('input[name="_token"]')?.value || document.querySelector('meta[name="csrf-token"]')?.getAttribute('content') || '<?php echo e(csrf_token()); ?>';
        
        // Validar campos obrigatórios antes de enviar
        if (!turmaId || !disciplinaId || !trimestreId || !anoLetivoId) {
            console.error('Campos obrigatórios faltando:', { turmaId, disciplinaId, trimestreId, anoLetivoId });
            alert('Erro: Campos obrigatórios não encontrados. Por favor, recarregue a página.');
            isSaving = false;
            if (btnSalvar) btnSalvar.disabled = false;
            if (btnSalvarText) btnSalvarText.textContent = 'Salvar Avaliações';
            if (btnSalvarLoading) btnSalvarLoading.classList.add('d-none');
            return;
        }
        
        if (turmaId) formData.append('turma_id', turmaId);
        if (disciplinaId) formData.append('disciplina_id', disciplinaId);
        if (trimestreId) formData.append('trimestre_id', trimestreId);
        if (anoLetivoId) formData.append('ano_letivo_id', anoLetivoId);
        if (modelo) formData.append('modelo', modelo);
        formData.append('_token', csrfToken);
        
        // Adicionar todas as notas
        const notaInputs = formElement.querySelectorAll('input[name^="notas["]');
        notaInputs.forEach(input => {
            if (input.value !== '' || input.name.includes('map') || input.name.includes('macs') || input.name.includes('mt') || input.name.includes('media_nacional')) {
                formData.append(input.name, input.value || '');
            }
        });
        

        // Log para debug
        console.log('Enviando requisição para salvar avaliações', {
            turma_id: turmaId,
            disciplina_id: disciplinaId,
            trimestre_id: trimestreId,
            ano_letivo_id: anoLetivoId,
            total_notas: notaInputs.length,
            url_trimestre: new URLSearchParams(window.location.search).get('trimestre_id')
        });
        
        fetch('<?php echo e(route("avaliacoes.store")); ?>', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest',
                'Accept': 'application/json',
                'X-CSRF-TOKEN': csrfToken
            }
        })
        .then(async response => {
            // Se for erro 403 (permissão negada), mostrar modal APENAS se for resposta JSON
            if (response.status === 403) {
                try {
                    const errorData = await response.json();
                    // Só mostrar modal se a resposta tiver a estrutura esperada
                    if (errorData.error && errorData.code === 403) {
                        const errorMsg = errorData.message || 'Você não tem permissão para realizar esta acção.';
                        
                        // Mostrar modal de erro
                        if (typeof showErrorModal === 'function') {
                            showErrorModal(errorMsg);
                        } else {
                            alert(errorMsg);
                        }
                        
                        throw new Error(errorMsg);
                    }
                } catch (e) {
                    // Se não for JSON válido, não fazer nada (deixa o Laravel tratar)
                    throw new Error('Erro de permissão');
                }
            }
            
            // Se for erro 422 (validação), tratar separadamente
            if (response.status === 422) {
                const errorData = await response.json().catch(() => ({}));
                const errorMsg = errorData.message || 'Erro de validação';
                const errors = errorData.errors || {};
                let fullErrorMsg = errorMsg;
                
                // Verificar se é erro de ordem de trimestres
                if (errorData.message && (errorData.message.includes('trimestre') || errorData.message.includes('Primeiro deve lançar') || errorData.message.includes('Faltam notas'))) {
                    fullErrorMsg = errorData.message;
                    // Mostrar alerta para garantir que o usuário veja
                    alert(fullErrorMsg);
                } else {
                    // Adicionar detalhes dos erros de validação
                    if (Object.keys(errors).length > 0) {
                        const errorDetails = Object.values(errors).flat().join(', ');
                        fullErrorMsg += ': ' + errorDetails;
                        
                        // Log detalhado para debug
                        console.error('Erros de validação:', errors);
                        console.error('Dados enviados:', {
                            turma_id: turmaId,
                            disciplina_id: disciplinaId,
                            trimestre_id: trimestreId,
                            ano_letivo_id: anoLetivoId
                        });
                        
                        // Mostrar alerta com detalhes
                        alert('Erro de validação:\n' + errorDetails);
                    }
                }
                
                throw new Error(fullErrorMsg);
            }
            
            // Verificar se é JSON
            const contentType = response.headers.get("content-type") || '';
            if (contentType.includes("application/json")) {
                return response.json().catch(() => {
                    return { success: true, message: 'Salvo!' };
                });
            }
            return { success: true, message: 'Salvo!' };
        })
        .then(data => {
            isSaving = false;
            if (btnSalvar) btnSalvar.disabled = false;
            if (btnSalvarText) btnSalvarText.textContent = 'Salvar Avaliações';
            if (btnSalvarLoading) btnSalvarLoading.classList.add('d-none');
            
            if (data && data.success) {
                atualizarStatus('✓ Salvo com sucesso!', 'success');
                
                // Ocultar indicador de auto-save no desktop
                const statusAutoSave = document.getElementById('status-auto-save');
                if (statusAutoSave) {
                    const statusAutoSaveText = document.getElementById('status-auto-save-text');
                    if (statusAutoSaveText) {
                        statusAutoSaveText.textContent = 'Salvo automaticamente';
                    }
                    setTimeout(function() {
                        statusAutoSave.classList.add('d-none');
                    }, 2000);
                }
                
                // Após salvar, sincronizar todos os campos entre os formulários
                sincronizarTodosOsCampos();
            } else {
                atualizarStatus('Erro ao salvar', 'danger');
                
                // Ocultar indicador de auto-save em caso de erro
                const statusAutoSave = document.getElementById('status-auto-save');
                if (statusAutoSave) {
                    statusAutoSave.classList.add('d-none');
                }
            }
        })
        .catch(error => {
            isSaving = false;
            if (btnSalvar) btnSalvar.disabled = false;
            if (btnSalvarText) btnSalvarText.textContent = 'Salvar Avaliações';
            if (btnSalvarLoading) btnSalvarLoading.classList.add('d-none');
            
            let errorMsg = error.message || 'Erro ao salvar. Verifique os dados e tente novamente.';
            
            // Se for erro de ordem de trimestres, mostrar mensagem mais clara
            if (errorMsg.includes('trimestre') || errorMsg.includes('Primeiro deve lançar') || errorMsg.includes('Faltam notas')) {
                // Já foi mostrado o alert no tratamento do 422, não precisa mostrar novamente
            } else if (errorMsg.includes('Erro ao salvar avaliações') || errorMsg.includes('Erro interno')) {
                // Erro 500 - já foi mostrado o alert no tratamento do 500
            } else {
                // Outros erros - mostrar apenas se for requisição manual (não auto-save)
                if (mostrarMensagem) {
                    alert(errorMsg);
                }
            }
            
            atualizarStatus(errorMsg, 'danger');
            
            // Ocultar indicador de auto-save em caso de erro
            const statusAutoSave = document.getElementById('status-auto-save');
            if (statusAutoSave) {
                statusAutoSave.classList.add('d-none');
            }
            
            console.error('Erro ao salvar:', error);
        });
    }

    // Função para sincronizar valores entre formulários mobile e desktop
    function sincronizarEntreFormularios(inputAlterado) {
        const nomeCampo = inputAlterado.getAttribute('name');
        const alunoId = inputAlterado.getAttribute('data-aluno');
        const valor = inputAlterado.value;
        
        if (!nomeCampo || !alunoId) return;
        
        // Encontrar o formulário oposto
        const formMobile = document.getElementById('form-avaliacoes-mobile');
        const formDesktop = document.getElementById('form-avaliacoes');
        
        let formOrigem = inputAlterado.closest('form');
        let formDestino = null;
        
        if (formOrigem && formOrigem.id === 'form-avaliacoes-mobile') {
            formDestino = formDesktop;
        } else if (formOrigem && formOrigem.id === 'form-avaliacoes') {
            formDestino = formMobile;
        }
        
        if (formDestino) {
            // Encontrar o campo correspondente no formulário destino
            const campoDestino = formDestino.querySelector('input[name="' + nomeCampo + '"]');
            if (campoDestino && campoDestino !== inputAlterado) {
                // Atualizar valor sem disparar eventos para evitar loop
                const tinhaListener = campoDestino.hasAttribute('data-listener-attached');
                if (tinhaListener) {
                    campoDestino.removeAttribute('data-listener-attached');
                }
                campoDestino.value = valor;
                if (tinhaListener) {
                    campoDestino.setAttribute('data-listener-attached', 'true');
                }
                
                // Recalcular valores dependentes no formulário destino
                calcularValoresDependentes(alunoId, formDestino);
            }
        }
    }
    
    // Função para sincronizar todos os campos entre os dois formulários
    function sincronizarTodosOsCampos() {
        const formMobile = document.getElementById('form-avaliacoes-mobile');
        const formDesktop = document.getElementById('form-avaliacoes');
        
        if (!formMobile || !formDesktop) return;
        
        // Sincronizar do mobile para desktop
        formMobile.querySelectorAll('input[type="number"]:not([readonly]):not([data-sync])').forEach(function(inputMobile) {
            const nomeCampo = inputMobile.getAttribute('name');
            if (nomeCampo) {
                const inputDesktop = formDesktop.querySelector('input[name="' + nomeCampo + '"]');
                if (inputDesktop && inputDesktop !== inputMobile) {
                    const tinhaListener = inputDesktop.hasAttribute('data-listener-attached');
                    if (tinhaListener) {
                        inputDesktop.removeAttribute('data-listener-attached');
                    }
                    inputDesktop.value = inputMobile.value;
                    if (tinhaListener) {
                        inputDesktop.setAttribute('data-listener-attached', 'true');
                    }
                }
            }
        });
        
        // Sincronizar do desktop para mobile
        formDesktop.querySelectorAll('input[type="number"]:not([readonly]):not([data-sync])').forEach(function(inputDesktop) {
            const nomeCampo = inputDesktop.getAttribute('name');
            if (nomeCampo) {
                const inputMobile = formMobile.querySelector('input[name="' + nomeCampo + '"]');
                if (inputMobile && inputMobile !== inputDesktop) {
                    const tinhaListener = inputMobile.hasAttribute('data-listener-attached');
                    if (tinhaListener) {
                        inputMobile.removeAttribute('data-listener-attached');
                    }
                    inputMobile.value = inputDesktop.value;
                    if (tinhaListener) {
                        inputMobile.setAttribute('data-listener-attached', 'true');
                    }
                }
            }
        });
        
        // Recalcular todos os valores dependentes em ambos os formulários
        const alunosIds = new Set();
        formMobile.querySelectorAll('[data-aluno]').forEach(function(input) {
            const alunoId = input.getAttribute('data-aluno');
            if (alunoId) alunosIds.add(alunoId);
        });
        
        alunosIds.forEach(function(alunoId) {
            calcularValoresDependentes(alunoId, formMobile);
            calcularValoresDependentes(alunoId, formDesktop);
        });
    }

    // Função para anexar listeners a um formulário específico
    function anexarListenersAoFormulario(formElement) {
        if (!formElement) return false;
        
        // Sincronizar campos duplicados no mobile
        function sincronizarCamposDuplicados() {
            formElement.querySelectorAll('input[data-sync]').forEach(function(dupInput) {
                const syncName = dupInput.getAttribute('data-sync');
                const originalInput = formElement.querySelector('input[name="' + syncName + '"]');
                if (originalInput) {
                    dupInput.value = originalInput.value;
                }
            });
        }
        
        // Adicionar listeners a todos os campos editáveis (ignorar duplicados)
        const inputs = formElement.querySelectorAll('input[type="number"]:not([readonly]):not([data-sync])');
        
        inputs.forEach(function(input) {
            // Verificar se já tem listener para evitar duplicação
            if (input.hasAttribute('data-listener-attached')) {
                return; // Já tem listener, pular este input
            }
            
            // Marcar como tendo listener ANTES de anexar
            input.setAttribute('data-listener-attached', 'true');
            
            // Criar elemento para mensagem de erro (apenas visual, sem validação HTML5)
            const errorMsg = document.createElement('div');
            errorMsg.className = 'invalid-feedback-custom';
            errorMsg.style.display = 'none';
            errorMsg.style.fontSize = '0.75rem';
            errorMsg.style.color = '#dc3545';
            errorMsg.style.marginTop = '2px';
            errorMsg.textContent = 'A nota deve estar entre 0 e 20';
            
            // Adicionar o elemento de erro ao campo (se não existir)
            if (!input.parentElement.querySelector('.invalid-feedback-custom')) {
                input.parentElement.appendChild(errorMsg);
            }
            
            // Função para mostrar/ocultar mensagem de erro
            function mostrarErro(mostrar) {
                if (errorMsg) {
                    errorMsg.style.display = mostrar ? 'block' : 'none';
                    if (mostrar) {
                        input.style.borderColor = '#dc3545';
                    } else {
                        input.style.borderColor = '';
                    }
                }
            }
            
            // Validação e bloqueio de valores inválidos ao digitar
            input.addEventListener('input', function(e) {
                let valor = this.value;
                let valorCorrigido = false;
                
                // Se o campo não estiver vazio, validar e corrigir
                if (valor !== '' && valor !== '-') {
                    const valorNum = parseFloat(valor);
                    
                    // Se não for um número válido, limpar
                    if (isNaN(valorNum)) {
                        this.value = '';
                        valor = '';
                        mostrarErro(false);
                    } 
                    // Se for menor que 0, mostrar erro mas não corrigir
                    else if (valorNum < 0) {
                        mostrarErro(true);
                    }
                    // Se for maior que 20, mostrar erro mas não corrigir
                    else if (valorNum > 20) {
                        mostrarErro(true);
                    }
                    // Se estiver no intervalo válido
                    else {
                        mostrarErro(false);
                    }
                } else {
                    mostrarErro(false);
                }
                
                // Calcular IMEDIATAMENTE após cada mudança (síncrono, sem delay)
                // Mas apenas se o valor for válido
                const alunoId = this.getAttribute('data-aluno');
                if (alunoId && formElement) {
                    const valorNum = parseFloat(valor);
                    // Só calcular se o valor for válido (entre 0 e 20)
                    if (!isNaN(valorNum) && valorNum >= 0 && valorNum <= 20) {
                        calcularValoresDependentes(alunoId, formElement);
                        // Sincronizar com o outro formulário (mobile <-> desktop)
                        sincronizarEntreFormularios(this);
                        // Auto-save também (com delay de 2 segundos)
                        processarMudancaCampo(this, formElement);
                    }
                }
                
                sincronizarCamposDuplicados();
            }, { passive: true });
            
            // Validação ao perder o foco (corrigir se necessário)
            input.addEventListener('blur', function() {
                if (this.value !== '') {
                    const valor = parseFloat(this.value);
                    
                    if (isNaN(valor)) {
                        this.value = '';
                        mostrarErro(false);
                    } else if (valor < 0) {
                        // Não corrigir automaticamente, apenas mostrar erro
                        mostrarErro(true);
                    } else if (valor > 20) {
                        // Não corrigir automaticamente, apenas mostrar erro
                        mostrarErro(true);
                    } else {
                        mostrarErro(false);
                    }
                } else {
                    mostrarErro(false);
                }
                
                // Recalcular ao perder foco
                const alunoId = this.getAttribute('data-aluno');
                if (alunoId && formElement) {
                    calcularValoresDependentes(alunoId, formElement);
                    // Sincronizar com o outro formulário
                    sincronizarEntreFormularios(this);
                }
            }, { passive: true });
            
            // Prevenir entrada de caracteres inválidos
            input.addEventListener('keydown', function(e) {
                // Permitir: backspace, delete, tab, escape, enter, ponto decimal
                if ([8, 9, 27, 13, 46, 110, 190].indexOf(e.keyCode) !== -1 ||
                    // Permitir: Ctrl+A, Ctrl+C, Ctrl+V, Ctrl+X
                    (e.keyCode === 65 && e.ctrlKey === true) ||
                    (e.keyCode === 67 && e.ctrlKey === true) ||
                    (e.keyCode === 86 && e.ctrlKey === true) ||
                    (e.keyCode === 88 && e.ctrlKey === true) ||
                    // Permitir: home, end, left, right
                    (e.keyCode >= 35 && e.keyCode <= 39)) {
                    return;
                }
                // Garantir que é um número ou ponto decimal
                if ((e.shiftKey || (e.keyCode < 48 || e.keyCode > 57)) && (e.keyCode < 96 || e.keyCode > 105) && e.keyCode !== 110 && e.keyCode !== 190) {
                    e.preventDefault();
                }
            });
            
            // Evento 'keyup' - calcular imediatamente (backup)
            input.addEventListener('keyup', function() {
                const alunoId = this.getAttribute('data-aluno');
                if (alunoId && formElement) {
                    calcularValoresDependentes(alunoId, formElement);
                    sincronizarEntreFormularios(this);
                }
            }, { passive: true });
            
            // Evento 'change' - garantir que calcula quando valor muda
            input.addEventListener('change', function() {
                const alunoId = this.getAttribute('data-aluno');
                if (alunoId && formElement) {
                    calcularValoresDependentes(alunoId, formElement);
                    sincronizarEntreFormularios(this);
                }
            }, { passive: true });
            
            // Evento 'paste' - calcular após colar
            input.addEventListener('paste', function() {
                const alunoId = this.getAttribute('data-aluno');
                if (alunoId && formElement) {
                    setTimeout(function() {
                        calcularValoresDependentes(alunoId, formElement);
                        sincronizarEntreFormularios(this);
                    }.bind(this), 10);
                }
            }, { passive: true });
            
            // Evento 'focusout' - calcular ao sair do campo
            input.addEventListener('focusout', function() {
                const alunoId = this.getAttribute('data-aluno');
                if (alunoId && formElement) {
                    calcularValoresDependentes(alunoId, formElement);
                    sincronizarEntreFormularios(this);
                }
            }, { passive: true });
        });
        
        return true;
    }

    // Função para inicializar listeners (pode ser chamada múltiplas vezes)
    function inicializarListeners() {
        // Buscar AMBOS os formulários (mobile e desktop)
        const formMobile = document.getElementById('form-avaliacoes-mobile');
        const formDesktop = document.getElementById('form-avaliacoes');
        
        // Definir form como o formulário visível (para compatibilidade com código existente)
        if (!form) {
            form = formMobile || formDesktop;
        }
        
        // Buscar botões se ainda não foram encontrados
        if (!btnSalvar) {
            btnSalvar = document.getElementById('btn-salvar-mobile') || document.getElementById('btn-salvar');
            btnSalvarText = document.getElementById('btn-salvar-text-mobile') || document.getElementById('btn-salvar-text');
            btnSalvarLoading = document.getElementById('btn-salvar-loading-mobile') || document.getElementById('btn-salvar-loading');
            statusSalvamento = document.getElementById('status-salvamento');
        }
        
        // Anexar listeners a AMBOS os formulários
        let sucesso = false;
        if (formMobile) {
            sucesso = anexarListenersAoFormulario(formMobile) || sucesso;
        }
        if (formDesktop) {
            sucesso = anexarListenersAoFormulario(formDesktop) || sucesso;
        }
        
        return sucesso;
    }

    // Inicializar quando DOM estiver pronto
    document.addEventListener('DOMContentLoaded', function() {
        // Verificar se o lançamento está trancado e desabilitar campos
        <?php if(!$lancamentoNotasLiberado): ?>
        const lancamentoTrancado = true;
        
        // Desabilitar todos os campos de input de notas
        function desabilitarCamposNotas() {
            const todosInputs = document.querySelectorAll('input[type="number"][name^="notas["]');
            todosInputs.forEach(input => {
                input.disabled = true;
                input.readOnly = true;
                input.style.backgroundColor = '#f8f9fa';
                input.style.cursor = 'not-allowed';
                input.setAttribute('title', 'Lançamento de notas trancado. Apenas visualização.');
            });
            
            // Desabilitar botões de salvar
            const btnSalvar = document.getElementById('btn-salvar');
            const btnSalvarMobile = document.getElementById('btn-salvar-mobile');
            if (btnSalvar) btnSalvar.disabled = true;
            if (btnSalvarMobile) btnSalvarMobile.disabled = true;
            
            // Remover event listeners de auto-save
            if (window.salvarAvaliacoes) {
                const originalSalvar = window.salvarAvaliacoes;
                window.salvarAvaliacoes = function() {
                    alert('O lançamento de notas está trancado. Você pode apenas visualizar as notas, mas não pode alterá-las.');
                    return false;
                };
            }
        }
        
        // Executar imediatamente
        desabilitarCamposNotas();
        
        // Executar novamente após um pequeno delay para garantir que todos os campos foram renderizados
        setTimeout(desabilitarCamposNotas, 500);
        <?php else: ?>
        const lancamentoTrancado = false;
        <?php endif; ?>
        
        // Função para sincronizar trimestre_id da URL com os campos hidden
        function sincronizarTrimestreId() {
            const urlParams = new URLSearchParams(window.location.search);
            const trimestreIdUrl = urlParams.get('trimestre_id');
            if (trimestreIdUrl) {
                const formAvaliacoes = document.getElementById('form-avaliacoes');
                const formAvaliacoesMobile = document.getElementById('form-avaliacoes-mobile');
                
                if (formAvaliacoes) {
                    const hiddenTrimestre = formAvaliacoes.querySelector('input[name="trimestre_id"]');
                    if (hiddenTrimestre && hiddenTrimestre.value !== trimestreIdUrl) {
                        hiddenTrimestre.value = trimestreIdUrl;
                        console.log('Trimestre ID atualizado no formulário desktop:', trimestreIdUrl);
                    }
                }
                
                if (formAvaliacoesMobile) {
                    const hiddenTrimestreMobile = formAvaliacoesMobile.querySelector('input[name="trimestre_id"]');
                    if (hiddenTrimestreMobile && hiddenTrimestreMobile.value !== trimestreIdUrl) {
                        hiddenTrimestreMobile.value = trimestreIdUrl;
                        console.log('Trimestre ID atualizado no formulário mobile:', trimestreIdUrl);
                    }
                }
            }
        }
        
        // Sincronizar imediatamente
        sincronizarTrimestreId();
        
        // Sincronizar periodicamente para garantir que está sempre atualizado (apenas se não estiver trancado)
        if (!lancamentoTrancado) {
            setInterval(sincronizarTrimestreId, 1000);
        }
        
        if (!inicializarListeners()) {
            // Tentar novamente após um pequeno delay
            setTimeout(function() {
                inicializarListeners();
            }, 200);
        }
        
        // Calcular valores iniciais para todos os alunos em ambos os formulários
        const formMobile = document.getElementById('form-avaliacoes-mobile');
        const formDesktop = document.getElementById('form-avaliacoes');
        
        function calcularValoresIniciais(formElement) {
            if (!formElement) return;
            
            const alunosIds = new Set();
            formElement.querySelectorAll('[data-aluno]').forEach(function(input) {
                const alunoId = input.getAttribute('data-aluno');
                if (alunoId) alunosIds.add(alunoId);
            });
            
            // Calcular imediatamente para todos os alunos
            alunosIds.forEach(function(alunoId) {
                calcularValoresDependentes(alunoId, formElement);
            });
            
            // Recalcular após um pequeno delay para garantir que todos os campos foram renderizados
            setTimeout(function() {
                alunosIds.forEach(function(alunoId) {
                    calcularValoresDependentes(alunoId, formElement);
                });
            }, 100);
        }
        
        calcularValoresIniciais(formMobile);
        calcularValoresIniciais(formDesktop);
        
        // Sincronizar todos os campos entre os formulários após carregar
        setTimeout(function() {
            sincronizarTodosOsCampos();
        }, 200);
        
        // Adicionar listener para o select de trimestre
        const selectTrimestre = document.getElementById('trimestre_id');
        if (selectTrimestre) {
            selectTrimestre.addEventListener('change', function() {
                // Atualizar o campo hidden trimestre_id nos formulários antes de submeter
                const novoTrimestreId = this.value;
                const formAvaliacoes = document.getElementById('form-avaliacoes');
                const formAvaliacoesMobile = document.getElementById('form-avaliacoes-mobile');
                
                if (formAvaliacoes) {
                    const hiddenTrimestre = formAvaliacoes.querySelector('input[name="trimestre_id"]');
                    if (hiddenTrimestre) {
                        hiddenTrimestre.value = novoTrimestreId;
                    }
                }
                
                if (formAvaliacoesMobile) {
                    const hiddenTrimestreMobile = formAvaliacoesMobile.querySelector('input[name="trimestre_id"]');
                    if (hiddenTrimestreMobile) {
                        hiddenTrimestreMobile.value = novoTrimestreId;
                    }
                }
                
                const formTrimestre = document.getElementById('form-trimestre');
                if (formTrimestre) {
                    formTrimestre.submit();
                }
            });
        }

        // Validação antes do submit
        function validarNotas(formElement) {
            if (!formElement) formElement = form || document.getElementById('form-avaliacoes-mobile') || document.getElementById('form-avaliacoes');
            if (!formElement) return false;
            
            let notasInvalidas = [];
            const inputs = formElement.querySelectorAll('input[type="number"]:not([readonly]):not([data-sync])');
            
            inputs.forEach(function(input) {
                if (input.value !== '') {
                    const valor = parseFloat(input.value);
                    const nomeAluno = input.closest('tr') ? input.closest('tr').querySelector('td:nth-child(2)') ? input.closest('tr').querySelector('td:nth-child(2)').textContent.trim() : 'Aluno' : 'Aluno';
                    const nomeCampo = input.getAttribute('name') ? (input.getAttribute('name').match(/\[([^\]]+)\]$/) ? input.getAttribute('name').match(/\[([^\]]+)\]$/)[1] : 'Campo') : 'Campo';
                    
                    if (isNaN(valor) || valor < 0 || valor > 20) {
                        notasInvalidas.push(nomeAluno + ' - ' + nomeCampo + ': ' + input.value);
                    }
                }
            });
            
            if (notasInvalidas.length > 0) {
                alert('Por favor, corrija as seguintes notas (devem estar entre 0 e 20):\n\n' + notasInvalidas.join('\n'));
                return false;
            }
            
            return true;
        }
        
        // Prevenir submit padrão em ambos os formulários
        function anexarSubmitListeners(formElement) {
            if (!formElement) return;
            
            formElement.addEventListener('submit', function(e) {
                e.preventDefault();
                e.stopPropagation();
                e.stopImmediatePropagation();
                
                if (!validarNotas(formElement)) {
                    return false;
                }
                
                salvarAvaliacoes(true, formElement);
                return false;
            }, true);
            
            formElement.onsubmit = function(e) {
                e.preventDefault();
                e.stopPropagation();
                
                if (!validarNotas(formElement)) {
                    return false;
                }
                
                salvarAvaliacoes(true, formElement);
                return false;
            };
        }
        
        if (formMobile) anexarSubmitListeners(formMobile);
        if (formDesktop) anexarSubmitListeners(formDesktop);
        
        // Prevenir no botão - ambos os botões
        const btnSalvarMobile = document.getElementById('btn-salvar-mobile');
        const btnSalvarDesktop = document.getElementById('btn-salvar');
        
        if (btnSalvarMobile) {
            btnSalvarMobile.addEventListener('click', function(e) {
                e.preventDefault();
                e.stopPropagation();
                
                if (!validarNotas(formMobile)) {
                    return false;
                }
                
                salvarAvaliacoes(true, formMobile);
                return false;
            });
        }
        
        if (btnSalvarDesktop) {
            btnSalvarDesktop.addEventListener('click', function(e) {
                e.preventDefault();
                e.stopPropagation();
                
                if (!validarNotas(formDesktop)) {
                    return false;
                }
                
                salvarAvaliacoes(true, formDesktop);
                return false;
            });
        }
    });
    
    // Fallback: tentar inicializar novamente após a página carregar completamente
    window.addEventListener('load', function() {
        setTimeout(function() {
            const formMobile = document.getElementById('form-avaliacoes-mobile');
            const formDesktop = document.getElementById('form-avaliacoes');
            
            function calcularValoresIniciais(formElement) {
                if (!formElement) return;
                
                const alunosIds = new Set();
                formElement.querySelectorAll('[data-aluno]').forEach(function(input) {
                    const alunoId = input.getAttribute('data-aluno');
                    if (alunoId) alunosIds.add(alunoId);
                });
                alunosIds.forEach(function(alunoId) {
                    calcularValoresDependentes(alunoId, formElement);
                });
            }
            
            calcularValoresIniciais(formMobile);
            calcularValoresIniciais(formDesktop);
            
            // Sincronizar todos os campos entre os formulários
            sincronizarTodosOsCampos();
        }, 300);
    });
})();
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/avaliacoes/create.blade.php ENDPATH**/ ?>