<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Folheto de Aproveitamento - <?php echo e($aluno->user->name); ?></title>
    <style>
        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
            font-family: 'Times New Roman', Times, serif;
        }
        
        @page {
            size: A4;
            margin: 0;
        }
        
        @media print {
            @page {
                margin: 0;
                size: A4;
            }
            
            html, body {
                margin: 0;
                padding: 0;
                width: 210mm;
                height: auto;
                background: white;
            }
        }
        
        body {
            background-color: #f5f5f5;
            color: #000;
            line-height: 1.4;
            padding: 20px;
        }
        
        .document {
            background-color: white;
            padding: 20px;
            max-width: 100%;
            width: 210mm;
            min-height: 297mm;
            box-sizing: border-box;
        }
        
        .header {
            margin-bottom: 15px;
            text-align: center;
            line-height: 1.3;
        }
        
        .header img {
            max-height: 120px;
            margin-bottom: 5px;
        }
        
        .header-line {
            font-size: 11pt;
            margin-bottom: 3px;
        }
        
        .escola-nome {
            font-weight: bold;
        }
        
        .info-header {
            font-size: 9pt;
            margin-top: 5px;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 9pt;
            margin-bottom: 20px;
        }
        
        table th,
        table td {
            border: 1px solid #000;
            padding: 4px;
            text-align: center;
        }
        
        table th {
            background-color: #f0f0f0;
            font-weight: bold;
        }
        
        .col-numero {
            width: 30px;
        }
        
        .col-nome {
            width: 200px;
            text-align: left;
        }
        
        .col-genero {
            width: 40px;
        }
        
        .col-disciplina {
            width: 50px;
        }
        
        .col-media {
            width: 60px;
        }
        
        .col-classificacao {
            width: 100px;
        }
        
        .footer {
            text-align: center;
            margin-top: 20px;
            font-size: 10pt;
        }
        
        @media print {
            @page {
                margin: 0;
                size: A4;
            }
            
            * {
                -webkit-print-color-adjust: exact;
                print-color-adjust: exact;
            }
            
            html, body {
                margin: 0 !important;
                padding: 0 !important;
                width: 210mm !important;
                height: auto !important;
                background: white !important;
                overflow: visible !important;
            }
            
            body {
                padding: 0 !important;
            }
            
            .no-print {
                display: none !important;
            }
            
            .document {
                margin: 0 !important;
                padding: 15mm !important;
                width: 210mm !important;
                min-height: 267mm !important;
                max-height: 267mm !important;
                box-shadow: none !important;
                overflow: hidden !important;
                page-break-inside: avoid;
            }
            
            table {
                page-break-inside: avoid;
            }
            
            tr {
                page-break-inside: avoid;
            }
        }
        
        .print-btn {
            position: fixed;
            bottom: 20px;
            right: 20px;
            padding: 10px 20px;
            background-color: #007bff;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 14px;
            z-index: 1000;
        }
        
        .print-btn:hover {
            background-color: #0056b3;
        }
        
        .select-trimestre {
            margin-bottom: 15px;
            padding: 10px;
            background-color: #f9f9f9;
            border: 1px solid #ddd;
            border-radius: 5px;
        }
    </style>
</head>
<body>
    <div class="document">
        <div class="select-trimestre no-print">
            <form method="GET" style="display: flex; gap: 10px; align-items: center;">
                <label for="trimestre"><strong>Selecionar Trimestre:</strong></label>
                <select name="trimestre" id="trimestre" onchange="this.form.submit()" style="padding: 5px;">
                    <option value="1" <?php echo e(request('trimestre', 1) == 1 ? 'selected' : ''); ?>>1º Trimestre</option>
                    <option value="2" <?php echo e(request('trimestre') == 2 ? 'selected' : ''); ?>>2º Trimestre</option>
                    <option value="3" <?php echo e(request('trimestre') == 3 ? 'selected' : ''); ?>>3º Trimestre</option>
                </select>
            </form>
        </div>
        
        <div class="header">
            <?php if(!empty($logotipoBase64)): ?>
                <img src="<?php echo e($logotipoBase64); ?>" alt="Logotipo da Escola">
            <?php endif; ?>
            <div class="header-line">Aproveitamento Pedagógico do <?php echo e($trimestre->numero); ?>º Trimestre</div>
            <div class="info-header">
                <?php if($turma->codigo): ?>
                    <?php echo e(strtoupper($turma->codigo)); ?>

                <?php endif; ?>
                Turma: <?php echo e(strtoupper($turma->nome)); ?> | Ano Lectivo: <?php echo e($anoLetivo->ano_inicial ?? $anoLetivo->ano); ?>

            </div>
        </div>
        
        <table>
            <thead>
                <tr>
                    <th class="col-numero">Nº</th>
                    <th class="col-nome">Nome Completo</th>
                    <th class="col-genero">Gén.</th>
                    <th colspan="<?php echo e($disciplinas->count()); ?>" style="text-align: center;">Médias por Disciplina</th>
                    <th class="col-media">Média Trimestral</th>
                    <th class="col-classificacao">Classificação</th>
                </tr>
                <tr>
                    <th></th>
                    <th></th>
                    <th></th>
                    <?php $__currentLoopData = $disciplinas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $disciplina): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $abreviacoes = [
                                'Português' => 'Port.',
                                'Matemática' => 'Mat.',
                                'Ciências Naturais' => 'C. Nat.',
                                'Ciências Sociais' => 'C. Soc.',
                                'Educação Visual e Ofícios' => 'EVO',
                                'Educação Física' => 'E. Fis.',
                                'Física' => 'Físi',
                                'História' => 'HIST',
                                'Inglês' => 'Ingl.',
                                'Química' => 'Quím.',
                                'Biologia' => 'Biol.',
                            ];
                            $abrev = $abreviacoes[$disciplina->nome] ?? strtoupper(substr($disciplina->nome, 0, 5));
                        ?>
                        <th class="col-disciplina"><?php echo e($abrev); ?></th>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <th></th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>1</td>
                    <td style="text-align: left;"><?php echo e(strtoupper($aluno->user->name)); ?></td>
                    <td><?php echo e($aluno->genero == 'M' ? 'H' : ($aluno->genero == 'F' ? 'M' : '-')); ?></td>
                    <?php $__currentLoopData = $disciplinas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $disciplina): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <td>
                            <?php if(isset($mediasPorDisciplina[$disciplina->id]) && $mediasPorDisciplina[$disciplina->id] !== null): ?>
                                <?php echo e($mediasPorDisciplina[$disciplina->id]); ?>

                            <?php else: ?>
                                -
                            <?php endif; ?>
                        </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <td>
                        <?php if($mediaTrimestralGeral !== null): ?>
                            <?php echo e($mediaTrimestralGeral); ?>

                        <?php else: ?>
                            -
                        <?php endif; ?>
                    </td>
                    <td><strong><?php echo e($classificacaoMedia ?? '-'); ?></strong></td>
                </tr>
            </tbody>
        </table>
        
        <div class="footer">
            O(A) Director(a) de Turma
        </div>
    </div>
    
    <button class="print-btn no-print" onclick="window.print()">Imprimir Folheto</button>
</body>
</html>
<?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/admin/alunos/folheto-aluno.blade.php ENDPATH**/ ?>