

<?php $__env->startSection('title', 'Novo Pagamento - SIGE'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header bg-primary text-white">
                <h5 class="mb-0">
                    <i class="bi bi-cash-coin me-2"></i>
                    Novo Pagamento de Professor
                </h5>
            </div>
            <div class="card-body">
                <form method="POST" action="<?php echo e(route('admin.professor-payments.store')); ?>" id="paymentForm">
                    <?php echo csrf_field(); ?>

                    <div class="row g-3">
                        <div class="col-md-6">
                            <label for="professor_id" class="form-label">Professor *</label>
                            <select name="professor_id" id="professor_id" class="form-select <?php $__errorArgs = ['professor_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                <option value="">Selecione um professor</option>
                                <?php $__currentLoopData = $professores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $prof): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($prof->id); ?>" 
                                            data-nivel="<?php echo e($prof->nivel_ensino); ?>"
                                            data-salario-fixo="<?php echo e($prof->salario_fixo ?? 0); ?>"
                                            data-valor-hora="<?php echo e($prof->valor_hora ?? 0); ?>"
                                            <?php echo e(old('professor_id', $professor?->id) == $prof->id ? 'selected' : ''); ?>>
                                        <?php echo e($prof->user->name); ?> (<?php echo e($prof->numero_funcionario); ?>)
                                        <?php if($prof->nivel_ensino === 'PRIMARIO'): ?>
                                            - Primário
                                        <?php elseif($prof->nivel_ensino === 'SECUNDARIO'): ?>
                                            - Secundário
                                        <?php else: ?>
                                            - Ambos
                                        <?php endif; ?>
                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php $__errorArgs = ['professor_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="col-md-3">
                            <label for="mes" class="form-label">Mês *</label>
                            <select name="mes" id="mes" class="form-select <?php $__errorArgs = ['mes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                <option value="">Selecione</option>
                                <?php for($i = 1; $i <= 12; $i++): ?>
                                    <option value="<?php echo e($i); ?>" <?php echo e(old('mes', date('n')) == $i ? 'selected' : ''); ?>>
                                        <?php echo e(['', 'Janeiro', 'Fevereiro', 'Março', 'Abril', 'Maio', 'Junho', 'Julho', 'Agosto', 'Setembro', 'Outubro', 'Novembro', 'Dezembro'][$i]); ?>

                                    </option>
                                <?php endfor; ?>
                            </select>
                            <?php $__errorArgs = ['mes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="col-md-3">
                            <label for="ano" class="form-label">Ano *</label>
                            <input type="number" name="ano" id="ano" class="form-control <?php $__errorArgs = ['ano'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   value="<?php echo e(old('ano', date('Y'))); ?>" min="2020" max="2100" required>
                            <?php $__errorArgs = ['ano'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="col-md-6" id="horas_field" style="display: none;">
                            <label for="horas_trabalhadas" class="form-label">Horas Trabalhadas *</label>
                            <input type="number" step="0.01" min="0" name="horas_trabalhadas" id="horas_trabalhadas" 
                                   class="form-control <?php $__errorArgs = ['horas_trabalhadas'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   value="<?php echo e(old('horas_trabalhadas')); ?>" placeholder="Ex: 40.00">
                            <small class="form-text text-muted">Digite o número de horas trabalhadas no mês</small>
                            <?php $__errorArgs = ['horas_trabalhadas'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="col-md-6">
                            <label for="valor_total" class="form-label">Valor Total (MT) *</label>
                            <input type="number" step="0.01" min="0" name="valor_total" id="valor_total" 
                                   class="form-control <?php $__errorArgs = ['valor_total'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   value="<?php echo e(old('valor_total')); ?>" required readonly>
                            <small class="form-text text-muted" id="valor_help">O valor será calculado automaticamente</small>
                            <?php $__errorArgs = ['valor_total'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="col-12">
                            <label for="observacoes" class="form-label">Observações</label>
                            <textarea name="observacoes" id="observacoes" class="form-control" rows="3" 
                                      placeholder="Observações sobre o pagamento..."><?php echo e(old('observacoes')); ?></textarea>
                        </div>
                    </div>

                    <div class="mt-4">
                        <button type="submit" class="btn btn-primary">
                            <i class="bi bi-save me-1"></i> Salvar Pagamento
                        </button>
                        <a href="<?php echo e(route('admin.professor-payments.index')); ?>" class="btn btn-secondary">
                            <i class="bi bi-arrow-left me-1"></i> Cancelar
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const professorSelect = document.getElementById('professor_id');
    const horasField = document.getElementById('horas_field');
    const horasInput = document.getElementById('horas_trabalhadas');
    const valorTotalInput = document.getElementById('valor_total');
    const valorHelp = document.getElementById('valor_help');
    const mesSelect = document.getElementById('mes');
    const anoInput = document.getElementById('ano');

    function atualizarCampos() {
        const selectedOption = professorSelect.options[professorSelect.selectedIndex];
        if (!selectedOption || !selectedOption.value) {
            horasField.style.display = 'none';
            valorTotalInput.value = '';
            valorTotalInput.readOnly = true;
            return;
        }

        const nivel = selectedOption.getAttribute('data-nivel');
        const salarioFixo = parseFloat(selectedOption.getAttribute('data-salario-fixo')) || 0;
        const valorHora = parseFloat(selectedOption.getAttribute('data-valor-hora')) || 0;

        if (nivel === 'SECUNDARIO' || nivel === 'AMBOS') {
            horasField.style.display = 'block';
            horasInput.required = true;
            valorHelp.textContent = 'Digite as horas trabalhadas para calcular o valor';
            valorTotalInput.readOnly = true;
        } else {
            horasField.style.display = 'none';
            horasInput.required = false;
            horasInput.value = '';
            valorTotalInput.value = salarioFixo.toFixed(2);
            valorHelp.textContent = 'Salário fixo do professor';
            valorTotalInput.readOnly = false;
        }

        calcularValor();
    }

    function calcularValor() {
        const selectedOption = professorSelect.options[professorSelect.selectedIndex];
        if (!selectedOption || !selectedOption.value) return;

        const nivel = selectedOption.getAttribute('data-nivel');
        const salarioFixo = parseFloat(selectedOption.getAttribute('data-salario-fixo')) || 0;
        const valorHora = parseFloat(selectedOption.getAttribute('data-valor-hora')) || 0;
        const horas = parseFloat(horasInput.value) || 0;

        if (nivel === 'PRIMARIO') {
            valorTotalInput.value = salarioFixo.toFixed(2);
        } else if (nivel === 'SECUNDARIO') {
            if (horas > 0) {
                valorTotalInput.value = (valorHora * horas).toFixed(2);
            } else {
                valorTotalInput.value = '';
            }
        } else if (nivel === 'AMBOS') {
            // Se tem horas, calcula por horas, senão usa salário fixo
            if (horas > 0) {
                valorTotalInput.value = (valorHora * horas).toFixed(2);
            } else if (salarioFixo > 0) {
                valorTotalInput.value = salarioFixo.toFixed(2);
            } else {
                valorTotalInput.value = '';
            }
        }
    }

    professorSelect.addEventListener('change', atualizarCampos);
    horasInput.addEventListener('input', calcularValor);

    // Verificar se há professor pré-selecionado
    if (professorSelect.value) {
        atualizarCampos();
    }
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/admin/professor-payments/create.blade.php ENDPATH**/ ?>