

<?php $__env->startSection('title', 'Todas as Disciplinas - Avaliações'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="card mb-3">
            <div class="card-body">
                <form method="GET" action="<?php echo e(route('avaliacoes.todas-disciplinas')); ?>" class="row g-3">
                    <div class="col-md-4">
                        <label for="ano_letivo_id" class="form-label">Ano Lectivo</label>
                        <select name="ano_letivo_id" id="ano_letivo_id" class="form-select" required>
                            <option value="">Selecione o Ano Lectivo</option>
                            <?php $__currentLoopData = $anosLetivos ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ano): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($ano->id); ?>" <?php echo e(($anoLetivoId ?? '') == $ano->id ? 'selected' : ''); ?>>
                                    <?php echo e($ano->ano_inicial ?? explode('/', $ano->ano)[0] ?? $ano->ano); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="col-md-4">
                        <label for="turma_id" class="form-label">Turma</label>
                        <select name="turma_id" id="turma_id" class="form-select" required>
                            <option value="">Selecione a Turma</option>
                            <?php $__currentLoopData = $todasTurmas ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($t->id); ?>" <?php echo e(($turmaId ?? '') == $t->id ? 'selected' : ''); ?>>
                                    <?php echo e($t->codigo); ?> - <?php echo e($t->nome); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="col-md-4">
                        <label for="disciplina_id" class="form-label">Disciplina (opcional)</label>
                        <select name="disciplina_id" id="disciplina_id" class="form-select">
                            <option value="">Todas as Disciplinas</option>
                            <?php $__currentLoopData = $todasDisciplinas ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $disc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($disc->id); ?>" <?php echo e(($disciplinaId ?? '') == $disc->id ? 'selected' : ''); ?>>
                                    <?php echo e($disc->nome); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="col-md-12">
                        <button type="submit" class="btn btn-primary btn-sm">Filtrar</button>
                        <a href="<?php echo e(route('avaliacoes.todas-disciplinas')); ?>" class="btn btn-secondary btn-sm">Limpar</a>
                    </div>
                </form>
            </div>
        </div>

        <?php if(session('error')): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <?php echo e(session('error')); ?>

                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>

        <?php if(isset($turma) && isset($anoLetivo)): ?>
            <div class="d-flex justify-content-between align-items-center mb-3 pb-2 border-bottom">
                <div class="text-muted small">
                    <span><?php echo e($turma->codigo); ?> - <?php echo e($turma->nome); ?></span>
                    <span class="ms-3"><?php echo e($anoLetivo->ano_inicial ?? explode('/', $anoLetivo->ano)[0] ?? $anoLetivo->ano); ?></span>
                    <span class="ms-3"><?php echo e($disciplinas->count()); ?> disciplinas</span>
                </div>
                <div>
                    <a href="<?php echo e(route('avaliacoes.download-pdf-todas-disciplinas', ['turma_id' => $turma->id, 'ano_letivo_id' => $anoLetivo->id])); ?>" 
                       class="btn btn-sm btn-outline-danger">
                        <i class="bi bi-file-earmark-pdf"></i> Download PDF
                    </a>
                    <button onclick="window.print()" class="btn btn-sm btn-outline-primary">
                        <i class="bi bi-printer"></i> Imprimir
                    </button>
                    <a href="<?php echo e(route('avaliacoes.index')); ?>" class="btn btn-sm btn-outline-secondary">Voltar</a>
                </div>
            </div>

        <?php if(isset($disciplinas) && $disciplinas->count() > 0): ?>
            <?php
                $isSecundario = ($turma->nivel_ensino ?? 'PRIMARIO') === 'SECUNDARIO';
            ?>
            <?php $__currentLoopData = $disciplinas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $disciplina): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="mb-3">
                <h6 class="mb-2"><?php echo e($disciplina->nome); ?></h6>
                <div class="table-responsive">
                    <table class="table table-bordered table-sm" style="font-size: 0.7rem;">
                        <style>
                            .table-bordered th, .table-bordered td {
                                padding: 0.25rem 0.35rem !important;
                            }
                        </style>
                        <thead>
                            <?php if($isSecundario): ?>
                                <tr>
                                    <th rowspan="2" class="align-middle">N°</th>
                                    <th rowspan="2" class="align-middle">Nome</th>
                                    <th rowspan="2" class="align-middle">G</th>
                                    <?php $__currentLoopData = $trimestres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trimestre): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <th colspan="4" class="text-center"><?php echo e($trimestre->numero); ?>° Trimestre</th>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <th rowspan="2" class="align-middle">MFrD</th>
                                    <th rowspan="2" class="align-middle">Classificação</th>
                                </tr>
                                <tr>
                                    <?php $__currentLoopData = $trimestres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trimestre): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <th>Teste 1</th>
                                        <th>Teste 2</th>
                                        <th>Av. Final</th>
                                        <th>Média</th>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tr>
                            <?php else: ?>
                                <tr>
                                    <th rowspan="3" class="align-middle">N°</th>
                                    <th rowspan="3" class="align-middle">Nome</th>
                                    <th rowspan="3" class="align-middle">G</th>
                                    <?php $__currentLoopData = $trimestres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trimestre): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <th colspan="8" class="text-center"><?php echo e($trimestre->numero); ?>° Trimestre</th>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <th rowspan="3" class="align-middle">MFrD</th>
                                    <th rowspan="3" class="align-middle">Classificação</th>
                                </tr>
                                <tr>
                                    <?php $__currentLoopData = $trimestres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trimestre): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <th colspan="3">A.Prática</th>
                                        <th colspan="2">ACS</th>
                                        <th rowspan="2" class="align-middle">MACS</th>
                                        <th rowspan="2" class="align-middle">AT</th>
                                        <th rowspan="2" class="align-middle">MT</th>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tr>
                                <tr>
                                    <?php $__currentLoopData = $trimestres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trimestre): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <th>1ª</th>
                                        <th>2ª</th>
                                        <th>MAP</th>
                                        <th>1ª</th>
                                        <th>2ª</th>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tr>
                            <?php endif; ?>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $alunos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $aluno): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $primeiraAvaliacao = collect($avaliacoesPorDisciplina[$disciplina->id][$aluno->id] ?? [])->first();
                                    $mfrd = $primeiraAvaliacao ? $primeiraAvaliacao->mfrd : null;
                                    $aprovado = \App\Models\Avaliacao::isAprovado($mfrd);
                                ?>
                                <tr>
                                    <td class="text-center"><?php echo e($index + 1); ?></td>
                                    <td><?php echo e($aluno->user->name); ?></td>
                                    <td class="text-center"><?php echo e($aluno->genero == 'M' ? 'H' : ($aluno->genero == 'F' ? 'M' : '')); ?></td>
                                    <?php $__currentLoopData = $trimestres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trimestre): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $avaliacao = $avaliacoesPorDisciplina[$disciplina->id][$aluno->id][$trimestre->id] ?? null;
                                        ?>
                                        <?php if($isSecundario): ?>
                                            <td class="text-center <?php echo e($avaliacao && $avaliacao->teste1 !== null && $avaliacao->teste1 < 10 ? 'text-danger' : ''); ?>"><?php echo e($avaliacao && $avaliacao->teste1 !== null ? number_format($avaliacao->teste1, 1, '.', '') : ''); ?></td>
                                            <td class="text-center <?php echo e($avaliacao && $avaliacao->teste2 !== null && $avaliacao->teste2 < 10 ? 'text-danger' : ''); ?>"><?php echo e($avaliacao && $avaliacao->teste2 !== null ? number_format($avaliacao->teste2, 1, '.', '') : ''); ?></td>
                                            <td class="text-center <?php echo e($avaliacao && $avaliacao->avaliacao_final !== null && $avaliacao->avaliacao_final < 10 ? 'text-danger' : ''); ?>"><?php echo e($avaliacao && $avaliacao->avaliacao_final !== null ? number_format($avaliacao->avaliacao_final, 1, '.', '') : ''); ?></td>
                                            <td class="text-center fw-bold <?php echo e($avaliacao && $avaliacao->media_nacional !== null && $avaliacao->media_nacional < 10 ? 'text-danger' : ''); ?>"><?php echo e($avaliacao && $avaliacao->media_nacional !== null ? number_format($avaliacao->media_nacional, 1, '.', '') : ''); ?></td>
                                        <?php else: ?>
                                            <td class="text-center <?php echo e($avaliacao && $avaliacao->a_pratica_1 !== null && $avaliacao->a_pratica_1 < 10 ? 'text-danger' : ''); ?>"><?php echo e($avaliacao && $avaliacao->a_pratica_1 !== null ? number_format($avaliacao->a_pratica_1, 1, '.', '') : ''); ?></td>
                                            <td class="text-center <?php echo e($avaliacao && $avaliacao->a_pratica_2 !== null && $avaliacao->a_pratica_2 < 10 ? 'text-danger' : ''); ?>"><?php echo e($avaliacao && $avaliacao->a_pratica_2 !== null ? number_format($avaliacao->a_pratica_2, 1, '.', '') : ''); ?></td>
                                            <td class="text-center fw-bold <?php echo e($avaliacao && $avaliacao->map !== null && $avaliacao->map < 10 ? 'text-danger' : ''); ?>"><?php echo e($avaliacao && $avaliacao->map !== null ? number_format($avaliacao->map, 1, '.', '') : ''); ?></td>
                                            <td class="text-center <?php echo e($avaliacao && $avaliacao->acs_1 !== null && $avaliacao->acs_1 < 10 ? 'text-danger' : ''); ?>"><?php echo e($avaliacao && $avaliacao->acs_1 !== null ? number_format($avaliacao->acs_1, 1, '.', '') : ''); ?></td>
                                            <td class="text-center <?php echo e($avaliacao && $avaliacao->acs_2 !== null && $avaliacao->acs_2 < 10 ? 'text-danger' : ''); ?>"><?php echo e($avaliacao && $avaliacao->acs_2 !== null ? number_format($avaliacao->acs_2, 1, '.', '') : ''); ?></td>
                                            <td class="text-center fw-bold <?php echo e($avaliacao && $avaliacao->macs !== null && $avaliacao->macs < 10 ? 'text-danger' : ''); ?>"><?php echo e($avaliacao && $avaliacao->macs !== null ? number_format($avaliacao->macs, 1, '.', '') : ''); ?></td>
                                            <td class="text-center <?php echo e($avaliacao && $avaliacao->at !== null && $avaliacao->at < 10 ? 'text-danger' : ''); ?>"><?php echo e($avaliacao && $avaliacao->at !== null ? number_format($avaliacao->at, 1, '.', '') : ''); ?></td>
                                            <td class="text-center fw-bold <?php echo e($avaliacao && $avaliacao->mt !== null && $avaliacao->mt < 10 ? 'text-danger' : ''); ?>"><?php echo e($avaliacao && $avaliacao->mt !== null ? number_format($avaliacao->mt, 0, '.', '') : ''); ?></td>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <td class="text-center fw-bold <?php echo e($mfrd !== null && $mfrd < 10 ? 'text-danger' : ''); ?>"><?php echo e($mfrd !== null ? number_format($mfrd, 0, '.', '') : ''); ?></td>
                                    <td class="text-center <?php echo e($aprovado ? 'text-success' : ($mfrd !== null ? 'text-danger' : '')); ?>"><?php echo e($mfrd !== null ? ($aprovado ? 'APROVADO' : 'REPROVADO') : ''); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php elseif(isset($turma)): ?>
            <div class="alert alert-info">
                Nenhuma disciplina encontrada com os filtros selecionados.
            </div>
        <?php endif; ?>
        <?php endif; ?>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const anoLetivoSelect = document.getElementById('ano_letivo_id');
        const turmaSelect = document.getElementById('turma_id');
        
        if (anoLetivoSelect) {
            anoLetivoSelect.addEventListener('change', function() {
                // Limpar seleção de turma quando mudar o ano letivo
                if (turmaSelect) {
                    turmaSelect.value = '';
                }
            });
        }
    });
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/avaliacoes/todas-disciplinas.blade.php ENDPATH**/ ?>