<?php $__env->startSection('title', 'Lista de presenças – Professores'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-3" style="border-bottom: 1px solid #dee2e6; padding-bottom: 10px;">
            <h5 class="mb-0" style="font-weight: 600;">Lista de presenças / faltas</h5>
            <div class="d-flex gap-2">
                <a href="<?php echo e(route('admin.presenca-professor.scanner')); ?>" class="btn btn-sm btn-success" target="_blank">
                    <i class="bi bi-upc-scan me-1"></i> Scanner
                </a>
                <a href="<?php echo e(route('admin.cartoes-professores.index')); ?>" class="btn btn-sm btn-outline-secondary">Crachás</a>
            </div>
        </div>

        <form method="GET" action="<?php echo e(route('admin.presenca-professor.index')); ?>" class="mb-3 p-3 rounded" style="background: #f8f9fa;">
            <div class="row g-2 align-items-end flex-wrap">
                <div class="col-auto">
                    <label class="form-label small mb-0">Data início</label>
                    <input type="date" class="form-control form-control-sm" name="data_inicio" value="<?php echo e($data_inicio ?? ''); ?>" style="width: 150px;">
                </div>
                <div class="col-auto">
                    <label class="form-label small mb-0">Data fim</label>
                    <input type="date" class="form-control form-control-sm" name="data_fim" value="<?php echo e($data_fim ?? ''); ?>" style="width: 150px;">
                </div>
                <div class="col-auto">
                    <label class="form-label small mb-0">Professor</label>
                    <select class="form-select form-select-sm" name="professor_id" style="width: 220px;">
                        <option value="">Todos</option>
                        <?php $__currentLoopData = $professores ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($p->id); ?>" <?php echo e((isset($professor_id) && $professor_id == $p->id) ? 'selected' : ''); ?>>
                                <?php echo e($p->user?->name ?? $p->numero_funcionario); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-auto">
                    <button type="submit" class="btn btn-sm btn-primary">Filtrar</button>
                </div>
            </div>
        </form>

        <div class="table-responsive">
            <table class="table table-sm table-bordered table-hover">
                <thead class="table-light">
                    <tr>
                        <th>Dia</th>
                        <th>Professor</th>
                        <th>Hora entrada</th>
                        <th>Hora saída</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $lista ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($item['dia']->format('d/m/Y')); ?></td>
                            <td><?php echo e($item['professor']->user?->name ?? $item['professor']->numero_funcionario); ?></td>
                            <td><?php echo e($item['entrada']->format('H:i')); ?></td>
                            <td><?php echo e($item['saida']->format('H:i')); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="4" class="text-center text-muted py-4">Nenhum registo de presença no período seleccionado.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/admin/presenca-professor/index.blade.php ENDPATH**/ ?>