<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Horários - <?php echo e($anoLetivo->ano ?? ''); ?></title>
    <style>
        @page {
            margin: 15mm;
        }
        body {
            font-family: Arial, sans-serif;
            font-size: 9pt;
            margin: 0;
            padding: 0;
        }
        .header {
            text-align: center;
            margin-bottom: 15px;
            border-bottom: 2px solid #000;
            padding-bottom: 10px;
        }
        .header img {
            max-height: 80px;
            margin-bottom: 5px;
        }
        .header h1 {
            font-size: 14pt;
            margin: 5px 0;
            font-weight: bold;
        }
        .header p {
            font-size: 9pt;
            margin: 2px 0;
        }
        .page-header {
            text-align: center;
            margin-bottom: 15px;
            border-bottom: 2px solid #000;
            padding-bottom: 10px;
        }
        .page-header img {
            max-height: 80px;
            margin-bottom: 5px;
        }
        .page-header p {
            font-size: 9pt;
            margin: 2px 0;
        }
        .turma-header {
            background-color: #e9ecef;
            padding: 8px;
            font-weight: bold;
            font-size: 10pt;
            margin-bottom: 10px;
            border: 1px solid #dee2e6;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
            page-break-inside: avoid;
        }
        th, td {
            border: 1px solid #000;
            padding: 4px;
            text-align: center;
            font-size: 8pt;
        }
        th {
            background-color: #f8f9fa;
            font-weight: bold;
        }
        .horario-time {
            background-color: #f8f9fa;
            font-weight: bold;
            width: 80px;
        }
        .horario-cell {
            min-height: 40px;
            vertical-align: middle;
        }
        .disciplina-badge {
            font-weight: bold;
            font-size: 8pt;
            display: block;
            margin-bottom: 2px;
        }
        .professor-name {
            font-size: 7pt;
            color: #495057;
        }
        .intervalo {
            background-color: #fff3cd;
            font-weight: bold;
            text-align: center;
        }
        .empty {
            background-color: #ffffff;
        }
    </style>
</head>
<body>
    <?php if(isset($grades) && count($grades) > 0): ?>
        <?php $__currentLoopData = $grades; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $turmaId => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
                $turma = $data['turma'];
                $grade = $data['grade'];
                $horarios = $data['horarios'];
                
                // Cores para disciplinas (gerar baseado no nome)
                $coresDisciplinas = [];
                $disciplinasUnicas = [];
                foreach ($grade as $hora => $dias) {
                    foreach ($dias as $dia => $horario) {
                        if ($horario && $horario->disciplina) {
                            $disciplinasUnicas[$horario->disciplina->id] = $horario->disciplina->nome;
                        }
                    }
                }
                $paletaCores = [
                    '#d4edda', '#fff3cd', '#d1ecf1', '#f8d7da', 
                    '#e2e3e5', '#d4edda', '#cce5ff', '#ffe6cc',
                    '#e6f3ff', '#ffe6f0', '#f0e6ff', '#fff0e6'
                ];
                $corIndex = 0;
                foreach ($disciplinasUnicas as $id => $nome) {
                    $coresDisciplinas[$id] = $paletaCores[$corIndex % count($paletaCores)];
                    $corIndex++;
                }
            ?>
            
            <div style="page-break-after: always;">
                <div class="page-header">
                    <?php if(!empty($logotipoBase64)): ?>
                        <img src="<?php echo e($logotipoBase64); ?>" alt="Logotipo da Escola">
                    <?php endif; ?>
                    <p>Ano Letivo: <?php echo e($anoLetivo->ano ?? ''); ?></p>
                    <p><strong>HORÁRIOS DE AULAS</strong></p>
                </div>
                <div class="turma-header">
                    Sala: <?php echo e($turma->codigo ?? ''); ?> - <?php echo e($turma->nome ?? 'Turma #' . $turmaId); ?>

                </div>
                
                <table>
                    <thead>
                        <tr>
                            <th class="horario-time">Horário</th>
                            <?php $__currentLoopData = $diasSemana; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dia): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <th><?php echo e($diasAbreviados[$dia]); ?></th>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $horarios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $horarioInfo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $horaInicio = $horarioInfo['inicio'];
                                $isIntervalo = isset($horarioInfo['tipo']) && $horarioInfo['tipo'] === 'intervalo';
                            ?>
                            <tr>
                                <td class="horario-time" style="<?php echo e($isIntervalo ? 'background-color: #fff3cd;' : ''); ?>">
                                    <?php echo e($horarioInfo['display']); ?>

                                </td>
                                <?php if($isIntervalo): ?>
                                    <td colspan="<?php echo e(count($diasSemana)); ?>" class="intervalo">
                                        Intervalo para Lanche
                                    </td>
                                <?php else: ?>
                                    <?php $__currentLoopData = $diasSemana; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dia): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $horario = $grade[$horaInicio][$dia] ?? null;
                                            $corFundo = $horario && $horario->disciplina ? ($coresDisciplinas[$horario->disciplina->id] ?? '#ffffff') : '#ffffff';
                                        ?>
                                        <td class="horario-cell <?php echo e(!$horario ? 'empty' : ''); ?>" 
                                            style="background-color: <?php echo e($corFundo); ?>;">
                                            <?php if($horario): ?>
                                                <span class="disciplina-badge">
                                                    <?php echo e($horario->disciplina->nome); ?>

                                                </span>
                                                <span class="professor-name">
                                                    <?php echo e($horario->professor->user->name); ?>

                                                </span>
                                            <?php else: ?>
                                                <span>-</span>
                                            <?php endif; ?>
                                        </td>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php else: ?>
        <p style="text-align: center; padding: 20px;">Nenhum horário registrado</p>
    <?php endif; ?>
</body>
</html>

<?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/horarios/pdf.blade.php ENDPATH**/ ?>