

<?php $__env->startSection('title', 'Funcionários - SGE'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-2" style="border-bottom: 1px solid #dee2e6; padding-bottom: 8px;">
            <h5 class="mb-0" style="font-weight: 600;">Funcionários</h5>
            <a href="<?php echo e(route('admin.funcionarios-servicos.create')); ?>" class="btn btn-sm btn-primary">
                <i class="bi bi-plus-circle"></i> Novo
            </a>
        </div>

        <form method="GET" action="<?php echo e(route('admin.funcionarios-servicos.index')); ?>" class="mb-2 row g-2">
            <div class="col-md-5">
                <input type="text" class="form-control form-control-sm" name="search"
                       value="<?php echo e(request('search')); ?>" placeholder="Pesquisar por nome/cargo/telefone...">
            </div>
            <div class="col-md-3">
                <select class="form-select form-select-sm" name="cargo">
                    <option value="">Todos os cargos</option>
                    <?php $__currentLoopData = $cargosExistentes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cargo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($cargo); ?>" <?php echo e(request('cargo') === $cargo ? 'selected' : ''); ?>><?php echo e($cargo); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-md-2">
                <select class="form-select form-select-sm" name="status">
                    <option value="">Status</option>
                    <option value="ATIVO" <?php echo e(request('status') === 'ATIVO' ? 'selected' : ''); ?>>Ativo</option>
                    <option value="INATIVO" <?php echo e(request('status') === 'INATIVO' ? 'selected' : ''); ?>>Inativo</option>
                </select>
            </div>
            <div class="col-md-2 d-flex gap-2">
                <button type="submit" class="btn btn-sm btn-primary">Filtrar</button>
                <?php if(request()->query()): ?>
                    <a href="<?php echo e(route('admin.funcionarios-servicos.index')); ?>" class="btn btn-sm btn-secondary">Limpar</a>
                <?php endif; ?>
            </div>
        </form>

        <div class="table-responsive">
            <table class="table table-sm table-bordered" style="font-size: 0.85rem;">
                <thead style="background-color: #f8f9fa;">
                    <tr>
                        <th style="padding: 6px;">Nome</th>
                        <th style="padding: 6px;">Cargo</th>
                        <th style="padding: 6px;">Salário Base</th>
                        <th style="padding: 6px;">Dep.</th>
                        <th style="padding: 6px;">Status</th>
                        <th style="padding: 6px;">Ações</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $funcionarios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $f): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td style="padding: 5px;"><?php echo e($f->nome); ?></td>
                            <td style="padding: 5px;"><?php echo e($f->cargo); ?></td>
                            <td style="padding: 5px;"><strong><?php echo e(number_format($f->salario_base ?? 0, 2, ',', '.')); ?></strong></td>
                            <td style="padding: 5px;"><span class="badge bg-secondary"><?php echo e($f->numero_dependentes ?? 0); ?></span></td>
                            <td style="padding: 5px;">
                                <?php if($f->is_active): ?>
                                    <span class="badge bg-success">Ativo</span>
                                <?php else: ?>
                                    <span class="badge bg-danger">Inativo</span>
                                <?php endif; ?>
                            </td>
                            <td style="padding: 5px;">
                                <div class="btn-group btn-group-sm">
                                    <a href="<?php echo e(route('admin.funcionarios-servicos.show', $f)); ?>" class="btn btn-outline-primary" title="Ver">
                                        <i class="bi bi-eye"></i>
                                    </a>
                                    <a href="<?php echo e(route('admin.funcionarios-servicos.edit', $f)); ?>" class="btn btn-outline-secondary" title="Editar">
                                        <i class="bi bi-pencil"></i>
                                    </a>
                                    <form action="<?php echo e(route('admin.funcionarios-servicos.toggle-status', $f)); ?>" method="POST" class="d-inline">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('PATCH'); ?>
                                        <button type="submit" class="btn btn-outline-warning" title="Ativar/Desativar">
                                            <i class="bi bi-toggle2-on"></i>
                                        </button>
                                    </form>
                                    <form action="<?php echo e(route('admin.funcionarios-servicos.destroy', $f)); ?>" method="POST" class="d-inline" onsubmit="return confirm('Eliminar este funcionário?');">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn btn-outline-danger" title="Eliminar">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="6" class="text-center text-muted" style="padding: 10px;">Nenhum funcionário encontrado.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <div class="mt-2">
            <?php echo e($funcionarios->links()); ?>

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/admin/funcionarios-servicos/index.blade.php ENDPATH**/ ?>