

<?php $__env->startSection('title', 'Avaliações - SGE'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h2>Avaliações</h2>
            <div>
                <?php if(auth()->user()->isProfessor()): ?>
                <?php endif; ?>
                <?php if((auth()->user()->isAdmin() || auth()->user()->isSuperadmin() || auth()->user()->podeGerir('gerir_avaliacoes')) && isset($turmas) && $turmas->count() > 0): ?>
                    <div class="btn-group">
                        <button type="button" class="btn btn-success dropdown-toggle" data-bs-toggle="dropdown">
                            <i class="bi bi-file-earmark-excel"></i> Exportar Excel
                        </button>
                        <ul class="dropdown-menu">
                            <?php $__currentLoopData = $turmas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $turma): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li>
                                    <a class="dropdown-item" href="<?php echo e(route('avaliacoes.exportar-excel', ['turma_id' => $turma->id, 'ano_letivo_id' => $anoLetivo->id ?? 0])); ?>">
                                        <?php echo e($turma->codigo); ?> - <?php echo e($turma->nome); ?>

                                    </a>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <?php if($errors->any()): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php echo e($error); ?>

                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>

        <?php if(session('error')): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <?php echo e(session('error')); ?>

                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>

        <?php if(session('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <?php echo e(session('success')); ?>

                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>

        <?php if(auth()->user()->isAdmin() || auth()->user()->isSuperadmin() || auth()->user()->podeGerir('gerir_avaliacoes')): ?>
            <div class="mb-3">
                <div class="row g-2">
                    <div class="col-md-3">
                        <a href="<?php echo e(route('avaliacoes.notas-por-estudante')); ?>" class="btn btn-outline-primary w-100 btn-sm">Notas por Estudante</a>
                    </div>
                    <div class="col-md-3">
                        <a href="<?php echo e(route('avaliacoes.todas-disciplinas', ['turma_id' => $turmas->first()->id ?? 0, 'ano_letivo_id' => $anoLetivo->id ?? 0])); ?>" 
                           class="btn btn-outline-primary w-100 btn-sm">Todas as Disciplinas</a>
                    </div>
                    <div class="col-md-3">
                        <a href="<?php echo e(route('admin.alunos.folhetos-turma')); ?>" class="btn btn-outline-primary w-100 btn-sm">Folhetos Individuais</a>
                    </div>
                    <div class="col-md-3">
                        <a href="<?php echo e(route('avaliacoes.estatisticas')); ?>" class="btn btn-outline-primary w-100 btn-sm">Estatísticas</a>
                    </div>
                </div>
            </div>
        <?php elseif(auth()->user()->isProfessor()): ?>
            <?php if(isset($avaliacoes) && isset($turma) && isset($disciplina)): ?>
                
                <div class="mb-2 d-flex justify-content-between align-items-center flex-wrap gap-2" style="font-size: 0.85rem;">
                    <div class="d-flex align-items-center gap-2 flex-wrap">
                        <span class="fw-bold"><?php echo e($turma->codigo); ?> - <?php echo e($turma->nome); ?></span>
                        <span>|</span>
                        <span class="fw-bold"><?php echo e($disciplina->nome); ?></span>
                    </div>
                    <form method="GET" action="<?php echo e(route('avaliacoes.index')); ?>" class="d-flex align-items-center gap-2" style="font-size: 0.85rem;">
                        <input type="hidden" name="turma_id" value="<?php echo e($turma->id); ?>">
                        <input type="hidden" name="disciplina_id" value="<?php echo e($disciplina->id); ?>">
                        <select name="filtro_tipo" class="form-select form-select-sm" style="width: auto; font-size: 0.85rem;" onchange="this.form.submit()">
                            <option value="anual" <?php echo e(($filtroTipo ?? 'anual') === 'anual' ? 'selected' : ''); ?>>Pauta Anual</option>
                            <option value="trimestre" <?php echo e(($filtroTipo ?? 'anual') === 'trimestre' ? 'selected' : ''); ?>>Por Trimestre</option>
                        </select>
                        <?php if(($filtroTipo ?? 'anual') === 'trimestre'): ?>
                            <select name="trimestre_id" class="form-select form-select-sm" style="width: auto; font-size: 0.85rem;" onchange="this.form.submit()">
                                <option value="">Todos</option>
                                <?php $__currentLoopData = $trimestres ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($t->id); ?>" <?php echo e(($trimestreFiltro ?? '') == $t->id ? 'selected' : ''); ?>>
                                        <?php echo e($t->numero); ?>º Trimestre
                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        <?php endif; ?>
                        <a href="<?php echo e(route('avaliacoes.index')); ?>" class="btn btn-sm btn-secondary" style="font-size: 0.85rem;">
                            <i class="bi bi-arrow-left"></i> Voltar
                        </a>
                    </form>
                </div>
                
                
                <?php
                    $isSecundario = isset($turma) && ($turma->nivel_ensino ?? 'PRIMARIO') === 'SECUNDARIO';
                ?>
                <div class="table-responsive">
                    <table class="table table-bordered table-sm" style="font-size: 0.7rem;">
                        <style>
                            .table-bordered th, .table-bordered td {
                                padding: 0.25rem 0.35rem !important;
                            }
                        </style>
                        <?php if(($filtroTipo ?? 'anual') === 'anual'): ?>
                            
                            <thead>
                                <?php if($isSecundario): ?>
                                    <tr>
                                        <th rowspan="2" style="vertical-align: middle;">Aluno</th>
                                        <?php $__currentLoopData = $trimestres ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <th colspan="4" class="text-center"><?php echo e($t->numero); ?>º Trimestre</th>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <th rowspan="2" style="vertical-align: middle;">MFRD</th>
                                        <th rowspan="2" style="vertical-align: middle;">Classificação</th>
                                    </tr>
                                    <tr>
                                        <?php $__currentLoopData = $trimestres ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <th>Teste 1</th>
                                            <th>Teste 2</th>
                                            <th>Av. Final</th>
                                            <th>Média</th>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tr>
                                <?php else: ?>
                                    <tr>
                                        <th rowspan="2" style="vertical-align: middle;">Aluno</th>
                                        <?php $__currentLoopData = $trimestres ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <th colspan="8" class="text-center"><?php echo e($t->numero); ?>º Trimestre</th>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <th rowspan="2" style="vertical-align: middle;">MFRD</th>
                                        <th rowspan="2" style="vertical-align: middle;">Classificação</th>
                                    </tr>
                                    <tr>
                                        <?php $__currentLoopData = $trimestres ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <th>1ª A.Pr</th>
                                            <th>2ª A.Pr</th>
                                            <th>MAP</th>
                                            <th>1ª ACS</th>
                                            <th>2ª ACS</th>
                                            <th>MACS</th>
                                            <th>AT</th>
                                            <th>MT</th>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tr>
                                <?php endif; ?>
                            </thead>
                            <tbody>
                                <?php
                                    $alunosUnicos = $avaliacoes->pluck('aluno')->unique('id')->values();
                                ?>
                                <?php $__empty_1 = true; $__currentLoopData = $alunosUnicos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $aluno): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($aluno->user->name ?? 'N/A'); ?></td>
                                        <?php $__currentLoopData = $trimestres ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php
                                                $avaliacao = $avaliacoes->filter(function($a) use ($aluno, $t) {
                                                    return $a->aluno_id == $aluno->id && $a->trimestre_id == $t->id;
                                                })->first();
                                            ?>
                                            <?php if($isSecundario): ?>
                                                <td class="text-center <?php echo e($avaliacao && $avaliacao->teste1 !== null && $avaliacao->teste1 < 10 ? 'text-danger' : ''); ?>"><?php echo e($avaliacao && $avaliacao->teste1 !== null ? number_format($avaliacao->teste1, 1) : '-'); ?></td>
                                                <td class="text-center <?php echo e($avaliacao && $avaliacao->teste2 !== null && $avaliacao->teste2 < 10 ? 'text-danger' : ''); ?>"><?php echo e($avaliacao && $avaliacao->teste2 !== null ? number_format($avaliacao->teste2, 1) : '-'); ?></td>
                                                <td class="text-center <?php echo e($avaliacao && $avaliacao->avaliacao_final !== null && $avaliacao->avaliacao_final < 10 ? 'text-danger' : ''); ?>"><?php echo e($avaliacao && $avaliacao->avaliacao_final !== null ? number_format($avaliacao->avaliacao_final, 1) : '-'); ?></td>
                                                <td class="text-center fw-bold <?php echo e($avaliacao && $avaliacao->media_nacional !== null && $avaliacao->media_nacional < 10 ? 'text-danger' : ''); ?>"><?php echo e($avaliacao && $avaliacao->media_nacional !== null ? number_format($avaliacao->media_nacional, 1) : '-'); ?></td>
                                            <?php else: ?>
                                                <td class="text-center <?php echo e($avaliacao && $avaliacao->a_pratica_1 !== null && $avaliacao->a_pratica_1 < 10 ? 'text-danger' : ''); ?>"><?php echo e($avaliacao && $avaliacao->a_pratica_1 !== null ? number_format($avaliacao->a_pratica_1, 1) : '-'); ?></td>
                                                <td class="text-center <?php echo e($avaliacao && $avaliacao->a_pratica_2 !== null && $avaliacao->a_pratica_2 < 10 ? 'text-danger' : ''); ?>"><?php echo e($avaliacao && $avaliacao->a_pratica_2 !== null ? number_format($avaliacao->a_pratica_2, 1) : '-'); ?></td>
                                                <td class="text-center fw-bold <?php echo e($avaliacao && $avaliacao->map !== null && $avaliacao->map < 10 ? 'text-danger' : ''); ?>"><?php echo e($avaliacao && $avaliacao->map !== null ? number_format($avaliacao->map, 1) : '-'); ?></td>
                                                <td class="text-center <?php echo e($avaliacao && $avaliacao->acs_1 !== null && $avaliacao->acs_1 < 10 ? 'text-danger' : ''); ?>"><?php echo e($avaliacao && $avaliacao->acs_1 !== null ? number_format($avaliacao->acs_1, 1) : '-'); ?></td>
                                                <td class="text-center <?php echo e($avaliacao && $avaliacao->acs_2 !== null && $avaliacao->acs_2 < 10 ? 'text-danger' : ''); ?>"><?php echo e($avaliacao && $avaliacao->acs_2 !== null ? number_format($avaliacao->acs_2, 1) : '-'); ?></td>
                                                <td class="text-center fw-bold <?php echo e($avaliacao && $avaliacao->macs !== null && $avaliacao->macs < 10 ? 'text-danger' : ''); ?>"><?php echo e($avaliacao && $avaliacao->macs !== null ? number_format($avaliacao->macs, 1) : '-'); ?></td>
                                                <td class="text-center <?php echo e($avaliacao && $avaliacao->at !== null && $avaliacao->at < 10 ? 'text-danger' : ''); ?>"><?php echo e($avaliacao && $avaliacao->at !== null ? number_format($avaliacao->at, 1) : '-'); ?></td>
                                                <td class="text-center fw-bold <?php echo e($avaliacao && $avaliacao->mt !== null && $avaliacao->mt < 10 ? 'text-danger' : ''); ?>"><?php echo e($avaliacao && $avaliacao->mt !== null ? number_format($avaliacao->mt, 0) : '-'); ?></td>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <td class="text-center fw-bold <?php echo e(isset($mediasAnuais[$aluno->id]) && $mediasAnuais[$aluno->id] < 10 ? 'text-danger' : ''); ?>">
                                            <?php echo e(isset($mediasAnuais[$aluno->id]) ? number_format($mediasAnuais[$aluno->id], 0) : '-'); ?>

                                        </td>
                                        <td class="text-center fw-bold <?php echo e(isset($classificacoes[$aluno->id]) ? ($classificacoes[$aluno->id] === 'APROVADO' ? 'text-success' : 'text-danger') : ''); ?>">
                                            <?php echo e(isset($classificacoes[$aluno->id]) ? $classificacoes[$aluno->id] : '-'); ?>

                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="<?php echo e(($isSecundario ? (count($trimestres ?? []) * 4) : (count($trimestres ?? []) * 8)) + 3); ?>" class="text-center text-muted">Nenhuma avaliação registrada</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        <?php else: ?>
                            
                            <thead>
                                <?php if($isSecundario): ?>
                                    <tr>
                                        <th>Aluno</th>
                                        <th>Trimestre</th>
                                        <th>Teste 1</th>
                                        <th>Teste 2</th>
                                        <th>Av. Final</th>
                                        <th>Média</th>
                                    </tr>
                                <?php else: ?>
                                    <tr>
                                        <th>Aluno</th>
                                        <th>Trimestre</th>
                                        <th>1ª A.Pr</th>
                                        <th>2ª A.Pr</th>
                                        <th>MAP</th>
                                        <th>1ª ACS</th>
                                        <th>2ª ACS</th>
                                        <th>MACS</th>
                                        <th>AT</th>
                                        <th>MT</th>
                                    </tr>
                                <?php endif; ?>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $avaliacoes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $avaliacao): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($avaliacao->aluno->user->name ?? 'N/A'); ?></td>
                                        <td><?php echo e($avaliacao->trimestre->numero ?? 'N/A'); ?>º</td>
                                        <?php if($isSecundario): ?>
                                            <td class="text-center <?php echo e($avaliacao->teste1 !== null && $avaliacao->teste1 < 10 ? 'text-danger' : ''); ?>"><?php echo e($avaliacao->teste1 !== null ? number_format($avaliacao->teste1, 1) : '-'); ?></td>
                                            <td class="text-center <?php echo e($avaliacao->teste2 !== null && $avaliacao->teste2 < 10 ? 'text-danger' : ''); ?>"><?php echo e($avaliacao->teste2 !== null ? number_format($avaliacao->teste2, 1) : '-'); ?></td>
                                            <td class="text-center <?php echo e($avaliacao->avaliacao_final !== null && $avaliacao->avaliacao_final < 10 ? 'text-danger' : ''); ?>"><?php echo e($avaliacao->avaliacao_final !== null ? number_format($avaliacao->avaliacao_final, 1) : '-'); ?></td>
                                            <td class="text-center fw-bold <?php echo e($avaliacao->media_nacional !== null && $avaliacao->media_nacional < 10 ? 'text-danger' : ''); ?>"><?php echo e($avaliacao->media_nacional !== null ? number_format($avaliacao->media_nacional, 1) : '-'); ?></td>
                                        <?php else: ?>
                                            <td class="text-center <?php echo e($avaliacao->a_pratica_1 !== null && $avaliacao->a_pratica_1 < 10 ? 'text-danger' : ''); ?>"><?php echo e($avaliacao->a_pratica_1 !== null ? number_format($avaliacao->a_pratica_1, 1) : '-'); ?></td>
                                            <td class="text-center <?php echo e($avaliacao->a_pratica_2 !== null && $avaliacao->a_pratica_2 < 10 ? 'text-danger' : ''); ?>"><?php echo e($avaliacao->a_pratica_2 !== null ? number_format($avaliacao->a_pratica_2, 1) : '-'); ?></td>
                                            <td class="text-center fw-bold <?php echo e($avaliacao->map !== null && $avaliacao->map < 10 ? 'text-danger' : ''); ?>"><?php echo e($avaliacao->map !== null ? number_format($avaliacao->map, 1) : '-'); ?></td>
                                            <td class="text-center <?php echo e($avaliacao->acs_1 !== null && $avaliacao->acs_1 < 10 ? 'text-danger' : ''); ?>"><?php echo e($avaliacao->acs_1 !== null ? number_format($avaliacao->acs_1, 1) : '-'); ?></td>
                                            <td class="text-center <?php echo e($avaliacao->acs_2 !== null && $avaliacao->acs_2 < 10 ? 'text-danger' : ''); ?>"><?php echo e($avaliacao->acs_2 !== null ? number_format($avaliacao->acs_2, 1) : '-'); ?></td>
                                            <td class="text-center fw-bold <?php echo e($avaliacao->macs !== null && $avaliacao->macs < 10 ? 'text-danger' : ''); ?>"><?php echo e($avaliacao->macs !== null ? number_format($avaliacao->macs, 1) : '-'); ?></td>
                                            <td class="text-center <?php echo e($avaliacao->at !== null && $avaliacao->at < 10 ? 'text-danger' : ''); ?>"><?php echo e($avaliacao->at !== null ? number_format($avaliacao->at, 1) : '-'); ?></td>
                                            <td class="text-center fw-bold <?php echo e($avaliacao->mt !== null && $avaliacao->mt < 10 ? 'text-danger' : ''); ?>"><?php echo e($avaliacao->mt !== null ? number_format($avaliacao->mt, 0) : '-'); ?></td>
                                        <?php endif; ?>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="<?php echo e($isSecundario ? 6 : 10); ?>" class="text-center text-muted">Nenhuma avaliação registrada</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        <?php endif; ?>
                    </table>
                </div>
            <?php else: ?>
                
                <div class="table-responsive">
                    <table class="table table-bordered table-sm" style="font-size: 0.75rem;">
                        <style>
                            .table-bordered th, .table-bordered td {
                                padding: 0.3rem 0.5rem !important;
                            }
                        </style>
                        <thead>
                            <tr>
                                <th>Turma</th>
                                <th>Disciplina</th>
                                <th>Acções</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $turmasComDisciplinas ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($item->turma->codigo); ?> - <?php echo e($item->turma->nome); ?></td>
                                    <td><?php echo e($item->disciplina->nome); ?></td>
                                    <td>
                                        <a href="<?php echo e(route('avaliacoes.create', ['turma_id' => $item->turma_id, 'disciplina_id' => $item->disciplina_id, 'trimestre_id' => 1, 'ano_letivo_id' => $anoLetivo->id ?? 0])); ?>" 
                                           class="btn btn-sm btn-outline-primary" style="font-size: 0.7rem; padding: 0.2rem 0.4rem;">Lançar</a>
                                        <a href="<?php echo e(route('avaliacoes.index', ['turma_id' => $item->turma_id, 'disciplina_id' => $item->disciplina_id])); ?>" 
                                           class="btn btn-sm btn-outline-info" style="font-size: 0.7rem; padding: 0.2rem 0.4rem;">Ver</a>
                                        <a href="<?php echo e(route('avaliacoes.imprimir-ficha', ['turma_id' => $item->turma_id, 'disciplina_id' => $item->disciplina_id, 'ano_letivo_id' => $anoLetivo->id ?? 0])); ?>" 
                                           class="btn btn-sm btn-outline-secondary" style="font-size: 0.7rem; padding: 0.2rem 0.4rem;" target="_blank">Imprimir</a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="3" class="text-center text-muted">Nenhuma turma atribuída</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            <?php endif; ?>
        <?php elseif(auth()->user()->isAluno()): ?>
            <div class="table-responsive">
                <table class="table table-bordered table-sm">
                    <thead>
                        <tr>
                            <th>Disciplina</th>
                            <th>Turma</th>
                            <th>Trimestre</th>
                            <th>Nota Nacional</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $avaliacoes ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $avaliacao): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($avaliacao->disciplina->nome); ?></td>
                                <td><?php echo e($avaliacao->turma->nome); ?></td>
                                <td><?php echo e($avaliacao->trimestre->nome); ?></td>
                                <td><?php echo e($avaliacao->media_nacional ?? 'N/A'); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="4" class="text-center text-muted">Nenhuma avaliação registrada</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/avaliacoes/index.blade.php ENDPATH**/ ?>