<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Folha de Salário - <?php echo e($mesNome); ?>/<?php echo e($ano); ?></title>
    <style>
        @media print {
            .no-print {
                display: none !important;
            }
            body {
                margin: 0;
                padding: 0;
            }
        }
        /* Esconder botão no PDF */
        .btn-print {
            display: none;
        }
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            margin: 20px;
            color: #333;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #333;
            padding-bottom: 15px;
        }
        .header h1 {
            margin: 0;
            font-size: 20px;
            font-weight: bold;
        }
        .header h2 {
            margin: 5px 0;
            font-size: 16px;
            font-weight: normal;
        }
        .info-box {
            margin-bottom: 20px;
            padding: 10px;
            background-color: #f5f5f5;
            border: 1px solid #ddd;
        }
        .info-box p {
            margin: 5px 0;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        table th, table td {
            border: 1px solid #333;
            padding: 8px;
            text-align: left;
        }
        table th {
            background-color: #333;
            color: white;
            font-weight: bold;
        }
        table tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        .text-right {
            text-align: right;
        }
        .text-center {
            text-align: center;
        }
        .total-row {
            font-weight: bold;
            background-color: #e8e8e8 !important;
        }
        .footer {
            margin-top: 30px;
            padding-top: 15px;
            border-top: 1px solid #333;
            text-align: center;
            font-size: 10px;
        }
        .btn-print {
            position: fixed;
            top: 20px;
            right: 20px;
            padding: 10px 20px;
            background-color: #007bff;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 14px;
        }
        .btn-print:hover {
            background-color: #0056b3;
        }
    </style>
</head>
<body>
    <?php if(!isset($logotipoBase64) && isset($logotipoUrl)): ?>
        <button class="btn-print no-print" onclick="window.print()" style="position: fixed; top: 20px; right: 20px; padding: 10px 20px; background-color: #007bff; color: white; border: none; border-radius: 5px; cursor: pointer; font-size: 14px;">
            <i class="bi bi-printer"></i> Imprimir
        </button>
    <?php endif; ?>

    <div class="header">
        <div style="text-align: center; margin-bottom: 15px;">
            <?php if($logotipoBase64): ?>
                <img src="<?php echo e($logotipoBase64); ?>" alt="Logotipo" style="max-height: 80px; max-width: 200px; margin-bottom: 10px;">
            <?php elseif(isset($logotipoUrl) && $logotipoUrl): ?>
                <img src="<?php echo e($logotipoUrl); ?>" alt="Logotipo" style="max-height: 80px; max-width: 200px; margin-bottom: 10px;">
            <?php endif; ?>
            <div style="text-align: center;">
                <h2 style="margin: 5px 0; font-size: 16px; font-weight: normal;">FOLHA DE SALÁRIO</h2>
                <h3 style="margin: 5px 0; font-size: 14px; font-weight: normal;"><?php echo e($mesNome); ?> de <?php echo e($ano); ?></h3>
            </div>
        </div>
        <?php if($professorEspecifico): ?>
            <p style="margin: 10px 0 0 0;"><strong>Professor:</strong> <?php echo e($professorEspecifico->user->name); ?> (<?php echo e($professorEspecifico->numero_funcionario); ?>)</p>
        <?php else: ?>
            <p style="margin: 10px 0 0 0;"><strong>Todos os Professores</strong></p>
        <?php endif; ?>
    </div>

    <div class="info-box">
        <p><strong>Período:</strong> <?php echo e($mesNome); ?> de <?php echo e($ano); ?></p>
        <p><strong>Data de Emissão:</strong> <?php echo e(now()->format('d/m/Y H:i')); ?></p>
        <p><strong>Total de Professores:</strong> <?php echo e($payments->count()); ?></p>
    </div>

    <table>
        <thead>
            <tr>
                <th style="width: 5%;">#</th>
                <th style="width: 15%;">Código</th>
                <th style="width: 30%;">Nome do Professor</th>
                <th style="width: 10%;">Ensino</th>
                <th style="width: 10%;">Horas</th>
                <th style="width: 15%;" class="text-right">Valor Total</th>
                <th style="width: 15%;">Data Pagamento</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td class="text-center"><?php echo e($index + 1); ?></td>
                    <td><?php echo e($payment->professor->numero_funcionario); ?></td>
                    <td><?php echo e($payment->professor->user->name); ?></td>
                    <td class="text-center">
                        <?php if(($payment->professor->nivel_ensino ?? 'AMBOS') === 'PRIMARIO'): ?>
                            Primário
                        <?php elseif(($payment->professor->nivel_ensino ?? 'AMBOS') === 'SECUNDARIO'): ?>
                            Secundário
                        <?php else: ?>
                            Ambos
                        <?php endif; ?>
                    </td>
                    <td class="text-center">
                        <?php if($payment->horas_trabalhadas): ?>
                            <?php echo e(number_format($payment->horas_trabalhadas, 2)); ?>h
                        <?php else: ?>
                            -
                        <?php endif; ?>
                    </td>
                    <td class="text-right"><?php echo e(number_format($payment->valor_total, 2, ',', '.')); ?> MT</td>
                    <td class="text-center">
                        <?php if($payment->data_pagamento): ?>
                            <?php echo e(\Carbon\Carbon::parse($payment->data_pagamento)->format('d/m/Y')); ?>

                        <?php else: ?>
                            -
                        <?php endif; ?>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
        <tfoot>
            <tr class="total-row">
                <td colspan="5" class="text-right"><strong>TOTAL GERAL:</strong></td>
                <td class="text-right"><strong><?php echo e(number_format($totalGeral, 2, ',', '.')); ?> MT</strong></td>
                <td></td>
            </tr>
        </tfoot>
    </table>

    <div class="footer">
        <p>Documento gerado em <?php echo e(now()->format('d/m/Y H:i')); ?> pelo Sistema Integrado de Gestão Escolar (SIGE)</p>
        <p>Este documento é uma cópia autêntica da folha de salário</p>
    </div>
</body>
</html>
<?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/admin/professor-payments/folha-salario.blade.php ENDPATH**/ ?>