

<?php $__env->startSection('title', 'Pagamentos - SIGE'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <div>
                <h4 class="mb-0">
                    <i class="bi bi-cash-stack text-primary me-2"></i>
                    Pagamentos
                </h4>
                <small class="text-muted">Resumo do período: <strong><?php echo e($mesNome ?? ''); ?>/<?php echo e($ano ?? ''); ?></strong></small>
            </div>
            <form method="GET" action="<?php echo e(route('admin.payments.index')); ?>" class="d-flex gap-2 align-items-end">
                <div>
                    <label class="form-label small mb-1" for="mes">Mês</label>
                    <select name="mes" id="mes" class="form-select form-select-sm">
                        <?php for($i=1;$i<=12;$i++): ?>
                            <option value="<?php echo e($i); ?>" <?php echo e((int)($mes ?? date('m')) === $i ? 'selected' : ''); ?>>
                                <?php echo e(['', 'Jan', 'Fev', 'Mar', 'Abr', 'Mai', 'Jun', 'Jul', 'Ago', 'Set', 'Out', 'Nov', 'Dez'][$i]); ?>

                            </option>
                        <?php endfor; ?>
                    </select>
                </div>
                <div>
                    <label class="form-label small mb-1" for="ano">Ano</label>
                    <input type="number" class="form-control form-control-sm" name="ano" id="ano" value="<?php echo e($ano ?? date('Y')); ?>" min="2020" max="2100" style="width: 110px;">
                </div>
                <div>
                    <button class="btn btn-primary btn-sm" type="submit">
                        <i class="bi bi-arrow-repeat me-1"></i> Atualizar
                    </button>
                </div>
            </form>
        </div>

        <!-- Card de Resumo Financeiro -->
        <div class="row g-3 mb-3">
            <div class="col-12">
                <div class="card border-0 shadow-sm" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
                    <div class="card-body text-white">
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <div>
                                <h5 class="mb-1">
                                    <i class="bi bi-calculator me-2"></i>
                                    Resumo Financeiro - <?php echo e($mesNome ?? ''); ?>/<?php echo e($ano ?? ''); ?>

                                </h5>
                                <small class="opacity-75">Totais dos pagamentos realizados (status: PAGO)</small>
                            </div>
                            <div class="text-end">
                                <div class="badge bg-white text-dark px-3 py-2" style="font-size: 0.9rem;">
                                    <i class="bi bi-check-circle me-1"></i>
                                    Período Atual
                                </div>
                            </div>
                        </div>
                        <div class="row g-3">
                            <div class="col-md-3">
                                <div class="bg-white bg-opacity-10 rounded p-3">
                                    <div class="d-flex align-items-center justify-content-between mb-2">
                                        <span class="small opacity-75">Valor Bruto</span>
                                        <i class="bi bi-currency-dollar"></i>
                                    </div>
                                    <h4 class="mb-0 fw-bold"><?php echo e(number_format($totalBruto ?? 0, 2, ',', '.')); ?> MT</h4>
                                    <?php if(($totalBruto ?? 0) > 0): ?>
                                        <div class="mt-2" style="height: 4px; background: rgba(255,255,255,0.2); border-radius: 2px; overflow: hidden;">
                                            <div style="height: 100%; width: 100%; background: rgba(255,255,255,0.6);"></div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="bg-white bg-opacity-10 rounded p-3">
                                    <div class="d-flex align-items-center justify-content-between mb-2">
                                        <span class="small opacity-75">INSS (3%)</span>
                                        <i class="bi bi-shield-check text-info"></i>
                                    </div>
                                    <h4 class="mb-0 fw-bold"><?php echo e(number_format($totalINSS ?? 0, 2, ',', '.')); ?> MT</h4>
                                    <?php if(($totalBruto ?? 0) > 0): ?>
                                        <?php $percentINSS = (($totalINSS ?? 0) / ($totalBruto ?? 1)) * 100; ?>
                                        <div class="mt-2" style="height: 4px; background: rgba(255,255,255,0.2); border-radius: 2px; overflow: hidden;">
                                            <div style="height: 100%; width: <?php echo e(min(100, $percentINSS)); ?>%; background: rgba(13, 202, 240, 0.8);"></div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="bg-white bg-opacity-10 rounded p-3">
                                    <div class="d-flex align-items-center justify-content-between mb-2">
                                        <span class="small opacity-75">IRPS</span>
                                        <i class="bi bi-receipt text-warning"></i>
                                    </div>
                                    <h4 class="mb-0 fw-bold"><?php echo e(number_format($totalIRPS ?? 0, 2, ',', '.')); ?> MT</h4>
                                    <?php if(($totalBruto ?? 0) > 0): ?>
                                        <?php $percentIRPS = (($totalIRPS ?? 0) / ($totalBruto ?? 1)) * 100; ?>
                                        <div class="mt-2" style="height: 4px; background: rgba(255,255,255,0.2); border-radius: 2px; overflow: hidden;">
                                            <div style="height: 100%; width: <?php echo e(min(100, $percentIRPS)); ?>%; background: rgba(255, 193, 7, 0.8);"></div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="bg-white bg-opacity-10 rounded p-3">
                                    <div class="d-flex align-items-center justify-content-between mb-2">
                                        <span class="small opacity-75">Valor Líquido</span>
                                        <i class="bi bi-cash-coin text-success"></i>
                                    </div>
                                    <h4 class="mb-0 fw-bold"><?php echo e(number_format($totalLiquido ?? 0, 2, ',', '.')); ?> MT</h4>
                                    <?php if(($totalBruto ?? 0) > 0): ?>
                                        <?php $percentLiquido = (($totalLiquido ?? 0) / ($totalBruto ?? 1)) * 100; ?>
                                        <div class="mt-2" style="height: 4px; background: rgba(255,255,255,0.2); border-radius: 2px; overflow: hidden;">
                                            <div style="height: 100%; width: <?php echo e(min(100, $percentLiquido)); ?>%; background: rgba(25, 135, 84, 0.8);"></div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row g-3">
            <div class="col-md-4">
                <div class="card h-100 border-0 shadow-sm">
                    <div class="card-body d-flex flex-column">
                        <div class="d-flex align-items-center justify-content-between mb-2">
                            <div class="d-flex align-items-center gap-2">
                                <div class="rounded-3 d-flex align-items-center justify-content-center" style="width:40px;height:40px;background:#e7f1ff;">
                                    <i class="bi bi-person-badge fs-4 text-primary"></i>
                                </div>
                                <div>
                                    <h5 class="mb-0">Professores</h5>
                                    <small class="text-muted">Pagamentos, IRPS/INSS e folha</small>
                                </div>
                            </div>
                        </div>
                        <div class="mb-3">
                            <div class="d-flex gap-2 flex-wrap">
                                <div class="badge bg-warning text-dark">Pendentes: <?php echo e($profPendentes ?? 0); ?></div>
                                <div class="badge bg-success">Pagos: <?php echo e($profPagos ?? 0); ?></div>
                            </div>
                        </div>
                        <div class="mt-auto d-flex gap-2 flex-wrap">
                            <a class="btn btn-primary btn-sm" href="<?php echo e(route('admin.professor-payments.index', ['mes' => $mes ?? date('m'), 'ano' => $ano ?? date('Y')])); ?>">
                                Abrir
                            </a>
                            <a class="btn btn-outline-primary btn-sm" href="<?php echo e(route('admin.professor-payments.index', ['mes' => $mes ?? date('m'), 'ano' => $ano ?? date('Y'), 'status' => 'PENDENTE'])); ?>">
                                Ver pendentes
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="card h-100 border-0 shadow-sm">
                    <div class="card-body d-flex flex-column">
                        <div class="d-flex align-items-center justify-content-between mb-2">
                            <div class="d-flex align-items-center gap-2">
                                <div class="rounded-3 d-flex align-items-center justify-content-center" style="width:40px;height:40px;background:#e7fff2;">
                                    <i class="bi bi-people fs-4 text-success"></i>
                                </div>
                                <div>
                                    <h5 class="mb-0">Funcionários</h5>
                                    <small class="text-muted">Limpeza, segurança, portaria, etc.</small>
                                </div>
                            </div>
                        </div>
                        <div class="mb-3">
                            <?php if($isAdmin ?? false): ?>
                                <div class="d-flex gap-2 flex-wrap">
                                    <div class="badge bg-warning text-dark">Pendentes: <?php echo e($funcPendentes ?? 0); ?></div>
                                    <div class="badge bg-success">Pagos: <?php echo e($funcPagos ?? 0); ?></div>
                                </div>
                            <?php else: ?>
                                <div class="text-muted small">Acesso restrito</div>
                            <?php endif; ?>
                        </div>
                        <div class="mt-auto d-flex gap-2 flex-wrap">
                            <a class="btn btn-success btn-sm" href="<?php echo e(route('admin.funcionario-payments.index', ['mes' => $mes ?? date('m'), 'ano' => $ano ?? date('Y')])); ?>">
                                Abrir
                            </a>
                            <?php if($isAdmin ?? false): ?>
                                <a class="btn btn-outline-success btn-sm" href="<?php echo e(route('admin.funcionario-payments.index', ['mes' => $mes ?? date('m'), 'ano' => $ano ?? date('Y'), 'status' => 'PENDENTE'])); ?>">
                                    Ver pendentes
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <?php if($isAdmin ?? false): ?>
                    <div class="card h-100 border-0 shadow-sm">
                        <div class="card-body d-flex flex-column">
                            <div class="d-flex align-items-center justify-content-between mb-2">
                                <div class="d-flex align-items-center gap-2">
                                    <div class="rounded-3 d-flex align-items-center justify-content-center" style="width:40px;height:40px;background:#f1f1f1;">
                                        <i class="bi bi-person-badge fs-4 text-secondary"></i>
                                    </div>
                                    <div>
                                        <h5 class="mb-0">Administração</h5>
                                        <small class="text-muted">Pessoal administrativo</small>
                                    </div>
                                </div>
                            </div>
                            <div class="mb-3">
                                <div class="d-flex gap-2 flex-wrap">
                                    <div class="badge bg-warning text-dark">Pendentes: <?php echo e($admPendentes ?? 0); ?></div>
                                    <div class="badge bg-success">Pagos: <?php echo e($admPagos ?? 0); ?></div>
                                </div>
                            </div>
                            <div class="mt-auto d-flex gap-2 flex-wrap">
                                <a class="btn btn-secondary btn-sm" href="<?php echo e(route('admin.administracao-payments.index', ['mes' => $mes ?? date('m'), 'ano' => $ano ?? date('Y')])); ?>">
                                    Abrir
                                </a>
                                <a class="btn btn-outline-secondary btn-sm" href="<?php echo e(route('admin.administracao-payments.index', ['mes' => $mes ?? date('m'), 'ano' => $ano ?? date('Y'), 'status' => 'PENDENTE'])); ?>">
                                    Ver pendentes
                                </a>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/admin/payments/index.blade.php ENDPATH**/ ?>