

<?php $__env->startSection('title', 'Enviar Plano - Professor'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header bg-primary-custom text-white py-2">
                <h5 class="mb-0">Novo Plano</h5>
            </div>
            <div class="card-body p-3">
                <form method="POST" action="<?php echo e(route('professor.planos.store')); ?>" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    
                    <div class="mb-2">
                        <label for="turma_id" class="form-label small mb-0">Turma *</label>
                        <select class="form-control form-control-sm <?php $__errorArgs = ['turma_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                id="turma_id" name="turma_id" required>
                            <option value="">Selecione</option>
                            <?php $__currentLoopData = $alocacoes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $alocacao): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($alocacao->turma_id); ?>" 
                                        data-disciplina="<?php echo e($alocacao->disciplina_id); ?>"
                                        <?php echo e(old('turma_id') == $alocacao->turma_id ? 'selected' : ''); ?>>
                                    <?php echo e($alocacao->turma_codigo); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php $__errorArgs = ['turma_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback small"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="mb-2">
                        <label for="disciplina_id" class="form-label small mb-0">Disciplina *</label>
                        <select class="form-control form-control-sm <?php $__errorArgs = ['disciplina_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                id="disciplina_id" name="disciplina_id" required>
                            <option value="">Selecione</option>
                            <?php $__currentLoopData = $alocacoes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $alocacao): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($alocacao->disciplina_id); ?>" 
                                        data-turma="<?php echo e($alocacao->turma_id); ?>"
                                        <?php echo e(old('disciplina_id') == $alocacao->disciplina_id ? 'selected' : ''); ?>>
                                    <?php echo e($alocacao->disciplina_nome); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php $__errorArgs = ['disciplina_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback small"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="mb-2">
                        <label for="trimestre_id" class="form-label small mb-0">Trimestre *</label>
                        <select class="form-control form-control-sm <?php $__errorArgs = ['trimestre_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                id="trimestre_id" name="trimestre_id" required>
                            <option value="">Selecione</option>
                            <?php $__currentLoopData = $trimestres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trimestre): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($trimestre->id); ?>" <?php echo e(old('trimestre_id') == $trimestre->id ? 'selected' : ''); ?>>
                                    <?php echo e($trimestre->nome); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php $__errorArgs = ['trimestre_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback small"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="mb-3">
                        <label for="arquivo" class="form-label small mb-0">Arquivo *</label>
                        <input type="file" class="form-control form-control-sm <?php $__errorArgs = ['arquivo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                               id="arquivo" name="arquivo" accept=".pdf,.doc,.docx" required>
                        <?php $__errorArgs = ['arquivo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback small"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="mt-3">
                        <button type="submit" class="btn btn-sm btn-primary-custom">Salvar</button>
                        <a href="<?php echo e(route('professor.planos.index')); ?>" class="btn btn-sm btn-secondary">Cancelar</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const turmaSelect = document.getElementById('turma_id');
    const disciplinaSelect = document.getElementById('disciplina_id');
    
    turmaSelect.addEventListener('change', function() {
        const turmaId = this.value;
        const options = disciplinaSelect.querySelectorAll('option[data-turma]');
        
        options.forEach(option => {
            if (turmaId && option.getAttribute('data-turma') !== turmaId) {
                option.style.display = 'none';
            } else {
                option.style.display = '';
            }
        });
        
        if (!turmaId) {
            disciplinaSelect.value = '';
        }
    });
    
    disciplinaSelect.addEventListener('change', function() {
        const disciplinaId = this.value;
        const options = turmaSelect.querySelectorAll('option[data-disciplina]');
        
        options.forEach(option => {
            if (disciplinaId && option.getAttribute('data-disciplina') !== disciplinaId) {
                option.style.display = 'none';
            } else {
                option.style.display = '';
            }
        });
        
        if (!disciplinaId) {
            turmaSelect.value = '';
        }
    });
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/professor/planos/create.blade.php ENDPATH**/ ?>