

<?php $__env->startSection('title', 'Planos - SGE'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-2" style="border-bottom: 1px solid #dee2e6; padding-bottom: 8px;">
            <h5 class="mb-0" style="font-weight: 600;">Planos Trimestrais</h5>
        </div>

        <?php if(auth()->user()->isAdmin() || auth()->user()->isSuperadmin() || auth()->user()->podeGerir('gerir_planos')): ?>
            <div class="table-responsive">
                <table class="table table-sm table-bordered" style="font-size: 0.85rem;">
                    <thead style="background-color: #f8f9fa;">
                        <tr>
                            <th style="padding: 6px;">Professor</th>
                            <th style="padding: 6px;">Disciplina</th>
                            <th style="padding: 6px;">Turma</th>
                            <th style="padding: 6px;">Trimestre</th>
                            <th style="padding: 6px;">Acções</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $planos ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plano): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td style="padding: 5px;"><?php echo e($plano->professor->user->name ?? 'N/A'); ?></td>
                                <td style="padding: 5px;"><?php echo e($plano->disciplina->nome); ?></td>
                                <td style="padding: 5px;"><?php echo e($plano->turma->codigo); ?></td>
                                <td style="padding: 5px;"><?php echo e($plano->trimestre->nome ?? 'N/A'); ?></td>
                                <td style="padding: 5px;">
                                    <?php if($plano->arquivo): ?>
                                        <div style="display: flex; gap: 4px;">
                                            <a href="<?php echo e(route('planos.visualizar', $plano)); ?>" target="_blank" class="btn btn-sm" style="padding: 2px 6px; font-size: 0.75rem; background: #e7f3ff; color: #0066cc; border: none;" title="Visualizar">
                                                <i class="bi bi-eye"></i>
                                            </a>
                                            <a href="<?php echo e(asset('storage/' . $plano->arquivo)); ?>" download class="btn btn-sm" style="padding: 2px 6px; font-size: 0.75rem; background: #d4edda; color: #155724; border: none;" title="Download">
                                                <i class="bi bi-download"></i>
                                            </a>
                                        </div>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="5" class="text-center" style="padding: 20px; color: #999;">
                                    Nenhum plano trimestral encontrado.
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        <?php elseif(auth()->user()->isProfessor() || auth()->user()->isAluno()): ?>
            <div class="table-responsive">
                <table class="table table-sm table-bordered" style="font-size: 0.85rem;">
                    <thead style="background-color: #f8f9fa;">
                        <tr>
                            <th style="padding: 6px;">Título</th>
                            <th style="padding: 6px;">Disciplina</th>
                            <th style="padding: 6px;">Turma</th>
                            <th style="padding: 6px;">Data Entrega</th>
                            <th style="padding: 6px;">Tipo</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $trabalhos ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trabalho): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td style="padding: 5px;"><?php echo e($trabalho->titulo); ?></td>
                                <td style="padding: 5px;"><?php echo e($trabalho->disciplina->nome ?? 'N/A'); ?></td>
                                <td style="padding: 5px;"><?php echo e($trabalho->turma->codigo ?? 'N/A'); ?></td>
                                <td style="padding: 5px;"><?php echo e($trabalho->data_entrega ? $trabalho->data_entrega->format('d/m/Y') : 'N/A'); ?></td>
                                <td style="padding: 5px;">
                                    <span class="badge bg-<?php echo e($trabalho->tipo === 'TPC' ? 'warning' : 'primary'); ?>">
                                        <?php echo e($trabalho->tipo); ?>

                                    </span>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="5" class="text-center" style="padding: 20px; color: #999;">
                                    Nenhum trabalho encontrado.
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/trabalhos/index.blade.php ENDPATH**/ ?>