

<?php $__env->startSection('title', 'Logs do Sistema - SGE'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-3" style="border-bottom: 1px solid #dee2e6; padding-bottom: 8px;">
            <h5 class="mb-0" style="font-weight: 600;">Logs de Auditoria do Sistema</h5>
            <div>
                <a href="<?php echo e(route('superadmin.logs.erros')); ?>" class="btn btn-sm btn-danger">
                    <i class="bi bi-exclamation-triangle"></i> Ver Erros
                </a>
            </div>
        </div>

        <!-- Filtros -->
        <div class="card mb-3" style="font-size: 0.85rem;">
            <div class="card-body">
                <form method="GET" action="<?php echo e(route('superadmin.logs.index')); ?>" class="row g-2">
                    <div class="col-md-3">
                        <label class="form-label">Ação</label>
                        <select name="acao" class="form-select form-select-sm">
                            <option value="">Todas</option>
                            <option value="LOGIN" <?php echo e(request('acao') == 'LOGIN' ? 'selected' : ''); ?>>Login</option>
                            <option value="LOGOUT" <?php echo e(request('acao') == 'LOGOUT' ? 'selected' : ''); ?>>Logout</option>
                            <option value="CREATE" <?php echo e(request('acao') == 'CREATE' ? 'selected' : ''); ?>>Criar</option>
                            <option value="UPDATE" <?php echo e(request('acao') == 'UPDATE' ? 'selected' : ''); ?>>Atualizar</option>
                            <option value="DELETE" <?php echo e(request('acao') == 'DELETE' ? 'selected' : ''); ?>>Deletar</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">Usuário</label>
                        <input type="text" name="usuario" class="form-control form-control-sm" value="<?php echo e(request('usuario')); ?>" placeholder="Nome ou email">
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">Data Início</label>
                        <input type="date" name="data_inicio" class="form-control form-control-sm" value="<?php echo e(request('data_inicio')); ?>">
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">Data Fim</label>
                        <input type="date" name="data_fim" class="form-control form-control-sm" value="<?php echo e(request('data_fim')); ?>">
                    </div>
                    <div class="col-md-12 mt-2">
                        <button type="submit" class="btn btn-sm btn-primary">Filtrar</button>
                        <a href="<?php echo e(route('superadmin.logs.index')); ?>" class="btn btn-sm btn-secondary">Limpar</a>
                    </div>
                </form>
            </div>
        </div>

        <div class="table-responsive">
            <table class="table table-sm table-bordered table-hover" style="font-size: 0.85rem;">
                <thead style="background-color: #e9ecef;">
                    <tr>
                        <th style="padding: 6px;">Data/Hora</th>
                        <th style="padding: 6px;">Usuário</th>
                        <th style="padding: 6px;">Ação</th>
                        <th style="padding: 6px;">Modelo</th>
                        <th style="padding: 6px;">IP</th>
                        <th style="padding: 6px;">Ações</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $logs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td style="padding: 5px;"><?php echo e($log->created_at->format('d/m/Y H:i:s')); ?></td>
                            <td style="padding: 5px;">
                                <?php echo e($log->user ? $log->user->name : 'Sistema'); ?>

                                <br><small class="text-muted"><?php echo e($log->user ? $log->user->email : ''); ?></small>
                            </td>
                            <td style="padding: 5px;">
                                <span class="badge 
                                    <?php if($log->acao == 'LOGIN'): ?> bg-success
                                    <?php elseif($log->acao == 'LOGOUT'): ?> bg-info
                                    <?php elseif($log->acao == 'CREATE'): ?> bg-primary
                                    <?php elseif($log->acao == 'UPDATE'): ?> bg-warning
                                    <?php elseif($log->acao == 'DELETE'): ?> bg-danger
                                    <?php else: ?> bg-secondary
                                    <?php endif; ?>">
                                    <?php echo e($log->acao); ?>

                                </span>
                            </td>
                            <td style="padding: 5px;"><?php echo e($log->modelo ?? '-'); ?></td>
                            <td style="padding: 5px;"><small><?php echo e($log->ip_address ?? '-'); ?></small></td>
                            <td style="padding: 5px;">
                                <a href="<?php echo e(route('superadmin.logs.detalhes', $log->id)); ?>" class="btn btn-sm btn-outline-primary" style="font-size: 0.75rem;">
                                    <i class="bi bi-eye"></i> Detalhes
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="6" class="text-center" style="padding: 20px;">Nenhum log encontrado</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <div class="mt-3">
            <?php echo e($logs->links()); ?>

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/superadmin/logs/index.blade.php ENDPATH**/ ?>