

<?php $__env->startSection('title', 'Redefinir Senha - SGE'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-2" style="border-bottom: 1px solid #dee2e6; padding-bottom: 8px;">
            <h5 class="mb-0" style="font-weight: 600;">
                <i class="bi bi-key-fill text-warning me-2"></i>
                Redefinir Senha
            </h5>
            <a href="<?php echo e(route('admin.password-reset.index')); ?>" class="btn btn-sm btn-secondary">
                <i class="bi bi-arrow-left"></i> Voltar
            </a>
        </div>

        <div class="card">
            <div class="card-body">
                <div class="alert alert-warning">
                    <i class="bi bi-exclamation-triangle me-2"></i>
                    <strong>Atenção:</strong> Você está prestes a redefinir a senha de <strong><?php echo e($user->name); ?></strong>.
                    O usuário precisará alterar a senha no próximo login.
                </div>

                <div class="mb-3">
                    <strong>Informações do Usuário:</strong>
                    <ul class="mt-2">
                        <li><strong>Nome:</strong> <?php echo e($user->name); ?></li>
                        <li><strong>Email:</strong> <?php echo e($user->email); ?></li>
                        <li><strong>Tipo:</strong> 
                            <?php
                                $tipoLabels = [
                                    'superadmin' => 'Superadmin',
                                    'admin' => 'Admin',
                                    'funcionario' => 'Funcionário',
                                    'professor' => 'Professor',
                                    'aluno' => 'Aluno',
                                ];
                                $tipoLabel = $tipoLabels[$user->tipo] ?? ucfirst($user->tipo);
                            ?>
                            <?php echo e($tipoLabel); ?>

                        </li>
                        <?php if($user->aluno): ?>
                            <li><strong>Código de Estudante:</strong> <?php echo e($user->aluno->codigo_estudante); ?></li>
                        <?php elseif($user->professor): ?>
                            <li><strong>Número de Funcionário:</strong> <?php echo e($user->professor->numero_funcionario); ?></li>
                        <?php elseif($user->funcionario): ?>
                            <li><strong>Número de Funcionário:</strong> <?php echo e($user->funcionario->numero_funcionario); ?></li>
                        <?php endif; ?>
                    </ul>
                </div>

                <form method="POST" action="<?php echo e(route('admin.password-reset.reset', $user)); ?>">
                    <?php echo csrf_field(); ?>

                    <div class="mb-3">
                        <label for="password" class="form-label">Nova Senha</label>
                        <input type="password" 
                               class="form-control <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                               id="password" 
                               name="password" 
                               required 
                               minlength="8">
                        <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        <small class="form-text text-muted">
                            A senha deve ter no mínimo 8 caracteres.
                        </small>
                    </div>

                    <div class="mb-3">
                        <label for="password_confirmation" class="form-label">Confirmar Nova Senha</label>
                        <input type="password" 
                               class="form-control" 
                               id="password_confirmation" 
                               name="password_confirmation" 
                               required 
                               minlength="8">
                    </div>

                    <div class="d-flex gap-2">
                        <button type="submit" class="btn btn-warning">
                            <i class="bi bi-key-fill"></i> Redefinir Senha
                        </button>
                        <a href="<?php echo e(route('admin.password-reset.index')); ?>" class="btn btn-secondary">
                            Cancelar
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/admin/password-reset/reset.blade.php ENDPATH**/ ?>