

<?php $__env->startSection('title', 'Detalhes do Log - SGE'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-3" style="border-bottom: 1px solid #dee2e6; padding-bottom: 8px;">
            <h5 class="mb-0" style="font-weight: 600;">Detalhes do Log</h5>
            <a href="<?php echo e(route('superadmin.logs.index')); ?>" class="btn btn-sm btn-secondary">Voltar</a>
        </div>

        <div class="card">
            <div class="card-body" style="font-size: 0.9rem;">
                <div class="row mb-3">
                    <div class="col-md-6">
                        <strong>Data/Hora:</strong> <?php echo e($log->created_at->format('d/m/Y H:i:s')); ?>

                    </div>
                    <div class="col-md-6">
                        <strong>Usuário:</strong> <?php echo e($log->user ? $log->user->name . ' (' . $log->user->email . ')' : 'Sistema'); ?>

                    </div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-6">
                        <strong>Ação:</strong> 
                        <span class="badge 
                            <?php if($log->acao == 'LOGIN'): ?> bg-success
                            <?php elseif($log->acao == 'LOGOUT'): ?> bg-info
                            <?php elseif($log->acao == 'CREATE'): ?> bg-primary
                            <?php elseif($log->acao == 'UPDATE'): ?> bg-warning
                            <?php elseif($log->acao == 'DELETE'): ?> bg-danger
                            <?php else: ?> bg-secondary
                            <?php endif; ?>">
                            <?php echo e($log->acao); ?>

                        </span>
                    </div>
                    <div class="col-md-6">
                        <strong>Modelo:</strong> <?php echo e($log->modelo ?? '-'); ?>

                    </div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-6">
                        <strong>IP Address:</strong> <?php echo e($log->ip_address ?? '-'); ?>

                    </div>
                    <div class="col-md-6">
                        <strong>User Agent:</strong> <?php echo e($log->user_agent ?? '-'); ?>

                    </div>
                </div>

                <?php if($log->dados_anteriores): ?>
                <div class="mb-3">
                    <strong>Dados Anteriores:</strong>
                    <pre class="bg-light p-2 rounded" style="font-size: 0.8rem; max-height: 300px; overflow-y: auto;"><?php echo e(json_encode($log->dados_anteriores, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE)); ?></pre>
                </div>
                <?php endif; ?>

                <?php if($log->dados_novos): ?>
                <div class="mb-3">
                    <strong>Dados Novos:</strong>
                    <pre class="bg-light p-2 rounded" style="font-size: 0.8rem; max-height: 300px; overflow-y: auto;"><?php echo e(json_encode($log->dados_novos, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE)); ?></pre>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/superadmin/logs/detalhes.blade.php ENDPATH**/ ?>