<?php $__env->startSection('title', 'Disciplinas - SGE'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-2" style="border-bottom: 1px solid #dee2e6; padding-bottom: 8px;">
            <h5 class="mb-0" style="font-weight: 600;">Disciplinas</h5>
            <a href="<?php echo e(route('admin.disciplinas.create')); ?>" class="btn btn-sm btn-primary">Nova Disciplina</a>
        </div>

        <form method="GET" action="<?php echo e(route('admin.disciplinas.index')); ?>" class="mb-2" style="display: flex; gap: 8px; align-items: end;">
            <input type="text" class="form-control form-control-sm" name="search" 
                   placeholder="Pesquisar..." value="<?php echo e(request('search')); ?>" style="flex: 1;">
            <select class="form-select form-select-sm" name="nivel_ensino" id="nivel_ensino" style="width: 150px;">
                <option value="">Todos os Níveis</option>
                <option value="PRIMARIO" <?php echo e(request('nivel_ensino') == 'PRIMARIO' ? 'selected' : ''); ?>>Primário</option>
                <option value="SECUNDARIO" <?php echo e(request('nivel_ensino') == 'SECUNDARIO' ? 'selected' : ''); ?>>Secundário</option>
            </select>
            <button type="submit" class="btn btn-sm btn-primary">Filtrar</button>
            <?php if(request('search') || request('nivel_ensino')): ?>
                <a href="<?php echo e(route('admin.disciplinas.index')); ?>" class="btn btn-sm btn-secondary">Limpar</a>
            <?php endif; ?>
        </form>

        <div class="mb-3 js-ajax-pagination">
            <div class="table-responsive">
                <table class="table table-sm table-bordered" style="font-size: 0.85rem; margin-bottom: 0;">
                    <thead style="background-color: #f8f9fa;">
                        <tr>
                            <th style="padding: 6px;">Código</th>
                            <th style="padding: 6px;">Nome</th>
                            <th style="padding: 6px;">Carga Horária</th>
                            <th style="padding: 6px;">Nível</th>
                            <th style="padding: 6px;">Status</th>
                            <th style="padding: 6px;">Acções</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $disciplinas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $disciplina): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td style="padding: 5px;"><?php echo e($disciplina->codigo); ?></td>
                                <td style="padding: 5px;"><?php echo e($disciplina->nome); ?></td>
                                <td style="padding: 5px;">
                                    <span style="font-size: 0.75rem; color: #666;"><?php echo e($disciplina->carga_horaria_formatada); ?></span>
                                </td>
                                <td style="padding: 5px;">
                                    <?php echo e(($disciplina->nivel_ensino ?? 'PRIMARIO') === 'SECUNDARIO' ? 'Secundário' : 'Primário'); ?>

                                </td>
                                <td style="padding: 5px;">
                                    <?php if($disciplina->ativa): ?>
                                        <span style="font-size: 0.75rem; padding: 2px 6px; background: #d4edda; color: #155724; border-radius: 3px;">Activa</span>
                                    <?php else: ?>
                                        <span style="font-size: 0.75rem; padding: 2px 6px; background: #e2e3e5; color: #383d41; border-radius: 3px;">Inactiva</span>
                                    <?php endif; ?>
                                </td>
                                <td style="padding: 5px;">
                                    <div style="display: flex; gap: 4px;">
                                        <a href="<?php echo e(route('admin.disciplinas.edit', $disciplina)); ?>" class="btn btn-sm" style="padding: 2px 6px; font-size: 0.75rem; background: #fff3cd; color: #856404; border: none;" title="Editar">
                                            <i class="bi bi-pencil"></i>
                                        </a>
                                        <form action="<?php echo e(route('admin.disciplinas.destroy', $disciplina)); ?>" method="POST" class="d-inline delete-form"
                                              data-id="<?php echo e($disciplina->id); ?>"
                                              data-confirm="Tem certeza que deseja eliminar esta disciplina?">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-sm" style="padding: 2px 6px; font-size: 0.75rem; background: #f8d7da; color: #721c24; border: none;" title="Eliminar">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="6" class="text-center text-muted">
                                    <i class="bi bi-inbox"></i> Nenhuma disciplina encontrada
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            
            <?php if(method_exists($disciplinas, 'links')): ?>
                <div class="mt-3">
                    <?php echo e($disciplinas->appends(request()->query())->links()); ?>

                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Interceptar formulários de delete
    document.querySelectorAll('.delete-form').forEach(function(form) {
        form.addEventListener('submit', function(e) {
            e.preventDefault();
            
            const confirmMsg = this.getAttribute('data-confirm');
            if (!confirm(confirmMsg)) {
                return false;
            }
            
            const formData = new FormData(this);
            const row = this.closest('tr');
            const url = this.action;
            
            // Mostrar loading
            const submitBtn = this.querySelector('button[type="submit"]');
            const originalHTML = submitBtn.innerHTML;
            submitBtn.disabled = true;
            submitBtn.innerHTML = '<i class="bi bi-hourglass-split"></i>';
            
            fetch(url, {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': formData.get('_token'),
                    'X-Requested-With': 'XMLHttpRequest',
                    'Accept': 'application/json'
                },
                body: formData
            })
            .then(response => {
                if (!response.ok) {
                    return response.json().then(data => {
                        throw new Error(data.message || 'Erro ao processar requisição');
                    });
                }
                return response.json();
            })
            .then(data => {
                if (data.success) {
                    // Remover linha da tabela com animação
                    row.style.transition = 'opacity 0.3s';
                    row.style.opacity = '0';
                    setTimeout(function() {
                        row.remove();
                        // Verificar se a tabela ficou vazia
                        const tbody = document.querySelector('tbody');
                        if (tbody && tbody.children.length === 0) {
                            tbody.innerHTML = '<tr><td colspan="6" class="text-center text-muted"><i class="bi bi-inbox"></i> Nenhuma disciplina encontrada</td></tr>';
                        }
                    }, 300);
                } else {
                    alert('Erro: ' + (data.message || 'Erro desconhecido'));
                    submitBtn.disabled = false;
                    submitBtn.innerHTML = originalHTML;
                }
            })
            .catch(error => {
                console.error('Erro:', error);
                alert('Erro: ' + (error.message || 'Erro ao eliminar disciplina. Por favor, tente novamente.'));
                submitBtn.disabled = false;
                submitBtn.innerHTML = originalHTML;
            });
        });
    });
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/admin/disciplinas/index.blade.php ENDPATH**/ ?>