<?php $__env->startSection('title', 'Relatório Financeiro - SIGE'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-2">
            <h5 class="mb-0">Relatório Financeiro</h5>
            <div class="d-flex gap-2 align-items-center">
                <form method="GET" action="<?php echo e(route('financeiro.relatorio')); ?>" class="d-flex gap-2" id="filtrosForm">
                    <select class="form-select form-select-sm" id="ano_letivo_id" name="ano_letivo_id" style="width: auto;" onchange="this.form.submit()">
                        <option value="">Todos</option>
                        <?php $__currentLoopData = $anosLetivos ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ano): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $anoRaw = $ano->getRawOriginal('ano');
                                $anoFinal = strpos($anoRaw, '/') !== false ? explode('/', $anoRaw)[1] : $anoRaw;
                            ?>
                            <option value="<?php echo e($ano->id); ?>" <?php echo e($anoLetivoId == $ano->id ? 'selected' : ''); ?>>
                                <?php echo e($anoFinal); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <select class="form-select form-select-sm" id="turma_id" name="turma_id" style="width: auto;">
                        <option value="">Todas as Turmas</option>
                        <?php $__currentLoopData = $turmas ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $turma): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($turma->id); ?>" <?php echo e($turmaId == $turma->id ? 'selected' : ''); ?>>
                                <?php echo e($turma->codigo); ?> - <?php echo e($turma->nome); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <button type="submit" class="btn btn-sm btn-primary">Filtrar</button>
                </form>
            </div>
        </div>

        <!-- KPIs Básicos -->
        <div class="row g-2 mb-3">
            <div class="col-md-3">
                <div class="border rounded p-3 text-center" style="background: #f8f9fa;">
                    <div class="small text-muted mb-1">Esperado</div>
                    <div class="fw-bold fs-5"><?php echo e(number_format($totalEsperado ?? 0, 0, ',', '.')); ?> MT</div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="border rounded p-3 text-center" style="background: #f8f9fa;">
                    <div class="small text-muted mb-1">Pago</div>
                    <div class="fw-bold fs-5 text-success"><?php echo e(number_format($totalPago ?? 0, 0, ',', '.')); ?> MT</div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="border rounded p-3 text-center" style="background: #f8f9fa;">
                    <div class="small text-muted mb-1">Pendente</div>
                    <div class="fw-bold fs-5 text-warning"><?php echo e(number_format($totalPendente ?? 0, 0, ',', '.')); ?> MT</div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="border rounded p-3 text-center" style="background: #f8f9fa;">
                    <div class="small text-muted mb-1">Vencido</div>
                    <div class="fw-bold fs-5 text-danger"><?php echo e(number_format($totalVencido ?? 0, 0, ',', '.')); ?> MT</div>
                </div>
            </div>
        </div>

        <!-- Tabela de Todos os Meses -->
        <div class="border rounded p-3 mb-3">
            <h6 class="fw-bold mb-3">Visão Mensal</h6>
            <div class="table-responsive">
                <table class="table table-sm table-bordered mb-0">
                    <thead style="background-color: #f8f9fa;">
                        <tr>
                            <th style="padding: 8px;">Mês</th>
                            <th class="text-end" style="padding: 8px;">Esperado (MT)</th>
                            <th class="text-end" style="padding: 8px;">Pago (MT)</th>
                            <th class="text-end" style="padding: 8px;">Pendente (MT)</th>
                            <th class="text-end" style="padding: 8px;">Vencido (MT)</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                            $meses = [
                                1 => 'Janeiro', 2 => 'Fevereiro', 3 => 'Março', 4 => 'Abril',
                                5 => 'Maio', 6 => 'Junho', 7 => 'Julho', 8 => 'Agosto',
                                9 => 'Setembro', 10 => 'Outubro', 11 => 'Novembro', 12 => 'Dezembro'
                            ];
                            // Se tipoPeriodo for mensal, usar dadosPorPeriodo diretamente
                            // Caso contrário, construir array mensal vazio
                            $dadosMensais = [];
                            if (($tipoPeriodo ?? 'mensal') === 'mensal' && isset($dadosPorPeriodo) && is_array($dadosPorPeriodo)) {
                                // dadosPorPeriodo já vem indexado por mês (1-12) quando tipoPeriodo é mensal
                                foreach ($meses as $num => $nome) {
                                    $item = $dadosPorPeriodo[$num] ?? null;
                                    $dadosMensais[$num] = [
                                        'mes' => $nome,
                                        'esperado' => $item['esperado'] ?? 0,
                                        'pago' => $item['pago'] ?? 0,
                                        'pendente' => $item['pendente'] ?? 0,
                                        'vencido' => $item['vencido'] ?? 0
                                    ];
                                }
                            } else {
                                // Para outros períodos, mostrar meses vazios ou tentar extrair
                                foreach ($meses as $num => $nome) {
                                    $dadosMensais[$num] = [
                                        'mes' => $nome,
                                        'esperado' => 0,
                                        'pago' => 0,
                                        'pendente' => 0,
                                        'vencido' => 0
                                    ];
                                }
                            }
                        ?>
                        <?php $__currentLoopData = $meses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $num => $nome): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $dados = $dadosMensais[$num] ?? ['mes' => $nome, 'esperado' => 0, 'pago' => 0, 'pendente' => 0, 'vencido' => 0];
                            ?>
                            <tr>
                                <td style="padding: 6px;"><?php echo e($dados['mes']); ?></td>
                                <td class="text-end" style="padding: 6px;"><?php echo e(number_format($dados['esperado'], 0, ',', '.')); ?> MT</td>
                                <td class="text-end text-success" style="padding: 6px;"><?php echo e(number_format($dados['pago'], 0, ',', '.')); ?> MT</td>
                                <td class="text-end text-warning" style="padding: 6px;"><?php echo e(number_format($dados['pendente'], 0, ',', '.')); ?> MT</td>
                                <td class="text-end text-danger" style="padding: 6px;"><?php echo e(number_format($dados['vencido'], 0, ',', '.')); ?> MT</td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <tr style="background-color: #f8f9fa; font-weight: bold;">
                            <td style="padding: 8px;">TOTAL</td>
                            <td class="text-end" style="padding: 8px;"><?php echo e(number_format($totalEsperado ?? 0, 0, ',', '.')); ?> MT</td>
                            <td class="text-end text-success" style="padding: 8px;"><?php echo e(number_format($totalPago ?? 0, 0, ',', '.')); ?> MT</td>
                            <td class="text-end text-warning" style="padding: 8px;"><?php echo e(number_format($totalPendente ?? 0, 0, ',', '.')); ?> MT</td>
                            <td class="text-end text-danger" style="padding: 8px;"><?php echo e(number_format($totalVencido ?? 0, 0, ',', '.')); ?> MT</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Dívidas por Aluno -->
        <div class="border rounded p-3 mb-3">
            <h6 class="fw-bold mb-3">Dívidas por Aluno</h6>
            <div class="table-responsive">
                <table class="table table-sm table-bordered mb-0">
                    <thead style="background-color: #f8f9fa;">
                        <tr>
                            <th style="padding: 8px;">Aluno</th>
                            <th class="text-end" style="padding: 8px;">Total (MT)</th>
                            <th class="text-end" style="padding: 8px;">Pendente (MT)</th>
                            <th class="text-end" style="padding: 8px;">Vencido (MT)</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if(isset($dividasPorAluno) && count($dividasPorAluno) > 0): ?>
                            <?php $__currentLoopData = $dividasPorAluno; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $divida): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td style="padding: 6px;"><?php echo e($divida['aluno_nome'] ?? 'N/A'); ?></td>
                                    <td class="text-end text-danger" style="padding: 6px;"><?php echo e(number_format($divida['total'] ?? 0, 0, ',', '.')); ?> MT</td>
                                    <td class="text-end text-warning" style="padding: 6px;"><?php echo e(number_format($divida['pendente'] ?? 0, 0, ',', '.')); ?> MT</td>
                                    <td class="text-end text-danger" style="padding: 6px;"><?php echo e(number_format($divida['vencido'] ?? 0, 0, ',', '.')); ?> MT</td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="4" class="text-center text-muted py-3">Nenhuma dívida encontrada</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/financeiro/relatorio.blade.php ENDPATH**/ ?>