

<?php $__env->startSection('title', 'Gerar Horários para Todas as Turmas - SGE'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-md-10">
        <div class="d-flex justify-content-between align-items-center mb-2" style="border-bottom: 1px solid #dee2e6; padding-bottom: 8px;">
            <h5 class="mb-0" style="font-weight: 600;">Gerar Horários para Todas as Turmas</h5>
            <a href="<?php echo e(route('horarios.index')); ?>" class="btn btn-sm btn-secondary">
                <i class="bi bi-arrow-left"></i> Voltar
            </a>
        </div>
        
        <div style="background: #f8f9fa; padding: 15px; border-radius: 4px;">
            <form method="POST" action="<?php echo e(route('horarios.store-todas-turmas')); ?>">
                <?php echo csrf_field(); ?>

                <div class="mb-2">
                    <label for="nivel_ensino" class="form-label" style="font-size: 0.85rem; margin-bottom: 3px;">Nível de Ensino</label>
                    <select class="form-select form-select-sm <?php $__errorArgs = ['nivel_ensino'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                            id="nivel_ensino" name="nivel_ensino">
                        <option value="">Todos os Níveis</option>
                        <option value="PRIMARIO" <?php echo e(old('nivel_ensino') == 'PRIMARIO' ? 'selected' : ''); ?>>Primário</option>
                        <option value="SECUNDARIO" <?php echo e(old('nivel_ensino') == 'SECUNDARIO' ? 'selected' : ''); ?>>Secundário</option>
                    </select>
                    <?php $__errorArgs = ['nivel_ensino'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    <small class="text-muted" style="font-size: 0.75rem;">Deixe em branco para gerar para todas as turmas, ou selecione um nível específico.</small>
                </div>

                <div class="row">
                    <div class="col-md-6 mb-2">
                        <label for="hora_inicio_manha" class="form-label" style="font-size: 0.85rem; margin-bottom: 3px;">Início <span class="text-danger">*</span></label>
                        <input type="time" class="form-control form-control-sm <?php $__errorArgs = ['hora_inicio_manha'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                               id="hora_inicio_manha" name="hora_inicio_manha" value="<?php echo e(old('hora_inicio_manha', '07:30')); ?>" required>
                        <?php $__errorArgs = ['hora_inicio_manha'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="col-md-6 mb-2">
                        <label for="hora_fim_manha" class="form-label" style="font-size: 0.85rem; margin-bottom: 3px;">Fim <span class="text-danger">*</span></label>
                        <input type="time" class="form-control form-control-sm <?php $__errorArgs = ['hora_fim_manha'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                               id="hora_fim_manha" name="hora_fim_manha" value="<?php echo e(old('hora_fim_manha', '12:15')); ?>" required>
                        <?php $__errorArgs = ['hora_fim_manha'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        <small class="text-muted" style="font-size: 0.7rem;">Intervalo de 15 min após a 3ª aula</small>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6 mb-2">
                        <label for="duracao_aula" class="form-label" style="font-size: 0.85rem; margin-bottom: 3px;">Duração da Aula (minutos) <span class="text-danger">*</span></label>
                        <input type="number" class="form-control form-control-sm <?php $__errorArgs = ['duracao_aula'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                               id="duracao_aula" name="duracao_aula" value="<?php echo e(old('duracao_aula', 45)); ?>" min="30" max="120" step="15" required>
                        <?php $__errorArgs = ['duracao_aula'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        <small class="text-muted" style="font-size: 0.7rem;">Serão criadas exatamente 6 aulas por dia</small>
                    </div>

                    <div class="col-md-6 mb-2">
                        <label for="sala_padrao" class="form-label" style="font-size: 0.85rem; margin-bottom: 3px;">Sala Padrão</label>
                        <input type="text" class="form-control form-control-sm <?php $__errorArgs = ['sala_padrao'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                               id="sala_padrao" name="sala_padrao" value="<?php echo e(old('sala_padrao')); ?>" placeholder="Ex: Sala 1">
                        <?php $__errorArgs = ['sala_padrao'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>

                <div class="mb-2">
                    <label class="form-label" style="font-size: 0.85rem; margin-bottom: 3px;">Dias da Semana <span class="text-danger">*</span></label>
                    <div style="display: flex; flex-wrap: wrap; gap: 10px;">
                        <?php $__currentLoopData = ['Segunda', 'Terça', 'Quarta', 'Quinta', 'Sexta']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dia): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="dias_semana[]" 
                                       id="dia_<?php echo e($dia); ?>" value="<?php echo e($dia); ?>" 
                                       <?php echo e(in_array($dia, old('dias_semana', ['Segunda', 'Terça', 'Quarta', 'Quinta', 'Sexta'])) ? 'checked' : ''); ?>>
                                <label class="form-check-label" for="dia_<?php echo e($dia); ?>" style="font-size: 0.85rem;">
                                    <?php echo e($dia); ?>-feira
                                </label>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <?php $__errorArgs = ['dias_semana'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="text-danger" style="font-size: 0.75rem;"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <input type="hidden" name="ano_letivo_id" value="<?php echo e($anoLetivo->id); ?>">

                <div class="alert alert-info" style="font-size: 0.85rem; padding: 10px;">
                    <strong><i class="bi bi-info-circle"></i> Informação:</strong> O sistema irá gerar horários para todas as turmas que possuem disciplinas e professores atribuídos. Turmas sem disciplinas ou professores serão ignoradas.
                </div>

                <div class="mt-3">
                    <button type="submit" class="btn btn-sm btn-primary" onclick="return confirm('Tem certeza que deseja gerar horários para todas as turmas? Esta acção pode demorar alguns minutos.');">
                        <i class="bi bi-calendar-check"></i> Gerar Horários para Todas as Turmas
                    </button>
                    <a href="<?php echo e(route('horarios.index')); ?>" class="btn btn-sm btn-secondary">Cancelar</a>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/horarios/gerar-todas-turmas.blade.php ENDPATH**/ ?>