

<?php $__env->startSection('title', 'Alunos Renovados - SIGE'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-2">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h5 class="mb-0">Alunos Renovados</h5>
        <a href="<?php echo e(route('admin.inscricoes.index')); ?>" class="btn btn-sm btn-outline-primary">Voltar</a>
    </div>

    <div class="card mb-3">
        <div class="card-body p-2">
            <form method="GET" action="<?php echo e(route('admin.inscricoes.renovados')); ?>" class="row g-2">
                <div class="col-md-3">
                    <label for="ano_letivo_id" class="form-label small mb-0">Ano Lectivo</label>
                    <select class="form-select form-select-sm" id="ano_letivo_id" name="ano_letivo_id">
                        <option value="">Selecione o Ano Lectivo</option>
                        <?php $__currentLoopData = $anosLetivos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ano): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($ano->id); ?>" <?php echo e($anoLetivoId == $ano->id ? 'selected' : ''); ?>>
                                <?php
                                    $anoFinal = strpos($ano->ano, '/') !== false ? explode('/', $ano->ano)[1] : $ano->ano;
                                ?>
                                <?php echo e($anoFinal); ?>

                                <?php if($ano->ativo): ?> (Activo) <?php endif; ?>
                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-md-3">
                    <label for="search" class="form-label small mb-0">Pesquisar</label>
                    <input type="text" class="form-control form-control-sm" id="search" name="search" 
                           value="<?php echo e(request('search')); ?>" placeholder="Código ou Nome...">
                </div>
                <div class="col-md-2">
                    <button type="submit" class="btn btn-sm btn-primary mt-4">Filtrar</button>
                </div>
            </form>
        </div>
    </div>

    <div class="table-responsive">
        <table class="table table-sm table-bordered" style="font-size: 0.85rem; margin-bottom: 0;">
            <thead style="background-color: #f8f9fa;">
                <tr>
                    <th style="padding: 6px;">Código</th>
                    <th style="padding: 6px;">Nome</th>
                    <th style="padding: 6px;">Turma Atual</th>
                    <th style="padding: 6px;">Classe</th>
                    <th style="padding: 6px;">Status</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $alunos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $aluno): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td style="padding: 5px;"><?php echo e($aluno->codigo_estudante); ?></td>
                        <td style="padding: 5px;"><?php echo e($aluno->user->name ?? '-'); ?></td>
                        <td style="padding: 5px;">
                            <?php if($aluno->turmas->isNotEmpty()): ?>
                                <?php $__currentLoopData = $aluno->turmas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $turma): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <span style="font-size: 0.75rem; padding: 2px 6px; background: #e7f3ff; color: #0066cc; border-radius: 3px;"><?php echo e($turma->codigo); ?> - <?php echo e($turma->nome); ?></span>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                                <span style="color: #999;">Sem turma</span>
                            <?php endif; ?>
                        </td>
                        <td style="padding: 5px;">
                            <?php if($aluno->turmas->isNotEmpty()): ?>
                                <?php echo e($aluno->turmas->first()->codigo); ?>

                            <?php else: ?>
                                -
                            <?php endif; ?>
                        </td>
                        <td style="padding: 5px;">
                            <?php if($aluno->user && $aluno->user->is_active): ?>
                                <span style="font-size: 0.75rem; padding: 2px 6px; background: #d4edda; color: #155724; border-radius: 3px;">Activo</span>
                            <?php else: ?>
                                <span style="font-size: 0.75rem; padding: 2px 6px; background: #f8d7da; color: #721c24; border-radius: 3px;">Bloqueado</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="5" class="text-center">Nenhum aluno renovado encontrado</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/admin/inscricoes/renovados.blade.php ENDPATH**/ ?>