

<?php $__env->startSection('title', 'Detalhes do Professor - SGE'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-2" style="border-bottom: 1px solid #dee2e6; padding-bottom: 8px;">
            <div>
                <h5 class="mb-0" style="font-weight: 600;"><?php echo e($professor->user->name); ?></h5>
                <small class="text-muted"><?php echo e($professor->numero_funcionario); ?></small>
            </div>
            <div>
                <a href="<?php echo e(route('admin.professores.imprimir-cracha', $professor)); ?>" class="btn btn-sm btn-outline-success" target="_blank" title="Imprimir crachá">
                    <i class="bi bi-upc-scan"></i> Imprimir crachá
                </a>
                <a href="<?php echo e(route('admin.professores.edit', $professor)); ?>" class="btn btn-sm btn-primary">
                    <i class="bi bi-pencil"></i> Editar
                </a>
                <a href="<?php echo e(route('admin.professores.index')); ?>" class="btn btn-sm btn-secondary">
                    <i class="bi bi-arrow-left"></i> Voltar
                </a>
            </div>
        </div>

        <div class="row">
            <div class="col-md-6 mb-3">
                <div class="mb-1">
                    <small class="text-muted" style="font-weight: 600;">Informações Pessoais</small>
                </div>
                <div style="background: #f8f9fa; padding: 10px; border-radius: 4px; font-size: 0.85rem;">
                    <div class="mb-1"><strong>Nome:</strong> <?php echo e($professor->user->name); ?></div>
                    <div class="mb-1"><strong>Gênero:</strong> 
                        <?php if($professor->genero == 'M'): ?>
                            Masculino
                        <?php elseif($professor->genero == 'F'): ?>
                            Feminino
                        <?php elseif($professor->genero == 'Outro'): ?>
                            Outro
                        <?php else: ?>
                            N/A
                        <?php endif; ?>
                    </div>
                    <div class="mb-1"><strong>Nível de Ensino:</strong>
                        <?php if(($professor->nivel_ensino ?? 'AMBOS') === 'PRIMARIO'): ?>
                            Primário
                        <?php elseif(($professor->nivel_ensino ?? 'AMBOS') === 'SECUNDARIO'): ?>
                            Secundário
                        <?php else: ?>
                            Ambos
                        <?php endif; ?>
                    </div>
                    <div class="mb-1"><strong>Status:</strong> 
                        <?php if($professor->user && $professor->user->is_active): ?>
                            <span style="font-size: 0.75rem; padding: 2px 6px; background: #d4edda; color: #155724; border-radius: 3px;">Activo</span>
                        <?php else: ?>
                            <span style="font-size: 0.75rem; padding: 2px 6px; background: #f8d7da; color: #721c24; border-radius: 3px;">Bloqueado</span>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <div class="col-md-6 mb-3">
                <div class="mb-1">
                    <small class="text-muted" style="font-weight: 600;">
                        Disciplinas
                        <?php if($anoLetivo): ?>
                            (<?php echo e($anoLetivo->ano); ?>)
                        <?php endif; ?>
                    </small>
                </div>
                <?php if($disciplinas->count() > 0): ?>
                    <div style="background: #f8f9fa; padding: 10px; border-radius: 4px;">
                        <table class="table table-sm table-bordered" style="font-size: 0.85rem; margin-bottom: 0;">
                            <thead style="background-color: #e9ecef;">
                                <tr>
                                    <th style="padding: 6px;">Disciplina</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $disciplinas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $disciplina): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td style="padding: 5px;"><?php echo e($disciplina->nome); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                <?php else: ?>
                    <div style="background: #f8f9fa; padding: 10px; border-radius: 4px; font-size: 0.85rem; text-align: center;">
                        Nenhuma disciplina atribuída
                    </div>
                <?php endif; ?>

                <div class="mb-1 mt-3">
                    <small class="text-muted" style="font-weight: 600;">
                        Turmas e Disciplinas
                        <?php if($anoLetivo): ?>
                            (<?php echo e($anoLetivo->ano); ?>)
                        <?php endif; ?>
                    </small>
                </div>
                <?php if(isset($alocacoes) && count($alocacoes) > 0): ?>
                    <div style="background: #f8f9fa; padding: 10px; border-radius: 4px; max-height: 400px; overflow-y: auto;">
                        <table class="table table-sm table-bordered" style="font-size: 0.75rem; margin-bottom: 0;">
                            <thead style="background-color: #e9ecef; position: sticky; top: 0;">
                                <tr>
                                    <th style="padding: 6px;">Turma</th>
                                    <th style="padding: 6px;">Disciplina</th>
                                    <th style="padding: 6px; text-align: center; width: 60px;">Alunos</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $alocacoes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $alocacao): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td style="padding: 5px;">
                                            <strong><?php echo e($alocacao->turma_codigo); ?></strong> - <?php echo e($alocacao->turma_nome); ?>

                                        </td>
                                        <td style="padding: 5px;">
                                            <span class="badge bg-info" style="font-size: 0.7rem;"><?php echo e($alocacao->disciplina_nome); ?></span>
                                        </td>
                                        <td style="padding: 5px; text-align: center;"><?php echo e($alocacao->total_alunos ?? 0); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                <?php else: ?>
                    <div style="background: #f8f9fa; padding: 10px; border-radius: 4px; font-size: 0.85rem; text-align: center;">
                        Nenhuma turma atribuída
                    </div>
                <?php endif; ?>

                <div class="mb-1 mt-2">
                    <small class="text-muted" style="font-weight: 600;">Acções</small>
                </div>
                <div style="background: #f8f9fa; padding: 10px; border-radius: 4px;">
                    <form action="<?php echo e(route('admin.professores.toggle-status', $professor)); ?>" method="POST" class="mb-1">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PATCH'); ?>
                        <button type="submit" class="btn btn-sm w-100" style="font-size: 0.75rem; background: <?php echo e($professor->user && $professor->user->is_active ? '#fff3cd' : '#d4edda'); ?>; color: <?php echo e($professor->user && $professor->user->is_active ? '#856404' : '#155724'); ?>; border: none;">
                            <i class="bi bi-<?php echo e($professor->user && $professor->user->is_active ? 'lock' : 'unlock'); ?>"></i>
                            <?php echo e($professor->user && $professor->user->is_active ? 'Bloquear Acesso' : 'Ativar Acesso'); ?>

                        </button>
                    </form>
                    <form action="<?php echo e(route('admin.professores.destroy', $professor)); ?>" method="POST"
                          onsubmit="return confirm('Tem certeza que deseja eliminar este professor?');">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button type="submit" class="btn btn-sm btn-danger w-100" style="font-size: 0.75rem;">
                            <i class="bi bi-trash"></i> Eliminar
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/admin/professores/show.blade.php ENDPATH**/ ?>