<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Recibo de Pagamento de Inscrição ou Matrícula - <?php echo e($configuracao['escola']); ?></title>
    <style>
        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
            font-family: 'Times New Roman', Times, serif;
        }
        
        body {
            background-color: #f5f5f5;
            color: #333;
            line-height: 1.6;
            padding: 20px;
            max-width: 800px;
            margin: 0 auto;
        }
        
        .document-container {
            background-color: white;
            box-shadow: 0 0 15px rgba(0, 0, 0, 0.1);
            border: 1px solid #ddd;
            padding: 30px;
            position: relative;
        }
        
        .header {
            text-align: center;
            padding-bottom: 15px;
            margin-bottom: 25px;
            border-bottom: 2px solid #333;
        }
        
        .logotipo-container {
            display: flex;
            justify-content: center;
            margin-bottom: 20px;
        }
        
        .logotipo {
            max-width: 150px;
            max-height: 100px;
            object-fit: contain;
        }
        
        .escola {
            font-size: 18px;
            font-weight: bold;
            text-transform: uppercase;
            margin-bottom: 10px;
            color: #900;
        }
        
        .titulo {
            font-size: 18px;
            font-weight: bold;
            text-transform: uppercase;
            margin-top: 15px;
            padding: 10px;
            background-color: #f0f0f0;
            border: 1px solid #ccc;
            color: #000;
        }
        
        .recibo-content {
            margin: 30px 0;
        }
        
        .recibo-line {
            margin-bottom: 15px;
            padding: 8px 0;
            border-bottom: 1px dotted #666;
        }
        
        .recibo-label {
            font-weight: bold;
            display: inline-block;
            min-width: 150px;
        }
        
        .recibo-value {
            display: inline-block;
        }
        
        .valor-total {
            font-size: 20px;
            font-weight: bold;
            text-align: center;
            padding: 15px;
            background-color: #f0f0f0;
            border: 2px solid #333;
            margin: 20px 0;
        }
        
        .assinaturas {
            display: flex;
            justify-content: space-between;
            margin-top: 60px;
            padding-top: 20px;
            border-top: 1px solid #333;
        }
        
        .assinatura-area {
            text-align: center;
            width: 45%;
        }
        
        .assinatura-line {
            border-top: 1px solid #333;
            width: 100%;
            margin-top: 40px;
        }
        
        .assinatura-label {
            margin-top: 5px;
            font-weight: bold;
        }
        
        .data-local {
            margin-top: 20px;
            font-style: italic;
            text-align: right;
        }
        
        @media print {
            body {
                background-color: white;
                padding: 0;
            }
            
            .document-container {
                box-shadow: none;
                border: none;
                padding: 20px;
            }
            
            .no-print {
                display: none;
            }
        }
        
        .print-btn {
            display: block;
            width: 200px;
            margin: 20px auto;
            padding: 10px 15px;
            background-color: #006600;
            color: white;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 16px;
            text-align: center;
            transition: background-color 0.3s;
        }
        
        .print-btn:hover {
            background-color: #008800;
        }
    </style>
</head>
<body>
    <div class="document-container">
        <div class="header">
            <?php if($configuracao['logotipo']): ?>
                <div class="logotipo-container">
                    <img src="<?php echo e(asset('storage/' . $configuracao['logotipo'])); ?>" 
                         alt="Logotipo da Escola" 
                         class="logotipo">
                </div>
            <?php endif; ?>
            <div class="escola"><?php echo e($configuracao['escola']); ?></div>
            <div class="titulo">RECIBO DE PAGAMENTO DE INSCRIÇÃO OU MATRÍCULA</div>
        </div>
        
        <div class="recibo-content">
            <div class="recibo-line">
                <span class="recibo-label">Código do Aluno:</span>
                <span class="recibo-value"><?php echo e($aluno->codigo_estudante); ?></span>
            </div>
            
            <div class="recibo-line">
                <span class="recibo-label">Nome do Aluno:</span>
                <span class="recibo-value"><?php echo e($aluno->user->name); ?></span>
            </div>
            
            <div class="recibo-line">
                <span class="recibo-label">Encarregado de Educação:</span>
                <span class="recibo-value"><?php echo e($aluno->nome_encarregado ?? 'N/A'); ?></span>
            </div>
            
            <div class="recibo-line">
                <span class="recibo-label">Ano Letivo:</span>
                <span class="recibo-value">
                    <?php
                        $anoLetivo = \App\Models\AnoLetivo::where('ativo', true)->first();
                    ?>
                    <?php echo e($anoLetivo ? $anoLetivo->ano_inicial : date('Y')); ?>

                </span>
            </div>
            
            <div class="recibo-line">
                <span class="recibo-label">Classe/Turma:</span>
                <span class="recibo-value">
                    <?php
                        $turmaAtual = $aluno->turmas()->wherePivot('ano_letivo_id', $anoLetivo?->id)->first();
                    ?>
                    <?php echo e($turmaAtual ? $turmaAtual->codigo . ' - Turma ' . $turmaAtual->nome : 'Não alocado'); ?>

                </span>
            </div>
            
            <div class="recibo-line">
                <span class="recibo-label">Data de Pagamento:</span>
                <span class="recibo-value"><?php echo e(date('d/m/Y')); ?></span>
            </div>
            
            <div class="valor-total">
                <div>VALOR PAGO: <?php echo e($aluno->pago ? 'PAGO' : 'PENDENTE'); ?></div>
            </div>
        </div>
        
        <div class="data-local">
            <?php echo e($configuracao['escola']); ?>, <?php echo e(date('d')); ?> de <?php echo e(\Carbon\Carbon::now()->locale('pt')->monthName); ?> de <?php echo e(date('Y')); ?>

        </div>
        
        <div class="assinaturas">
            <div class="assinatura-area">
                <div class="assinatura-line"></div>
                <div class="assinatura-label">Encarregado de educação</div>
            </div>
            
            <div class="assinatura-area">
                <div class="assinatura-line"></div>
                <div class="assinatura-label">Chefe da secretaria</div>
            </div>
        </div>
    </div>
    
    <button class="print-btn no-print" onclick="window.print()">Imprimir Recibo de Pagamento</button>
</body>
</html>

<?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/admin/alunos/imprimir-recibo.blade.php ENDPATH**/ ?>