

<?php $__env->startSection('title', 'Alocar Alunos - SGE'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-2" style="border-bottom: 1px solid #dee2e6; padding-bottom: 8px;">
            <div>
                <h5 class="mb-0" style="font-weight: 600;">Alocar Alunos</h5>
                <small class="text-muted"><?php echo e($turma->codigo); ?> - <?php echo e($turma->nome); ?><?php if($anoLetivo): ?> | <?php echo e($anoLetivo->ano); ?><?php endif; ?></small>
            </div>
            <a href="<?php echo e(route('admin.turmas.index')); ?>" class="btn btn-sm btn-secondary">
                <i class="bi bi-arrow-left"></i> Voltar
            </a>
        </div>

        <div class="row">
            <!-- Alunos da Turma -->
            <div class="col-md-6">
                <div class="mb-2">
                    <small class="text-muted" style="font-weight: 600;">Alunos Alocados (<?php echo e($alunosTurma->count()); ?>)</small>
                </div>
                <?php if($alunosTurma->count() > 0): ?>
                    <div class="table-responsive">
                        <table class="table table-sm table-bordered" style="font-size: 0.85rem; margin-bottom: 0;">
                                    <thead style="background-color: #f8f9fa;">
                                        <tr>
                                            <th style="padding: 6px;">Código</th>
                                            <th style="padding: 6px;">Nome</th>
                                            <th style="padding: 6px;">Acções</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $alunosTurma; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $aluno): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td style="padding: 5px;"><?php echo e($aluno->codigo_estudante); ?></td>
                                                <td style="padding: 5px;"><?php echo e($aluno->user->name); ?></td>
                                                <td style="padding: 5px;">
                                                    <form action="<?php echo e(route('admin.turmas.remover-aluno', ['turma' => $turma, 'aluno' => $aluno])); ?>" 
                                                          method="POST" 
                                                          class="d-inline"
                                                          onsubmit="return confirm('Tem certeza que deseja remover este aluno da turma?');">
                                                        <?php echo csrf_field(); ?>
                                                        <?php echo method_field('DELETE'); ?>
                                                        <input type="hidden" name="ano_letivo_id" value="<?php echo e($anoLetivo->id); ?>">
                                                        <button type="submit" class="btn btn-sm" style="padding: 2px 6px; font-size: 0.75rem; background: #f8d7da; color: #721c24; border: none;">
                                                            <i class="bi bi-x-circle"></i>
                                                        </button>
                                                    </form>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php else: ?>
                            <p class="text-muted text-center mb-0" style="font-size: 0.85rem; padding: 10px;">
                                Nenhum aluno alocado
                            </p>
                        <?php endif; ?>
            </div>

            <!-- Alunos Disponíveis -->
            <div class="col-md-6">
                <div class="mb-2">
                    <small class="text-muted" style="font-weight: 600;">Alunos Disponíveis (<?php echo e($alunosDisponiveis->count()); ?>)</small>
                </div>
                <?php if($alunosDisponiveis->count() > 0): ?>
                    <form action="<?php echo e(route('admin.turmas.alocar-alunos.store', $turma)); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="ano_letivo_id" value="<?php echo e($anoLetivo->id); ?>">
                        
                        <div class="table-responsive" style="max-height: 400px; overflow-y: auto;">
                            <table class="table table-sm table-bordered" style="font-size: 0.85rem; margin-bottom: 0;">
                                <thead class="sticky-top" style="background-color: #f8f9fa;">
                                    <tr>
                                        <th width="30" style="padding: 6px;">
                                            <input type="checkbox" id="selectAll" title="Selecionar todos" style="width: 16px; height: 16px;">
                                        </th>
                                        <th style="padding: 6px;">Código</th>
                                        <th style="padding: 6px;">Nome</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $alunosDisponiveis; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $aluno): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td style="padding: 5px;">
                                                <input type="checkbox" 
                                                       name="aluno_id[]" 
                                                       value="<?php echo e($aluno->id); ?>"
                                                       class="aluno-checkbox"
                                                       style="width: 16px; height: 16px;">
                                            </td>
                                            <td style="padding: 5px;"><?php echo e($aluno->codigo_estudante); ?></td>
                                            <td style="padding: 5px;"><?php echo e($aluno->user->name); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                        
                        <div class="mt-2">
                            <button type="submit" class="btn btn-sm btn-primary w-100" id="btnAlocar" disabled>
                                Alocar Selecionados
                            </button>
                        </div>
                    </form>
                <?php else: ?>
                    <p class="text-muted text-center mb-0" style="font-size: 0.85rem; padding: 10px;">
                        Todos os alunos já estão alocados
                    </p>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const selectAll = document.getElementById('selectAll');
    const checkboxes = document.querySelectorAll('.aluno-checkbox');
    const btnAlocar = document.getElementById('btnAlocar');
    
    if (selectAll) {
        selectAll.addEventListener('change', function() {
            checkboxes.forEach(checkbox => {
                checkbox.checked = this.checked;
            });
            updateButtonState();
        });
    }
    
    checkboxes.forEach(checkbox => {
        checkbox.addEventListener('change', function() {
            if (selectAll) {
                selectAll.checked = Array.from(checkboxes).every(cb => cb.checked);
            }
            updateButtonState();
        });
    });
    
    function updateButtonState() {
        if (btnAlocar) {
            const hasSelected = Array.from(checkboxes).some(cb => cb.checked);
            btnAlocar.disabled = !hasSelected;
        }
    }
});
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/admin/turmas/alocar-alunos.blade.php ENDPATH**/ ?>