

<?php $__env->startSection('title', 'Meus Horários - Professor'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h4 class="mb-0">
                <i class="bi bi-clock text-info me-2"></i>
                Meus Horários
            </h4>
            <div>
                <span class="badge bg-primary"><?php echo e($anoLetivoAtivo->ano ?? 'N/A'); ?></span>
                <a href="<?php echo e(route('professor.dashboard')); ?>" class="btn btn-sm btn-secondary">
                    <i class="bi bi-arrow-left me-1"></i> Voltar
                </a>
            </div>
        </div>
    </div>

    <div class="col-12">
        <div class="card border-0 shadow-sm">
            <div class="card-body">
                <?php if(count($horariosPorDia) > 0): ?>
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead class="table-light">
                                <tr>
                                    <th style="width: 120px;">Horário</th>
                                    <?php $__currentLoopData = $diasSemana; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dia): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <th class="text-center"><?php echo e($dia); ?></th>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                    // Coletar todos os horários únicos
                                    $todosHorarios = collect();
                                    foreach ($horariosPorDia as $dia => $horarios) {
                                        foreach ($horarios as $horario) {
                                            $todosHorarios->push([
                                                'hora_inicio' => $horario->hora_inicio,
                                                'hora_fim' => $horario->hora_fim,
                                                'dia' => $dia,
                                                'horario' => $horario
                                            ]);
                                        }
                                    }
                                    $horariosUnicos = $todosHorarios->unique(function($item) {
                                        return \Carbon\Carbon::parse($item['hora_inicio'])->format('H:i');
                                    })->sortBy('hora_inicio')->values();
                                ?>

                                <?php $__currentLoopData = $horariosUnicos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $horarioUnico): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td class="fw-bold">
                                            <?php echo e(\Carbon\Carbon::parse($horarioUnico['hora_inicio'])->format('H:i')); ?> - 
                                            <?php echo e(\Carbon\Carbon::parse($horarioUnico['hora_fim'])->format('H:i')); ?>

                                        </td>
                                        <?php $__currentLoopData = $diasSemana; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dia): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <td class="text-center">
                                                <?php
                                                    $horarioDia = collect($horariosPorDia[$dia] ?? [])->first(function($h) use ($horarioUnico) {
                                                        return \Carbon\Carbon::parse($h->hora_inicio)->format('H:i') === 
                                                               \Carbon\Carbon::parse($horarioUnico['hora_inicio'])->format('H:i');
                                                    });
                                                ?>
                                                
                                                <?php if($horarioDia): ?>
                                                    <div class="p-2 bg-info bg-opacity-10 rounded">
                                                        <strong class="d-block"><?php echo e($horarioDia->turma->codigo ?? 'N/A'); ?> - <?php echo e($horarioDia->turma->nome ?? 'N/A'); ?></strong>
                                                        <small class="text-muted"><?php echo e($horarioDia->disciplina->nome ?? 'N/A'); ?></small>
                                                    </div>
                                                <?php else: ?>
                                                    <span class="text-muted">-</span>
                                                <?php endif; ?>
                                            </td>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                <?php else: ?>
                    <div class="text-center py-5">
                        <i class="bi bi-calendar-x display-4 text-muted"></i>
                        <p class="text-muted mt-3">Nenhum horário atribuído</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/professor/horarios.blade.php ENDPATH**/ ?>