

<?php $__env->startSection('title', 'Eventos - Estudante'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h4 class="mb-0">
                <i class="bi bi-calendar-event text-warning me-2"></i>
                Eventos
            </h4>
            <div>
                <span class="badge bg-primary"><?php echo e($anoLetivoAtivo->ano ?? 'N/A'); ?></span>
            </div>
        </div>
    </div>
</div>

<?php if($eventos->count() > 0): ?>
    <div class="row">
        <?php $__currentLoopData = $eventos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $evento): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-md-6 mb-3">
                <div class="card border-0 shadow-sm h-100">
                    <div class="card-header bg-white">
                        <h5 class="mb-0"><?php echo e($evento->titulo); ?></h5>
                    </div>
                    <div class="card-body">
                        <p class="mb-2"><?php echo e($evento->descricao ?? 'Sem descrição'); ?></p>
                        <div class="d-flex flex-column gap-2">
                            <div>
                                <i class="bi bi-calendar me-2"></i>
                                <strong>Data:</strong> <?php echo e($evento->data->format('d/m/Y')); ?>

                            </div>
                            <?php if($evento->hora_inicio): ?>
                                <div>
                                    <i class="bi bi-clock me-2"></i>
                                    <strong>Hora:</strong> <?php echo e($evento->hora_inicio); ?>

                                    <?php if($evento->hora_fim): ?>
                                        - <?php echo e($evento->hora_fim); ?>

                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>
                            <?php if($evento->turma): ?>
                                <div>
                                    <i class="bi bi-building me-2"></i>
                                    <strong>Turma:</strong> <?php echo e($evento->turma->codigo); ?> - <?php echo e($evento->turma->nome); ?>

                                </div>
                            <?php endif; ?>
                            <?php if($evento->disciplina): ?>
                                <div>
                                    <i class="bi bi-book me-2"></i>
                                    <strong>Disciplina:</strong> <?php echo e($evento->disciplina->nome); ?>

                                </div>
                            <?php endif; ?>
                            <div>
                                <?php if($evento->cancelado): ?>
                                    <span class="badge bg-danger">CANCELADO</span>
                                <?php else: ?>
                                    <span class="badge bg-success">CONFIRMADO</span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
<?php else: ?>
    <div class="alert alert-info text-center">
        <i class="bi bi-inbox display-4 d-block mb-3"></i>
        Nenhum evento registrado.
    </div>
<?php endif; ?>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Alcidio\Desktop\escola\resources\views/aluno/eventos.blade.php ENDPATH**/ ?>