<!DOCTYPE html>
<html>
<head>
    <title>Teste de Permissões</title>
    <style>
        body { font-family: Arial, sans-serif; padding: 20px; }
        table { border-collapse: collapse; width: 100%; margin-top: 20px; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background-color: #f2f2f2; }
        .sim { color: green; font-weight: bold; }
        .nao { color: red; }
    </style>
</head>
<body>
    <h1>Teste de Permissões - Funcionário</h1>
    
    <h2>Dados do Usuário</h2>
    <p><strong>Nome:</strong> {{ $user->name }}</p>
    <p><strong>Email:</strong> {{ $user->email }}</p>
    <p><strong>Tipo:</strong> {{ $user->tipo }}</p>
    
    @if($funcionario)
        <h2>Dados do Funcionário</h2>
        <p><strong>ID:</strong> {{ $funcionario->id }}</p>
        <p><strong>Número:</strong> {{ $funcionario->numero_funcionario }}</p>
        
        <h2>Permissões no Banco (Raw)</h2>
        <table>
            <tr>
                <th>Permissão</th>
                <th>Valor Raw</th>
                <th>Tipo</th>
            </tr>
            @php
                $permissoes = ['gerir_alunos', 'gerir_professores', 'gerir_turmas', 'gerir_disciplinas',
                    'gerir_mensalidades', 'gerir_horarios', 'gerir_eventos', 'gerir_planos',
                    'gerir_avaliacoes', 'gerir_inscricoes'];
            @endphp
            @foreach($permissoes as $perm)
                @php
                    $raw = $funcionario->getRawOriginal($perm);
                @endphp
                <tr>
                    <td>{{ $perm }}</td>
                    <td>{{ $raw }}</td>
                    <td>{{ gettype($raw) }}</td>
                </tr>
            @endforeach
        </table>
        
        <h2>Permissões Após Cast</h2>
        <table>
            <tr>
                <th>Permissão</th>
                <th>Valor</th>
                <th>Tipo</th>
            </tr>
            @foreach($permissoes as $perm)
                @php
                    $valor = $funcionario->getAttribute($perm);
                @endphp
                <tr>
                    <td>{{ $perm }}</td>
                    <td>{{ var_export($valor, true) }}</td>
                    <td>{{ gettype($valor) }}</td>
                </tr>
            @endforeach
        </table>
    @endif
    
    <h2>Resultado podeGerir()</h2>
    <table>
        <tr>
            <th>Permissão</th>
            <th>podeGerir()</th>
            <th>Status</th>
        </tr>
        @foreach($permissoes as $perm => $resultado)
            <tr>
                <td>{{ $perm }}</td>
                <td class="{{ $resultado ? 'sim' : 'nao' }}">
                    {{ $resultado ? 'SIM' : 'NÃO' }}
                </td>
                <td>
                    @if($resultado)
                        ✅ Deve aparecer no menu
                    @else
                        ❌ NÃO deve aparecer no menu
                    @endif
                </td>
            </tr>
        @endforeach
    </table>
    
    <h2>Menu que DEVERIA aparecer</h2>
    <ul>
        @foreach($permissoes as $perm => $resultado)
            @if($resultado)
                <li>{{ $perm }}</li>
            @endif
        @endforeach
    </ul>
    
    <hr>
    <p><a href="{{ route('dashboard') }}">Voltar ao Dashboard</a></p>
</body>
</html>

