@extends('layouts.app')

@section('title', 'Modo de Manutenção - SGE')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-3" style="border-bottom: 1px solid #dee2e6; padding-bottom: 8px;">
            <h5 class="mb-0" style="font-weight: 600;">Modo de Manutenção</h5>
        </div>

        @if(session('success'))
            <div class="alert alert-success alert-dismissible fade show">
                <i class="bi bi-check-circle"></i> {{ session('success') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        @endif

        @if($errors->any())
            <div class="alert alert-danger alert-dismissible fade show">
                <i class="bi bi-exclamation-triangle"></i> 
                @foreach($errors->all() as $error)
                    <div>{{ $error }}</div>
                @endforeach
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        @endif

        <div class="card">
            <div class="card-header bg-primary text-white">
                <i class="bi bi-tools"></i> <strong>Configurações de Manutenção</strong>
            </div>
            <div class="card-body">
                <form method="POST" action="{{ route('superadmin.manutencao.update') }}">
                    @csrf

                    <div class="mb-4">
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="manutencao_ativa" 
                                   name="manutencao_ativa" 
                                   {{ $manutencaoAtiva ? 'checked' : '' }}
                                   style="width: 3rem; height: 1.5rem;">
                            <label class="form-check-label ms-3" for="manutencao_ativa" style="font-size: 1.1rem;">
                                <strong>Ativar Modo de Manutenção</strong>
                            </label>
                        </div>
                        <small class="text-muted d-block mt-2">
                            Quando ativado, o sistema ficará offline para todos os usuários, exceto superadmin.
                        </small>
                    </div>

                    <hr>

                    <div class="mb-3">
                        <label for="manutencao_mensagem" class="form-label">
                            <strong>Mensagem de Manutenção</strong>
                        </label>
                        <textarea class="form-control @error('manutencao_mensagem') is-invalid @enderror" 
                                  id="manutencao_mensagem" 
                                  name="manutencao_mensagem" 
                                  rows="4"
                                  placeholder="Digite a mensagem que será exibida aos usuários durante a manutenção...">{{ old('manutencao_mensagem', $mensagemManutencao) }}</textarea>
                        @error('manutencao_mensagem')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <small class="text-muted">
                            Esta mensagem será exibida na página de manutenção para todos os usuários.
                        </small>
                    </div>

                    <div class="mb-3">
                        <label for="manutencao_data_fim" class="form-label">
                            <strong>Data/Hora Prevista para Fim da Manutenção (Opcional)</strong>
                        </label>
                        <input type="datetime-local" 
                               class="form-control @error('manutencao_data_fim') is-invalid @enderror" 
                               id="manutencao_data_fim" 
                               name="manutencao_data_fim" 
                               value="{{ old('manutencao_data_fim', $dataFimManutencao ? \Carbon\Carbon::parse($dataFimManutencao)->format('Y-m-d\TH:i') : '') }}">
                        @error('manutencao_data_fim')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <small class="text-muted">
                            Informe quando a manutenção deve terminar. Esta informação será exibida aos usuários.
                        </small>
                    </div>

                    <div class="mt-4">
                        <button type="submit" class="btn btn-primary">
                            <i class="bi bi-save"></i> Salvar Configurações
                        </button>
                        <a href="{{ route('superadmin.configuracoes') }}" class="btn btn-secondary">
                            <i class="bi bi-arrow-left"></i> Voltar
                        </a>
                    </div>
                </form>
            </div>
        </div>

        @if($manutencaoAtiva)
            <div class="alert alert-info mt-3">
                <i class="bi bi-info-circle"></i> <strong>Status Atual:</strong> 
                O modo de manutenção está <strong class="text-danger">ATIVO</strong>. 
                Todos os usuários (exceto superadmin) estão vendo a página de manutenção.
            </div>
        @else
            <div class="alert alert-success mt-3">
                <i class="bi bi-check-circle"></i> <strong>Status Atual:</strong> 
                O modo de manutenção está <strong class="text-success">INATIVO</strong>. 
                O sistema está funcionando normalmente para todos os usuários.
            </div>
        @endif

        <div class="card mt-3" style="background: #f8f9fa;">
            <div class="card-body">
                <h6 class="card-title"><i class="bi bi-question-circle"></i> Como Funciona?</h6>
                <ul class="mb-0" style="font-size: 0.9rem;">
                    <li><strong>Ativar:</strong> Marque a opção "Ativar Modo de Manutenção" e salve</li>
                    <li><strong>Efeito:</strong> Todos os usuários (exceto superadmin) verão a página de manutenção</li>
                    <li><strong>Superadmin:</strong> Você sempre terá acesso, mesmo durante a manutenção</li>
                    <li><strong>Desativar:</strong> Desmarque a opção e salve para voltar ao normal</li>
                </ul>
            </div>
        </div>
    </div>
</div>
@endsection
