@extends('layouts.app')

@section('title', 'Detalhes do Log - SGE')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-3" style="border-bottom: 1px solid #dee2e6; padding-bottom: 8px;">
            <h5 class="mb-0" style="font-weight: 600;">Detalhes do Log</h5>
            <a href="{{ route('superadmin.logs.index') }}" class="btn btn-sm btn-secondary">Voltar</a>
        </div>

        <div class="card">
            <div class="card-body" style="font-size: 0.9rem;">
                <div class="row mb-3">
                    <div class="col-md-6">
                        <strong>Data/Hora:</strong> {{ $log->created_at->format('d/m/Y H:i:s') }}
                    </div>
                    <div class="col-md-6">
                        <strong>Usuário:</strong> {{ $log->user ? $log->user->name . ' (' . $log->user->email . ')' : 'Sistema' }}
                    </div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-6">
                        <strong>Ação:</strong> 
                        <span class="badge 
                            @if($log->acao == 'LOGIN') bg-success
                            @elseif($log->acao == 'LOGOUT') bg-info
                            @elseif($log->acao == 'CREATE') bg-primary
                            @elseif($log->acao == 'UPDATE') bg-warning
                            @elseif($log->acao == 'DELETE') bg-danger
                            @else bg-secondary
                            @endif">
                            {{ $log->acao }}
                        </span>
                    </div>
                    <div class="col-md-6">
                        <strong>Modelo:</strong> {{ $log->modelo ?? '-' }}
                    </div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-6">
                        <strong>IP Address:</strong> {{ $log->ip_address ?? '-' }}
                    </div>
                    <div class="col-md-6">
                        <strong>User Agent:</strong> {{ $log->user_agent ?? '-' }}
                    </div>
                </div>

                @if($log->dados_anteriores)
                <div class="mb-3">
                    <strong>Dados Anteriores:</strong>
                    <pre class="bg-light p-2 rounded" style="font-size: 0.8rem; max-height: 300px; overflow-y: auto;">{{ json_encode($log->dados_anteriores, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) }}</pre>
                </div>
                @endif

                @if($log->dados_novos)
                <div class="mb-3">
                    <strong>Dados Novos:</strong>
                    <pre class="bg-light p-2 rounded" style="font-size: 0.8rem; max-height: 300px; overflow-y: auto;">{{ json_encode($log->dados_novos, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) }}</pre>
                </div>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection
