@extends('layouts.app')

@section('title', 'Configurações - SGE')

@section('content')
<div class="row">
    <div class="col-md-8">
        <div class="d-flex justify-content-between align-items-center mb-2" style="border-bottom: 1px solid #dee2e6; padding-bottom: 8px;">
            <h5 class="mb-0" style="font-weight: 600;">Configurações do Sistema</h5>
        </div>
        
        <div style="background: #f8f9fa; padding: 15px; border-radius: 4px;">
            <form method="POST" action="{{ route('superadmin.configuracoes.update') }}">
                @csrf

                <div class="mb-2">
                    <label for="ano_letivo_id" class="form-label" style="font-size: 0.85rem; margin-bottom: 3px;">Ano Letivo Activo</label>
                    <select class="form-select form-select-sm @error('ano_letivo_id') is-invalid @enderror" 
                            id="ano_letivo_id" name="ano_letivo_id">
                        <option value="">Selecione</option>
                        @foreach(\App\Models\AnoLetivo::all() as $ano)
                            <option value="{{ $ano->id }}" {{ ($anoLetivoAtivo && $anoLetivoAtivo->id == $ano->id) ? 'selected' : '' }}>
                                {{ $ano->ano }}
                            </option>
                        @endforeach
                    </select>
                    @error('ano_letivo_id')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <hr style="margin: 0.75rem 0;">

                <h6 style="font-size: 0.9rem; font-weight: 600; margin-bottom: 0.5rem;">Controle de Lançamento de Notas por Trimestre</h6>

                @if($trimestres && $trimestres->isNotEmpty())
                    @foreach($trimestres as $trimestre)
                        <div class="mb-2 p-2 border rounded" style="background: white;">
                            <div class="form-check form-switch">
                                <input type="hidden" name="trimestres[{{ $trimestre->id }}]" value="0">
                                <input class="form-check-input" type="checkbox" 
                                       id="trimestre_{{ $trimestre->id }}" 
                                       name="trimestres[{{ $trimestre->id }}]" 
                                       value="1"
                                       {{ ($lancamentoPorTrimestre[$trimestre->id] ?? true) ? 'checked' : '' }}>
                                <label class="form-check-label" for="trimestre_{{ $trimestre->id }}" style="font-size: 0.85rem;">
                                    <strong>{{ $trimestre->numero }}º Trimestre - {{ $trimestre->nome }}</strong>
                                </label>
                            </div>
                        </div>
                    @endforeach
                    <small class="form-text text-muted d-block" style="font-size: 0.75rem; margin-top: 5px;">
                        Quando desmarcado, os professores poderão apenas visualizar as notas daquele trimestre, mas não poderão alterá-las.
                    </small>
                @else
                    <div class="alert alert-warning" style="font-size: 0.85rem; padding: 8px;">
                        <i class="bi bi-exclamation-triangle"></i> Nenhum trimestre encontrado para o ano letivo ativo.
                    </div>
                @endif

                <hr style="margin: 0.75rem 0;">

                <h6 style="font-size: 0.9rem; font-weight: 600; margin-bottom: 0.5rem;">Tema Visual</h6>

                <div class="mb-2">
                    <label for="cor_principal" class="form-label" style="font-size: 0.85rem; margin-bottom: 3px;">Cor Principal <span class="text-danger">*</span></label>
                    <input type="color" class="form-control form-control-color form-control-sm @error('cor_principal') is-invalid @enderror" 
                           id="cor_principal" name="cor_principal" value="{{ $temaAtivo->cor_principal ?? '#6c757d' }}" required style="width: 60px; height: 35px;">
                    @error('cor_principal')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="mb-2">
                    <label for="cor_secundaria" class="form-label" style="font-size: 0.85rem; margin-bottom: 3px;">Cor Secundária</label>
                    <input type="color" class="form-control form-control-color form-control-sm @error('cor_secundaria') is-invalid @enderror" 
                           id="cor_secundaria" name="cor_secundaria" value="{{ $temaAtivo->cor_secundaria ?? '#0d6efd' }}" style="width: 60px; height: 35px;">
                    @error('cor_secundaria')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="mt-2">
                    <button type="submit" class="btn btn-sm btn-primary">Salvar</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection



