@extends('layouts.app')

@section('title', 'Sistema de Backup - SGE')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-3" style="border-bottom: 1px solid #dee2e6; padding-bottom: 8px;">
            <h5 class="mb-0" style="font-weight: 600;">Sistema de Backup</h5>
            <div class="d-flex gap-2">
                <a href="{{ route('superadmin.backups.google-drive') }}" class="btn btn-sm btn-info">
                    <i class="bi bi-cloud-upload"></i> Google Drive
                </a>
                <form method="POST" action="{{ route('superadmin.backups.criar') }}" class="d-inline">
                    @csrf
                    <input type="hidden" name="tipo" value="database">
                    <button type="submit" class="btn btn-sm btn-primary" onclick="return confirm('Deseja criar backup apenas do banco de dados?')">
                        <i class="bi bi-database"></i> Backup do Banco
                    </button>
                </form>
                <form method="POST" action="{{ route('superadmin.backups.criar') }}" class="d-inline">
                    @csrf
                    <input type="hidden" name="tipo" value="files">
                    <button type="submit" class="btn btn-sm btn-success" onclick="return confirm('Deseja criar backup apenas dos arquivos?')">
                        <i class="bi bi-folder"></i> Backup dos Arquivos
                    </button>
                </form>
                <form method="POST" action="{{ route('superadmin.backups.criar') }}" class="d-inline">
                    @csrf
                    <input type="hidden" name="tipo" value="completo">
                    <button type="submit" class="btn btn-sm btn-warning" onclick="return confirm('Deseja criar backup completo (banco + arquivos)? Isso pode demorar alguns minutos.')">
                        <i class="bi bi-archive"></i> Backup Completo
                    </button>
                </form>
            </div>
        </div>

        @if(session('success'))
            <div class="alert alert-success alert-dismissible fade show">
                <i class="bi bi-check-circle"></i> {{ session('success') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        @endif

        @if($errors->any())
            <div class="alert alert-danger alert-dismissible fade show">
                <i class="bi bi-exclamation-triangle"></i> 
                @foreach($errors->all() as $error)
                    <div>{{ $error }}</div>
                @endforeach
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        @endif

        <div class="card mb-3" style="font-size: 0.85rem;">
            <div class="card-header bg-info text-white">
                <i class="bi bi-pie-chart"></i> <strong>Estatísticas de Armazenamento</strong>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6 mb-2">
                        <strong>Fotos de Alunos:</strong>
                        <div class="d-flex justify-content-between">
                            <span>{{ number_format($estatisticas['fotos_alunos']['quantidade']) }} arquivo(s)</span>
                            <span class="text-primary"><strong>{{ number_format($estatisticas['fotos_alunos']['tamanho'] / 1024 / 1024, 2) }} MB</strong></span>
                        </div>
                    </div>
                    <div class="col-md-6 mb-2">
                        <strong>TPCs e Trabalhos:</strong>
                        <div class="d-flex justify-content-between">
                            <span>{{ number_format($estatisticas['tpcs']['quantidade']) }} arquivo(s)</span>
                            <span class="text-success"><strong>{{ number_format($estatisticas['tpcs']['tamanho'] / 1024 / 1024, 2) }} MB</strong></span>
                        </div>
                    </div>
                    <div class="col-md-6 mb-2">
                        <strong>Planos Trimestrais:</strong>
                        <div class="d-flex justify-content-between">
                            <span>{{ number_format($estatisticas['planos']['quantidade']) }} arquivo(s)</span>
                            <span class="text-warning"><strong>{{ number_format($estatisticas['planos']['tamanho'] / 1024 / 1024, 2) }} MB</strong></span>
                        </div>
                    </div>
                    <div class="col-md-6 mb-2">
                        <strong>Configurações:</strong>
                        <div class="d-flex justify-content-between">
                            <span>{{ number_format($estatisticas['configuracoes']['quantidade']) }} arquivo(s)</span>
                            <span class="text-secondary"><strong>{{ number_format($estatisticas['configuracoes']['tamanho'] / 1024 / 1024, 2) }} MB</strong></span>
                        </div>
                    </div>
                    <div class="col-12 mt-2 pt-2 border-top">
                        <div class="d-flex justify-content-between">
                            <strong>TOTAL DE ARQUIVOS:</strong>
                            <span class="text-primary"><strong>{{ number_format($estatisticas['total']['quantidade']) }} arquivo(s) - {{ number_format($estatisticas['total']['tamanho'] / 1024 / 1024, 2) }} MB</strong></span>
                        </div>
                    </div>
                </div>
                <div class="alert alert-light mt-3 mb-0" style="font-size: 0.8rem;">
                    <i class="bi bi-info-circle"></i> <strong>Importante:</strong> Mesmo com muitos arquivos (GB), a base de dados permanece pequena e rápida porque armazena apenas os caminhos (strings), não os arquivos em si.
                </div>
            </div>
        </div>

        <div class="alert alert-info">
            <i class="bi bi-info-circle"></i> <strong>Informações sobre Backups:</strong>
            <ul class="mb-0 mt-2" style="padding-left: 20px;">
                <li><strong>Backups:</strong> Salvos em <code>storage/app/backups</code> (NÃO em public) - não afetam velocidade do sistema</li>
                <li><strong>Espaço Total de Backups:</strong> <strong>{{ number_format($tamanhoTotal / 1024 / 1024, 2) }} MB</strong></li>
                <li><strong>Recomendação:</strong> Faça download dos backups importantes e delete os antigos regularmente</li>
            </ul>
        </div>

        <div class="card mb-3" style="font-size: 0.85rem;">
            <div class="card-header bg-warning text-dark">
                <i class="bi bi-trash"></i> <strong>Limpeza de Backups Antigos</strong>
            </div>
            <div class="card-body">
                <p class="mb-2">Deletar automaticamente backups mais antigos que X dias:</p>
                <form method="POST" action="{{ route('superadmin.backups.limpar') }}" class="d-flex gap-2 align-items-end">
                    @csrf
                    <div style="flex: 1;">
                        <label for="dias" class="form-label" style="font-size: 0.8rem;">Manter backups dos últimos:</label>
                        <select class="form-select form-select-sm" id="dias" name="dias" required>
                            <option value="7">7 dias</option>
                            <option value="15">15 dias</option>
                            <option value="30" selected>30 dias</option>
                            <option value="60">60 dias</option>
                            <option value="90">90 dias</option>
                        </select>
                    </div>
                    <button type="submit" class="btn btn-sm btn-warning" onclick="return confirm('Tem certeza? Todos os backups mais antigos serão deletados permanentemente!')">
                        <i class="bi bi-trash"></i> Limpar Backups Antigos
                    </button>
                </form>
                <small class="text-muted d-block mt-2">
                    <i class="bi bi-exclamation-triangle"></i> Esta ação não pode ser desfeita. Certifique-se de ter feito download dos backups importantes antes de limpar.
                </small>
            </div>
        </div>

        <div class="table-responsive">
            <table class="table table-sm table-bordered" style="font-size: 0.85rem;">
                <thead style="background-color: #e9ecef;">
                    <tr>
                        <th style="padding: 6px;">Nome do Arquivo</th>
                        <th style="padding: 6px;">Tipo</th>
                        <th style="padding: 6px;">Tamanho</th>
                        <th style="padding: 6px;">Data de Criação</th>
                        <th style="padding: 6px;">Ações</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($backups as $backup)
                        <tr>
                            <td style="padding: 5px;">
                                @if(str_ends_with($backup['nome'], '.zip'))
                                    <i class="bi bi-file-earmark-zip"></i>
                                @else
                                    <i class="bi bi-file-earmark-code"></i>
                                @endif
                                {{ $backup['nome'] }}
                            </td>
                            <td style="padding: 5px;">
                                @if($backup['tipo'] === 'database')
                                    <span class="badge bg-primary">Banco de Dados</span>
                                @elseif($backup['tipo'] === 'files')
                                    <span class="badge bg-success">Arquivos</span>
                                @elseif($backup['tipo'] === 'completo')
                                    <span class="badge bg-warning text-dark">Completo</span>
                                @else
                                    <span class="badge bg-secondary">Desconhecido</span>
                                @endif
                            </td>
                            <td style="padding: 5px;">
                                {{ number_format($backup['tamanho'] / 1024 / 1024, 2) }} MB
                            </td>
                            <td style="padding: 5px;">
                                {{ \Carbon\Carbon::parse($backup['data'])->format('d/m/Y H:i:s') }}
                            </td>
                            <td style="padding: 5px;">
                                <div style="display: flex; gap: 4px;">
                                    <a href="{{ route('superadmin.backups.download', $backup['nome']) }}" class="btn btn-sm btn-success" style="font-size: 0.75rem;">
                                        <i class="bi bi-download"></i> Download
                                    </a>
                                    <form action="{{ route('superadmin.backups.deletar', $backup['nome']) }}" method="POST" class="d-inline">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-danger" style="font-size: 0.75rem;" onclick="return confirm('Tem certeza que deseja deletar este backup?')">
                                            <i class="bi bi-trash"></i> Deletar
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="text-center" style="padding: 20px;">
                                <i class="bi bi-inbox" style="font-size: 2rem; color: #ccc;"></i>
                                <p class="mt-2">Nenhum backup encontrado</p>
                                <p class="text-muted" style="font-size: 0.85rem;">Clique em "Criar Backup" para gerar o primeiro backup.</p>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection
