@extends('layouts.app')

@section('title', 'Configurações Google Drive - SGE')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-3" style="border-bottom: 1px solid #dee2e6; padding-bottom: 8px;">
            <h5 class="mb-0" style="font-weight: 600;">Configurações do Google Drive</h5>
            <a href="{{ route('superadmin.backups.index') }}" class="btn btn-sm btn-secondary">Voltar</a>
        </div>

        @if(session('success'))
            <div class="alert alert-success alert-dismissible fade show">
                <i class="bi bi-check-circle"></i> {{ session('success') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        @endif

        @if($errors->any())
            <div class="alert alert-danger alert-dismissible fade show">
                <i class="bi bi-exclamation-triangle"></i> 
                @foreach($errors->all() as $error)
                    <div>{{ $error }}</div>
                @endforeach
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        @endif

        <div class="alert alert-info">
            <i class="bi bi-info-circle"></i> <strong>Como configurar:</strong>
            <ol class="mb-0 mt-2" style="padding-left: 20px;">
                <li>Acesse <a href="https://console.cloud.google.com" target="_blank">Google Cloud Console</a></li>
                <li>Crie um projeto ou selecione um existente</li>
                <li>Ative a API do Google Drive</li>
                <li>Vá em "Credenciais" → "Criar credenciais" → "ID do cliente OAuth 2.0"</li>
                <li>Configure o tipo de aplicativo como "Aplicativo da Web"</li>
                <li>Adicione a URL de redirecionamento: <code>{{ route('superadmin.backups.google-drive.callback') }}</code></li>
                <li>Copie o Client ID e Client Secret e cole abaixo</li>
                <li>Clique em "Autenticar" para autorizar o acesso</li>
            </ol>
        </div>

        <div style="background: #f8f9fa; padding: 15px; border-radius: 4px;">
            <form method="POST" action="{{ route('superadmin.backups.google-drive.update') }}">
                @csrf

                <div class="mb-3">
                    <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="google_drive_enabled" 
                               name="google_drive_enabled" 
                               {{ $googleDriveEnabled ? 'checked' : '' }}>
                        <label class="form-check-label" for="google_drive_enabled" style="font-size: 0.9rem;">
                            <strong>Enviar backups automaticamente para Google Drive</strong>
                        </label>
                        <small class="form-text text-muted d-block" style="font-size: 0.75rem; margin-top: 3px;">
                            Quando ativado, todos os backups criados serão automaticamente enviados para o Google Drive.
                        </small>
                    </div>
                </div>

                <hr>

                <div class="mb-2">
                    <label for="google_drive_client_id" class="form-label" style="font-size: 0.85rem; margin-bottom: 3px;">Client ID <span class="text-danger">*</span></label>
                    <input type="text" class="form-control form-control-sm @error('google_drive_client_id') is-invalid @enderror" 
                           id="google_drive_client_id" name="google_drive_client_id" 
                           value="{{ old('google_drive_client_id', $clientId) }}" 
                           placeholder="xxxxx.apps.googleusercontent.com">
                    @error('google_drive_client_id')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="mb-2">
                    <label for="google_drive_client_secret" class="form-label" style="font-size: 0.85rem; margin-bottom: 3px;">Client Secret <span class="text-danger">*</span></label>
                    <input type="password" class="form-control form-control-sm @error('google_drive_client_secret') is-invalid @enderror" 
                           id="google_drive_client_secret" name="google_drive_client_secret" 
                           value="{{ old('google_drive_client_secret', $clientSecret) }}" 
                           placeholder="GOCSPX-xxxxx">
                    @error('google_drive_client_secret')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                @if($isAuthenticated)
                    <div class="alert alert-success" style="font-size: 0.85rem;">
                        <i class="bi bi-check-circle"></i> <strong>Autenticado com sucesso!</strong> O sistema está autorizado a enviar arquivos para o Google Drive.
                    </div>
                @else
                    <div class="alert alert-warning" style="font-size: 0.85rem;">
                        <i class="bi bi-exclamation-triangle"></i> <strong>Atenção:</strong> Você precisa autenticar antes de poder enviar backups.
                    </div>
                @endif

                @if($isConfigured && !$isAuthenticated)
                    <div class="mb-3">
                        <a href="{{ route('superadmin.backups.google-drive.auth') }}" class="btn btn-sm btn-primary">
                            <i class="bi bi-google"></i> Autenticar com Google Drive
                        </a>
                    </div>
                @endif

                <div class="mb-2">
                    <label for="google_drive_folder_id" class="form-label" style="font-size: 0.85rem; margin-bottom: 3px;">ID da Pasta (Opcional)</label>
                    <input type="text" class="form-control form-control-sm @error('google_drive_folder_id') is-invalid @enderror" 
                           id="google_drive_folder_id" name="google_drive_folder_id" 
                           value="{{ old('google_drive_folder_id', $folderId) }}" 
                           placeholder="1BxiMVs0XRA5nFMdKvBdBZjgmUUqptlbs74OgvE2upms">
                    @error('google_drive_folder_id')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                    <small class="text-muted" style="font-size: 0.75rem;">
                        ID da pasta no Google Drive onde os backups serão salvos. Deixe em branco para salvar na raiz do Drive.
                        <br>Para encontrar o ID: Abra a pasta no Google Drive, o ID está na URL após <code>/folders/</code>
                    </small>
                </div>

                @if($isAuthenticated && count($folders) > 0)
                    <div class="mb-3">
                        <label class="form-label" style="font-size: 0.85rem;">Pastas Disponíveis:</label>
                        <select class="form-select form-select-sm" id="select_folder" onchange="document.getElementById('google_drive_folder_id').value = this.value">
                            <option value="">Selecione uma pasta (ou deixe em branco para raiz)</option>
                            @foreach($folders as $folder)
                                <option value="{{ $folder->id }}" {{ $folderId == $folder->id ? 'selected' : '' }}>
                                    {{ $folder->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                @endif

                <div class="mt-3">
                    <button type="submit" class="btn btn-sm btn-primary">Salvar Configurações</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
