@extends('layouts.app')

@section('title', 'Admins - SGE')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-2" style="border-bottom: 1px solid #dee2e6; padding-bottom: 8px;">
            <h5 class="mb-0" style="font-weight: 600;">Gestão de Usuários (Admins, Funcionários e Professores)</h5>
            <a href="{{ route('superadmin.admins.create') }}" class="btn btn-sm btn-primary">
                <i class="bi bi-plus-circle"></i> Novo Admin
            </a>
        </div>

        <div class="table-responsive">
            <table class="table table-sm table-bordered" style="font-size: 0.85rem; margin-bottom: 0;">
                <thead style="background-color: #e9ecef;">
                    <tr>
                        <th style="padding: 6px;">Nome</th>
                        <th style="padding: 6px;">Email</th>
                        <th style="padding: 6px;">Tipo/Role</th>
                        <th style="padding: 6px;">Status</th>
                        <th style="padding: 6px;">Acções</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($admins as $admin)
                        <tr>
                            <td style="padding: 5px;">{{ $admin->name }}</td>
                            <td style="padding: 5px;">{{ $admin->email }}</td>
                            <td style="padding: 5px;">
                                <span style="font-size: 0.75rem; padding: 2px 6px; background: 
                                    @if($admin->tipo == 'admin') #0d6efd
                                    @elseif($admin->tipo == 'funcionario') #6c757d
                                    @elseif($admin->tipo == 'professor') #198754
                                    @else #ffc107
                                    @endif; color: white; border-radius: 3px; text-transform: capitalize;">
                                    {{ ucfirst($admin->tipo) }}
                                </span>
                            </td>
                            <td style="padding: 5px;">
                                <span style="font-size: 0.75rem; padding: 2px 6px; background: {{ $admin->is_active ? '#d4edda' : '#f8d7da' }}; color: {{ $admin->is_active ? '#155724' : '#721c24' }}; border-radius: 3px;">
                                    {{ $admin->is_active ? 'Activo' : 'Bloqueado' }}
                                </span>
                            </td>
                            <td style="padding: 5px;">
                                <div style="display: flex; gap: 4px; flex-wrap: wrap;">
                                    <a href="{{ route('superadmin.admins.edit', $admin) }}" class="btn btn-sm" style="padding: 2px 6px; font-size: 0.75rem; background: #fff3cd; color: #856404; border: none;">
                                        <i class="bi bi-pencil"></i> Editar
                                    </a>
                                    <form action="{{ route('superadmin.admins.toggle-block', $admin) }}" method="POST" class="d-inline">
                                        @csrf
                                        @method('POST')
                                        <button type="submit" class="btn btn-sm" style="padding: 2px 6px; font-size: 0.75rem; background: {{ $admin->is_active ? '#f8d7da' : '#d4edda' }}; color: {{ $admin->is_active ? '#721c24' : '#155724' }}; border: none;" 
                                                onclick="return confirm('{{ $admin->is_active ? 'Deseja bloquear' : 'Deseja desbloquear' }} este usuário?')">
                                            <i class="bi bi-{{ $admin->is_active ? 'lock' : 'unlock' }}"></i> {{ $admin->is_active ? 'Bloquear' : 'Desbloquear' }}
                                        </button>
                                    </form>
                                    <form action="{{ route('superadmin.admins.destroy', $admin) }}" method="POST" class="d-inline">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-sm" style="padding: 2px 6px; font-size: 0.75rem; background: #f8d7da; color: #721c24; border: none;" onclick="return confirm('Tem certeza que deseja eliminar este usuário?')">
                                            <i class="bi bi-trash"></i> Eliminar
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="text-center" style="padding: 10px;">Nenhum usuário registrado</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection



