@extends('layouts.app')

@section('title', 'Editar Admin - SGE')

@section('content')
<div class="row">
    <div class="col-md-8">
        <div class="d-flex justify-content-between align-items-center mb-2" style="border-bottom: 1px solid #dee2e6; padding-bottom: 8px;">
            <h5 class="mb-0" style="font-weight: 600;">Editar Admin</h5>
            <a href="{{ route('superadmin.admins.index') }}" class="btn btn-sm btn-secondary">Voltar</a>
        </div>
        
        <div style="background: #f8f9fa; padding: 15px; border-radius: 4px;">
            <form method="POST" action="{{ route('superadmin.admins.update', $user) }}">
                @csrf
                @method('PUT')

                <div class="mb-2">
                    <label for="name" class="form-label" style="font-size: 0.85rem; margin-bottom: 3px;">Nome <span class="text-danger">*</span></label>
                    <input type="text" class="form-control form-control-sm @error('name') is-invalid @enderror" 
                           id="name" name="name" value="{{ old('name', $user->name) }}" required>
                    @error('name')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="mb-2">
                    <label for="email" class="form-label" style="font-size: 0.85rem; margin-bottom: 3px;">Email <span class="text-danger">*</span></label>
                    <input type="email" class="form-control form-control-sm @error('email') is-invalid @enderror" 
                           id="email" name="email" value="{{ old('email', $user->email) }}" required>
                    @error('email')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="mb-2">
                    <label for="password" class="form-label" style="font-size: 0.85rem; margin-bottom: 3px;">Nova Senha</label>
                    <input type="password" class="form-control form-control-sm @error('password') is-invalid @enderror" 
                           id="password" name="password" minlength="8">
                    @error('password')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                    <small class="text-muted" style="font-size: 0.75rem;">Deixe em branco para manter a senha atual. Mínimo de 8 caracteres.</small>
                </div>

                <div class="mb-2">
                    <label for="tipo" class="form-label" style="font-size: 0.85rem; margin-bottom: 3px;">Tipo/Role <span class="text-danger">*</span></label>
                    <select class="form-select form-select-sm @error('tipo') is-invalid @enderror" 
                            id="tipo" name="tipo" required>
                        <option value="admin" {{ old('tipo', $user->tipo) == 'admin' ? 'selected' : '' }}>Admin</option>
                        <option value="funcionario" {{ old('tipo', $user->tipo) == 'funcionario' ? 'selected' : '' }}>Funcionário</option>
                        <option value="professor" {{ old('tipo', $user->tipo) == 'professor' ? 'selected' : '' }}>Professor</option>
                    </select>
                    @error('tipo')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                    <small class="text-muted" style="font-size: 0.75rem;">Altere o tipo/role do usuário conforme necessário.</small>
                </div>

                <div class="mb-2 form-check form-switch">
                    <input type="checkbox" class="form-check-input" id="is_active" name="is_active" 
                           value="1" {{ old('is_active', $user->is_active) ? 'checked' : '' }}>
                    <label class="form-check-label" for="is_active" style="font-size: 0.85rem;">
                        <strong>Usuário Ativo</strong>
                    </label>
                    <small class="text-muted d-block" style="font-size: 0.75rem;">Quando desmarcado, o usuário fica bloqueado e não pode fazer login.</small>
                </div>

                <div class="mt-2">
                    <button type="submit" class="btn btn-sm btn-primary">Atualizar</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection



