@extends('layouts.app')

@section('title', 'Visualizar TPC - Professor')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-2" style="font-size: 0.85rem;">
            <h5 class="mb-0" style="font-weight: 600;">Visualizar TPC</h5>
            <a href="{{ route('professor.tpcs.index') }}" class="btn btn-sm btn-secondary" style="font-size: 0.85rem; padding: 0.25rem 0.5rem;">
                <i class="bi bi-arrow-left"></i> Voltar
            </a>
        </div>

        <div class="card border-0 shadow-sm">
            <div class="card-body p-2">
                <div class="row g-2 mb-2" style="font-size: 0.75rem;">
                    <div class="col-md-6">
                        <strong>Título:</strong> {{ $tpc->titulo }}
                    </div>
                    <div class="col-md-6">
                        <strong>Disciplina:</strong> {{ $tpc->disciplina->nome }}
                    </div>
                    <div class="col-md-6">
                        <strong>Turma:</strong> {{ $tpc->turma->codigo }} - {{ $tpc->turma->nome }}
                    </div>
                    <div class="col-md-6">
                        <strong>Data de Entrega:</strong> {{ $tpc->data_entrega->format('d/m/Y') }}
                    </div>
                    @if($tpc->valor)
                        <div class="col-md-6">
                            <strong>Valor:</strong> {{ $tpc->valor }}
                        </div>
                    @endif
                    @if($tpc->descricao)
                        <div class="col-12">
                            <strong>Descrição:</strong>
                            <p class="mb-0">{{ $tpc->descricao }}</p>
                        </div>
                    @endif
                    @if($tpc->arquivo)
                        <div class="col-12">
                            <strong>Arquivo:</strong>
                            <div class="mt-1">
                                <a href="{{ route('professor.tpcs.visualizar', $tpc) }}" target="_blank" class="btn btn-sm btn-primary" style="font-size: 0.7rem; padding: 0.2rem 0.4rem;">
                                    <i class="bi bi-file-earmark-pdf"></i> Visualizar
                                </a>
                                <a href="{{ Storage::url($tpc->arquivo) }}" download class="btn btn-sm btn-success" style="font-size: 0.7rem; padding: 0.2rem 0.4rem;">
                                    <i class="bi bi-download"></i> Download
                                </a>
                            </div>
                        </div>
                    @endif
                </div>

                @if($tpc->alunos->count() > 0)
                    <hr class="my-2">
                    <h6 class="mb-2" style="font-size: 0.8rem;">Alunos Atribuídos ({{ $tpc->alunos->count() }})</h6>
                    <div class="table-responsive">
                        <table class="table table-bordered table-sm" style="font-size: 0.7rem;">
                            <style>
                                .table-bordered th, .table-bordered td {
                                    padding: 0.25rem 0.35rem !important;
                                }
                            </style>
                            <thead>
                                <tr>
                                    <th>Nome</th>
                                    <th>Status</th>
                                    <th>Nota</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($tpc->alunos as $aluno)
                                    @php
                                        $pivot = $aluno->pivot;
                                        $entregue = $pivot->entregue ?? false;
                                    @endphp
                                    <tr>
                                        <td>{{ $aluno->user->name }}</td>
                                        <td>
                                            <span class="badge bg-{{ $entregue ? 'success' : 'warning' }}" style="font-size: 0.65rem;">
                                                {{ $entregue ? 'Entregue' : 'Pendente' }}
                                            </span>
                                        </td>
                                        <td>{{ $pivot->nota ?? '-' }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                @endif

                <div class="mt-2">
                    <a href="{{ route('professor.tpcs.edit', $tpc) }}" class="btn btn-sm btn-primary" style="font-size: 0.75rem; padding: 0.25rem 0.5rem;">
                        <i class="bi bi-pencil"></i> Editar
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

