@extends('layouts.app')

@section('title', 'Editar TPC - Professor')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-2" style="font-size: 0.85rem;">
            <h5 class="mb-0" style="font-weight: 600;">Editar TPC</h5>
            <a href="{{ route('professor.tpcs.index') }}" class="btn btn-sm btn-secondary" style="font-size: 0.85rem; padding: 0.25rem 0.5rem;">
                <i class="bi bi-arrow-left"></i> Voltar
            </a>
        </div>

        <div class="card border-0 shadow-sm">
            <div class="card-body p-2">
                <form method="POST" action="{{ route('professor.tpcs.update', $tpc) }}" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    
                    <div class="mb-2">
                        <label for="titulo" class="form-label small mb-0">Título <span class="text-danger">*</span></label>
                        <input type="text" class="form-control form-control-sm @error('titulo') is-invalid @enderror" 
                               id="titulo" name="titulo" value="{{ old('titulo', $tpc->titulo) }}" required>
                        @error('titulo')
                            <div class="invalid-feedback small">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="row g-2">
                        <div class="col-md-6 mb-2">
                            <label for="turma_id" class="form-label small mb-0">Turma <span class="text-danger">*</span></label>
                            <select class="form-select form-select-sm @error('turma_id') is-invalid @enderror" 
                                    id="turma_id" name="turma_id" required>
                                <option value="">Selecione a turma</option>
                                @foreach($alocacoes as $alocacao)
                                    <option value="{{ $alocacao->turma_id }}" 
                                            data-disciplina="{{ $alocacao->disciplina_id }}"
                                            {{ old('turma_id', $tpc->turma_id) == $alocacao->turma_id ? 'selected' : '' }}>
                                        {{ $alocacao->turma_codigo }} - {{ $alocacao->turma_nome }}
                                    </option>
                                @endforeach
                            </select>
                            @error('turma_id')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6 mb-2">
                            <label for="disciplina_id" class="form-label small mb-0">Disciplina <span class="text-danger">*</span></label>
                            <select class="form-select form-select-sm @error('disciplina_id') is-invalid @enderror" 
                                    id="disciplina_id" name="disciplina_id" required>
                                <option value="">Selecione a disciplina</option>
                                @foreach($alocacoes as $alocacao)
                                    <option value="{{ $alocacao->disciplina_id }}" 
                                            data-turma="{{ $alocacao->turma_id }}"
                                            {{ old('disciplina_id', $tpc->disciplina_id) == $alocacao->disciplina_id ? 'selected' : '' }}>
                                        {{ $alocacao->disciplina_nome }}
                                    </option>
                                @endforeach
                            </select>
                            @error('disciplina_id')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <div class="row g-2">
                        <div class="col-md-6 mb-2">
                            <label for="data_entrega" class="form-label small mb-0">Data de Entrega <span class="text-danger">*</span></label>
                            <input type="date" class="form-control form-control-sm @error('data_entrega') is-invalid @enderror" 
                                   id="data_entrega" name="data_entrega" value="{{ old('data_entrega', $tpc->data_entrega->format('Y-m-d')) }}" required>
                            @error('data_entrega')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6 mb-2">
                            <label for="valor" class="form-label small mb-0">Valor</label>
                            <input type="number" step="0.1" min="0" max="20" class="form-control form-control-sm @error('valor') is-invalid @enderror" 
                                   id="valor" name="valor" value="{{ old('valor', $tpc->valor) }}">
                            @error('valor')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <div class="mb-2">
                        <label for="descricao" class="form-label small mb-0">Descrição</label>
                        <textarea class="form-control form-control-sm @error('descricao') is-invalid @enderror" 
                                  id="descricao" name="descricao" rows="2">{{ old('descricao', $tpc->descricao) }}</textarea>
                        @error('descricao')
                            <div class="invalid-feedback small">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-2">
                        <label for="arquivo" class="form-label small mb-0">Arquivo</label>
                        @if($tpc->arquivo)
                            <div class="mb-1">
                                <small class="text-muted">Arquivo atual: {{ $tpc->nome_arquivo }}</small>
                                <a href="{{ route('professor.tpcs.visualizar', $tpc) }}" target="_blank" class="btn btn-sm btn-outline-info ms-2" style="font-size: 0.7rem; padding: 0.15rem 0.3rem;">
                                    <i class="bi bi-eye"></i> Ver
                                </a>
                            </div>
                        @endif
                        <input type="file" class="form-control form-control-sm @error('arquivo') is-invalid @enderror" 
                               id="arquivo" name="arquivo" accept=".pdf,.doc,.docx">
                        <small class="text-muted" style="font-size: 0.65rem;">Deixe em branco para manter o arquivo atual</small>
                        @error('arquivo')
                            <div class="invalid-feedback small">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="d-flex justify-content-between mt-2">
                        <a href="{{ route('professor.tpcs.index') }}" class="btn btn-sm btn-secondary" style="font-size: 0.75rem; padding: 0.25rem 0.5rem;">
                            <i class="bi bi-x-circle"></i> Cancelar
                        </a>
                        <button type="submit" class="btn btn-sm btn-primary" style="font-size: 0.75rem; padding: 0.25rem 0.5rem;">
                            <i class="bi bi-check-circle"></i> Atualizar
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const turmaSelect = document.getElementById('turma_id');
    const disciplinaSelect = document.getElementById('disciplina_id');
    
    // Filtrar disciplinas quando turma é selecionada
    turmaSelect.addEventListener('change', function() {
        const turmaId = this.value;
        const options = disciplinaSelect.querySelectorAll('option[data-turma]');
        
        options.forEach(option => {
            if (turmaId && option.getAttribute('data-turma') !== turmaId) {
                option.style.display = 'none';
            } else {
                option.style.display = '';
            }
        });
        
        if (!turmaId) {
            disciplinaSelect.value = '';
        }
    });
    
    // Filtrar turmas quando disciplina é selecionada
    disciplinaSelect.addEventListener('change', function() {
        const disciplinaId = this.value;
        const options = turmaSelect.querySelectorAll('option[data-disciplina]');
        
        options.forEach(option => {
            if (disciplinaId && option.getAttribute('data-disciplina') !== disciplinaId) {
                option.style.display = 'none';
            } else {
                option.style.display = '';
            }
        });
        
        if (!disciplinaId) {
            turmaSelect.value = '';
        }
    });
});
</script>
@endsection

