@extends('layouts.app')

@section('title', 'Editar Plano - Professor')

@section('content')
<div class="row">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header bg-primary-custom text-white py-2">
                <h5 class="mb-0">Editar Plano</h5>
            </div>
            <div class="card-body p-3">
                <form method="POST" action="{{ route('professor.planos.update', $plano) }}" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    
                    <div class="mb-2">
                        <label for="turma_id" class="form-label small mb-0">Turma *</label>
                        <select class="form-control form-control-sm @error('turma_id') is-invalid @enderror" 
                                id="turma_id" name="turma_id" required>
                            <option value="">Selecione</option>
                            @foreach($alocacoes as $alocacao)
                                <option value="{{ $alocacao->turma_id }}" 
                                        data-disciplina="{{ $alocacao->disciplina_id }}"
                                        {{ old('turma_id', $plano->turma_id) == $alocacao->turma_id ? 'selected' : '' }}>
                                    {{ $alocacao->turma_codigo }}
                                </option>
                            @endforeach
                        </select>
                        @error('turma_id')
                            <div class="invalid-feedback small">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-2">
                        <label for="disciplina_id" class="form-label small mb-0">Disciplina *</label>
                        <select class="form-control form-control-sm @error('disciplina_id') is-invalid @enderror" 
                                id="disciplina_id" name="disciplina_id" required>
                            <option value="">Selecione</option>
                            @foreach($alocacoes as $alocacao)
                                <option value="{{ $alocacao->disciplina_id }}" 
                                        data-turma="{{ $alocacao->turma_id }}"
                                        {{ old('disciplina_id', $plano->disciplina_id) == $alocacao->disciplina_id ? 'selected' : '' }}>
                                    {{ $alocacao->disciplina_nome }}
                                </option>
                            @endforeach
                        </select>
                        @error('disciplina_id')
                            <div class="invalid-feedback small">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-2">
                        <label for="trimestre_id" class="form-label small mb-0">Trimestre *</label>
                        <select class="form-control form-control-sm @error('trimestre_id') is-invalid @enderror" 
                                id="trimestre_id" name="trimestre_id" required>
                            <option value="">Selecione</option>
                            @foreach($trimestres as $trimestre)
                                <option value="{{ $trimestre->id }}" {{ old('trimestre_id', $plano->trimestre_id) == $trimestre->id ? 'selected' : '' }}>
                                    {{ $trimestre->nome }}
                                </option>
                            @endforeach
                        </select>
                        @error('trimestre_id')
                            <div class="invalid-feedback small">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="arquivo" class="form-label small mb-0">Arquivo</label>
                        <input type="file" class="form-control form-control-sm @error('arquivo') is-invalid @enderror" 
                               id="arquivo" name="arquivo" accept=".pdf,.doc,.docx">
                        @error('arquivo')
                            <div class="invalid-feedback small">{{ $message }}</div>
                        @enderror
                        @if($plano->nome_arquivo)
                            <small class="form-text text-muted">Atual: {{ $plano->nome_arquivo }}</small>
                        @endif
                    </div>

                    <div class="mt-3">
                        <button type="submit" class="btn btn-sm btn-primary-custom">Salvar</button>
                        <a href="{{ route('professor.planos.index') }}" class="btn btn-sm btn-secondary">Cancelar</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const turmaSelect = document.getElementById('turma_id');
    const disciplinaSelect = document.getElementById('disciplina_id');
    
    turmaSelect.addEventListener('change', function() {
        const turmaId = this.value;
        const options = disciplinaSelect.querySelectorAll('option[data-turma]');
        
        options.forEach(option => {
            if (turmaId && option.getAttribute('data-turma') !== turmaId) {
                option.style.display = 'none';
            } else {
                option.style.display = '';
            }
        });
        
        if (!turmaId) {
            disciplinaSelect.value = '';
        }
    });
    
    disciplinaSelect.addEventListener('change', function() {
        const disciplinaId = this.value;
        const options = turmaSelect.querySelectorAll('option[data-disciplina]');
        
        options.forEach(option => {
            if (disciplinaId && option.getAttribute('data-disciplina') !== disciplinaId) {
                option.style.display = 'none';
            } else {
                option.style.display = '';
            }
        });
        
        if (!disciplinaId) {
            turmaSelect.value = '';
        }
    });
});
</script>
@endsection
