@extends('layouts.app')

@section('title', 'Meus Horários - Professor')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h4 class="mb-0">
                <i class="bi bi-clock text-info me-2"></i>
                Meus Horários
            </h4>
            <div>
                <span class="badge bg-primary">{{ $anoLetivoAtivo->ano ?? 'N/A' }}</span>
                <a href="{{ route('professor.dashboard') }}" class="btn btn-sm btn-secondary">
                    <i class="bi bi-arrow-left me-1"></i> Voltar
                </a>
            </div>
        </div>
    </div>

    <div class="col-12">
        <div class="card border-0 shadow-sm">
            <div class="card-body">
                @if(count($horariosPorDia) > 0)
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead class="table-light">
                                <tr>
                                    <th style="width: 120px;">Horário</th>
                                    @foreach($diasSemana as $dia)
                                        <th class="text-center">{{ $dia }}</th>
                                    @endforeach
                                </tr>
                            </thead>
                            <tbody>
                                @php
                                    // Coletar todos os horários únicos
                                    $todosHorarios = collect();
                                    foreach ($horariosPorDia as $dia => $horarios) {
                                        foreach ($horarios as $horario) {
                                            $todosHorarios->push([
                                                'hora_inicio' => $horario->hora_inicio,
                                                'hora_fim' => $horario->hora_fim,
                                                'dia' => $dia,
                                                'horario' => $horario
                                            ]);
                                        }
                                    }
                                    $horariosUnicos = $todosHorarios->unique(function($item) {
                                        return \Carbon\Carbon::parse($item['hora_inicio'])->format('H:i');
                                    })->sortBy('hora_inicio')->values();
                                @endphp

                                @foreach($horariosUnicos as $horarioUnico)
                                    <tr>
                                        <td class="fw-bold">
                                            {{ \Carbon\Carbon::parse($horarioUnico['hora_inicio'])->format('H:i') }} - 
                                            {{ \Carbon\Carbon::parse($horarioUnico['hora_fim'])->format('H:i') }}
                                        </td>
                                        @foreach($diasSemana as $dia)
                                            <td class="text-center">
                                                @php
                                                    $horarioDia = collect($horariosPorDia[$dia] ?? [])->first(function($h) use ($horarioUnico) {
                                                        return \Carbon\Carbon::parse($h->hora_inicio)->format('H:i') === 
                                                               \Carbon\Carbon::parse($horarioUnico['hora_inicio'])->format('H:i');
                                                    });
                                                @endphp
                                                
                                                @if($horarioDia)
                                                    <div class="p-2 bg-info bg-opacity-10 rounded">
                                                        <strong class="d-block">{{ $horarioDia->turma->codigo ?? 'N/A' }} - {{ $horarioDia->turma->nome ?? 'N/A' }}</strong>
                                                        <small class="text-muted">{{ $horarioDia->disciplina->nome ?? 'N/A' }}</small>
                                                    </div>
                                                @else
                                                    <span class="text-muted">-</span>
                                                @endif
                                            </td>
                                        @endforeach
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                @else
                    <div class="text-center py-5">
                        <i class="bi bi-calendar-x display-4 text-muted"></i>
                        <p class="text-muted mt-3">Nenhum horário atribuído</p>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection

