<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=yes">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <link rel="icon" type="image/x-icon" href="data:image/svg+xml,<svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 100 100'><text y='.9em' font-size='90'>📚</text></svg>">
    <title>@yield('title', 'SIGE - Sistema Integrado de Gestão Escolar')</title>
    
    @php
        // Verifica se o Vite está disponível (apenas em desenvolvimento)
        $viteAvailable = false;
        if (config('app.debug')) {
            $connection = @fsockopen('localhost', 5173, $errno, $errstr, 0.1);
            if ($connection) {
                fclose($connection);
                $viteAvailable = true;
            }
        }
        
        // Se Vite não estiver disponível, carrega assets compilados
        if (!$viteAvailable && file_exists(public_path('build/manifest.json'))) {
            $manifest = json_decode(file_get_contents(public_path('build/manifest.json')), true);
            $cssFile = $manifest['resources/css/app.css']['file'] ?? null;
            $jsFile = $manifest['resources/js/app.js']['file'] ?? null;
        }
    @endphp
    
    @if(!$viteAvailable && isset($cssFile) && isset($jsFile))
        {{-- Usa assets compilados --}}
        <link rel="stylesheet" href="{{ asset('build/' . $cssFile) }}">
        <script type="module" src="{{ asset('build/' . $jsFile) }}"></script>
    @else
        {{-- Usa Vite (desenvolvimento com hot reload) --}}
        @vite(['resources/css/app.css', 'resources/js/app.js'])
    @endif
    
    {{-- Bootstrap via CDN como fallback se não estiver disponível --}}
    <script>
        // Aguardar um pouco e verificar se Bootstrap foi carregado
        window.addEventListener('load', function() {
            setTimeout(function() {
                if (typeof window.bootstrap === 'undefined') {
                    // Silenciosamente carregar via CDN sem mensagens de console
                    const script = document.createElement('script');
                    script.src = 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js';
                    script.integrity = 'sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz';
                    script.crossOrigin = 'anonymous';
                    document.head.appendChild(script);
                }
            }, 500);
        });
    </script>
    
    <style>
        :root {
            --cor-principal: {{ \App\Models\Tema::getTemaAtivo()->cor_principal ?? '#6c757d' }};
            --cor-secundaria: {{ \App\Models\Tema::getTemaAtivo()->cor_secundaria ?? '#0d6efd' }};
        }
        
        .bg-primary-custom {
            background-color: var(--cor-principal) !important;
        }
        
        .text-primary-custom {
            color: var(--cor-principal) !important;
        }
        
        .btn-primary-custom {
            background-color: var(--cor-principal);
            border-color: var(--cor-principal);
        }
        
        .btn-primary-custom:hover {
            background-color: var(--cor-secundaria);
            border-color: var(--cor-secundaria);
        }
        
        /* Estilo para idioma Activo no dropdown */
        .dropdown-item.active {
            background-color: #e9ecef;
            font-weight: 500;
        }
        
        /* Sidebar - Estilo cinza do card de Disciplinas */
        .sidebar {
            background-color: #6b7280 !important;
            background: #6b7280 !important;
            background-image: linear-gradient(135deg, #6b7280 0%, #4b5563 100%) !important;
        }
    </style>
</head>
<body class="{{ auth()->check() ? 'auth-layout' : '' }}">
    @auth
        <!-- Menu Hambúrguer Mobile -->
        <button class="mobile-menu-toggle" id="mobileMenuToggle" type="button" aria-label="Menu">
            <i class="bi bi-list" id="mobileMenuIcon"></i>
        </button>
        
        <!-- Overlay para fechar sidebar no mobile -->
        <div class="sidebar-overlay" id="sidebarOverlay"></div>
        
        <!-- Sidebar -->
        <div class="sidebar" id="sidebar">
            <div class="sidebar-header">
                <h5 class="sidebar-title">SGE</h5>
                <button class="btn btn-link sidebar-toggle" id="sidebarToggle" type="button" title="Recolher menu">
                    <i class="bi bi-chevron-left" id="sidebarToggleIcon"></i>
                </button>
            </div>
            
            <nav class="sidebar-nav">
                <ul class="nav flex-column">
                    @if((auth()->user()->isAdmin() || auth()->user()->isSuperadmin()) && !auth()->user()->isFuncionario())
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('dashboard') ? 'active' : '' }}" href="{{ route('dashboard') }}">
                                <i class="bi bi-speedometer2"></i>
                                <span class="nav-text">{{ __('common.dashboard') }}</span>
                            </a>
                        </li>
                    @endif
                    
                    @if(auth()->user()->isSuperadmin())
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('superadmin.admins.*') ? 'active' : '' }}" href="{{ route('superadmin.admins.index') }}">
                                <i class="bi bi-shield-lock"></i>
                                <span class="nav-text">{{ __('common.superadmin') }}</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('superadmin.configuracoes.*') ? 'active' : '' }}" href="{{ route('superadmin.configuracoes') }}">
                                <i class="bi bi-gear"></i>
                                <span class="nav-text">{{ __('common.settings') }}</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('superadmin.configuracoes.cabecalho*') ? 'active' : '' }}" href="{{ route('superadmin.configuracoes.cabecalho') }}">
                                <i class="bi bi-file-text"></i>
                                <span class="nav-text">{{ __('common.header') }}</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('superadmin.manutencao*') ? 'active' : '' }}" href="{{ route('superadmin.manutencao') }}">
                                <i class="bi bi-tools"></i>
                                <span class="nav-text">Manutenção</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('superadmin.logs.*') ? 'active' : '' }}" href="{{ route('superadmin.logs.index') }}">
                                <i class="bi bi-journal-text"></i>
                                <span class="nav-text">Logs do Sistema</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('superadmin.backups.*') ? 'active' : '' }}" href="{{ route('superadmin.backups.index') }}">
                                <i class="bi bi-database"></i>
                                <span class="nav-text">Backups</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('superadmin.atividade-logins') ? 'active' : '' }}" href="{{ route('superadmin.atividade-logins') }}">
                                <i class="bi bi-activity"></i>
                                <span class="nav-text">Atividade / Logins</span>
                            </a>
                        </li>
                    @endif
                    
                    @if(auth()->user()->isAdmin() || auth()->user()->isSuperadmin())
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('admin.alunos.*') ? 'active' : '' }}" href="{{ route('admin.alunos.index') }}">
                                <i class="bi bi-people"></i>
                                <span class="nav-text">{{ __('common.students') }}</span>
                            </a>
                        </li>
                        
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('admin.professores.*') ? 'active' : '' }}" href="{{ route('admin.professores.index') }}">
                                <i class="bi bi-person-badge"></i>
                                <span class="nav-text">{{ __('common.teachers') }}</span>
                            </a>
                        </li>
                        
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('admin.turmas.*') ? 'active' : '' }}" href="{{ route('admin.turmas.index') }}">
                                <i class="bi bi-collection"></i>
                                <span class="nav-text">{{ __('common.classes') }}</span>
                            </a>
                        </li>
                        
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('admin.disciplinas.*') ? 'active' : '' }}" href="{{ route('admin.disciplinas.index') }}">
                                <i class="bi bi-book"></i>
                                <span class="nav-text">{{ __('common.subjects') }}</span>
                            </a>
                        </li>
                        
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('admin.funcionarios.*') ? 'active' : '' }}" href="{{ route('admin.funcionarios.index') }}">
                                <i class="bi bi-person-badge"></i>
                                <span class="nav-text">Administração</span>
                            </a>
                        </li>

                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('admin.funcionarios-servicos.*') ? 'active' : '' }}" href="{{ route('admin.funcionarios-servicos.index') }}">
                                <i class="bi bi-people"></i>
                                <span class="nav-text">Funcionários</span>
                            </a>
                        </li>
                        
                        @if((auth()->user()->isAdmin() || auth()->user()->isSuperadmin()))
                            @php
                                $pagamentosAtivo = request()->routeIs('admin.payments.*')
                                    || request()->routeIs('admin.professor-payments.*')
                                    || request()->routeIs('admin.funcionario-payments.*')
                                    || request()->routeIs('admin.administracao-payments.*');
                            @endphp
                            <li class="nav-item">
                                <a class="nav-link d-flex justify-content-between align-items-center {{ $pagamentosAtivo ? 'active' : '' }}"
                                   data-bs-toggle="collapse"
                                   href="#navPagamentos"
                                   role="button"
                                   aria-expanded="{{ $pagamentosAtivo ? 'true' : 'false' }}"
                                   aria-controls="navPagamentos">
                                    <span>
                                        <i class="bi bi-cash-stack"></i>
                                        <span class="nav-text">Pagamentos</span>
                                    </span>
                                    <i class="bi bi-chevron-down small"></i>
                                </a>
                                <div class="collapse {{ $pagamentosAtivo ? 'show' : '' }}" id="navPagamentos">
                                    <ul class="nav flex-column ms-3">
                                        <li class="nav-item">
                                            <a class="nav-link {{ request()->routeIs('admin.payments.*') ? 'active' : '' }}" href="{{ route('admin.payments.index') }}">
                                                <i class="bi bi-grid-3x3-gap"></i>
                                                <span class="nav-text">Dashboard</span>
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link {{ request()->routeIs('admin.professor-payments.*') ? 'active' : '' }}" href="{{ route('admin.professor-payments.index') }}">
                                                <i class="bi bi-cash-coin"></i>
                                                <span class="nav-text">Professores</span>
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link {{ request()->routeIs('admin.funcionario-payments.*') ? 'active' : '' }}" href="{{ route('admin.funcionario-payments.index') }}">
                                                <i class="bi bi-people"></i>
                                                <span class="nav-text">Funcionários</span>
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link {{ request()->routeIs('admin.administracao-payments.*') ? 'active' : '' }}" href="{{ route('admin.administracao-payments.index') }}">
                                                <i class="bi bi-person-badge"></i>
                                                <span class="nav-text">Administração</span>
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                            </li>
                        @endif
                    @elseif(auth()->user()->isFuncionario())
                        {{-- Menu para funcionários baseado em permissões --}}
                        @php
                            // Garantir que o relacionamento está carregado antes de verificar permissões
                            $user = auth()->user();
                            if (!$user->relationLoaded('funcionario')) {
                                $user->load('funcionario');
                            }
                        @endphp
                        @if($user->podeGerir('gerir_alunos'))
                            <li class="nav-item">
                                <a class="nav-link {{ request()->routeIs('admin.alunos.*') ? 'active' : '' }}" href="{{ route('admin.alunos.index') }}">
                                    <i class="bi bi-people"></i>
                                    <span class="nav-text">{{ __('common.students') }}</span>
                                </a>
                            </li>
                        @endif
                        
                        @if($user->podeGerir('gerir_professores'))
                            <li class="nav-item">
                                <a class="nav-link {{ request()->routeIs('admin.professores.*') ? 'active' : '' }}" href="{{ route('admin.professores.index') }}">
                                    <i class="bi bi-person-badge"></i>
                                    <span class="nav-text">{{ __('common.teachers') }}</span>
                                </a>
                            </li>
                        @endif
                        
                        @if($user->podeGerir('gerir_turmas'))
                            <li class="nav-item">
                                <a class="nav-link {{ request()->routeIs('admin.turmas.*') ? 'active' : '' }}" href="{{ route('admin.turmas.index') }}">
                                    <i class="bi bi-collection"></i>
                                    <span class="nav-text">{{ __('common.classes') }}</span>
                                </a>
                            </li>
                        @endif
                        
                        @if($user->podeGerir('gerir_pagamentos_professores'))
                            @php
                                $pagamentosAtivo = request()->routeIs('admin.payments.*') || request()->routeIs('admin.professor-payments.*');
                            @endphp
                            <li class="nav-item">
                                <a class="nav-link d-flex justify-content-between align-items-center {{ $pagamentosAtivo ? 'active' : '' }}"
                                   data-bs-toggle="collapse"
                                   href="#navPagamentosFuncionario"
                                   role="button"
                                   aria-expanded="{{ $pagamentosAtivo ? 'true' : 'false' }}"
                                   aria-controls="navPagamentosFuncionario">
                                    <span>
                                        <i class="bi bi-cash-stack"></i>
                                        <span class="nav-text">Pagamentos</span>
                                    </span>
                                    <i class="bi bi-chevron-down small"></i>
                                </a>
                                <div class="collapse {{ $pagamentosAtivo ? 'show' : '' }}" id="navPagamentosFuncionario">
                                    <ul class="nav flex-column ms-3">
                                        <li class="nav-item">
                                            <a class="nav-link {{ request()->routeIs('admin.payments.*') ? 'active' : '' }}" href="{{ route('admin.payments.index') }}">
                                                <i class="bi bi-grid-3x3-gap"></i>
                                                <span class="nav-text">Dashboard</span>
                                            </a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link {{ request()->routeIs('admin.professor-payments.*') ? 'active' : '' }}" href="{{ route('admin.professor-payments.index') }}">
                                                <i class="bi bi-cash-coin"></i>
                                                <span class="nav-text">Professores</span>
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                            </li>
                        @endif
                        
                        @if($user->podeGerir('gerir_disciplinas'))
                            <li class="nav-item">
                                <a class="nav-link {{ request()->routeIs('admin.disciplinas.*') ? 'active' : '' }}" href="{{ route('admin.disciplinas.index') }}">
                                    <i class="bi bi-book"></i>
                                    <span class="nav-text">{{ __('common.subjects') }}</span>
                                </a>
                            </li>
                        @endif
                        
                        @if($user->podeGerir('gerir_mensalidades'))
                            <li class="nav-item">
                                <a class="nav-link {{ request()->routeIs('financeiro.index') || request()->routeIs('financeiro.*') && !request()->routeIs('financeiro.relatorio') ? 'active' : '' }}" href="{{ route('financeiro.index') }}">
                                    <i class="bi bi-cash-coin"></i>
                                    <span class="nav-text">{{ __('common.monthly_fees') }}</span>
                                </a>
                            </li>
                        @endif
                        
                        @if($user->podeGerir('gerir_horarios'))
                            <li class="nav-item">
                                <a class="nav-link {{ request()->routeIs('horarios.*') ? 'active' : '' }}" href="{{ route('horarios.index') }}">
                                    <i class="bi bi-clock"></i>
                                    <span class="nav-text">{{ __('common.schedules') }}</span>
                                </a>
                            </li>
                        @endif
                        
                        @if($user->podeGerir('gerir_eventos'))
                            <li class="nav-item">
                                <a class="nav-link {{ request()->routeIs('eventos.*') ? 'active' : '' }}" href="{{ route('eventos.index') }}">
                                    <i class="bi bi-calendar-event"></i>
                                    <span class="nav-text">{{ __('common.events') }}</span>
                                </a>
                            </li>
                        @endif
                        
                        @if($user->podeGerir('gerir_planos'))
                            <li class="nav-item">
                                <a class="nav-link {{ request()->routeIs('trabalhos.index') ? 'active' : '' }}" href="{{ route('trabalhos.index') }}">
                                    <i class="bi bi-file-earmark-text"></i>
                                    <span class="nav-text">{{ __('common.plans') }}</span>
                                </a>
                            </li>
                        @endif
                        
                        @if($user->podeGerir('gerir_avaliacoes'))
                            <li class="nav-item">
                                <a class="nav-link {{ request()->routeIs('avaliacoes.*') ? 'active' : '' }}" href="{{ route('avaliacoes.index') }}">
                                    <i class="bi bi-clipboard-check"></i>
                                    <span class="nav-text">{{ __('common.evaluations') }}</span>
                                </a>
                            </li>
                        @endif
                        
                        @if($user->podeGerir('gerir_inscricoes'))
                            <li class="nav-item">
                                <a class="nav-link {{ request()->routeIs('admin.inscricoes.*') ? 'active' : '' }}" href="{{ route('admin.inscricoes.index') }}">
                                    <i class="bi bi-person-plus"></i>
                                    <span class="nav-text">{{ __('common.enrollments') }}</span>
                                </a>
                            </li>
                        @endif
                    @endif
                    
                    @if(auth()->user()->isProfessor())
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('professor.dashboard') ? 'active' : '' }}" href="{{ route('professor.dashboard') }}">
                                <i class="bi bi-speedometer2"></i>
                                <span class="nav-text">{{ __('common.dashboard') }}</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('avaliacoes.*') ? 'active' : '' }}" href="{{ route('avaliacoes.index') }}">
                                <i class="bi bi-clipboard-check"></i>
                                <span class="nav-text">{{ __('common.evaluations') }}</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('professor.tpcs.*') ? 'active' : '' }}" href="{{ route('professor.tpcs.index') }}">
                                <i class="bi bi-file-earmark-text"></i>
                                <span class="nav-text">{{ __('common.tpc') }}</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('professor.planos.*') ? 'active' : '' }}" href="{{ route('professor.planos.index') }}">
                                <i class="bi bi-calendar-check"></i>
                                <span class="nav-text">{{ __('common.quarterly_plans') }}</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('professor.horarios') ? 'active' : '' }}" href="{{ route('professor.horarios') }}">
                                <i class="bi bi-clock"></i>
                                <span class="nav-text">{{ __('common.my_schedules') }}</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('professor.turmas') ? 'active' : '' }}" href="{{ route('professor.turmas') }}">
                                <i class="bi bi-building"></i>
                                <span class="nav-text">{{ __('common.my_classes') }}</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('chat.*') ? 'active' : '' }}" href="{{ route('chat.index') }}">
                                <i class="bi bi-chat-dots"></i>
                                <span class="nav-text">Mensagens</span>
                            </a>
                        </li>
                    @elseif(auth()->user()->isAluno())
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('aluno.dashboard') ? 'active' : '' }}" href="{{ route('aluno.dashboard') }}">
                                <i class="bi bi-speedometer2"></i>
                                <span class="nav-text">{{ __('common.dashboard') }}</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('aluno.notas') || request()->routeIs('aluno.folheto-aproveitamento') ? 'active' : '' }}" href="{{ route('aluno.notas') }}">
                                <i class="bi bi-clipboard-check"></i>
                                <span class="nav-text">{{ __('common.my_grades') }}</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('aluno.horarios') ? 'active' : '' }}" href="{{ route('aluno.horarios') }}">
                                <i class="bi bi-calendar-week"></i>
                                <span class="nav-text">{{ __('common.my_schedules') }}</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('aluno.trabalhos') ? 'active' : '' }}" href="{{ route('aluno.trabalhos') }}">
                                <i class="bi bi-file-earmark-text"></i>
                                <span class="nav-text">{{ __('common.assignments') }}</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('aluno.eventos') ? 'active' : '' }}" href="{{ route('aluno.eventos') }}">
                                <i class="bi bi-calendar-event"></i>
                                <span class="nav-text">{{ __('common.events') }}</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('aluno.financeiro') ? 'active' : '' }}" href="{{ route('aluno.financeiro') }}">
                                <i class="bi bi-cash-coin"></i>
                                <span class="nav-text">{{ __('common.monthly_fees') }}</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('chat.*') ? 'active' : '' }}" href="{{ route('chat.index') }}">
                                <i class="bi bi-chat-dots"></i>
                                <span class="nav-text">Mensagens</span>
                            </a>
                        </li>
                    @elseif(!auth()->user()->isFuncionario())
                        {{-- Menu para Admin/Superadmin (não funcionários) --}}
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('avaliacoes.*') ? 'active' : '' }}" href="{{ route('avaliacoes.index') }}">
                                <i class="bi bi-clipboard-check"></i>
                                <span class="nav-text">{{ __('common.evaluations') }}</span>
                            </a>
                        </li>
                        
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('trabalhos.*') ? 'active' : '' }}" href="{{ route('trabalhos.index') }}">
                                <i class="bi bi-file-earmark-text"></i>
                                <span class="nav-text">{{ __('common.plans') }}</span>
                            </a>
                        </li>
                    @endif
                    
                    {{-- Menu geral para Admin/Superadmin (funcionários têm menu específico acima) --}}
                    @if((auth()->user()->isAdmin() || auth()->user()->isSuperadmin()) && !auth()->user()->isFuncionario())
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('horarios.*') ? 'active' : '' }}" href="{{ route('horarios.index') }}">
                                <i class="bi bi-calendar-week"></i>
                                <span class="nav-text">{{ __('common.schedules') }}</span>
                            </a>
                        </li>
                        
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('eventos.*') ? 'active' : '' }}" href="{{ route('eventos.index') }}">
                                <i class="bi bi-calendar-event"></i>
                                <span class="nav-text">{{ __('common.events') }}</span>
                            </a>
                        </li>
                        
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('financeiro.index') || request()->routeIs('financeiro.*') && !request()->routeIs('financeiro.relatorio') ? 'active' : '' }}" href="{{ route('financeiro.index') }}">
                                <i class="bi bi-cash-coin"></i>
                                <span class="nav-text">{{ __('common.monthly_fees') }}</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('financeiro.relatorio') ? 'active' : '' }}" href="{{ route('financeiro.relatorio') }}">
                                <i class="bi bi-graph-up"></i>
                                <span class="nav-text">{{ __('common.financial_report') }}</span>
                            </a>
                        </li>
                    @endif
                    
                    @if(auth()->user()->isAdmin() || auth()->user()->isSuperadmin())
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('admin.inscricoes.*') ? 'active' : '' }}" href="{{ route('admin.inscricoes.index') }}">
                                <i class="bi bi-person-check"></i>
                                <span class="nav-text">{{ __('common.enrollments') }}</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('admin.configuracoes.lancamento-notas*') ? 'active' : '' }}" href="{{ route('admin.configuracoes.lancamento-notas') }}">
                                <i class="bi bi-lock"></i>
                                <span class="nav-text">Controle de Notas</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('admin.atividade-logins') ? 'active' : '' }}" href="{{ route('admin.atividade-logins') }}">
                                <i class="bi bi-activity"></i>
                                <span class="nav-text">Atividade / Logins</span>
                            </a>
                        </li>
                    @endif
                    
                    @if((auth()->user()->isAdmin() || auth()->user()->isSuperadmin()) || (auth()->user()->isFuncionario() && auth()->user()->podeGerir('gerir_recuperacao_senha')))
                        <li class="nav-item">
                            <a class="nav-link {{ request()->routeIs('admin.password-reset.*') ? 'active' : '' }}" href="{{ route('admin.password-reset.index') }}">
                                <i class="bi bi-key-fill"></i>
                                <span class="nav-text">{{ __('common.password_reset') }}</span>
                            </a>
                        </li>
                    @endif
                    
                    {{-- Botão Sair --}}
                    <li class="nav-item mt-3 sidebar-logout">
                        <form action="{{ route('logout') }}" method="POST" class="d-inline w-100">
                            @csrf
                            <button type="submit" class="nav-link w-100 border-0 bg-transparent text-start">
                                <i class="bi bi-box-arrow-right"></i>
                                <span class="nav-text">{{ __('common.logout') }}</span>
                            </button>
                        </form>
                    </li>
                </ul>
            </nav>
            
        </div>
        
        <!-- Top Bar -->
        <div class="topbar">
            <div class="topbar-spacer"></div>
            <div class="topbar-title-wrapper d-flex align-items-center justify-content-center">
                <span class="topbar-title">{{ __('common.app_name') }}</span>
            </div>
            <div class="topbar-icons-wrapper d-flex align-items-center gap-1 gap-md-3">
                <!-- Notificações -->
                <div class="dropdown topbar-dropdown">
                    <button class="btn dropdown-toggle topbar-dropdown-btn position-relative" type="button" data-bs-toggle="dropdown" aria-expanded="false" id="notificationsDropdown" title="Notificações">
                        <i class="bi bi-bell"></i>
                        <span class="d-none d-md-inline ms-1">Notificações</span>
                        <span class="badge bg-danger rounded-pill position-absolute" id="notificationBadge" style="display: none; top: 2px; right: 2px; left: auto; transform: translate(50%, -50%);">0</span>
                    </button>
                    <ul class="dropdown-menu dropdown-menu-end" style="min-width: 350px; max-height: 400px; overflow-y: auto;" id="notificationsList">
                        <li class="dropdown-header">Carregando...</li>
                    </ul>
                </div>
                
                <!-- Chat -->
                <a href="{{ route('chat.index') }}" class="btn topbar-dropdown-btn position-relative" title="Mensagens" id="chatLink">
                    <i class="bi bi-chat-dots"></i>
                    <span class="d-none d-md-inline ms-1">Chat</span>
                    <span class="badge bg-danger rounded-pill position-absolute" id="chatBadge" style="display: none; top: 2px; right: 2px; left: auto; transform: translate(50%, -50%); font-size: 0.6rem; padding: 0.15em 0.4em;">0</span>
                </a>
                
                <div class="dropdown topbar-dropdown">
                    <button class="btn dropdown-toggle topbar-dropdown-btn" type="button" data-bs-toggle="dropdown" aria-expanded="false" title="Idioma">
                        <i class="bi bi-globe"></i> 
                        <span class="d-none d-md-inline ms-1">{{ __('common.language') }}</span>
                        <small class="d-md-none ms-1" style="font-size: 0.7rem;">{{ strtoupper(app()->getLocale()) }}</small>
                    </button>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li>
                            <a class="dropdown-item {{ app()->getLocale() === 'pt' ? 'active' : '' }}" href="{{ route('language.switch', 'pt') }}">
                                <i class="bi bi-check-circle {{ app()->getLocale() === 'pt' ? '' : 'd-none' }} me-2"></i>
                                {{ __('common.portuguese') }}
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item {{ app()->getLocale() === 'en' ? 'active' : '' }}" href="{{ route('language.switch', 'en') }}">
                                <i class="bi bi-check-circle {{ app()->getLocale() === 'en' ? '' : 'd-none' }} me-2"></i>
                                {{ __('common.english') }}
                            </a>
                        </li>
                    </ul>
                </div>
                <div class="dropdown topbar-dropdown">
                    <button class="btn dropdown-toggle topbar-dropdown-btn" type="button" data-bs-toggle="dropdown" aria-expanded="false" title="{{ auth()->user()->name }}">
                        <i class="bi bi-person-circle"></i> 
                        <span class="d-none d-md-inline ms-1">{{ auth()->user()->name }}</span>
                    </button>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li><a class="dropdown-item" href="{{ route('password.change') }}"><i class="bi bi-key me-2"></i> {{ __('common.change_password') }}</a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li>
                            <form action="{{ route('logout') }}" method="POST">
                                @csrf
                                <button type="submit" class="dropdown-item" style="color: #212529 !important; background: none; border: none; width: 100%; text-align: left; padding: 0.5rem 1rem; cursor: pointer;"><i class="bi bi-box-arrow-right me-2"></i> {{ __('common.logout') }}</button>
                            </form>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        
        <!-- Main Content -->
        <div class="main-content" id="mainContent">
            <div class="container-fluid">
                @if(session('success'))
                    <div class="alert alert-success alert-dismissible fade show auto-dismiss" role="alert" data-dismiss-time="3000">
                        <i class="bi bi-check-circle me-2"></i>{{ session('success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                @endif

                @if(session('error'))
                    <div class="alert alert-danger alert-dismissible fade show auto-dismiss" role="alert" data-dismiss-time="5000">
                        <i class="bi bi-exclamation-circle me-2"></i>{{ session('error') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                @endif

                @if(session('warning'))
                    <div class="alert alert-warning alert-dismissible fade show auto-dismiss" role="alert" data-dismiss-time="4000">
                        <i class="bi bi-exclamation-triangle me-2"></i>{{ session('warning') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                @endif

                @if($errors->any())
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <ul class="mb-0">
                            @foreach($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                @endif

                @yield('content')
            </div>
        </div>
        
        <!-- Modal para erros 403 -->
        <div class="modal fade" id="errorModal" tabindex="-1" aria-labelledby="errorModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header bg-danger text-white">
                        <h5 class="modal-title" id="errorModalLabel">
                            <i class="bi bi-exclamation-triangle-fill me-2"></i>
                            Acesso Negado
                        </h5>
                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <p id="errorModalMessage">Você não tem permissão para acessar este recurso.</p>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Fechar</button>
                        <a href="{{ route('dashboard') }}" class="btn btn-primary">Ir para Dashboard</a>
                    </div>
                </div>
            </div>
        </div>
        
        <script>
        // Função global para mostrar modal de erro (apenas quando explicitamente chamada)
        window.showErrorModal = function(message) {
            const modalElement = document.getElementById('errorModal');
            if (modalElement) {
                const modal = new bootstrap.Modal(modalElement);
                const messageElement = document.getElementById('errorModalMessage');
                if (messageElement) {
                    messageElement.textContent = message;
                }
                modal.show();
            }
        };
        </script>
    @endauth

    @guest
        <main class="container-fluid mt-4">
            @if(session('success'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    {{ session('success') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            @if(session('error'))
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    {{ session('error') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            @if(session('warning'))
                <div class="alert alert-warning alert-dismissible fade show" role="alert">
                    {{ session('warning') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            @if($errors->any())
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <ul class="mb-0">
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            @yield('content')
        </main>
    @endguest

    <!-- Bootstrap Icons e Bootstrap JS são carregados via Vite (app.css e app.js) -->
    
    @stack('scripts')
    
    <script>
        // Auto-dismiss alerts
        document.addEventListener('DOMContentLoaded', function() {
            const alerts = document.querySelectorAll('.auto-dismiss');
            alerts.forEach(function(alert) {
                const dismissTime = parseInt(alert.getAttribute('data-dismiss-time')) || 3000;
                setTimeout(function() {
                    const bsAlert = new bootstrap.Alert(alert);
                    bsAlert.close();
                }, dismissTime);
            });
        });

        // Sidebar Toggle e Mobile Menu
        document.addEventListener('DOMContentLoaded', function() {
            const sidebar = document.getElementById('sidebar');
            const mainContent = document.getElementById('mainContent');
            const topbar = document.querySelector('.topbar');
            const sidebarToggle = document.getElementById('sidebarToggle');
            const sidebarToggleIcon = document.getElementById('sidebarToggleIcon');
            const mobileMenuToggle = document.getElementById('mobileMenuToggle');
            const mobileMenuIcon = document.getElementById('mobileMenuIcon');
            const sidebarOverlay = document.getElementById('sidebarOverlay');
            
            // Verificar se é mobile
            let isMobile = window.innerWidth <= 768;
            
            // Garantir scroll horizontal no mobile
            // GARANTIR QUE BOTÕES SEJAM CLICÁVEIS NO MOBILE - VERSÃO ULTRA AGRESSIVA
            function fixMobileButtons() {
                if (window.innerWidth <= 768) {
                    // PRIMEIRO: Garantir que overlay não bloqueie
                    const overlay = document.getElementById('sidebarOverlay');
                    if (overlay && !overlay.classList.contains('active')) {
                        overlay.style.setProperty('pointer-events', 'none', 'important');
                        overlay.style.setProperty('display', 'none', 'important');
                    }
                    
                    // SEGUNDO: Encontrar TODOS os botões e elementos clicáveis
                    const buttons = document.querySelectorAll('.btn, button, a.btn, input[type="button"], input[type="submit"], .btn-link, .dropdown-toggle, a[onclick], [data-bs-toggle], [data-toggle], a[href]:not([href="#"]):not([href=""]):not([href="javascript:void(0)"])');
                    buttons.forEach(function(btn) {
                        // Pular o mobile-menu-toggle (já funciona)
                        if (btn.id === 'mobileMenuToggle' || btn.classList.contains('mobile-menu-toggle')) {
                            return;
                        }
                        
                        // FORÇAR propriedades de toque com z-index MUITO ALTO
                        btn.style.setProperty('pointer-events', 'auto', 'important');
                        btn.style.setProperty('touch-action', 'manipulation', 'important');
                        btn.style.setProperty('z-index', '10000', 'important');
                        btn.style.setProperty('position', 'relative', 'important');
                        btn.style.setProperty('min-height', '44px', 'important');
                        btn.style.setProperty('min-width', '44px', 'important');
                        btn.style.setProperty('-webkit-tap-highlight-color', 'rgba(0, 0, 0, 0.2)', 'important');
                        btn.style.setProperty('cursor', 'pointer', 'important');
                        
                        // Garantir que eventos de toque funcionem - não bloquear
                        btn.addEventListener('touchstart', function(e) {
                            // Não bloquear - permitir propagação normal
                        }, { passive: true, once: false });
                        
                        btn.addEventListener('touchend', function(e) {
                            // Não bloquear - permitir propagação normal
                        }, { passive: true, once: false });
                        
                        // Garantir que click também funcione
                        btn.addEventListener('click', function(e) {
                            // Não bloquear
                        }, { passive: true, once: false });
                    });
                    
                    // TERCEIRO: Remover pointer-events: none de elementos pais
                    const containers = document.querySelectorAll('.card, .card-body, .container, .container-fluid, .row, [class*="col-"], .main-content');
                    containers.forEach(function(container) {
                        const computed = getComputedStyle(container);
                        if (computed.pointerEvents === 'none') {
                            container.style.setProperty('pointer-events', 'auto', 'important');
                        }
                        // Garantir que não tenha z-index muito baixo
                        if (parseInt(computed.zIndex) < 0) {
                            container.style.setProperty('z-index', '1', 'important');
                        }
                    });
                }
            }
            
            // GARANTIR SCROLL HORIZONTAL EM TABELAS - VERSÃO ULTRA AGRESSIVA
            function fixTableScroll() {
                if (window.innerWidth <= 768) {
                    // Primeiro: garantir que html, body e main-content permitam scroll
                    document.documentElement.style.setProperty('overflow-x', 'auto', 'important');
                    document.documentElement.style.setProperty('touch-action', 'pan-x pan-y', 'important');
                    document.documentElement.style.setProperty('-webkit-overflow-scrolling', 'touch', 'important');
                    
                    document.body.style.setProperty('overflow-x', 'auto', 'important');
                    document.body.style.setProperty('touch-action', 'pan-x pan-y', 'important');
                    document.body.style.setProperty('-webkit-overflow-scrolling', 'touch', 'important');
                    
                    if (mainContent) {
                        mainContent.style.setProperty('overflow-x', 'auto', 'important');
                        mainContent.style.setProperty('touch-action', 'pan-x pan-y', 'important');
                        mainContent.style.setProperty('-webkit-overflow-scrolling', 'touch', 'important');
                        mainContent.style.setProperty('position', 'relative', 'important');
                        mainContent.style.setProperty('z-index', '10', 'important');
                    }
                    
                    // Garantir que container-fluid permita scroll
                    const containerFluid = document.querySelector('.main-content .container-fluid');
                    if (containerFluid) {
                        containerFluid.style.setProperty('overflow-x', 'auto', 'important');
                        containerFluid.style.setProperty('touch-action', 'pan-x pan-y', 'important');
                        containerFluid.style.setProperty('-webkit-overflow-scrolling', 'touch', 'important');
                    }
                    
                    // Encontrar TODAS as tabelas
                    const tables = document.querySelectorAll('table, .table, .horario-table');
                    tables.forEach(function(table) {
                        // Forçar largura mínima na tabela PRIMEIRO
                        table.style.setProperty('min-width', '600px', 'important');
                        table.style.setProperty('width', 'auto', 'important');
                        table.style.setProperty('display', 'table', 'important');
                        table.style.setProperty('table-layout', 'auto', 'important');
                        
                        // Células não quebram linha
                        const cells = table.querySelectorAll('td, th');
                        cells.forEach(function(cell) {
                            cell.style.setProperty('white-space', 'nowrap', 'important');
                            cell.style.setProperty('min-width', '80px', 'important');
                        });
                        
                        // Encontrar o container pai - verificar vários níveis
                        let container = table.closest('.table-responsive') || 
                                       table.closest('.horario-scroll-wrapper') ||
                                       table.closest('.border') || 
                                       table.closest('.border.rounded') ||
                                       table.closest('.card-body') || 
                                       table.closest('.card') ||
                                       table.closest('.container-fluid') ||
                                       table.closest('.container') ||
                                       table.parentElement;
                        
                        if (container) {
                            // FORÇAR scroll no container
                            container.style.setProperty('overflow-x', 'auto', 'important');
                            container.style.setProperty('overflow-y', 'visible', 'important');
                            container.style.setProperty('-webkit-overflow-scrolling', 'touch', 'important');
                            container.style.setProperty('touch-action', 'pan-x pan-y', 'important');
                            container.style.setProperty('width', '100%', 'important');
                            container.style.setProperty('max-width', '100vw', 'important');
                            container.style.setProperty('display', 'block', 'important');
                            container.style.setProperty('position', 'relative', 'important');
                            container.style.setProperty('-ms-overflow-style', '-ms-autohiding-scrollbar', 'important');
                            container.style.setProperty('scroll-behavior', 'smooth', 'important');
                            
                            // Se não tiver table-responsive, adicionar a classe ou comportamento
                            if (!container.classList.contains('table-responsive')) {
                                container.style.setProperty('overflow-x', 'auto', 'important');
                                // Tentar adicionar a classe se possível
                                if (container.tagName === 'DIV') {
                                    container.classList.add('table-responsive');
                                }
                            }
                            
                            // Verificar e corrigir containers pais também
                            let parent = container.parentElement;
                            let depth = 0;
                            while (parent && depth < 3) {
                                const computedStyle = window.getComputedStyle(parent);
                                if (computedStyle.overflowX === 'hidden' || computedStyle.overflowX === 'clip') {
                                    parent.style.setProperty('overflow-x', 'auto', 'important');
                                }
                                parent = parent.parentElement;
                                depth++;
                            }
                        }
                    });
                    
                    // Garantir que TODOS os .table-responsive tenham scroll
                    const tableResponsives = document.querySelectorAll('.table-responsive, .horario-scroll-wrapper, .table-wrapper');
                    tableResponsives.forEach(function(tr) {
                        tr.style.setProperty('overflow-x', 'auto', 'important');
                        tr.style.setProperty('overflow-y', 'visible', 'important');
                        tr.style.setProperty('-webkit-overflow-scrolling', 'touch', 'important');
                        tr.style.setProperty('touch-action', 'pan-x pan-y', 'important');
                        tr.style.setProperty('display', 'block', 'important');
                        tr.style.setProperty('width', '100%', 'important');
                        tr.style.setProperty('max-width', '100vw', 'important');
                        tr.style.setProperty('position', 'relative', 'important');
                        tr.style.setProperty('z-index', '5', 'important');
                        // Forçar scroll mesmo se houver conflitos
                        tr.style.setProperty('scroll-behavior', 'smooth', 'important');
                        });
                    
                    // Garantir que card-body com tabelas permita scroll
                    const cardBodies = document.querySelectorAll('.card-body');
                    cardBodies.forEach(function(cb) {
                        if (cb.querySelector('table') || cb.querySelector('.table') || cb.querySelector('.table-responsive')) {
                            cb.style.setProperty('overflow-x', 'auto', 'important');
                            cb.style.setProperty('-webkit-overflow-scrolling', 'touch', 'important');
                            cb.style.setProperty('touch-action', 'pan-x pan-y', 'important');
                            cb.style.setProperty('position', 'relative', 'important');
                        }
                    });
                    
                    // Garantir que cards com tabelas permitam scroll
                    const cards = document.querySelectorAll('.card');
                    cards.forEach(function(card) {
                        if (card.querySelector('table') || card.querySelector('.table') || card.querySelector('.table-responsive')) {
                            card.style.setProperty('overflow-x', 'auto', 'important');
                            card.style.setProperty('-webkit-overflow-scrolling', 'touch', 'important');
                            card.style.setProperty('touch-action', 'pan-x pan-y', 'important');
                        }
                    });
                    
                    // FORÇAR scroll em qualquer div que contenha uma tabela
                    const allDivs = document.querySelectorAll('div');
                    allDivs.forEach(function(div) {
                        const hasTable = div.querySelector('table') || div.querySelector('.table');
                        if (hasTable && !div.classList.contains('table-responsive') && !div.classList.contains('horario-scroll-wrapper')) {
                            const computed = getComputedStyle(div);
                            if (computed.overflowX === 'hidden' || computed.overflowX === 'clip' || computed.overflowX === 'visible') {
                                div.style.setProperty('overflow-x', 'auto', 'important');
                                div.style.setProperty('-webkit-overflow-scrolling', 'touch', 'important');
                                div.style.setProperty('touch-action', 'pan-x pan-y', 'important');
                            }
                        }
                    });
                }
            }
            
            function enableHorizontalScroll() {
                if (window.innerWidth <= 768) {
                    // Permitir scroll horizontal em todos os elementos necessários
                    document.documentElement.style.setProperty('overflow-x', 'auto', 'important');
                    document.documentElement.style.setProperty('touch-action', 'pan-x pan-y', 'important');
                    document.documentElement.style.setProperty('-webkit-overflow-scrolling', 'touch', 'important');
                    
                    document.body.style.setProperty('overflow-x', 'auto', 'important');
                    document.body.style.setProperty('touch-action', 'pan-x pan-y', 'important');
                    document.body.style.setProperty('-webkit-overflow-scrolling', 'touch', 'important');
                    
                    if (mainContent) {
                        mainContent.style.setProperty('overflow-x', 'auto', 'important');
                        mainContent.style.setProperty('touch-action', 'pan-x pan-y', 'important');
                        mainContent.style.setProperty('-webkit-overflow-scrolling', 'touch', 'important');
                    }
                    
                    // Garantir que tabelas possam ser roladas
                    const tableResponsives = document.querySelectorAll('.table-responsive, .border, .border.rounded, .card-body');
                    tableResponsives.forEach(function(el) {
                        el.style.setProperty('overflow-x', 'auto', 'important');
                        el.style.setProperty('touch-action', 'pan-x pan-y', 'important');
                        el.style.setProperty('-webkit-overflow-scrolling', 'touch', 'important');
                    });
                    
                    // Garantir que containers não bloqueiem
                    const containers = document.querySelectorAll('.container, .container-fluid, .row');
                    containers.forEach(function(container) {
                        if (getComputedStyle(container).overflowX === 'hidden') {
                            container.style.setProperty('overflow-x', 'visible', 'important');
                        }
                    });
                }
            }
            
            // Função para garantir que overlay não bloqueie
            function fixOverlay() {
                if (window.innerWidth <= 768) {
                    const overlay = document.getElementById('sidebarOverlay');
                    if (overlay) {
                        if (!overlay.classList.contains('active')) {
                            overlay.style.setProperty('pointer-events', 'none', 'important');
                            overlay.style.setProperty('display', 'none', 'important');
                        } else {
                            overlay.style.setProperty('pointer-events', 'auto', 'important');
                            overlay.style.setProperty('display', 'block', 'important');
                        }
                    }
                }
            }
            
            // Executar imediatamente e após carregamento
            if (sidebar) fixOverlay();
            enableHorizontalScroll();
            fixMobileButtons();
            fixTableScroll();
            
            // Executar múltiplas vezes para garantir
            setTimeout(function() {
                if (sidebar) fixOverlay();
                enableHorizontalScroll();
                fixMobileButtons();
                fixTableScroll();
            }, 100);
            
            setTimeout(function() {
                if (sidebar) fixOverlay();
                enableHorizontalScroll();
                fixMobileButtons();
                fixTableScroll();
            }, 500);
            
            window.addEventListener('load', function() {
                if (sidebar) fixOverlay();
                enableHorizontalScroll();
                fixMobileButtons();
                fixTableScroll();
                // Executar novamente após load
                setTimeout(function() {
                    if (sidebar) fixOverlay();
                    enableHorizontalScroll();
                    fixMobileButtons();
                    fixTableScroll();
                }, 200);
            });
            
            window.addEventListener('resize', function() {
                setTimeout(function() {
                    if (sidebar) fixOverlay();
                    enableHorizontalScroll();
                    fixMobileButtons();
                    fixTableScroll();
                }, 100);
            });
            
            // Verificar estado salvo (apenas desktop)
            if (!isMobile && sidebar && mainContent) {
                const sidebarCollapsed = localStorage.getItem('sidebarCollapsed') === 'true';
                if (sidebarCollapsed) {
                    sidebar.classList.add('collapsed');
                    mainContent.classList.add('expanded');
                    if (topbar) topbar.classList.add('expanded');
                    updateIcon(true);
                }
            }
            
            function updateIcon(isCollapsed) {
                if (sidebarToggleIcon) {
                    sidebarToggleIcon.className = isCollapsed ? 'bi bi-chevron-right' : 'bi bi-chevron-left';
                }
                if (sidebarToggle) {
                    sidebarToggle.title = isCollapsed ? 'Expandir menu' : 'Recolher menu';
                }
            }
            
            function closeMobileMenu() {
                if (!sidebar) return;
                sidebar.classList.remove('mobile-open');
                if (sidebarOverlay) {
                    sidebarOverlay.classList.remove('active');
                    // FORÇAR que overlay não bloqueie quando fechado
                    sidebarOverlay.style.setProperty('pointer-events', 'none', 'important');
                    sidebarOverlay.style.setProperty('display', 'none', 'important');
                }
                if (mobileMenuIcon) {
                    mobileMenuIcon.className = 'bi bi-list';
                }
            }
            
            function toggleSidebar() {
                if (!sidebar) return;
                if (isMobile) {
                    // Comportamento mobile: toggle overlay e sidebar
                    const isOpen = sidebar.classList.contains('mobile-open');
                    if (isOpen) {
                        closeMobileMenu();
                    } else {
                        sidebar.classList.add('mobile-open');
                        if (sidebarOverlay) {
                            sidebarOverlay.classList.add('active');
                            // Permitir que overlay bloqueie quando Activo
                            sidebarOverlay.style.setProperty('pointer-events', 'auto', 'important');
                            sidebarOverlay.style.setProperty('display', 'block', 'important');
                        }
                        if (mobileMenuIcon) {
                            mobileMenuIcon.className = 'bi bi-x-lg';
                        }
                    }
                } else {
                    // Comportamento desktop: collapse/expand
                    if (!mainContent) return;
                    sidebar.classList.toggle('collapsed');
                    mainContent.classList.toggle('expanded');
                    if (topbar) topbar.classList.toggle('expanded');
                    const isCollapsed = sidebar.classList.contains('collapsed');
                    localStorage.setItem('sidebarCollapsed', isCollapsed);
                    updateIcon(isCollapsed);
                }
            }
            
            // Fechar sidebar ao clicar no overlay (mobile)
            if (sidebarOverlay && sidebar) {
                sidebarOverlay.addEventListener('click', function() {
                    if (isMobile) {
                        closeMobileMenu();
                    }
                });
            }
            
            // Toggle sidebar (desktop)
            if (sidebarToggle && sidebar && mainContent) {
                sidebarToggle.addEventListener('click', function(e) {
                    e.stopPropagation();
                    if (!isMobile) {
                        toggleSidebar();
                    }
                });
            }
            
            // Toggle mobile menu
            if (mobileMenuToggle && sidebar) {
                mobileMenuToggle.addEventListener('click', function(e) {
                    e.stopPropagation();
                    toggleSidebar();
                });
            }
            
            // Fechar sidebar ao clicar em um link (mobile)
            if (isMobile && sidebar) {
                const navLinks = sidebar.querySelectorAll('.nav-link');
                if (navLinks && navLinks.length > 0) {
                navLinks.forEach(function(link) {
                    link.addEventListener('click', function() {
                        setTimeout(function() {
                            closeMobileMenu();
                        }, 300);
                    });
                });
                }
            }
            
            // Ajustar ao redimensionar janela
            let resizeTimer;
            window.addEventListener('resize', function() {
                clearTimeout(resizeTimer);
                resizeTimer = setTimeout(function() {
                    const newIsMobile = window.innerWidth <= 768;
                    if (newIsMobile !== isMobile) {
                        isMobile = newIsMobile;
                        // Fechar menu mobile se estiver aberto ao mudar para desktop
                        if (!isMobile) {
                            closeMobileMenu();
                        }
                    }
                    if (sidebar) fixOverlay();
                    enableHorizontalScroll();
                    fixMobileButtons();
                    fixTableScroll();
                }, 250);
            });
            
            // Garantir scroll horizontal após qualquer mudança - MÚLTIPLAS TENTATIVAS
            setTimeout(function() {
                if (sidebar) fixOverlay();
                enableHorizontalScroll();
                fixMobileButtons();
                fixTableScroll();
            }, 500);
            
            setTimeout(function() {
                if (sidebar) fixOverlay();
                enableHorizontalScroll();
                fixMobileButtons();
                fixTableScroll();
            }, 1000);
            
            setTimeout(function() {
                if (sidebar) fixOverlay();
                enableHorizontalScroll();
                fixMobileButtons();
                fixTableScroll();
            }, 2000);
            
            document.addEventListener('touchstart', function() {
                if (sidebar) fixOverlay();
                enableHorizontalScroll();
                fixMobileButtons();
                fixTableScroll();
            }, { passive: true });
            
            // Observar mudanças no DOM - executar correções quando houver mudanças
            const observer = new MutationObserver(function(mutations) {
                let shouldFix = false;
                mutations.forEach(function(mutation) {
                    if (mutation.addedNodes.length > 0) {
                        mutation.addedNodes.forEach(function(node) {
                            if (node.nodeType === 1) { // Element node
                                if (node.tagName === 'TABLE' || node.querySelector('table') || node.querySelector('.table')) {
                                    shouldFix = true;
                                }
                            }
                        });
                    }
                });
                if (shouldFix) {
                    setTimeout(function() {
                fixMobileButtons();
                fixTableScroll();
                    }, 100);
                }
            });
            observer.observe(document.body, { childList: true, subtree: true });
        });
        
        // Script adicional para garantir scroll horizontal
        (function() {
            function forceHorizontalScroll() {
                if (window.innerWidth <= 768) {
                    // Remover qualquer bloqueio de scroll
                    const style = document.createElement('style');
                    style.textContent = `
                        @media (max-width: 768px) {
                            * {
                                -webkit-overflow-scrolling: touch !important;
                            }
                            html, body {
                                overflow-x: auto !important;
                                touch-action: pan-x pan-y !important;
                            }
                            .main-content, .container-fluid, .row {
                                overflow-x: visible !important;
                                touch-action: pan-x pan-y !important;
                            }
                            .table-responsive {
                                overflow-x: auto !important;
                                -webkit-overflow-scrolling: touch !important;
                            }
                        }
                    `;
                    document.head.appendChild(style);
                }
            }
            
            if (document.readyState === 'loading') {
                document.addEventListener('DOMContentLoaded', forceHorizontalScroll);
            } else {
                forceHorizontalScroll();
            }
            
            window.addEventListener('load', forceHorizontalScroll);
            window.addEventListener('resize', forceHorizontalScroll);
        })();
    </script>
    
    {{-- Script para inicializar dropdowns do Bootstrap --}}
    <script>
        (function() {
            function initDropdowns() {
                // Verificar se Bootstrap está disponível
                if (typeof bootstrap !== 'undefined' && bootstrap.Dropdown) {
                    // Inicializar todos os dropdowns
                    var dropdownTriggers = document.querySelectorAll('[data-bs-toggle="dropdown"]');
                    dropdownTriggers.forEach(function(trigger) {
                        // Verificar se já foi inicializado
                        if (!bootstrap.Dropdown.getInstance(trigger)) {
                            new bootstrap.Dropdown(trigger);
                        }
                    });
                    console.log('Dropdowns inicializados:', dropdownTriggers.length);
                    return true;
                }
                return false;
            }
            
            // Tentar inicializar imediatamente
            if (!initDropdowns()) {
                // Se não funcionou, tentar após o DOM carregar
                document.addEventListener('DOMContentLoaded', function() {
                    if (!initDropdowns()) {
                        // Se ainda não funcionou, tentar após 500ms
                        setTimeout(initDropdowns, 500);
                        // E mais uma vez após 1s
                        setTimeout(initDropdowns, 1000);
                        // E após 2s como último recurso
                        setTimeout(initDropdowns, 2000);
                    }
                });
            }
            
            // Também tentar após o window load
            window.addEventListener('load', function() {
                setTimeout(initDropdowns, 100);
                setTimeout(initDropdowns, 500);
            });
            
            // Adicionar fallback com click handler manual
            document.addEventListener('click', function(e) {
                var dropdownBtn = e.target.closest('[data-bs-toggle="dropdown"]');
                if (dropdownBtn) {
                    var dropdownMenu = dropdownBtn.nextElementSibling;
                    if (dropdownMenu && dropdownMenu.classList.contains('dropdown-menu')) {
                        // Se Bootstrap não inicializou, fazer toggle manual
                        if (typeof bootstrap === 'undefined' || !bootstrap.Dropdown) {
                            e.preventDefault();
                            e.stopPropagation();
                            
                            // Fechar outros dropdowns abertos
                            document.querySelectorAll('.dropdown-menu.show').forEach(function(menu) {
                                if (menu !== dropdownMenu) {
                                    menu.classList.remove('show');
                                    menu.previousElementSibling.setAttribute('aria-expanded', 'false');
                                }
                            });
                            
                            // Toggle este dropdown
                            var isOpen = dropdownMenu.classList.contains('show');
                            dropdownMenu.classList.toggle('show');
                            dropdownBtn.setAttribute('aria-expanded', !isOpen);
                        }
                    }
                }
            });
            
            // Fechar dropdown ao clicar fora
            document.addEventListener('click', function(e) {
                if (!e.target.closest('.dropdown')) {
                    document.querySelectorAll('.dropdown-menu.show').forEach(function(menu) {
                        menu.classList.remove('show');
                        if (menu.previousElementSibling) {
                            menu.previousElementSibling.setAttribute('aria-expanded', 'false');
                        }
                    });
                }
            });
        })();
    </script>

    {{-- Paginação AJAX (progressive enhancement) --}}
    <script>
        (function() {
            function handleAjaxPaginationClick(event) {
                var link = event.target.closest('.js-ajax-pagination a.page-link');
                if (!link) {
                    return;
                }

                event.preventDefault();
                var container = link.closest('.js-ajax-pagination');
                if (!container) {
                    window.location.href = link.href;
                    return;
                }

                var useHeader = !container.hasAttribute('data-ajax-no-header');
                var fetchOptions = {};
                if (useHeader) {
                    fetchOptions.headers = { 'X-Requested-With': 'XMLHttpRequest' };
                }

                fetch(link.href, fetchOptions)
                .then(function(response) {
                    if (!response.ok) {
                        throw new Error('Falha ao carregar a página.');
                    }
                    return response.text();
                })
                .then(function(html) {
                    var parser = new DOMParser();
                    var doc = parser.parseFromString(html, 'text/html');
                    var newContainer = doc.querySelector('.js-ajax-pagination');
                    if (newContainer) {
                        container.replaceWith(newContainer);
                        window.history.pushState({}, '', link.href);
                        if (newContainer.hasAttribute('data-relatorio-dashboard')) {
                            if (window.initRelatorioFilters) {
                                window.initRelatorioFilters();
                            }
                            if (window.initRelatorioDashboard) {
                                window.initRelatorioDashboard();
                            }
                        }
                    } else {
                        window.location.href = link.href;
                    }
                })
                .catch(function() {
                    window.location.href = link.href;
                });
            }

            function handleAjaxFormSubmit(event) {
                var form = event.target.closest('.js-ajax-pagination form');
                if (!form) {
                    return;
                }

                if ((form.method || 'GET').toUpperCase() !== 'GET') {
                    return;
                }

                event.preventDefault();
                var container = form.closest('.js-ajax-pagination');
                if (!container) {
                    form.submit();
                    return;
                }

                var formData = new FormData(form);
                var url = new URL(form.action);
                formData.forEach(function(value, key) {
                    if (value !== null && value !== '') {
                        url.searchParams.set(key, value);
                    } else {
                        url.searchParams.delete(key);
                    }
                });

                var useHeader = !container.hasAttribute('data-ajax-no-header');
                var fetchOptions = {};
                if (useHeader) {
                    fetchOptions.headers = { 'X-Requested-With': 'XMLHttpRequest' };
                }

                fetch(url.toString(), fetchOptions)
                .then(function(response) {
                    if (!response.ok) {
                        throw new Error('Falha ao carregar a página.');
                    }
                    return response.text();
                })
                .then(function(html) {
                    var parser = new DOMParser();
                    var doc = parser.parseFromString(html, 'text/html');
                    var newContainer = doc.querySelector('.js-ajax-pagination');
                    if (newContainer) {
                        container.replaceWith(newContainer);
                        window.history.pushState({}, '', url.toString());
                    } else {
                        window.location.href = url.toString();
                    }
                })
                .catch(function() {
                    window.location.href = url.toString();
                });
            }

            document.addEventListener('click', handleAjaxPaginationClick);
            document.addEventListener('submit', handleAjaxFormSubmit);
        })();
    </script>

    {{-- Navegação AJAX (progressive enhancement) --}}
    <script>
        (function() {
            function shouldHandleLink(link) {
                if (!link) return false;
                if (link.hasAttribute('data-no-ajax')) return false;
                if (link.getAttribute('target')) return false;
                if (link.hasAttribute('download')) return false;
                var href = link.getAttribute('href') || '';
                if (!href || href.startsWith('#')) return false;
                if (href.startsWith('mailto:') || href.startsWith('tel:') || href.startsWith('javascript:')) return false;
                try {
                    var url = new URL(href, window.location.origin);
                    if (url.searchParams.has('pdf') || url.searchParams.has('download') || url.searchParams.has('export') || url.searchParams.has('imprimir')) {
                        return false;
                    }
                    var path = url.pathname.toLowerCase();
                    if (path.includes('/admin/alunos') || path.includes('/admin/professores')) return false;
                    if (path.includes('download') || path.includes('export') || path.includes('imprimir')) return false;
                    if (path.includes('login') || path.includes('logout') || path.includes('password')) return false;
                    if (path.includes('pagar') || path.includes('payment')) return false;
                    return url.origin === window.location.origin;
                } catch (e) {
                    return false;
                }
            }

            function setLoading(isLoading) {
                var mainContent = document.getElementById('mainContent');
                if (!mainContent) return;
                if (isLoading) {
                    mainContent.classList.add('ajax-loading');
                } else {
                    mainContent.classList.remove('ajax-loading');
                }
            }

            function updateActiveNav(href) {
                var navLinks = document.querySelectorAll('.sidebar .nav-link');
                navLinks.forEach(function(link) {
                    link.classList.toggle('active', link.href === href);
                });
            }

            function runAfterSwap() {
                var mainContainer = document.querySelector('#mainContent .container-fluid');
                if (mainContainer) {
                    executeScripts(mainContainer);
                    document.dispatchEvent(new Event('DOMContentLoaded'));
                    document.dispatchEvent(new Event('ajax:loaded'));
                }

                var alerts = document.querySelectorAll('.auto-dismiss');
                alerts.forEach(function(alert) {
                    var dismissTime = parseInt(alert.getAttribute('data-dismiss-time')) || 3000;
                    setTimeout(function() {
                        if (window.bootstrap && bootstrap.Alert) {
                            var bsAlert = new bootstrap.Alert(alert);
                            bsAlert.close();
                        }
                    }, dismissTime);
                });

                if (window.initTurmaCreateForm) {
                    window.initTurmaCreateForm();
                }
                if (window.initTurmaEditForm) {
                    window.initTurmaEditForm();
                }
                if (window.initAlunoCreateForm) {
                    window.initAlunoCreateForm();
                }
                if (window.initAlunoEditForm) {
                    window.initAlunoEditForm();
                }
                if (window.initProfessorCreateForm) {
                    window.initProfessorCreateForm();
                }
                if (window.initProfessorEditForm) {
                    window.initProfessorEditForm();
                }
                if (window.initRelatorioFilters) {
                    window.initRelatorioFilters();
                }
                if (window.initRelatorioDashboard) {
                    window.initRelatorioDashboard();
                }
            }

            function executeScripts(container) {
                window.__ajaxScriptCache = window.__ajaxScriptCache || new Set();
                var scripts = container.querySelectorAll('script');
                scripts.forEach(function(script) {
                    var newScript = document.createElement('script');
                    Array.from(script.attributes).forEach(function(attr) {
                        newScript.setAttribute(attr.name, attr.value);
                    });
                    if (script.src) {
                        var src = script.src;
                        if (window.__ajaxScriptCache.has(src) || document.querySelector('script[src="' + src + '"]')) {
                            script.parentNode.removeChild(script);
                            return;
                        }
                        window.__ajaxScriptCache.add(src);
                        newScript.src = src;
                        newScript.async = script.async;
                        newScript.defer = script.defer;
                    } else {
                        var content = script.textContent || '';
                        if (window.__ajaxScriptCache.has(content)) {
                            script.parentNode.removeChild(script);
                            return;
                        }
                        window.__ajaxScriptCache.add(content);
                        newScript.textContent = content;
                    }
                    script.parentNode.removeChild(script);
                    document.body.appendChild(newScript);
                });
            }

            function loadPage(href) {
                setLoading(true);
                fetch(href)
                    .then(function(response) {
                        if (!response.ok) {
                            throw new Error('Falha ao carregar a página.');
                        }
                        return response.text();
                    })
                    .then(function(html) {
                        var parser = new DOMParser();
                        var doc = parser.parseFromString(html, 'text/html');
                        var newContainer = doc.querySelector('#mainContent .container-fluid');
                        var currentContainer = document.querySelector('#mainContent .container-fluid');
                        if (newContainer && currentContainer) {
                            currentContainer.innerHTML = newContainer.innerHTML;
                            document.title = doc.title || document.title;
                            window.history.pushState({}, '', href);
                            updateActiveNav(href);
                            runAfterSwap();
                        } else {
                            window.location.href = href;
                        }
                    })
                    .catch(function() {
                        window.location.href = href;
                    })
                    .finally(function() {
                        setLoading(false);
                    });
            }

            function handleAjaxNavClick(event) {
                var link = event.target.closest('a');
                if (!shouldHandleLink(link)) return;
                if (event.metaKey || event.ctrlKey || event.shiftKey || event.altKey) return;
                event.preventDefault();
                loadPage(link.href);
            }

            window.addEventListener('popstate', function() {
                loadPage(window.location.href);
            });

            document.addEventListener('click', handleAjaxNavClick);
        })();
    </script>

    @auth
    <!-- Script para Notificações -->
    <script>
        (function() {
            let notificationErrorCount = 0;
            let notificationInterval = null;
            
            window.loadNotifications = function() {
                fetch('{{ route("notifications.unread") }}', {
                    headers: {
                        'X-Requested-With': 'XMLHttpRequest',
                        'Accept': 'application/json'
                    }
                })
                .then(response => {
                    // Se não autorizado (401) ou não encontrado (404), silenciar o erro
                    if (response.status === 401 || response.status === 404) {
                        const badge = document.getElementById('notificationBadge');
                        if (badge) badge.style.display = 'none';
                        return null;
                    }
                    
                    if (!response.ok) {
                        throw new Error(`HTTP error! status: ${response.status}`);
                    }
                    
                    return response.json();
                })
                .then(data => {
                    if (!data) return; // Retornar se foi 401/404
                    
                    notificationErrorCount = 0; // Reset contador de erros
                    
                    const badge = document.getElementById('notificationBadge');
                    const list = document.getElementById('notificationsList');
                    
                    if (!badge || !list) return;
                    
                    if (data.count > 0) {
                        badge.textContent = data.count;
                        badge.style.display = 'block';
                    } else {
                        badge.style.display = 'none';
                    }
                    
                    if (data.notifications && data.notifications.length > 0) {
                        list.innerHTML = '';
                        data.notifications.forEach(notif => {
                            const li = document.createElement('li');
                            li.className = 'dropdown-item-text';
                            li.style.cursor = 'pointer';
                            
                            const linkElement = notif.link ? `<a href="${notif.link}" class="btn btn-sm btn-link p-0 ms-2" onclick="markNotificationAsRead(${notif.id}, event)"><i class="bi bi-arrow-right"></i></a>` : '';
                            
                            li.innerHTML = `
                                <div class="d-flex justify-content-between align-items-start" onclick="markNotificationAsRead(${notif.id}, event)">
                                    <div class="flex-grow-1">
                                        <strong>${notif.title}</strong>
                                        <p class="mb-0 small">${notif.message}</p>
                                        <small class="text-muted">${new Date(notif.created_at).toLocaleString('pt-PT')}</small>
                                    </div>
                                    ${linkElement}
                                </div>
                            `;
                            list.appendChild(li);
                        });
                        const footer = document.createElement('li');
                        footer.innerHTML = '<hr class="dropdown-divider"><li><a class="dropdown-item text-center" href="{{ route("notifications.index") }}">Ver todas</a></li>';
                        list.appendChild(footer);
                    } else {
                        list.innerHTML = '<li class="dropdown-item-text text-center text-muted">Nenhuma notificação</li>';
                    }
                })
                .catch(error => {
                    notificationErrorCount++;
                    
                    // Silenciar erros de conexão após 3 tentativas
                    if (notificationErrorCount <= 3) {
                        // Apenas logar os primeiros erros para debug
                        if (notificationErrorCount === 1) {
                            // Silenciar - não logar erros esperados
                        }
                    } else {
                        // Parar de tentar após muitos erros
                        if (notificationInterval) {
                            clearInterval(notificationInterval);
                            notificationInterval = null;
                        }
                    }
                });
            }
            
            // Carregar notificações ao carregar a página
            window.loadNotifications();
            
            // Atualizar a cada 30 segundos
            notificationInterval = setInterval(window.loadNotifications, 30000);
        })();
        
        // Função para marcar notificação como lida (global)
        window.markNotificationAsRead = function(notificationId, event) {
            if (event) {
                event.stopPropagation();
            }
            
            fetch('{{ route("notifications.read", 0) }}'.replace('0', notificationId), {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}',
                    'X-Requested-With': 'XMLHttpRequest',
                    'Accept': 'application/json'
                }
            })
            .then(response => {
                if (!response.ok) {
                    throw new Error(`HTTP error! status: ${response.status}`);
                }
                return response.json();
            })
            .then(data => {
                if (data && data.success) {
                    // Atualizar contador imediatamente
                    const badge = document.getElementById('notificationBadge');
                    if (badge) {
                        const currentCount = parseInt(badge.textContent) || 0;
                        const newCount = Math.max(0, currentCount - 1);
                        if (newCount > 0) {
                            badge.textContent = newCount;
                            badge.style.display = 'block';
                        } else {
                            badge.style.display = 'none';
                        }
                    }
                    // Recarregar notificações para atualizar lista (se a função existir)
                    if (typeof window.loadNotifications === 'function') {
                        setTimeout(() => window.loadNotifications(), 500);
                    }
                }
            })
            .catch(error => {
                // Silenciar erros - não logar no console
            });
        };
        
        // Marcar todas as notificações como lidas ao clicar no dropdown
        document.getElementById('notificationsDropdown')?.addEventListener('click', function() {
            // Pequeno delay para garantir que o dropdown abriu
            setTimeout(() => {
                const list = document.getElementById('notificationsList');
                if (list && list.querySelectorAll('.dropdown-item-text').length > 0) {
                    // Não marcar automaticamente, apenas quando clicar
                }
            }, 100);
        });
        
        // Atualizar contador de mensagens não lidas
        (function() {
            let messageErrorCount = 0;
            let messageInterval = null;
            
            function loadUnreadMessages() {
                fetch('{{ route("chat.unread.count") }}', {
                    headers: {
                        'X-Requested-With': 'XMLHttpRequest',
                        'Accept': 'application/json'
                    }
                })
                .then(response => {
                    // Se não autorizado (401) ou não encontrado (404), silenciar o erro
                    if (response.status === 401 || response.status === 404) {
                        const badge = document.getElementById('chatBadge');
                        if (badge) badge.style.display = 'none';
                        return null;
                    }
                    
                    if (!response.ok) {
                        throw new Error(`HTTP error! status: ${response.status}`);
                    }
                    
                    return response.json();
                })
                .then(data => {
                    if (!data) return; // Retornar se foi 401/404
                    
                    messageErrorCount = 0; // Reset contador de erros
                    
                    const badge = document.getElementById('chatBadge');
                    if (badge) {
                        if (data.count > 0) {
                            badge.textContent = data.count > 99 ? '99+' : data.count;
                            badge.style.display = 'block';
                        } else {
                            badge.style.display = 'none';
                        }
                    }
                })
                .catch(error => {
                    messageErrorCount++;
                    
                    // Silenciar erros de conexão após 3 tentativas
                    if (messageErrorCount <= 3) {
                        // Apenas logar os primeiros erros para debug
                        if (messageErrorCount === 1) {
                            // Silenciar - não logar erros esperados
                        }
                    } else {
                        // Parar de tentar após muitos erros
                        if (messageInterval) {
                            clearInterval(messageInterval);
                            messageInterval = null;
                        }
                    }
                });
            }
            
            // Carregar mensagens não lidas ao carregar a página
            loadUnreadMessages();
            
            // Atualizar a cada 10 segundos
            messageInterval = setInterval(loadUnreadMessages, 10000);
        })();
    </script>
    @endauth
</body>
</html>
