@extends('layouts.app')

@section('title', 'Horários - SGE')

@section('content')
<style>
    .horario-cell {
        padding: 6px 4px;
        text-align: center;
        font-size: 0.75rem;
        vertical-align: middle;
        min-height: 60px;
        border: 1px solid #dee2e6;
        position: relative;
    }
    .horario-cell.empty {
        background-color: #ffffff;
    }
    .horario-header {
        background-color: #e9ecef;
        font-weight: 600;
        text-align: center;
        padding: 10px 6px;
        font-size: 0.85rem;
        border: 1px solid #dee2e6;
    }
    .horario-time {
        background-color: #f8f9fa;
        font-weight: 600;
        text-align: center;
        padding: 10px 6px;
        font-size: 0.85rem;
        width: 90px;
        border: 1px solid #dee2e6;
    }
    .disciplina-badge {
        display: block;
        padding: 3px 5px;
        border-radius: 3px;
        font-weight: 600;
        margin-bottom: 3px;
        font-size: 0.75rem;
    }
    .professor-name {
        font-size: 0.7rem;
        color: #495057;
        font-weight: 500;
        display: block;
        margin-top: 2px;
    }
    .horario-table {
        border-collapse: collapse;
        width: 100%;
    }
    .horario-table td, .horario-table th {
        border: 1px solid #dee2e6;
    }
    .toolbar-fixed {
        position: sticky;
        top: 0;
        z-index: 1000;
        background-color: #fff;
        padding: 12px 0;
        margin-bottom: 20px;
        border-bottom: 2px solid #dee2e6;
        box-shadow: 0 2px 8px rgba(0,0,0,0.15);
    }
    .toolbar-fixed.is-fixed {
        position: fixed;
        top: 0;
        left: 0;
        right: 0;
        margin: 0;
        padding: 12px 0;
        width: 100%;
        box-shadow: 0 2px 8px rgba(0,0,0,0.25);
    }
    .toolbar-placeholder {
        display: none;
    }
</style>

<div class="row">
    <div class="col-12">
        <div id="toolbarPlaceholder" class="toolbar-placeholder"></div>
        <div id="toolbarHorarios" class="toolbar-fixed">
            <div class="d-flex justify-content-between align-items-center" style="flex-wrap: wrap; gap: 10px;">
                <h5 class="mb-0" style="font-weight: 600;">Horários</h5>
                @if(auth()->user()->isAdmin() || auth()->user()->isSuperadmin() || auth()->user()->podeGerir('gerir_horarios'))
                    <div style="display: flex; gap: 8px; align-items: center; flex-wrap: wrap;">
                        <form method="GET" action="{{ route('horarios.index') }}" style="display: flex; gap: 8px; align-items: center;">
                            <select name="nivel_ensino" id="nivel_ensino" class="form-select form-select-sm" style="width: auto; min-width: 150px;">
                                <option value="">Todos os Níveis</option>
                                <option value="PRIMARIO" {{ ($nivelEnsinoFiltro ?? '') == 'PRIMARIO' ? 'selected' : '' }}>Primário</option>
                                <option value="SECUNDARIO" {{ ($nivelEnsinoFiltro ?? '') == 'SECUNDARIO' ? 'selected' : '' }}>Secundário</option>
                            </select>
                            <select name="turma_id" id="turma_id" class="form-select form-select-sm" style="width: auto; min-width: 200px;">
                                <option value="">Todas as Turmas</option>
                                @foreach($todasTurmas ?? [] as $turma)
                                    <option value="{{ $turma->id }}" {{ ($turmaFiltro ?? '') == $turma->id ? 'selected' : '' }}>
                                        {{ $turma->codigo }} - {{ $turma->nome }}
                                    </option>
                                @endforeach
                            </select>
                            <button type="submit" class="btn btn-sm btn-primary">
                                <i class="bi bi-search"></i> Filtrar
                            </button>
                            @if($turmaFiltro || ($nivelEnsinoFiltro ?? ''))
                                <a href="{{ route('horarios.index') }}" class="btn btn-sm btn-secondary">
                                    <i class="bi bi-x-circle"></i> Limpar
                                </a>
                            @endif
                        </form>
                        <a href="{{ route('horarios.download-pdf', ['turma_id' => $turmaFiltro]) }}" class="btn btn-sm btn-danger">
                            <i class="bi bi-file-earmark-pdf"></i> Download PDF
                        </a>
                        <a href="{{ route('horarios.gerar-automatico') }}" class="btn btn-sm btn-success">
                            <i class="bi bi-magic"></i> Gerar Automaticamente
                        </a>
                        <a href="{{ route('horarios.gerar-todas-turmas') }}" class="btn btn-sm btn-info">
                            <i class="bi bi-calendar-check"></i> Gerar Todas as Turmas
                        </a>
                    </div>
                @endif
            </div>
        </div>

<script>
document.addEventListener('DOMContentLoaded', () => {
    const toolbar = document.getElementById('toolbarHorarios');
    const placeholder = document.getElementById('toolbarPlaceholder');
    if (!toolbar || !placeholder) return;

    const updateFixed = () => {
        const rect = toolbar.getBoundingClientRect();
        const initialTop = parseFloat(toolbar.dataset.initialTop || '0');
        const initialLeft = parseFloat(toolbar.dataset.initialLeft || '0');
        const initialWidth = parseFloat(toolbar.dataset.initialWidth || '0');

        const offsetTop = initialTop || (rect.top + window.scrollY);
        const shouldFix = window.scrollY >= offsetTop;

        if (shouldFix) {
            toolbar.classList.add('is-fixed');
            toolbar.style.left = `${initialLeft}px`;
            toolbar.style.width = `${initialWidth}px`;
            toolbar.style.right = 'auto';
            placeholder.style.display = 'block';
            placeholder.style.height = `${toolbar.offsetHeight}px`;
        } else {
            toolbar.classList.remove('is-fixed');
            toolbar.style.left = '';
            toolbar.style.width = '';
            toolbar.style.right = '';
            placeholder.style.display = 'none';
            placeholder.style.height = '0px';
        }
    };

    const storeInitial = () => {
        const rect = toolbar.getBoundingClientRect();
        toolbar.dataset.initialTop = rect.top + window.scrollY;
        toolbar.dataset.initialLeft = rect.left + window.scrollX;
        toolbar.dataset.initialWidth = rect.width;
        placeholder.style.height = `${toolbar.offsetHeight}px`;
    };

    // Guardar offset inicial
    storeInitial();

    window.addEventListener('scroll', updateFixed, { passive: true });
    window.addEventListener('resize', () => {
        storeInitial();
        updateFixed();
    });

    updateFixed();
});
</script>
        @if(isset($grades) && count($grades) > 0)
            <div class="js-ajax-pagination">
            @foreach($grades as $turmaId => $data)
                @php
                    $turma = $data['turma'];
                    $grade = $data['grade'];
                    $horarios = $data['horarios'];
                    $diasAbreviados = ['Segunda' => 'Seg', 'Terça' => 'Ter', 'Quarta' => 'Qua', 'Quinta' => 'Qui', 'Sexta' => 'Sex'];
                    
                    // Cores para disciplinas (gerar baseado no nome)
                    $coresDisciplinas = [];
                    $disciplinasUnicas = [];
                    foreach ($grade as $hora => $dias) {
                        foreach ($dias as $dia => $horario) {
                            if ($horario && $horario->disciplina) {
                                $disciplinasUnicas[$horario->disciplina->id] = $horario->disciplina->nome;
                            }
                        }
                    }
                    $paletaCores = [
                        '#d4edda', '#fff3cd', '#d1ecf1', '#f8d7da', 
                        '#e2e3e5', '#d4edda', '#cce5ff', '#ffe6cc',
                        '#e6f3ff', '#ffe6f0', '#f0e6ff', '#fff0e6'
                    ];
                    $corIndex = 0;
                    foreach ($disciplinasUnicas as $id => $nome) {
                        $coresDisciplinas[$id] = $paletaCores[$corIndex % count($paletaCores)];
                        $corIndex++;
                    }
                @endphp
                
                <div style="background: #fff; padding: 15px; border-radius: 4px; margin-bottom: 20px; box-shadow: 0 1px 3px rgba(0,0,0,0.1);">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <h6 style="font-weight: 600; margin-bottom: 0; font-size: 0.95rem; color: #495057;">
                            Sala: {{ $turma->codigo ?? '' }} - {{ $turma->nome ?? 'Turma #' . $turmaId }}
                        </h6>
                        @if(auth()->user()->isAdmin() || auth()->user()->isSuperadmin() || auth()->user()->podeGerir('gerir_horarios'))
                            <form action="{{ route('horarios.destroy-all') }}" method="POST" class="d-inline"
                                  onsubmit="return confirm('Tem certeza que deseja eliminar TODOS os horários desta turma? Esta acção não pode ser desfeita.');">
                                @csrf
                                @method('DELETE')
                                <input type="hidden" name="turma_id" value="{{ $turma->id }}">
                                <input type="hidden" name="ano_letivo_id" value="{{ $anoLetivo->id }}">
                                <button type="submit" class="btn btn-sm" style="padding: 4px 8px; font-size: 0.75rem; background: #f8d7da; color: #721c24; border: none;" title="Eliminar todos os horários">
                                    <i class="bi bi-trash"></i> Eliminar Todos
                                </button>
                            </form>
                        @endif
                    </div>
                    
                    <div class="table-responsive">
                        <table class="horario-table">
                            <thead>
                                <tr>
                                    <th class="horario-time">Horário</th>
                                    @foreach($diasSemana as $dia)
                                        <th class="horario-header">{{ $diasAbreviados[$dia] }}</th>
                                    @endforeach
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($horarios as $horarioInfo)
                                    @php
                                        $horaInicio = $horarioInfo['inicio'];
                                        $isIntervalo = isset($horarioInfo['tipo']) && $horarioInfo['tipo'] === 'intervalo';
                                    @endphp
                                    <tr>
                                        <td class="horario-time" style="{{ $isIntervalo ? 'background-color: #fff3cd; color: #856404;' : '' }}">
                                            {{ $horarioInfo['display'] }}
                                        </td>
                                        @if($isIntervalo)
                                            <td colspan="{{ count($diasSemana) }}" class="horario-cell" style="background-color: #fff3cd; text-align: center; font-weight: 600; color: #856404;">
                                                Intervalo para Lanche
                                            </td>
                                        @else
                                            @foreach($diasSemana as $dia)
                                                @php
                                                    $horario = $grade[$horaInicio][$dia] ?? null;
                                                    $corFundo = $horario && $horario->disciplina ? ($coresDisciplinas[$horario->disciplina->id] ?? '#ffffff') : '#ffffff';
                                                @endphp
                                                <td class="horario-cell {{ !$horario ? 'empty' : '' }}" 
                                                    style="background-color: {{ $corFundo }};">
                                                    @if($horario)
                                                        <span class="disciplina-badge" style="background-color: rgba(255,255,255,0.85); color: #212529;">
                                                            {{ $horario->disciplina->nome }}
                                                        </span>
                                                        <span class="professor-name">
                                                            {{ $horario->professor->user->name }}
                                                        </span>
                                                        @if(auth()->user()->isAdmin() || auth()->user()->isSuperadmin() || auth()->user()->podeGerir('gerir_horarios'))
                                                            <div style="margin-top: 4px; display: flex; gap: 3px; justify-content: center;">
                                                                <a href="{{ route('horarios.edit', $horario) }}" class="btn btn-sm" style="padding: 1px 4px; font-size: 0.65rem; background: #fff3cd; color: #856404; border: none;" title="Editar">
                                                                    <i class="bi bi-pencil"></i>
                                                                </a>
                                                                <form action="{{ route('horarios.destroy', $horario) }}" method="POST" class="d-inline"
                                                                      onsubmit="return confirm('Tem certeza que deseja eliminar este horário?');">
                                                                    @csrf
                                                                    @method('DELETE')
                                                                    <button type="submit" class="btn btn-sm" style="padding: 1px 4px; font-size: 0.65rem; background: #f8d7da; color: #721c24; border: none;" title="Eliminar">
                                                                        <i class="bi bi-trash"></i>
                                                                    </button>
                                                                </form>
                                                            </div>
                                                        @endif
                                                    @else
                                                        <span style="color: #adb5bd; font-size: 0.9rem;">-</span>
                                                    @endif
                                                </td>
                                            @endforeach
                                        @endif
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            @endforeach
            
            @if(method_exists($turmasComHorarios, 'links'))
                <div class="mt-3">
                    {{ $turmasComHorarios->appends(request()->query())->links() }}
                </div>
            @endif
            </div>
        @else
            <div style="background: #f8f9fa; padding: 20px; border-radius: 4px; text-align: center; font-size: 0.85rem;">
                Nenhum horário registrado
            </div>
        @endif
    </div>
</div>
@endsection
