@extends('layouts.app')

@section('title', 'Editar Horário - SGE')

@section('content')
<div class="row">
    <div class="col-md-8">
        <div class="d-flex justify-content-between align-items-center mb-2" style="border-bottom: 1px solid #dee2e6; padding-bottom: 8px;">
            <h5 class="mb-0" style="font-weight: 600;">Editar Horário</h5>
            <a href="{{ route('horarios.index') }}" class="btn btn-sm btn-secondary">
                <i class="bi bi-arrow-left"></i> Voltar
            </a>
        </div>
        
        <div style="background: #f8f9fa; padding: 15px; border-radius: 4px;">
            <form method="POST" action="{{ route('horarios.update', $horario) }}">
                @csrf
                @method('PUT')

                <div class="mb-2">
                    <label for="turma_id" class="form-label" style="font-size: 0.85rem; margin-bottom: 3px;">Turma <span class="text-danger">*</span></label>
                    <select class="form-select form-select-sm @error('turma_id') is-invalid @enderror" 
                            id="turma_id" name="turma_id" required>
                        <option value="">Selecione</option>
                        @foreach($turmas as $turma)
                            <option value="{{ $turma->id }}" {{ old('turma_id', $horario->turma_id) == $turma->id ? 'selected' : '' }}>
                                {{ $turma->codigo }} - {{ $turma->nome }}
                            </option>
                        @endforeach
                    </select>
                    @error('turma_id')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="mb-2">
                    <label for="disciplina_id" class="form-label" style="font-size: 0.85rem; margin-bottom: 3px;">Disciplina <span class="text-danger">*</span></label>
                    <select class="form-select form-select-sm @error('disciplina_id') is-invalid @enderror" 
                            id="disciplina_id" name="disciplina_id" required>
                        <option value="">Selecione</option>
                        @foreach($disciplinas as $disciplina)
                            <option value="{{ $disciplina->id }}" {{ old('disciplina_id', $horario->disciplina_id) == $disciplina->id ? 'selected' : '' }}>
                                {{ $disciplina->nome }}
                            </option>
                        @endforeach
                    </select>
                    @error('disciplina_id')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="mb-2">
                    <label for="professor_id" class="form-label" style="font-size: 0.85rem; margin-bottom: 3px;">Professor <span class="text-danger">*</span></label>
                    <select class="form-select form-select-sm @error('professor_id') is-invalid @enderror" 
                            id="professor_id" name="professor_id" required>
                        <option value="">Selecione</option>
                        @foreach($professores as $professor)
                            <option value="{{ $professor->id }}" {{ old('professor_id', $horario->professor_id) == $professor->id ? 'selected' : '' }}>
                                {{ $professor->user->name }}
                            </option>
                        @endforeach
                    </select>
                    @error('professor_id')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="row">
                    <div class="col-md-6 mb-2">
                        <label for="dia_semana" class="form-label" style="font-size: 0.85rem; margin-bottom: 3px;">Dia da Semana <span class="text-danger">*</span></label>
                        <select class="form-select form-select-sm @error('dia_semana') is-invalid @enderror" 
                                id="dia_semana" name="dia_semana" required>
                            <option value="Segunda" {{ old('dia_semana', $horario->dia_semana) == 'Segunda' ? 'selected' : '' }}>Segunda-feira</option>
                            <option value="Terça" {{ old('dia_semana', $horario->dia_semana) == 'Terça' ? 'selected' : '' }}>Terça-feira</option>
                            <option value="Quarta" {{ old('dia_semana', $horario->dia_semana) == 'Quarta' ? 'selected' : '' }}>Quarta-feira</option>
                            <option value="Quinta" {{ old('dia_semana', $horario->dia_semana) == 'Quinta' ? 'selected' : '' }}>Quinta-feira</option>
                            <option value="Sexta" {{ old('dia_semana', $horario->dia_semana) == 'Sexta' ? 'selected' : '' }}>Sexta-feira</option>
                        </select>
                        @error('dia_semana')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="col-md-6 mb-2">
                        <label for="sala" class="form-label" style="font-size: 0.85rem; margin-bottom: 3px;">Sala</label>
                        <input type="text" class="form-control form-control-sm @error('sala') is-invalid @enderror" 
                               id="sala" name="sala" value="{{ old('sala', $horario->sala) }}">
                        @error('sala')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6 mb-2">
                        <label for="hora_inicio" class="form-label" style="font-size: 0.85rem; margin-bottom: 3px;">Hora de Início <span class="text-danger">*</span></label>
                        <input type="time" class="form-control form-control-sm @error('hora_inicio') is-invalid @enderror" 
                               id="hora_inicio" name="hora_inicio" value="{{ old('hora_inicio', $horario->hora_inicio ? \Carbon\Carbon::parse($horario->hora_inicio)->format('H:i') : '') }}" required>
                        @error('hora_inicio')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="col-md-6 mb-2">
                        <label for="hora_fim" class="form-label" style="font-size: 0.85rem; margin-bottom: 3px;">Hora de Fim <span class="text-danger">*</span></label>
                        <input type="time" class="form-control form-control-sm @error('hora_fim') is-invalid @enderror" 
                               id="hora_fim" name="hora_fim" value="{{ old('hora_fim', $horario->hora_fim ? \Carbon\Carbon::parse($horario->hora_fim)->format('H:i') : '') }}" required>
                        @error('hora_fim')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>

                <input type="hidden" name="ano_letivo_id" value="{{ $anoLetivo->id }}">

                <div class="mt-2">
                    <button type="submit" class="btn btn-sm btn-primary">Atualizar Horário</button>
                    <a href="{{ route('horarios.index') }}" class="btn btn-sm btn-secondary">Cancelar</a>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

