@extends('layouts.app')

@section('title', 'Pagamento Registrado - SIGE')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h5 class="mb-0">Pagamento Registrado</h5>
            <div class="d-flex gap-2">
                <a href="{{ route('financeiro.factura.download', $invoice) }}" class="btn btn-sm btn-primary">
                    <i class="bi bi-download"></i> PDF
                </a>
                <button onclick="window.print()" class="btn btn-sm btn-outline-primary">
                    <i class="bi bi-printer"></i>
                </button>
                <a href="{{ route('financeiro.index') }}" class="btn btn-sm btn-secondary">
                    <i class="bi bi-arrow-left"></i> Voltar
                </a>
            </div>
        </div>
    </div>
</div>

<div class="border rounded p-3 mb-3">
    <div class="row mb-3">
        <div class="col-md-6">
            @if(isset($logotipoUrl) && $logotipoUrl)
                <img src="{{ $logotipoUrl }}" alt="Logotipo" style="max-height: 60px; margin-bottom: 8px;">
            @endif
            <div class="small text-muted">{{ \App\Models\Configuracao::get('escola', 'ESCOLA PRIMARIA E COMPLETA SGE') }}</div>
        </div>
        <div class="col-md-6 text-end">
            <div class="fw-bold mb-1">FACTURA Nº {{ $invoice->numero_factura }}</div>
            <div class="small text-muted">{{ $invoice->data_emissao->format('d/m/Y') }}</div>
            <span class="badge bg-{{ $invoice->status === 'PAGA' ? 'success' : 'warning' }}">
                {{ $invoice->status === 'PAGA' ? 'Paga' : 'Pendente' }}
            </span>
        </div>
    </div>

    <hr class="my-2">

    <div class="mb-2 small">
        <strong>Aluno:</strong> {{ $invoice->aluno->user->name }}<br>
        <strong>Código:</strong> {{ $invoice->aluno->codigo_estudante }}
    </div>

    <hr class="my-2">

    <div class="table-responsive">
        <table class="table table-sm table-bordered mb-0">
            <thead>
                <tr>
                    <th>Descrição</th>
                    <th class="text-end" style="width: 120px;">Valor</th>
                </tr>
            </thead>
            <tbody>
                @if($invoice->itens)
                    @foreach($invoice->itens as $item)
                        <tr>
                            <td>{{ $item['descricao'] ?? 'Mensalidade' }}</td>
                            <td class="text-end">{{ number_format($item['valor'] ?? $invoice->valor, 0, ',', '.') }} MT</td>
                        </tr>
                    @endforeach
                @else
                    <tr>
                        <td>{{ $invoice->descricao ?? 'Mensalidade' }}</td>
                        <td class="text-end">{{ number_format($invoice->valor, 0, ',', '.') }} MT</td>
                    </tr>
                @endif
            </tbody>
            <tfoot>
                <tr>
                    <th class="text-end">Total</th>
                    <th class="text-end">{{ number_format($invoice->valor, 0, ',', '.') }} MT</th>
                </tr>
            </tfoot>
        </table>
    </div>

    @if($invoice->payment)
        <div class="mt-3 pt-2 border-top small">
            <strong>Pagamento:</strong> {{ $invoice->payment->metodo === 'MPESA' ? 'M-Pesa' : ($invoice->payment->metodo === 'EMOLA' ? 'Emola' : 'Presencial') }}<br>
            <strong>Referência:</strong> {{ $invoice->payment->reference }}<br>
            @if($invoice->payment->data_pagamento)
                <strong>Data:</strong> {{ $invoice->payment->data_pagamento->format('d/m/Y H:i') }}
            @endif
        </div>
    @endif

    @if($invoice->codigo_verificacao)
        <div class="mt-2 pt-2 border-top text-center small">
            <span class="text-muted">Código:</span> <span class="badge bg-secondary">{{ $invoice->codigo_verificacao }}</span>
        </div>
    @endif
</div>

<style>
    @media print {
        .btn, .d-flex.justify-content-between {
            display: none !important;
        }
        .border {
            border: 1px solid #000 !important;
        }
    }
</style>
@endsection
