@extends('layouts.app')

@section('title', 'Mensalidades - SIGE')

@section('content')
@if(auth()->user()->isAluno())
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h5 class="mb-0">Mensalidades</h5>
            </div>

            <!-- Filtro por Ano Letivo -->
            @if(isset($anosLetivos) && $anosLetivos->count() > 0)
                <div class="card mb-3">
                    <div class="card-body p-2">
                        <form method="GET" action="{{ route('financeiro.index') }}" class="row g-2">
                            <div class="col-md-4">
                                <label for="ano_letivo_id" class="form-label small mb-0">Ano Lectivo</label>
                                <select class="form-select form-select-sm" id="ano_letivo_id" name="ano_letivo_id" onchange="this.form.submit()">
                                    @foreach($anosLetivos ?? [] as $ano)
                                        @php
                                            $anoFinal = strpos($ano->ano, '/') !== false ? explode('/', $ano->ano)[1] : $ano->ano;
                                        @endphp
                                        <option value="{{ $ano->id }}" {{ isset($anoLetivoId) && $anoLetivoId == $ano->id ? 'selected' : '' }}>
                                            {{ $anoFinal }}
                                            @if($ano->ativo) (Activo) @endif
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </form>
                    </div>
                </div>
            @endif

            <div class="alert alert-{{ $situacao === 'REGULAR' ? 'success' : 'warning' }}">
                <strong>Situação Financeira:</strong> {{ $situacao }}
            </div>

            <div class="table-responsive">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>Tipo</th>
                            <th>Descrição</th>
                            <th>Valor</th>
                            <th>Vencimento</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($financeiro ?? [] as $item)
                            <tr>
                                <td>{{ $item->tipo }}</td>
                                <td>{{ $item->descricao }}</td>
                                <td>{{ number_format($item->valor, 2, ',', '.') }} MT</td>
                                <td>{{ $item->data_vencimento->format('d/m/Y') }}</td>
                                <td>
                                    <span class="badge bg-{{ $item->status === 'PAGO' ? 'success' : ($item->status === 'VENCIDO' ? 'danger' : 'warning') }}">
                                        {{ $item->status }}
                                    </span>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="text-center">Nenhum registro financeiro</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@elseif(auth()->user()->isAdmin() || auth()->user()->isSuperadmin() || auth()->user()->podeGerir('gerir_mensalidades'))
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h5 class="mb-0">Mensalidades</h5>
            </div>

            <!-- Filtros -->
            <div class="card mb-3">
                <div class="card-body p-2">
                    <form method="GET" action="{{ route('financeiro.index') }}" class="row g-2">
                        <div class="col-md-2">
                            <label for="ano_letivo_id" class="form-label small mb-0">Ano Lectivo</label>
                            <select class="form-select form-select-sm" id="ano_letivo_id" name="ano_letivo_id" onchange="this.form.submit()">
                                <option value="">Selecione o Ano Lectivo</option>
                                @foreach($anosLetivos ?? [] as $ano)
                                    <option value="{{ $ano->id }}" {{ isset($anoLetivoId) && $anoLetivoId == $ano->id ? 'selected' : '' }}>
                                        @php
                                            $anoRaw = $ano->getRawOriginal('ano');
                                            $anoFinal = strpos($anoRaw, '/') !== false ? explode('/', $anoRaw)[1] : $anoRaw;
                                        @endphp
                                        {{ $anoFinal }}
                                        @if($ano->ativo) (Activo) @endif
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-2">
                            <label for="turma_id" class="form-label small mb-0">Turma</label>
                            <select class="form-select form-select-sm" id="turma_id" name="turma_id">
                                <option value="">Todas as Turmas</option>
                                @foreach($turmas ?? [] as $turma)
                                    <option value="{{ $turma->id }}" {{ ($turmaId ?? '') == $turma->id ? 'selected' : '' }}>
                                        {{ $turma->codigo }} - {{ $turma->nome }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-2">
                            <label for="classe" class="form-label small mb-0">Classe</label>
                            <select class="form-select form-select-sm" id="classe" name="classe">
                                <option value="">Todas as Classes</option>
                                @foreach($classes ?? [] as $classeOption)
                                    <option value="{{ $classeOption }}" {{ ($classe ?? '') == $classeOption ? 'selected' : '' }}>
                                        {{ $classeOption }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label for="pesquisa" class="form-label small mb-0">Pesquisar por Nome</label>
                            <div class="position-relative">
                                <input type="text" 
                                       class="form-control form-control-sm" 
                                       id="pesquisa" 
                                       name="pesquisa" 
                                       value="{{ $pesquisa ?? '' }}" 
                                       placeholder="Digite o nome do aluno..."
                                       autocomplete="off">
                                <div id="sugestoes-pesquisa" class="list-group position-absolute w-100" style="z-index: 1000; display: none; max-height: 200px; overflow-y: auto; top: 100%; margin-top: 2px;"></div>
                            </div>
                        </div>
                        <div class="col-md-3 d-flex align-items-end gap-2">
                            <button type="submit" class="btn btn-sm btn-primary">
                                <i class="bi bi-search me-1"></i> Filtrar
                            </button>
                            <a href="{{ route('financeiro.index', ['ano_letivo_id' => $anoLetivoId]) }}" class="btn btn-sm btn-outline-secondary">
                                <i class="bi bi-x-circle me-1"></i> Limpar
                            </a>
                        </div>
                    </form>
                </div>
            </div>

            <div class="d-flex justify-content-between align-items-center mb-2">
                <div>
                    <a href="{{ route('financeiro.configurar-mensalidades', ['ano_letivo_id' => $anoLetivoId]) }}" class="btn btn-sm btn-info">
                        <i class="bi bi-gear me-1"></i> Configurar Valores/Modalidades
                    </a>
                </div>
            </div>

            <div class="js-ajax-pagination">
                <div class="table-responsive">
                    <table class="table table-sm table-bordered" style="font-size: 0.85rem;">
                    <thead style="background-color: #f8f9fa;">
                        <tr>
                            <th style="padding: 6px;">Aluno</th>
                            <th style="padding: 6px;">Código</th>
                                @foreach($meses ?? [] as $mes)
                                    <th style="padding: 6px; text-align: center; min-width: 80px;">{{ $mes }}</th>
                                @endforeach
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($alunos ?? [] as $aluno)
                                <tr>
                                    <td style="padding: 5px;">
                                        <div class="d-flex align-items-center gap-2">
                                            <span>{{ $aluno->user->name ?? '-' }}</span>
                                            <a href="{{ route('financeiro.facturas-aluno', $aluno) }}" 
                                               class="btn btn-sm btn-outline-primary" 
                                               style="font-size: 0.7rem; padding: 1px 6px;"
                                               title="Ver Facturas">
                                                <i class="bi bi-receipt"></i>
                                            </a>
                                        </div>
                                        @if($aluno->valor_mensalidade_personalizado)
                                            <br><small class="text-muted" style="font-size: 0.7rem;">
                                                Valor: {{ number_format($aluno->valor_mensalidade_personalizado, 2, ',', '.') }} MT
                                            </small>
                                        @endif
                                        @if($aluno->modalidade_pagamento && $aluno->modalidade_pagamento !== 'MENSAL')
                                            <br><small class="text-info" style="font-size: 0.7rem;">
                                                {{ ucfirst(strtolower($aluno->modalidade_pagamento)) }}
                                            </small>
                                        @endif
                                    </td>
                                    <td style="padding: 5px;">{{ $aluno->codigo_estudante ?? '-' }}</td>
                                    @foreach($situacaoMensalidades[$aluno->id] ?? [] as $index => $mesData)
                                        <td style="padding: 5px; text-align: center;">
                                            @if($mesData['status'] == 'PAGO')
                                                <span style="font-size: 0.75rem; padding: 2px 6px; background: #d4edda; color: #155724; border-radius: 3px;">Pago</span>
                                            @elseif($mesData['tem_gateway'] ?? false)
                                                <span style="font-size: 0.7rem; padding: 2px 6px; background: #d1ecf1; color: #0c5460; border-radius: 3px;" title="Pago via Gateway">Gateway</span>
                                            @else
                                                {{-- Mostrar botão de pagar por padrão para todas as mensalidades não pagas --}}
                                                @if($mesData['financeiro_id'])
                                                    <button type="button" 
                                                            class="btn btn-sm btn-success" 
                                                            style="font-size: 0.7rem; padding: 2px 6px;"
                                                            onclick="abrirModalPagamento({{ $mesData['financeiro_id'] }}, {{ $aluno->id }}, '{{ addslashes($aluno->user->name ?? 'Aluno') }}', {{ $mesData['valor_com_multa'] ?? $mesData['valor'] ?? 0 }}, '{{ addslashes($mesData['mes']) }}', '{{ $mesData['descricao'] ?? '' }}', {{ $mesData['multa'] ?? 0 }})">
                                                        <i class="bi bi-credit-card"></i> Pagar
                                                    </button>
                                                @else
                                                    {{-- Se não há financeiro_id, ainda mostrar botão para criar e pagar --}}
                                                    <button type="button" 
                                                            class="btn btn-sm btn-success" 
                                                            style="font-size: 0.7rem; padding: 2px 6px;"
                                                            onclick="abrirModalPagamento(null, {{ $aluno->id }}, '{{ addslashes($aluno->user->name ?? 'Aluno') }}', {{ $mesData['valor'] ?? 0 }}, '{{ addslashes($mesData['mes']) }}', 'Mensalidade {{ $mesData['mes'] }}/{{ date('Y') }}', 0)">
                                                        <i class="bi bi-credit-card"></i> Pagar
                                                    </button>
                                                @endif
                                                @if($mesData['status'] == 'VENCIDO')
                                                    <br><small style="font-size: 0.65rem; color: #dc3545;">Vencido</small>
                                                @elseif($mesData['status'] == 'PENDENTE')
                                                    <br><small style="font-size: 0.65rem; color: #856404;">Pendente</small>
                                                @endif
                                            @endif
                                        </td>
                                    @endforeach
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="{{ 3 + count($meses ?? []) }}" class="text-center">Nenhum aluno encontrado</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
                
                @if(method_exists($alunos, 'links'))
                    <div class="mt-3">
                        {{ $alunos->appends(request()->query())->links() }}
                    </div>
                @endif
            </div>
        </div>
    </div>

    <!-- Modal de Pagamento Presencial -->
    <div class="modal fade" id="modalPagamento" tabindex="-1" aria-labelledby="modalPagamentoLabel" aria-hidden="true" data-bs-backdrop="false" style="z-index: 1055;">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content shadow-lg">
                <form id="formPagamento" method="POST">
                    @csrf
                    <div class="modal-header">
                        <h5 class="modal-title" id="modalPagamentoLabel">Registrar Pagamento Presencial</h5>
                        <button type="button" class="btn-close" onclick="fecharModal()" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label class="form-label">Aluno</label>
                            <input type="text" class="form-control" id="alunoNome" readonly>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Mensalidade</label>
                            <input type="text" class="form-control" id="mesDescricao" readonly>
                        </div>
                        <div class="mb-3">
                            <label for="valor_pago" class="form-label">Valor Pago (MT)</label>
                            <input type="number" 
                                   class="form-control" 
                                   id="valor_pago" 
                                   name="valor_pago" 
                                   step="0.01" 
                                   min="0" 
                                   required>
                            <small class="text-muted">Valor máximo: <span id="valorMaximo">0</span> MT (inclui multas se aplicável)</small>
                        </div>
                        <div class="mb-3 form-check">
                            <input type="checkbox" 
                                   class="form-check-input" 
                                   id="gerar_factura" 
                                   name="gerar_factura" 
                                   value="1" 
                                   checked>
                            <label class="form-check-label" for="gerar_factura">
                                Gerar Factura automaticamente
                            </label>
                        </div>
                        <div id="alertaGateway" class="alert alert-warning d-none">
                            <i class="bi bi-exclamation-triangle me-2"></i>
                            Este pagamento foi realizado via gateway (Emola/M-Pesa) e não pode ser alterado.
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" onclick="fecharModal()">Cancelar</button>
                        <button type="submit" class="btn btn-primary">Registrar Pagamento</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script>

        // Autocomplete para pesquisa de alunos
        let timeoutPesquisa;
        const campoPesquisa = document.getElementById('pesquisa');
        const sugestoesDiv = document.getElementById('sugestoes-pesquisa');
        
        if (campoPesquisa) {
            campoPesquisa.addEventListener('input', function() {
                const termo = this.value.trim();
                const anoLetivoId = document.getElementById('ano_letivo_id').value;
                
                clearTimeout(timeoutPesquisa);
                
                if (termo.length < 2) {
                    sugestoesDiv.style.display = 'none';
                    return;
                }
                
                timeoutPesquisa = setTimeout(function() {
                    fetch(`{{ route('financeiro.buscar-alunos') }}?q=${encodeURIComponent(termo)}&ano_letivo_id=${anoLetivoId}`)
                        .then(response => response.json())
                        .then(data => {
                            sugestoesDiv.innerHTML = '';
                            
                            if (data.length === 0) {
                                sugestoesDiv.style.display = 'none';
                                return;
                            }
                            
                            data.forEach(function(aluno) {
                                const item = document.createElement('a');
                                item.href = '#';
                                item.className = 'list-group-item list-group-item-action';
                                item.innerHTML = `<strong>${aluno.nome}</strong> <small class="text-muted">(${aluno.codigo})</small>`;
                                item.addEventListener('click', function(e) {
                                    e.preventDefault();
                                    campoPesquisa.value = aluno.nome;
                                    sugestoesDiv.style.display = 'none';
                                    // Opcional: submeter o formulário automaticamente
                                    // campoPesquisa.closest('form').submit();
                                });
                                sugestoesDiv.appendChild(item);
                            });
                            
                            sugestoesDiv.style.display = 'block';
                        })
                        .catch(error => {
                            console.error('Erro ao buscar alunos:', error);
                            sugestoesDiv.style.display = 'none';
                        });
                }, 300);
            });
            
            // Esconder sugestões ao clicar fora
            document.addEventListener('click', function(e) {
                if (!campoPesquisa.contains(e.target) && !sugestoesDiv.contains(e.target)) {
                    sugestoesDiv.style.display = 'none';
                }
            });
            
            // Esconder sugestões ao pressionar Enter
            campoPesquisa.addEventListener('keydown', function(e) {
                if (e.key === 'Enter') {
                    sugestoesDiv.style.display = 'none';
                }
            });
        }

        function abrirModalPagamento(financeiroId, alunoId, alunoNome, valor, mes, descricao, multa = 0) {
            const modalElement = document.getElementById('modalPagamento');
            if (!modalElement) {
                console.error('Modal não encontrada');
                return;
            }

            // Limpar dados anteriores
            document.getElementById('alertaGateway').classList.add('d-none');
            
            const form = document.getElementById('formPagamento');
            
            // Se não há financeiro_id, usar rota alternativa que cria automaticamente
            let actionUrl;
            if (financeiroId) {
                actionUrl = '{{ route("financeiro.pagar", ":id") }}'.replace(':id', financeiroId);
            } else {
                // Criar rota alternativa que aceita aluno_id e mes
                actionUrl = '{{ route("financeiro.pagar-aluno-mes") }}';
                // Adicionar campos ocultos para aluno_id e mes
                let alunoIdInput = form.querySelector('input[name="aluno_id"]');
                if (!alunoIdInput) {
                    alunoIdInput = document.createElement('input');
                    alunoIdInput.type = 'hidden';
                    alunoIdInput.name = 'aluno_id';
                    form.appendChild(alunoIdInput);
                }
                alunoIdInput.value = alunoId;
                
                // Extrair número do mês da string (ex: "Janeiro" -> 1, "Fevereiro" -> 2)
                const mesesMap = {
                    'Janeiro': 1, 'Fevereiro': 2, 'Março': 3, 'Abril': 4,
                    'Maio': 5, 'Junho': 6, 'Julho': 7, 'Agosto': 8,
                    'Setembro': 9, 'Outubro': 10, 'Novembro': 11, 'Dezembro': 12
                };
                const mesNumero = mesesMap[mes] || mes || new Date().getMonth() + 1;
                
                let mesInput = form.querySelector('input[name="mes"]');
                if (!mesInput) {
                    mesInput = document.createElement('input');
                    mesInput.type = 'hidden';
                    mesInput.name = 'mes';
                    form.appendChild(mesInput);
                }
                mesInput.value = mesNumero;
            }
            
            form.action = actionUrl;
            document.getElementById('alunoNome').value = alunoNome || '';
            // Usar descricao se disponível, senão usar o mês
            let mensalidadeDesc = descricao || mes || '';
            if (multa > 0) {
                mensalidadeDesc += ' (+ Multa: ' + parseFloat(multa).toFixed(2) + ' MT)';
            }
            document.getElementById('mesDescricao').value = mensalidadeDesc;
            document.getElementById('valor_pago').value = parseFloat(valor) || 0;
            document.getElementById('valor_pago').max = parseFloat(valor) || 0;
            document.getElementById('valorMaximo').textContent = parseFloat(valor || 0).toFixed(2);
            
            // Focar no campo de valor
            setTimeout(() => {
                document.getElementById('valor_pago').focus();
            }, 300);
            
            // Habilitar botão de submit
            const submitBtn = form.querySelector('button[type="submit"]');
            if (submitBtn) {
                submitBtn.disabled = false;
            }
            
            // Verificar se há pagamento via gateway
            fetch(`{{ route('financeiro.verificar-gateway', ':id') }}`.replace(':id', financeiroId))
                .then(response => response.json())
                .then(data => {
                    if (data.tem_gateway) {
                        document.getElementById('alertaGateway').classList.remove('d-none');
                        if (submitBtn) {
                            submitBtn.disabled = true;
                        }
                    } else {
                        document.getElementById('alertaGateway').classList.add('d-none');
                        if (submitBtn) {
                            submitBtn.disabled = false;
                        }
                    }
                })
                .catch(error => {
                    console.error('Erro ao verificar gateway:', error);
                });
            
            // Remover qualquer backdrop existente
            const existingBackdrop = document.getElementById('modalBackdrop');
            if (existingBackdrop) {
                existingBackdrop.remove();
            }
            
            // Inicializar e mostrar modal
            try {
                // Verificar se Bootstrap está disponível
                if (typeof bootstrap !== 'undefined' && bootstrap.Modal) {
                    // Remover instância anterior se existir
                    const existingModal = bootstrap.Modal.getInstance(modalElement);
                    if (existingModal) {
                        existingModal.dispose();
                    }
                    
                    const modal = new bootstrap.Modal(modalElement, {
                        backdrop: false, // Sem backdrop escuro
                        keyboard: true,
                        focus: true
                    });
                    
                    // Aguardar um pouco para garantir que o DOM está pronto
                    setTimeout(() => {
                        modal.show();
                    }, 100);
                } else if (typeof jQuery !== 'undefined' && jQuery.fn.modal) {
                    // Fallback para jQuery Bootstrap
                    jQuery(modalElement).modal('show');
                } else {
                    // Fallback manual - sem backdrop
                    modalElement.classList.add('show');
                    modalElement.style.display = 'block';
                    modalElement.setAttribute('aria-hidden', 'false');
                    modalElement.setAttribute('aria-modal', 'true');
                    // Não adicionar modal-open para não escurecer o fundo
                    // document.body.classList.add('modal-open');
                    // document.body.style.overflow = 'hidden';
                    // Não criar backdrop
                }
            } catch (error) {
                console.error('Erro ao abrir modal:', error);
                // Fallback manual - sem backdrop
                modalElement.classList.add('show');
                modalElement.style.display = 'block';
                modalElement.setAttribute('aria-hidden', 'false');
                modalElement.setAttribute('aria-modal', 'true');
                // Não adicionar modal-open para não escurecer o fundo
            }
        }

        // Fechar modal ao clicar no backdrop ou botão fechar
        document.addEventListener('DOMContentLoaded', function() {
            const modalElement = document.getElementById('modalPagamento');
            if (modalElement) {
                // Fechar modal ao clicar no backdrop
                modalElement.addEventListener('click', function(e) {
                    if (e.target === modalElement) {
                        fecharModal();
                    }
                });

                // Fechar modal com ESC
                document.addEventListener('keydown', function(e) {
                    if (e.key === 'Escape' && modalElement.classList.contains('show')) {
                        fecharModal();
                    }
                });
            }
        });


        function fecharModal() {
            const modalElement = document.getElementById('modalPagamento');
            if (!modalElement) return;

            try {
                if (typeof bootstrap !== 'undefined' && bootstrap.Modal) {
                    const modal = bootstrap.Modal.getInstance(modalElement);
                    if (modal) {
                        modal.hide();
                    } else {
                        const newModal = new bootstrap.Modal(modalElement);
                        newModal.hide();
                    }
                } else if (typeof jQuery !== 'undefined' && jQuery.fn.modal) {
                    jQuery(modalElement).modal('hide');
                }
            } catch (error) {
                console.error('Erro ao fechar modal:', error);
            }
            
            // Sempre fazer limpeza manual
            modalElement.classList.remove('show');
            modalElement.style.display = 'none';
            modalElement.setAttribute('aria-hidden', 'true');
            modalElement.removeAttribute('aria-modal');
            document.body.classList.remove('modal-open');
            document.body.style.overflow = '';
            
            // Remover backdrop
            const backdrop = document.getElementById('modalBackdrop');
            if (backdrop) {
                backdrop.remove();
            }
            
            // Remover todos os backdrops do Bootstrap
            const allBackdrops = document.querySelectorAll('.modal-backdrop');
            allBackdrops.forEach(b => b.remove());
        }
    </script>
@endif
@endsection
