@extends('layouts.app')

@section('title', 'Gerar Mensalidades - SIGE')

@section('content')
<div class="container-fluid py-2">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h5 class="mb-0">Gerar Mensalidades Automaticamente</h5>
        <a href="{{ route('financeiro.index') }}" class="btn btn-sm btn-secondary">
            <i class="bi bi-arrow-left"></i> Voltar
        </a>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    @if(session('erros'))
        <div class="alert alert-warning alert-dismissible fade show" role="alert">
            <strong>Atenção:</strong> Alguns erros ocorreram durante a geração.
            <ul class="mb-0 mt-2">
                @foreach(array_slice(session('erros'), 0, 5) as $erro)
                    <li>{{ $erro }}</li>
                @endforeach
            </ul>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="card">
        <div class="card-body p-3">
            <form method="POST" action="{{ route('financeiro.gerar-mensalidades.store') }}">
                @csrf
                
                <div class="row g-3">
                    <div class="col-md-6">
                        <label for="ano_letivo_id" class="form-label small mb-0">Ano Letivo <span class="text-danger">*</span></label>
                        <select class="form-select form-select-sm @error('ano_letivo_id') is-invalid @enderror" 
                                id="ano_letivo_id" name="ano_letivo_id" required>
                            <option value="">Selecione o Ano Letivo</option>
                            @foreach($anosLetivos as $ano)
                                <option value="{{ $ano->id }}" 
                                        {{ old('ano_letivo_id', $anoLetivo?->id) == $ano->id ? 'selected' : '' }}>
                                    {{ $ano->ano }}
                                    @if($ano->ativo) (Activo) @endif
                                </option>
                            @endforeach
                        </select>
                        @error('ano_letivo_id')
                            <div class="invalid-feedback small">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="col-md-6">
                        <label for="turma_id" class="form-label small mb-0">Turma (Opcional)</label>
                        <select class="form-select form-select-sm" id="turma_id" name="turma_id">
                            <option value="">Todas as Turmas</option>
                            @foreach($turmas as $turma)
                                <option value="{{ $turma->id }}" {{ old('turma_id') == $turma->id ? 'selected' : '' }}>
                                    {{ $turma->codigo }} - {{ $turma->nome }}
                                </option>
                            @endforeach
                        </select>
                        <small class="text-muted">Deixe em branco para gerar para todos os alunos do ano letivo</small>
                    </div>

                    <div class="col-md-4">
                        <label for="valor_mensalidade" class="form-label small mb-0">Valor da Mensalidade (MT) <span class="text-danger">*</span></label>
                        <input type="number" step="0.01" min="0" 
                               class="form-control form-control-sm @error('valor_mensalidade') is-invalid @enderror" 
                               id="valor_mensalidade" name="valor_mensalidade" 
                               value="{{ old('valor_mensalidade') }}" required>
                        @error('valor_mensalidade')
                            <div class="invalid-feedback small">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="col-md-4">
                        <label for="mes_inicio" class="form-label small mb-0">Mês Início <span class="text-danger">*</span></label>
                        <select class="form-select form-select-sm @error('mes_inicio') is-invalid @enderror" 
                                id="mes_inicio" name="mes_inicio" required>
                            @for($i = 1; $i <= 12; $i++)
                                <option value="{{ $i }}" {{ old('mes_inicio', date('n')) == $i ? 'selected' : '' }}>
                                    {{ str_pad($i, 2, '0', STR_PAD_LEFT) }} - {{ 
                                        ['Janeiro', 'Fevereiro', 'Março', 'Abril', 'Maio', 'Junho',
                                         'Julho', 'Agosto', 'Setembro', 'Outubro', 'Novembro', 'Dezembro'][$i-1] 
                                    }}
                                </option>
                            @endfor
                        </select>
                        @error('mes_inicio')
                            <div class="invalid-feedback small">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="col-md-4">
                        <label for="mes_fim" class="form-label small mb-0">Mês Fim <span class="text-danger">*</span></label>
                        <select class="form-select form-select-sm @error('mes_fim') is-invalid @enderror" 
                                id="mes_fim" name="mes_fim" required>
                            @for($i = 1; $i <= 12; $i++)
                                <option value="{{ $i }}" {{ old('mes_fim', 12) == $i ? 'selected' : '' }}>
                                    {{ str_pad($i, 2, '0', STR_PAD_LEFT) }} - {{ 
                                        ['Janeiro', 'Fevereiro', 'Março', 'Abril', 'Maio', 'Junho',
                                         'Julho', 'Agosto', 'Setembro', 'Outubro', 'Novembro', 'Dezembro'][$i-1] 
                                    }}
                                </option>
                            @endfor
                        </select>
                        @error('mes_fim')
                            <div class="invalid-feedback small">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="col-md-6">
                        <label for="dia_vencimento" class="form-label small mb-0">Dia de Vencimento <span class="text-danger">*</span></label>
                        <input type="number" min="1" max="31" 
                               class="form-control form-control-sm @error('dia_vencimento') is-invalid @enderror" 
                               id="dia_vencimento" name="dia_vencimento" 
                               value="{{ old('dia_vencimento', 5) }}" required>
                        @error('dia_vencimento')
                            <div class="invalid-feedback small">{{ $message }}</div>
                        @enderror
                        <small class="text-muted">Dia do mês em que a mensalidade vence</small>
                    </div>
                </div>

                <div class="mt-3">
                    <button type="submit" class="btn btn-sm btn-primary" onclick="return confirm('Tem certeza que deseja gerar as mensalidades? Esta acção criará registros financeiros para todos os alunos selecionados.')">
                        <i class="bi bi-check-circle"></i> Gerar Mensalidades
                    </button>
                    <a href="{{ route('financeiro.index') }}" class="btn btn-sm btn-secondary">Cancelar</a>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

