@extends('layouts.app')

@section('title', 'Facturas do Aluno - SIGE')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <div>
                <h4 class="mb-0">
                    <i class="bi bi-receipt text-primary me-2"></i>
                    Facturas de {{ $aluno->user->name }}
                </h4>
                <small class="text-muted">Código: {{ $aluno->codigo_estudante }}</small>
            </div>
            <a href="{{ route('financeiro.index') }}" class="btn btn-secondary btn-sm">
                <i class="bi bi-arrow-left"></i> Voltar
            </a>
        </div>
    </div>
</div>

@if($invoices->count() > 0)
    <div class="js-ajax-pagination no-print">
        <div class="table-responsive no-print">
            <table class="table table-hover no-print">
            <thead>
                <tr>
                    <th>Número</th>
                    <th>Data Emissão</th>
                    <th>Valor</th>
                    <th>Status</th>
                    <th>Método Pagamento</th>
                    <th>Acções</th>
                </tr>
            </thead>
            <tbody>
                @foreach($invoices as $invoice)
                    <tr>
                        <td>{{ $invoice->numero_factura }}</td>
                        <td>{{ $invoice->data_emissao->format('d/m/Y') }}</td>
                        <td>{{ number_format($invoice->valor, 2, ',', '.') }} MT</td>
                        <td>
                            @if($invoice->status === 'PAGA')
                                <span class="badge bg-success">Paga</span>
                            @else
                                <span class="badge bg-warning">Pendente</span>
                            @endif
                        </td>
                        <td>
                            @if($invoice->payment)
                                @if($invoice->payment->metodo === 'MPESA')
                                    <span class="badge bg-primary">M-Pesa</span>
                                @elseif($invoice->payment->metodo === 'EMOLA')
                                    <span class="badge bg-info">Emola</span>
                                @else
                                    <span class="badge bg-secondary">Presencial</span>
                                @endif
                            @else
                                <span class="text-muted">-</span>
                            @endif
                        </td>
                        <td class="no-print">
                            <div class="btn-group btn-group-sm">
                                <a href="{{ route('financeiro.factura.download-admin', $invoice) }}" class="btn btn-primary" title="Download PDF">
                                    <i class="bi bi-download"></i>
                                </a>
                                <button type="button" 
                                        class="btn btn-info" 
                                        onclick="imprimirFacturaDireto({{ $invoice->id }})"
                                        title="Imprimir">
                                    <i class="bi bi-printer"></i>
                                </button>
                                <button type="button" 
                                        class="btn btn-outline-primary" 
                                        onclick="visualizarFactura({{ $invoice->id }})"
                                        title="Visualizar">
                                    <i class="bi bi-eye"></i>
                                </button>
                            </div>
                        </td>
                    </tr>
                @endforeach
            </tbody>
                <tfoot>
                    <tr class="table-info">
                        <th colspan="2">Total</th>
                        <th>{{ number_format($totalInvoices ?? $invoices->sum('valor'), 2, ',', '.') }} MT</th>
                        <th colspan="3"></th>
                    </tr>
                </tfoot>
            </table>
        </div>

        @if(method_exists($invoices, 'links'))
            <div class="mt-3">
                {{ $invoices->appends(request()->query())->links() }}
            </div>
        @endif
    </div>

    <!-- Modal para visualizar factura -->
    <div class="modal fade" id="modalVisualizarFactura" tabindex="-1" aria-labelledby="modalVisualizarFacturaLabel" aria-hidden="true" data-bs-backdrop="static" style="z-index: 1055;">
        <div class="modal-dialog modal-xl modal-dialog-centered modal-dialog-scrollable">
            <div class="modal-content shadow-lg">
                <div class="modal-header bg-primary text-white no-print">
                    <h5 class="modal-title" id="modalVisualizarFacturaLabel">
                        <i class="bi bi-receipt me-2"></i>Visualizar Factura
                    </h5>
                    <button type="button" class="btn-close btn-close-white" onclick="fecharModalFactura()" aria-label="Close"></button>
                </div>
                <div class="modal-body p-4" id="conteudoFactura" style="background-color: #f8f9fa; max-height: 80vh; overflow-y: auto;">
                    <!-- Conteúdo será carregado via AJAX -->
                    <div class="text-center py-5">
                        <div class="spinner-border text-primary" role="status">
                            <span class="visually-hidden">Carregando...</span>
                        </div>
                        <p class="mt-2 text-muted">Carregando factura...</p>
                    </div>
                </div>
                <div class="modal-footer bg-light no-print">
                    <button type="button" class="btn btn-info" onclick="imprimirFactura()">
                        <i class="bi bi-printer me-1"></i> Imprimir
                    </button>
                    <button type="button" class="btn btn-secondary" onclick="fecharModalFactura()">
                        <i class="bi bi-x-circle me-1"></i>Fechar
                    </button>
                </div>
            </div>
        </div>
    </div>
    
    <style>
        @media print {
            /* Esconder todos os elementos que não devem ser impressos */
            .no-print,
            .btn,
            button:not(.no-print),
            .btn-group,
            .d-flex.justify-content-between,
            .modal-header,
            .modal-footer,
            nav,
            .sidebar,
            .topbar,
            header,
            footer,
            .table-responsive.no-print,
            table.no-print,
            .js-ajax-pagination,
            .pagination {
                display: none !important;
            }
            
            /* Esconder coluna de ações da tabela */
            table th:last-child,
            table td:last-child {
                display: none !important;
            }
            
            body {
                margin: 0;
                padding: 0;
            }
            
            .modal {
                position: static !important;
                display: block !important;
                opacity: 1 !important;
                background: white !important;
            }
            
            .modal-dialog {
                max-width: 100% !important;
                margin: 0 !important;
            }
            
            .modal-content {
                border: none !important;
                box-shadow: none !important;
                background: white !important;
            }
            
            .modal-body {
                max-height: none !important;
                overflow: visible !important;
                padding: 20px !important;
                background-color: white !important;
            }
            
            .card {
                border: none !important;
                box-shadow: none !important;
            }
            
            .card-body {
                padding: 0 !important;
            }
            
            .table {
                border-collapse: collapse;
                width: 100%;
            }
            
            .table th,
            .table td {
                border: 1px solid #ddd;
                padding: 8px;
            }
            
            .table thead th {
                background-color: #f8f9fa;
                font-weight: bold;
            }
            
            .badge {
                border: 1px solid #000;
                padding: 4px 8px;
            }
            
            @page {
                margin: 1cm;
            }
        }
    </style>
@else
    <div class="alert alert-info text-center">
        <i class="bi bi-inbox display-4 d-block mb-3"></i>
        Este aluno ainda não possui facturas.
    </div>
@endif

<script>
    function visualizarFactura(invoiceId) {
        const modalElement = document.getElementById('modalVisualizarFactura');
        const conteudoDiv = document.getElementById('conteudoFactura');
        
        // Mostrar loading
        conteudoDiv.innerHTML = '<div class="text-center"><div class="spinner-border" role="status"><span class="visually-hidden">Carregando...</span></div></div>';
        
        // Abrir modal
        try {
            if (typeof bootstrap !== 'undefined' && bootstrap.Modal) {
                const existingModal = bootstrap.Modal.getInstance(modalElement);
                if (existingModal) {
                    existingModal.dispose();
                }
                
                const modal = new bootstrap.Modal(modalElement, {
                    backdrop: false,
                    keyboard: true,
                    focus: true
                });
                
                modal.show();
            } else {
                modalElement.classList.add('show');
                modalElement.style.display = 'block';
                modalElement.setAttribute('aria-hidden', 'false');
            }
        } catch (error) {
            console.error('Erro ao abrir modal:', error);
        }
        
        // Carregar conteúdo da factura
        const url = '{{ route("financeiro.factura.visualizar", ":id") }}'.replace(':id', invoiceId);
        fetch(url, {
            headers: {
                'X-Requested-With': 'XMLHttpRequest',
                'Accept': 'text/html'
            }
        })
            .then(response => {
                if (!response.ok) {
                    throw new Error('Erro ao carregar factura');
                }
                return response.text();
            })
            .then(html => {
                conteudoDiv.innerHTML = html;
            })
            .catch(error => {
                console.error('Erro ao carregar factura:', error);
                conteudoDiv.innerHTML = '<div class="alert alert-danger">Erro ao carregar factura. Por favor, tente novamente.</div>';
            });
    }

    function fecharModalFactura() {
        const modalElement = document.getElementById('modalVisualizarFactura');
        if (!modalElement) return;

        try {
            if (typeof bootstrap !== 'undefined' && bootstrap.Modal) {
                const modal = bootstrap.Modal.getInstance(modalElement);
                if (modal) {
                    modal.hide();
                }
            }
        } catch (error) {
            console.error('Erro ao fechar modal:', error);
        }
        
        modalElement.classList.remove('show');
        modalElement.style.display = 'none';
        modalElement.setAttribute('aria-hidden', 'true');
    }
    
    function imprimirFactura() {
        const modalElement = document.getElementById('modalVisualizarFactura');
        const conteudoDiv = document.getElementById('conteudoFactura');
        if (!conteudoDiv || !modalElement) return;
        
        // Esconder elementos que não devem ser impressos
        const modalHeader = modalElement.querySelector('.modal-header');
        const modalFooter = modalElement.querySelector('.modal-footer');
        if (modalHeader) modalHeader.style.display = 'none';
        if (modalFooter) modalFooter.style.display = 'none';
        
        // Imprimir
        window.print();
        
        // Restaurar elementos após impressão
        setTimeout(() => {
            if (modalHeader) modalHeader.style.display = '';
            if (modalFooter) modalFooter.style.display = '';
        }, 500);
    }
    
    function imprimirFacturaDireto(invoiceId) {
        // Carregar conteúdo da factura no modal e depois imprimir
        const modalElement = document.getElementById('modalVisualizarFactura');
        const conteudoDiv = document.getElementById('conteudoFactura');
        
        if (!modalElement || !conteudoDiv) {
            alert('Erro: Modal não encontrado');
            return;
        }
        
        // Mostrar loading
        conteudoDiv.innerHTML = '<div class="text-center py-5"><div class="spinner-border text-primary" role="status"><span class="visually-hidden">Carregando...</span></div><p class="mt-2 text-muted">Carregando factura...</p></div>';
        
        // Abrir modal
        try {
            if (typeof bootstrap !== 'undefined' && bootstrap.Modal) {
                const existingModal = bootstrap.Modal.getInstance(modalElement);
                if (existingModal) {
                    existingModal.dispose();
                }
                
                const modal = new bootstrap.Modal(modalElement, {
                    backdrop: false,
                    keyboard: true,
                    focus: true
                });
                
                modal.show();
            } else {
                modalElement.classList.add('show');
                modalElement.style.display = 'block';
                modalElement.setAttribute('aria-hidden', 'false');
            }
        } catch (error) {
            console.error('Erro ao abrir modal:', error);
        }
        
        // Carregar conteúdo da factura
        const url = '{{ route("financeiro.factura.visualizar", ":id") }}'.replace(':id', invoiceId);
        fetch(url, {
            headers: {
                'X-Requested-With': 'XMLHttpRequest',
                'Accept': 'text/html'
            }
        })
            .then(response => {
                if (!response.ok) {
                    throw new Error('Erro ao carregar factura');
                }
                return response.text();
            })
            .then(html => {
                conteudoDiv.innerHTML = html;
                
                // Aguardar um pouco para o conteúdo renderizar e depois imprimir
                setTimeout(() => {
                    // Esconder elementos que não devem ser impressos
                    const modalHeader = modalElement.querySelector('.modal-header');
                    const modalFooter = modalElement.querySelector('.modal-footer');
                    if (modalHeader) modalHeader.style.display = 'none';
                    if (modalFooter) modalFooter.style.display = 'none';
                    
                    // Imprimir
                    window.print();
                    
                    // Restaurar elementos após impressão
                    setTimeout(() => {
                        if (modalHeader) modalHeader.style.display = '';
                        if (modalFooter) modalFooter.style.display = '';
                    }, 500);
                }, 300);
            })
            .catch(error => {
                console.error('Erro ao carregar factura:', error);
                conteudoDiv.innerHTML = '<div class="alert alert-danger">Erro ao carregar factura. Por favor, tente novamente.</div>';
            });
    }
</script>
@endsection

