@extends('layouts.app')

@section('title', 'Criar Item Financeiro - SGE')

@section('content')
<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header bg-primary-custom text-white">
                <h4 class="mb-0">Criar Item Financeiro</h4>
            </div>
            <div class="card-body">
                <form method="POST" action="{{ route('financeiro.store') }}">
                    @csrf

                    <div class="mb-3">
                        <label for="aluno_id" class="form-label">Aluno *</label>
                        <select class="form-control @error('aluno_id') is-invalid @enderror" 
                                id="aluno_id" name="aluno_id" required>
                            <option value="">Selecione</option>
                            @foreach($alunos as $aluno)
                                <option value="{{ $aluno->id }}" {{ old('aluno_id') == $aluno->id ? 'selected' : '' }}>
                                    {{ $aluno->user->name }} ({{ $aluno->codigo_estudante }})
                                </option>
                            @endforeach
                        </select>
                        @error('aluno_id')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="tipo" class="form-label">Tipo *</label>
                        <select class="form-control @error('tipo') is-invalid @enderror" 
                                id="tipo" name="tipo" required>
                            <option value="Mensalidade" {{ old('tipo') == 'Mensalidade' ? 'selected' : '' }}>Mensalidade</option>
                            <option value="Taxa" {{ old('tipo') == 'Taxa' ? 'selected' : '' }}>Taxa</option>
                            <option value="Outro" {{ old('tipo') == 'Outro' ? 'selected' : '' }}>Outro</option>
                        </select>
                        @error('tipo')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="descricao" class="form-label">Descrição *</label>
                        <input type="text" class="form-control @error('descricao') is-invalid @enderror" 
                               id="descricao" name="descricao" value="{{ old('descricao') }}" required>
                        @error('descricao')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="valor" class="form-label">Valor *</label>
                        <input type="number" step="0.01" min="0" 
                               class="form-control @error('valor') is-invalid @enderror" 
                               id="valor" name="valor" value="{{ old('valor') }}" required>
                        @error('valor')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="data_vencimento" class="form-label">Data de Vencimento *</label>
                        <input type="date" class="form-control @error('data_vencimento') is-invalid @enderror" 
                               id="data_vencimento" name="data_vencimento" value="{{ old('data_vencimento') }}" required>
                        @error('data_vencimento')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <input type="hidden" name="ano_letivo_id" value="{{ $anoLetivo->id }}">

                    <button type="submit" class="btn btn-primary-custom">Criar Item</button>
                    <a href="{{ route('financeiro.index') }}" class="btn btn-secondary">Cancelar</a>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection



