@extends('layouts.app')

@section('title', 'Configurar Valores e Modalidades - SIGE')

@section('content')
<div class="container-fluid py-3">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h5 class="mb-0" style="font-weight: 500;">Configurar Valores e Modalidades</h5>
            <small class="text-muted">Personalize valores e modalidades de pagamento por aluno</small>
        </div>
        <a href="{{ route('financeiro.index', ['ano_letivo_id' => $anoLetivoId]) }}" class="btn btn-sm btn-link text-muted" style="text-decoration: none;">
            ← Voltar
        </a>
    </div>

    <!-- Filtros -->
    <div class="card border-0 mb-4" style="box-shadow: 0 1px 3px rgba(0,0,0,0.05);">
        <div class="card-body p-3">
            <form method="GET" action="{{ route('financeiro.configurar-mensalidades') }}" class="row g-2">
                <div class="col-md-2">
                    <label class="form-label small mb-1 text-muted">Ano Lectivo</label>
                    <select class="form-select form-select-sm" name="ano_letivo_id" style="background: #f8f9fa; border: 1px solid #dee2e6;" onchange="this.form.submit()">
                        @foreach($anosLetivos ?? [] as $ano)
                            <option value="{{ $ano->id }}" {{ $anoLetivoId == $ano->id ? 'selected' : '' }}>
                                @php
                                    $anoRaw = $ano->getRawOriginal('ano');
                                    $anoFinal = strpos($anoRaw, '/') !== false ? explode('/', $anoRaw)[1] : $anoRaw;
                                @endphp
                                {{ $anoFinal }}
                                @if($ano->ativo) (Activo) @endif
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-3">
                    <label class="form-label small mb-1 text-muted">Classe</label>
                    <select class="form-select form-select-sm" name="classe" style="background: #f8f9fa; border: 1px solid #dee2e6;">
                        <option value="">Todas</option>
                        @foreach($classes ?? [] as $classeOption)
                            <option value="{{ $classeOption }}" {{ ($classe ?? '') == $classeOption ? 'selected' : '' }}>
                                {{ $classeOption }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-4">
                    <label class="form-label small mb-1 text-muted">Pesquisar</label>
                    <input type="text" 
                           class="form-control form-control-sm" 
                           name="pesquisa" 
                           value="{{ $pesquisa ?? '' }}" 
                           placeholder="Nome do aluno..."
                           style="background: #f8f9fa; border: 1px solid #dee2e6;">
                </div>
                <div class="col-md-3 d-flex align-items-end gap-2">
                    <button type="submit" class="btn btn-sm px-3" style="background: #0d6efd; color: white; border: none;">
                        Filtrar
                    </button>
                    <a href="{{ route('financeiro.configurar-mensalidades', ['ano_letivo_id' => $anoLetivoId]) }}" class="btn btn-sm btn-link text-muted" style="text-decoration: none;">
                        Limpar
                    </a>
                </div>
            </form>
        </div>
    </div>

    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    @if($errors->any())
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <ul class="mb-0">
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <!-- Formulário -->
    <form method="POST" action="{{ route('financeiro.configurar-mensalidades.store') }}">
        @csrf
        <input type="hidden" name="ano_letivo_id" value="{{ $anoLetivoId }}">
        
        <!-- Barra de Acções -->
        <div class="d-flex justify-content-between align-items-center mb-3">
            <div class="d-flex align-items-center gap-3">
                <input type="checkbox" id="selectAllConfig" onchange="toggleSelectAllConfig()" class="form-check-input" style="margin-top: 0;">
                <input type="text" 
                       id="filtroNomeConfig" 
                       class="form-control form-control-sm" 
                       style="width: 200px; background: #f8f9fa; font-size: 0.875rem; border: 1px solid #dee2e6;" 
                       placeholder="Buscar...">
                <select id="filtroModalidadeConfig" class="form-select form-select-sm" style="width: 130px; background: #f8f9fa; font-size: 0.875rem; border: 1px solid #dee2e6;">
                    <option value="">Modalidade</option>
                    <option value="MENSAL">Mensal</option>
                    <option value="TRIMESTRAL">Trimestral</option>
                    <option value="SEMESTRAL">Semestral</option>
                    <option value="ANUAL">Anual</option>
                </select>
            </div>
            <div class="d-flex gap-2">
                <button type="submit" class="btn btn-sm px-4" style="background: #0d6efd; color: white; border: none; font-size: 0.875rem;">
                    Salvar
                </button>
            </div>
        </div>

        <!-- Tabela -->
        <div class="card border-0" style="box-shadow: 0 1px 3px rgba(0,0,0,0.05);">
            <div class="table-responsive" style="max-height: 600px; overflow-y: auto;">
                <table class="table table-sm mb-0" id="tabelaConfiguracao" style="border-collapse: separate; border-spacing: 0;">
                    <thead class="sticky-top" style="background: #fff; border-bottom: 1px solid #e9ecef;">
                        <tr>
                            <th style="width: 35px; padding: 12px; font-weight: 500; font-size: 0.8rem; color: #6c757d;"></th>
                            <th style="padding: 12px; font-weight: 500; font-size: 0.8rem; color: #6c757d;">Aluno</th>
                            <th style="padding: 12px; font-weight: 500; font-size: 0.8rem; color: #6c757d;">Código</th>
                            <th style="padding: 12px; font-weight: 500; font-size: 0.8rem; color: #6c757d;">Turma</th>
                            <th style="padding: 12px; width: 150px; font-weight: 500; font-size: 0.8rem; color: #6c757d;">Valor (MT)</th>
                            <th style="padding: 12px; width: 150px; font-weight: 500; font-size: 0.8rem; color: #6c757d;">Modalidade</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($alunos ?? [] as $aluno)
                            @php
                                $turmaAluno = $aluno->turmas->first();
                            @endphp
                            <tr class="linha-config" 
                                data-nome="{{ strtolower($aluno->user->name ?? '') }}" 
                                data-modalidade="{{ $aluno->modalidade_pagamento ?? 'MENSAL' }}"
                                data-turma="{{ $turmaAluno->id ?? '' }}"
                                style="border-bottom: 1px solid #f8f9fa;">
                                <td style="padding: 12px;">
                                    <input type="checkbox" name="alunos[]" value="{{ $aluno->id }}" class="aluno-config-checkbox form-check-input" style="margin-top: 0;">
                                </td>
                                <td style="padding: 12px; font-size: 0.875rem;">{{ $aluno->user->name ?? '-' }}</td>
                                <td style="padding: 12px; font-size: 0.875rem; color: #6c757d;">{{ $aluno->codigo_estudante ?? '-' }}</td>
                                <td style="padding: 12px; font-size: 0.875rem; color: #6c757d;">{{ $turmaAluno->codigo ?? '-' }}</td>
                                <td style="padding: 12px;">
                                    <input type="number" 
                                           step="0.01" 
                                           min="0" 
                                           class="form-control form-control-sm border-0" 
                                           name="valores[{{ $aluno->id }}]" 
                                           value="{{ $aluno->valor_mensalidade_personalizado ?? '' }}" 
                                           placeholder="—"
                                           style="font-size: 0.875rem; background: #f8f9fa; padding: 6px 10px;">
                                </td>
                                <td style="padding: 12px;">
                                    <select class="form-select form-select-sm border-0" name="modalidades[{{ $aluno->id }}]" style="font-size: 0.875rem; background: #f8f9fa; padding: 6px 10px;">
                                        <option value="MENSAL" {{ ($aluno->modalidade_pagamento ?? 'MENSAL') == 'MENSAL' ? 'selected' : '' }}>Mensal</option>
                                        <option value="TRIMESTRAL" {{ ($aluno->modalidade_pagamento ?? 'MENSAL') == 'TRIMESTRAL' ? 'selected' : '' }}>Trimestral</option>
                                        <option value="SEMESTRAL" {{ ($aluno->modalidade_pagamento ?? 'MENSAL') == 'SEMESTRAL' ? 'selected' : '' }}>Semestral</option>
                                        <option value="ANUAL" {{ ($aluno->modalidade_pagamento ?? 'MENSAL') == 'ANUAL' ? 'selected' : '' }}>Anual</option>
                                    </select>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="text-center py-5 text-muted">
                                    Nenhum aluno encontrado
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
        
        <!-- Paginação -->
        @if(isset($alunos) && method_exists($alunos, 'links'))
            <div class="mt-3 d-flex justify-content-center">
                {{ $alunos->appends(request()->query())->links() }}
            </div>
        @endif
    </form>
</div>

<script>
    function toggleSelectAllConfig() {
        const selectAll = document.getElementById('selectAllConfig');
        const checkboxes = document.querySelectorAll('.aluno-config-checkbox:not([style*="display: none"])');
        checkboxes.forEach(cb => {
            if (cb.closest('tr').style.display !== 'none') {
                cb.checked = selectAll.checked;
            }
        });
    }

    // Filtros
    let filtrosInicializados = false;
    function inicializarFiltrosConfig() {
        if (filtrosInicializados) return;
        
        const filtroNome = document.getElementById('filtroNomeConfig');
        const filtroModalidade = document.getElementById('filtroModalidadeConfig');
        
        if (!filtroNome || !filtroModalidade) return;
        
        function aplicarFiltros() {
            const nomeFiltro = filtroNome.value.toLowerCase().trim();
            const modalidadeFiltro = filtroModalidade.value;
            
            const linhas = document.querySelectorAll('#tabelaConfiguracao tbody tr.linha-config');
            
            linhas.forEach(linha => {
                const nome = (linha.getAttribute('data-nome') || '').toLowerCase();
                const modalidade = linha.getAttribute('data-modalidade') || '';
                
                const matchNome = !nomeFiltro || nome.includes(nomeFiltro);
                const matchModalidade = !modalidadeFiltro || modalidade === modalidadeFiltro;
                
                if (matchNome && matchModalidade) {
                    linha.style.display = '';
                } else {
                    linha.style.display = 'none';
                }
            });
            
            const selectAll = document.getElementById('selectAllConfig');
            if (selectAll) {
                selectAll.checked = false;
            }
        }
        
        filtroNome.addEventListener('input', aplicarFiltros);
        filtroModalidade.addEventListener('change', aplicarFiltros);
        
        filtrosInicializados = true;
    }

    document.addEventListener('DOMContentLoaded', function() {
        inicializarFiltrosConfig();
    });
</script>
@endsection
